// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef _Runnable_h_
#define _Runnable_h_

#include <string.h>

namespace Smarts {

/*------------------------------------------------------------------------
CLASS
	Runnable

	Base class for a schedulable object or function to be executed
	by the scheduler asynchronously

KEYWORDS
	Thread, Native_Interface, Task_Parallelism, Data_Parallelism.

DESCRIPTION 
        Runnable is the base class for system classes "Thread" and
        "Iterate".  However, the user may define his/her own
        sub-class. Any class derived from Runnable, is an object that
        the scheduler understands and therefore is the mechanism to
        have something executed in parallel by the scheduler on behalf
        of the user.

COPYRIGHT
        This program was prepared by the Regents of the University of
        California at Los Alamos National Laboratory (the University)
        under Contract No.  W-7405-ENG-36 with the U.S. Department of
        Energy (DOE). The University has certain rights in the program
        pursuant to the contract and the program should not be copied
        or distributed outside your organization. All rights in the
        program are reserved by the DOE and the University. Neither
        the U.S.  Government nor the University makes any warranty,
        express or implied, or assumes any liability or responsibility
        for the use of this software.

	Parts of this software have been authored at the University of
	Colorado -- Boulder. Neither University of Colorado nor its
	employees makes any warranty, express or implied, or assumes
	any liability or responsibility for the use of this SOFTWARE.
                                                                        
	This SOFTWARE may be modified for derivative use, but modified
	SOFTWARE should be clearly marked as such, so as not to
	confuse it with the versions available from Los Alamos
	National Laboratory.  
*/

class Runnable
{
  friend class Context;
public:

  ///////////////////////////
  // Set priority of this runnable relative to other runnables 
  // being scheduled.
  //
  inline int
  priority() { return priority_m; };

  ///////////////////////////
  // Accessor function to priority.
  //
  inline void
  priority(int _priority) { priority_m = _priority; };

  /////////
  virtual ~Runnable(){};

  /////////
  Runnable()
  {
    priority_m = 0;
  }

  ///////////////////////////
  // The parameter to this constructor is the CPU id for
  // hard affinity.
  //
  Runnable(int )
  {
    priority_m = 0;
  }

  ////////
  virtual void execute(){
    run();
  };


protected:
  virtual void run(){};

private:
  int priority_m;
};

typedef Runnable *RunnablePtr_t;

}
#endif
