// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
// TransformPatch
//-----------------------------------------------------------------------------

#ifndef POOMA_TRANSFORM_TRANSFORM_PATCH_H
#define POOMA_TRANSFORM_TRANSFORM_PATCH_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Full Description:
//
//-----------------------------------------------------------------------------

template<int Dim, class Function>
class TransformPatch
{
public:
  typedef typename Function::Element_t Element_t;
  CTAssert(Function::sliceDimensions == 2);
  CTAssert(Function::inPlace == true);
  CTAssert(Dim > 1);

  TransformPatch(int transformDim, const Function &func)
    : transformDim_m(transformDim), function_m(func)
  { }

  void apply(const Array<Dim, Element_t, BrickView<Dim> >& a)
  {
    Loc<Dim> loc;
    int ends[Dim];
    int i;

    for (i = 0; i < Dim; ++i)
    {
      loc[i]  = Loc<1>(0);
      ends[i] = a.domain()[i].size();
    }

    int dim2    = (transformDim_m == 0) ? 1 : 0;
    int length  = ends[transformDim_m];
    int lot     = ends[dim2];
    int istride = a.engine().strides()[transformDim_m];
    int idist   = a.engine().strides()[dim2];

    function_m.initialize(Loc<2>(length, lot), Loc<2>(istride, idist));

    bool more = true;

    while(more)
    {
      function_m.apply(&a(loc));

      more = false;
      for (i = 0; i < Dim; ++i)
      {
	if ((i != transformDim_m) && (i != dim2))
	{
	  loc[i] += 1;
	  if (loc[i].first() != ends[i])
	  {
	    i = Dim;
	    more = true;
	  }
	  else
	  {
	    loc[i] = Loc<1>(0);
	  }
	}
      }
    }

    function_m.finalize();
  }

private:
  int transformDim_m;
  Function function_m;
};


//////////////////////////////////////////////////////////////////////

#endif     // POOMA_TRANSFORM_TRANSFORM_PATCH_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: TransformPatch.h,v $   $Author: jac $
// $Revision: 1.3 $   $Date: 2000/06/19 22:18:43 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
