// Stream buffer classes -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.5  Stream buffers
//

#ifndef _CPP_BITS_STREAMBUF_TCC
#define _CPP_BITS_STREAMBUF_TCC 1

namespace std {

  template<typename _CharT, typename _Traits>
    basic_streambuf<_CharT, _Traits>::int_type
    basic_streambuf<_CharT, _Traits>::
    sbumpc()
    {
      int_type __retval;
      if (_M_in_cur && _M_in_cur < _M_in_end)
	{
	  char_type __c = *gptr();
	  ++_M_in_cur;
	  if (_M_buf_unified && _M_out_cur)
	    ++_M_out_cur;
	  __retval = traits_type::to_int_type(__c);
	}
      else 
	__retval = this->uflow();
      return __retval;
    }

  template<typename _CharT, typename _Traits>
    basic_streambuf<_CharT, _Traits>::int_type
    basic_streambuf<_CharT, _Traits>::
    sputbackc(char_type __c) 
    {
      int_type __retval;
      bool __testpos = _M_in_cur && _M_in_beg < _M_in_cur;
      bool __testne = _M_in_cur && !traits_type::eq(__c, this->gptr()[-1]);
      if (!__testpos || __testne)
	__retval = pbackfail(traits_type::to_int_type(__c));
      else 
	{
	  --_M_in_cur;
	  if (_M_buf_unified && _M_mode & ios_base::out)
	    --_M_out_cur;
	  __retval = traits_type::to_int_type(*this->gptr());
	}
      return __retval;
    }
  
  template<typename _CharT, typename _Traits>
    basic_streambuf<_CharT, _Traits>::int_type
    basic_streambuf<_CharT, _Traits>::
    sungetc()
    {
      bool __testpos = _M_in_cur && _M_in_beg < _M_in_cur;
      int_type __retval;
      
      if (__testpos)
	{
	  --_M_in_cur;
	  if (_M_buf_unified && _M_out_cur)
	    --_M_out_cur;
	  __retval = traits_type::to_int_type(*_M_in_cur);
	}
      else 
	__retval = this->pbackfail();
      return __retval;
    }

  template<typename _CharT, typename _Traits>
    basic_streambuf<_CharT, _Traits>::int_type
    basic_streambuf<_CharT, _Traits>::
    sputc(char_type __c)
    {
      int_type __retval;
      if (_M_out_cur && _M_out_cur < _M_out_end)
	{
	  *_M_out_cur = __c;
	  ++_M_out_cur;
	  if (_M_buf_unified && _M_in_cur)
	    ++_M_in_cur;
	  __retval = traits_type::to_int_type(__c);
	}
      else
	__retval = this->overflow(traits_type::to_int_type(__c));
      return __retval;
    }

  template<typename _CharT, typename _Traits>
    streamsize
    basic_streambuf<_CharT, _Traits>::
    xsgetn(char_type* __s, streamsize __n)
    {
      bool __testout = _M_mode & ios_base::out;
      bool __testin = _M_in_cur && _M_in_cur < _M_in_end;
      streamsize __retval = 0; 

      if (__testin)
	{
	  if (_M_in_cur + __n < _M_in_end)
	    __retval = __n;
	  else
	    __retval = _M_in_end - _M_in_cur;

	  size_t __len = static_cast<size_t>(__retval);
	  traits_type::copy(__s, _M_in_cur, __len);
	  _M_in_cur += __len;
	  if (_M_buf_unified && __testout)
	    _M_out_cur += __len;
	}
      else
	{
	  if (this->uflow() != traits_type::eof())
	    ++__retval;
	}
      return __retval;
    }

  template<typename _CharT, typename _Traits>
    streamsize
    basic_streambuf<_CharT, _Traits>::
    xsputn(const char_type* __s, streamsize __n)
    {
      bool __testinit = _M_is_indeterminate();
      bool __testout = _M_mode & ios_base::out;
      bool __testin = _M_mode & ios_base::in;
      streamsize __retval = 0;
      streamsize __already = 0;

      if (__testout)
	{
	  if (__testinit)
	    {
	      char_type __c = *__s++;
	      char_type __overfc = this->overflow(__c);
	      if (__c == __overfc)
		++__already;
	    }
	  
	  if (_M_out_cur + __n - __already < _M_out_end)
	    __retval = __n;
	  else
	    __retval = _M_out_end - _M_out_cur;
	  
	  size_t __len = static_cast<size_t>(__retval - __already);
	  traits_type::copy(_M_out_cur, __s, __len);
	  _M_out_cur += __len;
	  if (_M_buf_unified && __testin)
	    _M_in_cur += __len;
	  
	  if (__retval != __n)
	    {
	      char_type __c = __s[__retval];
	      char_type __overfc = this->overflow(__c);
	      if (__c == __overfc)
		++__retval;
	    }
	}
      return __retval;
    }

} // namespace std

#endif // _CPP_BITS_STREAMBUF_TCC



