import os, time
from portage_data import portage_uid, portage_gid
from portage_util import ensure_dirs, apply_permissions

def process(mysettings, cpv, logentries, fulltext):
	if mysettings["PORT_LOGDIR"] != "":
		elogdir = os.path.join(mysettings["PORT_LOGDIR"], "elog")
	else:
		elogdir = os.path.join(os.sep, "var", "log", "portage", "elog")
	ensure_dirs(elogdir, uid=portage_uid, gid=portage_gid, mode=02770)

	# TODO: Locking
	elogfilename = elogdir+"/summary.log"
	elogfile = open(elogfilename, "a")
	apply_permissions(elogfilename, mode=060, mask=0)
	elogfile.write(">>> Messages generated by process %d on %s for package %s:\n\n" % \
		(os.getpid(), time.strftime("%Y-%m-%d %H:%M:%S %Z", time.localtime(time.time())), cpv))
	elogfile.write(fulltext)
	elogfile.write("\n")
	elogfile.close()

	return elogfilename
