require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_STRING_H)) {
    die("Never use <bits/string2.h> directly; include <string.h> instead.");
}
if(!defined (defined(&__NO_STRING_INLINES) ? &__NO_STRING_INLINES : 0)  && !defined (defined(&__BOUNDED_POINTERS__) ? &__BOUNDED_POINTERS__ : 0)) {
    unless(defined(&__STRING_INLINE)) {
	if(defined(&__cplusplus)) {
	    eval 'sub __STRING_INLINE () { &inline;}' unless defined(&__STRING_INLINE);
	} else {
	    eval 'sub __STRING_INLINE () { &__extern_inline;}' unless defined(&__STRING_INLINE);
	}
    }
    if((defined(&_STRING_ARCH_unaligned) ? &_STRING_ARCH_unaligned : 0)) {
	require 'endian.ph';
	require 'bits/types.ph';
	if((defined(&__BYTE_ORDER) ? &__BYTE_ORDER : 0) == (defined(&__LITTLE_ENDIAN) ? &__LITTLE_ENDIAN : 0)) {
	    eval 'sub __STRING2_SMALL_GET16 {
	        my($src, $idx) = @_;
    		eval q(((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx + 1] << 8| (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx]));
	    }' unless defined(&__STRING2_SMALL_GET16);
	    eval 'sub __STRING2_SMALL_GET32 {
	        my($src, $idx) = @_;
    		eval q(((((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx + 3] << 8| (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx + 2]) << 8| (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx + 1]) << 8| (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx]));
	    }' unless defined(&__STRING2_SMALL_GET32);
	} else {
	    eval 'sub __STRING2_SMALL_GET16 {
	        my($src, $idx) = @_;
    		eval q(((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx] << 8| (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx + 1]));
	    }' unless defined(&__STRING2_SMALL_GET16);
	    eval 'sub __STRING2_SMALL_GET32 {
	        my($src, $idx) = @_;
    		eval q(((((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx] << 8| (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx + 1]) << 8| (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx + 2]) << 8| (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($src))[$idx + 3]));
	    }' unless defined(&__STRING2_SMALL_GET32);
	}
    } else {
	eval 'sub __STRING2_COPY_TYPE {
	    my($N) = @_;
    	    eval q( &typedef \'struct struct\' { \'unsigned char __arr\'[$N]; }  &__attribute__ (( &__packed__))  &__STRING2_COPY_ARR$N);
	}' unless defined(&__STRING2_COPY_TYPE);
	undef(&__STRING2_COPY_TYPE) if defined(&__STRING2_COPY_TYPE);
    }
    eval 'sub __string2_1bptr_p {
        my($__x) = @_;
	    eval q((( &const  &void *)( + 1) - ( &const  &void *)($__x) == 1));
    }' unless defined(&__string2_1bptr_p);
    if(!defined (defined(&_HAVE_STRING_ARCH_memset) ? &_HAVE_STRING_ARCH_memset : 0)) {
	if(! &__GNUC_PREREQ (3, 0)) {
	    if((defined(&_STRING_ARCH_unaligned) ? &_STRING_ARCH_unaligned : 0)) {
		eval 'sub memset {
		    my($s, $c, $n) = @_;
    		    eval q(( &__extension__ ( &__builtin_constant_p ($n)  && ($n) <= 16? (($n) == 1?  &__memset_1 ($s, $c) :  &__memset_gc ($s, $c, $n)) : ( &__builtin_constant_p ($c)  && ($c) == ord(\'\\\\0\') ? ({  &void * &__s = ($s);  &__bzero ( &__s, $n);  &__s; }) :  &memset ($s, $c, $n)))));
		}' unless defined(&memset);
		eval 'sub __memset_1 {
		    my($s, $c) = @_;
    		    eval q(({  &void * &__s = ($s); *(( &__uint8_t *)  &__s) = ( &__uint8_t) $c;  &__s; }));
		}' unless defined(&__memset_1);
		eval 'sub __memset_gc {
		    my($s, $c, $n) = @_;
    		    eval q(({  &void * &__s = ($s); \'union union\' { \'unsigned int __ui\'; \'unsigned short int __usi\'; \'unsigned char __uc\'; } * &__u =  &__s;  &__uint8_t  &__c = ( &__uint8_t) ($c);  &switch ( ($n)) {  &case 15:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 11:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 7:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 3:  ($__u->{__usi}) =   &__c * 0x101;  &__u =  &__extension__ (( &void *)  &__u + 2);  ($__u->{__uc}) =   &__c;  &break;  &case 14:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 10:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 6:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 2:  ($__u->{__usi}) =   &__c * 0x101;  &break;  &case 13:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 9:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 5:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 1:  ($__u->{__uc}) =   &__c;  &break;  &case 16:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 12:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 8:  ($__u->{__ui}) =  &__c * 0x1010101;  &__u =  &__extension__ (( &void *)  &__u + 4);  &case 4:  ($__u->{__ui}) =  &__c * 0x1010101;  &case 0:  &break; }  &__s; }));
		}' unless defined(&__memset_gc);
	    } else {
		eval 'sub memset {
		    my($s, $c, $n) = @_;
    		    eval q(( &__extension__ ( &__builtin_constant_p ($c)  && ($c) == ord(\'\\\\0\') ? ({  &void * &__s = ($s);  &__bzero ( &__s, $n);  &__s; }) :  &memset ($s, $c, $n))));
		}' unless defined(&memset);
	    }
	}
	if( &__GNUC_PREREQ (2, 91)) {
	    eval 'sub __bzero {
	        my($s, $n) = @_;
    		eval q( &__builtin_memset ($s, ord(\'\\\\0\'), $n));
	    }' unless defined(&__bzero);
	}
    }
    if(defined(&__USE_GNU)) {
	if(!defined (defined(&_HAVE_STRING_ARCH_mempcpy) ? &_HAVE_STRING_ARCH_mempcpy : 0) || defined (defined(&_FORCE_INLINES) ? &_FORCE_INLINES : 0)) {
	    unless(defined(&_HAVE_STRING_ARCH_mempcpy)) {
		if( &__GNUC_PREREQ (3, 4)) {
		    eval 'sub __mempcpy {
		        my($dest, $src, $n) = @_;
    			eval q( &__builtin_mempcpy ($dest, $src, $n));
		    }' unless defined(&__mempcpy);
		}
 elsif( &__GNUC_PREREQ (3, 0)) {
		    eval 'sub __mempcpy {
		        my($dest, $src, $n) = @_;
    			eval q(( &__extension__ ( &__builtin_constant_p ($src)  &&  &__builtin_constant_p ($n)  &&  &__string2_1bptr_p ($src)  && $n <= 8?  &__builtin_memcpy ($dest, $src, $n) + ($n) :  &__mempcpy ($dest, $src, $n))));
		    }' unless defined(&__mempcpy);
		} else {
		    eval 'sub __mempcpy {
		        my($dest, $src, $n) = @_;
    			eval q(( &__extension__ ( &__builtin_constant_p ($src)  &&  &__builtin_constant_p ($n)  &&  &__string2_1bptr_p ($src)  && $n <= 8?  &__mempcpy_small ($dest,  &__mempcpy_args ($src), $n) :  &__mempcpy ($dest, $src, $n))));
		    }' unless defined(&__mempcpy);
		}
		eval 'sub mempcpy {
		    my($dest, $src, $n) = @_;
    		    eval q( &__mempcpy ($dest, $src, $n));
		}' unless defined(&mempcpy);
	    }
	    if(! &__GNUC_PREREQ (3, 0) || defined (defined(&_FORCE_INLINES) ? &_FORCE_INLINES : 0)) {
		if((defined(&_STRING_ARCH_unaligned) ? &_STRING_ARCH_unaligned : 0)) {
		    unless(defined(&_FORCE_INLINES)) {
			eval 'sub __mempcpy_args {
			    my($src) = @_;
    			    eval q((( &__const \'char\' *) ($src))[0], (( &__const \'char\' *) ($src))[2], (( &__const \'char\' *) ($src))[4], (( &__const \'char\' *) ($src))[6],  &__extension__  &__STRING2_SMALL_GET16 ($src, 0),  &__extension__  &__STRING2_SMALL_GET16 ($src, 4),  &__extension__  &__STRING2_SMALL_GET32 ($src, 0),  &__extension__  &__STRING2_SMALL_GET32 ($src, 4));
			}' unless defined(&__mempcpy_args);
		    }
		} else {
		    unless(defined(&_FORCE_INLINES)) {
			eval 'sub __mempcpy_args {
			    my($src) = @_;
    			    eval q((( &__const \'char\' *) ($src))[0],  &__extension__ (( &__STRING2_COPY_ARR2) { { (( &__const \'char\' *) ($src))[0], (( &__const \'char\' *) ($src))[1] } }),  &__extension__ (( &__STRING2_COPY_ARR3) { { (( &__const \'char\' *) ($src))[0], (( &__const \'char\' *) ($src))[1], (( &__const \'char\' *) ($src))[2] } }),  &__extension__ (( &__STRING2_COPY_ARR4) { { (( &__const \'char\' *) ($src))[0], (( &__const \'char\' *) ($src))[1], (( &__const \'char\' *) ($src))[2], (( &__const \'char\' *) ($src))[3] } }),  &__extension__ (( &__STRING2_COPY_ARR5) { { (( &__const \'char\' *) ($src))[0], (( &__const \'char\' *) ($src))[1], (( &__const \'char\' *) ($src))[2], (( &__const \'char\' *) ($src))[3], (( &__const \'char\' *) ($src))[4] } }),  &__extension__ (( &__STRING2_COPY_ARR6) { { (( &__const \'char\' *) ($src))[0], (( &__const \'char\' *) ($src))[1], (( &__const \'char\' *) ($src))[2], (( &__const \'char\' *) ($src))[3], (( &__const \'char\' *) ($src))[4], (( &__const \'char\' *) ($src))[5] } }),  &__extension__ (( &__STRING2_COPY_ARR7) { { (( &__const \'char\' *) ($src))[0], (( &__const \'char\' *) ($src))[1], (( &__const \'char\' *) ($src))[2], (( &__const \'char\' *) ($src))[3], (( &__const \'char\' *) ($src))[4], (( &__const \'char\' *) ($src))[5], (( &__const \'char\' *) ($src))[6] } }),  &__extension__ (( &__STRING2_COPY_ARR8) { { (( &__const \'char\' *) ($src))[0], (( &__const \'char\' *) ($src))[1], (( &__const \'char\' *) ($src))[2], (( &__const \'char\' *) ($src))[3], (( &__const \'char\' *) ($src))[4], (( &__const \'char\' *) ($src))[5], (( &__const \'char\' *) ($src))[6], (( &__const \'char\' *) ($src))[7] } }));
			}' unless defined(&__mempcpy_args);
		    }
		}
	    }
	}
    }
    unless(defined(&_HAVE_STRING_ARCH_strchr)) {
	if( &__GNUC_PREREQ (3, 2)) {
	    eval 'sub strchr {
	        my($s, $c) = @_;
    		eval q(( &__extension__ ( &__builtin_constant_p  && ! &__builtin_constant_p  && == ord(\'\\\\0\') ?  &__rawmemchr ($s, $c) :  &__builtin_strchr ($s, $c))));
	    }' unless defined(&strchr);
	} else {
	    eval 'sub strchr {
	        my($s, $c) = @_;
    		eval q(( &__extension__ ( &__builtin_constant_p  && == ord(\'\\\\0\') ?  &__rawmemchr ($s, $c) :  &strchr ($s, $c))));
	    }' unless defined(&strchr);
	}
    }
    if((!defined (defined(&_HAVE_STRING_ARCH_strcpy) ? &_HAVE_STRING_ARCH_strcpy : 0)  && ! &__GNUC_PREREQ (3, 0)) || defined (defined(&_FORCE_INLINES) ? &_FORCE_INLINES : 0)) {
	if(!defined (defined(&_HAVE_STRING_ARCH_strcpy) ? &_HAVE_STRING_ARCH_strcpy : 0)  && ! &__GNUC_PREREQ (3, 0)) {
	    eval 'sub strcpy {
	        my($dest, $src) = @_;
    		eval q(( &__extension__ ( &__builtin_constant_p ? ( &__string2_1bptr_p  &&  &strlen + 1<= 8?  &__strcpy_small ($dest,  &__strcpy_args ,  &strlen + 1) :  &memcpy ($dest, $src,  &strlen ($src) + 1)) :  &strcpy ($dest, $src))));
	    }' unless defined(&strcpy);
	}
	if((defined(&_STRING_ARCH_unaligned) ? &_STRING_ARCH_unaligned : 0)) {
	    unless(defined(&_FORCE_INLINES)) {
		eval 'sub __strcpy_args {
		    my($src) = @_;
    		    eval q( &__extension__  &__STRING2_SMALL_GET16 ($src, 0),  &__extension__  &__STRING2_SMALL_GET16 ($src, 4),  &__extension__  &__STRING2_SMALL_GET32 ($src, 0),  &__extension__  &__STRING2_SMALL_GET32 ($src, 4));
		}' unless defined(&__strcpy_args);
	    }
	} else {
	    unless(defined(&_FORCE_INLINES)) {
		eval 'sub __strcpy_args {
		    my($src) = @_;
    		    eval q( &__extension__ (( &__STRING2_COPY_ARR2) { { (( &__const \'char\' *) ($src))[0], ord(\'\\\\0\' } }),				   __extension__ ((__STRING2_COPY_ARR3)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  \'\\\\0\' } }),								   __extension__ ((__STRING2_COPY_ARR4)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  ((__const char *) (src))[2], \'\\\\0\' } }),				   __extension__ ((__STRING2_COPY_ARR5)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  ((__const char *) (src))[2], ((__const char *) (src))[3],	      	  \'\\\\0\' } }),								   __extension__ ((__STRING2_COPY_ARR6)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  ((__const char *) (src))[2], ((__const char *) (src))[3],	      	  ((__const char *) (src))[4], \'\\\\0\' } }),				   __extension__ ((__STRING2_COPY_ARR7)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  ((__const char *) (src))[2], ((__const char *) (src))[3],	      	  ((__const char *) (src))[4], ((__const char *) (src))[5],	      	  \'\\\\0\' } }),								   __extension__ ((__STRING2_COPY_ARR8)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  ((__const char *) (src))[2], ((__const char *) (src))[3],	      	  ((__const char *) (src))[4], ((__const char *) (src))[5],	      	  ((__const char *) (src))[6], \'\\\\0\') } }));
		}' unless defined(&__strcpy_args);
	    }
	}
    }
    if(defined(&__USE_GNU)) {
	if(!defined (defined(&_HAVE_STRING_ARCH_stpcpy) ? &_HAVE_STRING_ARCH_stpcpy : 0) || defined (defined(&_FORCE_INLINES) ? &_FORCE_INLINES : 0)) {
	    unless(defined(&_HAVE_STRING_ARCH_stpcpy)) {
		if( &__GNUC_PREREQ (3, 4)) {
		    eval 'sub __stpcpy {
		        my($dest, $src) = @_;
    			eval q( &__builtin_stpcpy ($dest, $src));
		    }' unless defined(&__stpcpy);
		}
 elsif( &__GNUC_PREREQ (3, 0)) {
		    eval 'sub __stpcpy {
		        my($dest, $src) = @_;
    			eval q(( &__extension__ ( &__builtin_constant_p ? ( &__string2_1bptr_p  &&  &strlen + 1<= 8?  &__builtin_strcpy ($dest, $src) +  &strlen : ( ( &__mempcpy) ($dest, $src,  &strlen ($src) + 1) - 1)) :  &__stpcpy ($dest, $src))));
		    }' unless defined(&__stpcpy);
		} else {
		    eval 'sub __stpcpy {
		        my($dest, $src) = @_;
    			eval q(( &__extension__ ( &__builtin_constant_p ? ( &__string2_1bptr_p  &&  &strlen + 1<= 8?  &__stpcpy_small ($dest,  &__stpcpy_args ,  &strlen + 1) : ( ( &__mempcpy) ($dest, $src,  &strlen ($src) + 1) - 1)) :  &__stpcpy ($dest, $src))));
		    }' unless defined(&__stpcpy);
		}
		eval 'sub stpcpy {
		    my($dest, $src) = @_;
    		    eval q( &__stpcpy ($dest, $src));
		}' unless defined(&stpcpy);
	    }
	    if(! &__GNUC_PREREQ (3, 0) || defined (defined(&_FORCE_INLINES) ? &_FORCE_INLINES : 0)) {
		if((defined(&_STRING_ARCH_unaligned) ? &_STRING_ARCH_unaligned : 0)) {
		    unless(defined(&_FORCE_INLINES)) {
			eval 'sub __stpcpy_args {
			    my($src) = @_;
    			    eval q( &__extension__  &__STRING2_SMALL_GET16 ($src, 0),  &__extension__  &__STRING2_SMALL_GET16 ($src, 4),  &__extension__  &__STRING2_SMALL_GET32 ($src, 0),  &__extension__  &__STRING2_SMALL_GET32 ($src, 4));
			}' unless defined(&__stpcpy_args);
		    }
		} else {
		    unless(defined(&_FORCE_INLINES)) {
			eval 'sub __stpcpy_args {
			    my($src) = @_;
    			    eval q( &__extension__ (( &__STRING2_COPY_ARR2) { { (( &__const \'char\' *) ($src))[0], ord(\'\\\\0\' } }),				   __extension__ ((__STRING2_COPY_ARR3)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  \'\\\\0\' } }),								   __extension__ ((__STRING2_COPY_ARR4)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  ((__const char *) (src))[2], \'\\\\0\' } }),				   __extension__ ((__STRING2_COPY_ARR5)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  ((__const char *) (src))[2], ((__const char *) (src))[3],	      	  \'\\\\0\' } }),								   __extension__ ((__STRING2_COPY_ARR6)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  ((__const char *) (src))[2], ((__const char *) (src))[3],	      	  ((__const char *) (src))[4], \'\\\\0\' } }),				   __extension__ ((__STRING2_COPY_ARR7)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  ((__const char *) (src))[2], ((__const char *) (src))[3],	      	  ((__const char *) (src))[4], ((__const char *) (src))[5],	      	  \'\\\\0\' } }),								   __extension__ ((__STRING2_COPY_ARR8)					    { { ((__const char *) (src))[0], ((__const char *) (src))[1],	      	  ((__const char *) (src))[2], ((__const char *) (src))[3],	      	  ((__const char *) (src))[4], ((__const char *) (src))[5],	      	  ((__const char *) (src))[6], \'\\\\0\') } }));
			}' unless defined(&__stpcpy_args);
		    }
		}
	    }
	}
    }
    unless(defined(&_HAVE_STRING_ARCH_strncpy)) {
	if( &__GNUC_PREREQ (3, 2)) {
	    eval 'sub strncpy {
	        my($dest, $src, $n) = @_;
    		eval q( &__builtin_strncpy ($dest, $src, $n));
	    }' unless defined(&strncpy);
	} else {
	    eval 'sub strncpy {
	        my($dest, $src, $n) = @_;
    		eval q(( &__extension__ ( &__builtin_constant_p  &&  &__builtin_constant_p ? ( &strlen + 1>= ?  &memcpy ($dest, $src, $n) :  &strncpy ($dest, $src, $n)) :  &strncpy ($dest, $src, $n))));
	    }' unless defined(&strncpy);
	}
    }
    unless(defined(&_HAVE_STRING_ARCH_strncat)) {
	if(defined(&_USE_STRING_ARCH_strchr)) {
	    eval 'sub strncat {
	        my($dest, $src, $n) = @_;
    		eval q(( &__extension__ ({ \'char\' * &__dest = ;  &__builtin_constant_p  &&  &__builtin_constant_p ? ( &strlen < ?  &strcat ( &__dest, $src) : (*(  &__mempcpy ( &strchr ( &__dest, ord(\'\\\\0\'),	      						src, n)) = \'\\\\0\'),  &__dest)) :  &strncat ($dest, $src, $n); })));
	    }' unless defined(&strncat);
	}
 elsif( &__GNUC_PREREQ (3, 2)) {
	    eval 'sub strncat {
	        my($dest, $src, $n) = @_;
    		eval q( &__builtin_strncat ($dest, $src, $n));
	    }' unless defined(&strncat);
	} else {
	    eval 'sub strncat {
	        my($dest, $src, $n) = @_;
    		eval q(( &__extension__ ( &__builtin_constant_p  &&  &__builtin_constant_p ? ( &strlen < ( ($n)) ?  &strcat ($dest, $src) :  &strncat ($dest, $src, $n)) :  &strncat ($dest, $src, $n))));
	    }' unless defined(&strncat);
	}
    }
    unless(defined(&_HAVE_STRING_ARCH_strcmp)) {
	if( &__GNUC_PREREQ (3, 2)) {
	    eval 'sub strcmp {
	        my($s1, $s2) = @_;
    		eval q( &__extension__ ({ \'size_t\'  &__s1_len,  &__s2_len; ( &__builtin_constant_p ($s1)  &&  &__builtin_constant_p ($s2)  && ( &__s1_len =  &strlen ($s1),  &__s2_len =  &strlen ($s2), (! &__string2_1bptr_p ($s1) ||  &__s1_len >= 4)  && (! &__string2_1bptr_p ($s2) ||  &__s2_len >= 4)) ?  &__builtin_strcmp ($s1, $s2) : ( &__builtin_constant_p ($s1)  &&  &__string2_1bptr_p ($s1)  && ( &__s1_len =  &strlen ($s1),  &__s1_len < 4) ? ( &__builtin_constant_p ($s2)  &&  &__string2_1bptr_p ($s2) ?  &__builtin_strcmp ($s1, $s2) :  &__strcmp_cg ($s1, $s2,  &__s1_len)) : ( &__builtin_constant_p ($s2)  &&  &__string2_1bptr_p ($s2)  && ( &__s2_len =  &strlen ($s2),  &__s2_len < 4) ? ( &__builtin_constant_p ($s1)  &&  &__string2_1bptr_p ($s1) ?  &__builtin_strcmp ($s1, $s2) :  &__strcmp_gc ($s1, $s2,  &__s2_len)) :  &__builtin_strcmp ($s1, $s2)))); }));
	    }' unless defined(&strcmp);
	} else {
	    eval 'sub strcmp {
	        my($s1, $s2) = @_;
    		eval q( &__extension__ ({ \'size_t\'  &__s1_len,  &__s2_len; ( &__builtin_constant_p ($s1)  &&  &__builtin_constant_p ($s2)  && ( &__s1_len =  &strlen ($s1),  &__s2_len =  &strlen ($s2), (! &__string2_1bptr_p ($s1) ||  &__s1_len >= 4)  && (! &__string2_1bptr_p ($s2) ||  &__s2_len >= 4)) ?  &memcmp (( &__const \'char\' *) ($s1), ( &__const \'char\' *) ($s2), ( &__s1_len <  &__s2_len ?  &__s1_len :  &__s2_len) + 1) : ( &__builtin_constant_p ($s1)  &&  &__string2_1bptr_p ($s1)  && ( &__s1_len =  &strlen ($s1),  &__s1_len < 4) ? ( &__builtin_constant_p ($s2)  &&  &__string2_1bptr_p ($s2) ?  &__strcmp_cc ($s1, $s2,  &__s1_len) :  &__strcmp_cg ($s1, $s2,  &__s1_len)) : ( &__builtin_constant_p ($s2)  &&  &__string2_1bptr_p ($s2)  && ( &__s2_len =  &strlen ($s2),  &__s2_len < 4) ? ( &__builtin_constant_p ($s1)  &&  &__string2_1bptr_p ($s1) ?  &__strcmp_cc ($s1, $s2,  &__s2_len) :  &__strcmp_gc ($s1, $s2,  &__s2_len)) :  &strcmp ($s1, $s2)))); }));
	    }' unless defined(&strcmp);
	}
	eval 'sub __strcmp_cc {
	    my($s1, $s2, $l) = @_;
    	    eval q(( &__extension__ ({  &register \'int\'  &__result = ((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s1))[0] - (( &__const \'unsigned char\' *) ( &__const \'char\' *)($s2))[0]);  &if ($l > 0 &&  &__result == 0) {  &__result = ((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s1))[1] - (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s2))[1]);  &if ($l > 1 &&  &__result == 0) {  &__result = ((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s1))[2] - (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s2))[2]);  &if ($l > 2 &&  &__result == 0)  &__result = ((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s1))[3] - (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s2))[3]); } }  &__result; })));
	}' unless defined(&__strcmp_cc);
	eval 'sub __strcmp_cg {
	    my($s1, $s2, $l1) = @_;
    	    eval q(( &__extension__ ({  &__const \'unsigned char\' * &__s2 = ( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s2);  &register \'int\'  &__result = ((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s1))[0] -  $__s2[0]);  &if ($l1 > 0 &&  &__result == 0) {  &__result = ((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s1))[1] -  $__s2[1]);  &if ($l1 > 1 &&  &__result == 0) {  &__result = ((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s1))[2] -  $__s2[2]);  &if ($l1 > 2 &&  &__result == 0)  &__result = ((( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s1))[3] -  $__s2[3]); } }  &__result; })));
	}' unless defined(&__strcmp_cg);
	eval 'sub __strcmp_gc {
	    my($s1, $s2, $l2) = @_;
    	    eval q(( &__extension__ ({  &__const \'unsigned char\' * &__s1 = ( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s1);  &register \'int\'  &__result =  $__s1[0] - (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s2))[0];  &if ($l2 > 0 &&  &__result == 0) {  &__result = ( $__s1[1] - (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s2))[1]);  &if ($l2 > 1 &&  &__result == 0) {  &__result = ( $__s1[2] - (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s2))[2]);  &if ($l2 > 2 &&  &__result == 0)  &__result = ( $__s1[3] - (( &__const \'unsigned char\' *) ( &__const \'char\' *) ($s2))[3]); } }  &__result; })));
	}' unless defined(&__strcmp_gc);
    }
    unless(defined(&_HAVE_STRING_ARCH_strncmp)) {
	eval 'sub strncmp {
	    my($s1, $s2, $n) = @_;
    	    eval q(( &__extension__ ( &__builtin_constant_p  && (( &__builtin_constant_p  &&  &strlen < ) || ( &__builtin_constant_p  &&  &strlen < ( ($n)))) ?  &strcmp ($s1, $s2) :  &strncmp ($s1, $s2, $n))));
	}' unless defined(&strncmp);
    }
    if(!defined (defined(&_HAVE_STRING_ARCH_strcspn) ? &_HAVE_STRING_ARCH_strcspn : 0) || defined (defined(&_FORCE_INLINES) ? &_FORCE_INLINES : 0)) {
	unless(defined(&_HAVE_STRING_ARCH_strcspn)) {
	    if( &__GNUC_PREREQ (3, 2)) {
		eval 'sub strcspn {
		    my($s, $reject) = @_;
    		    eval q( &__extension__ ({ \'char\'  &__r0,  &__r1,  &__r2; ( &__builtin_constant_p ($reject)  &&  &__string2_1bptr_p ($reject) ? (( &__builtin_constant_p ($s)  &&  &__string2_1bptr_p ($s)) ?  &__builtin_strcspn ($s, $reject) : (( &__r0 = (( &__const \'char\' *) ($reject))[0],  &__r0 == ord(\'\\\\0\')	      	    ? strlen (s)						      	    : ((__r1 = ((__const char *) (reject))[1], __r1 == \'\\\\0\')	      	       ? __strcspn_c1 (s, __r0)					      	       : ((__r2 = ((__const char *) (reject))[2], __r2 == \'\\\\0\')	      		  ? __strcspn_c2 (s, __r0, __r1)			      		  : (((__const char *) (reject))[3] == \'\\\\0\') ?  &__strcspn_c3 ($s,  &__r0,  &__r1,  &__r2) :  &__builtin_strcspn ($s, $reject)))))) :  &__builtin_strcspn ($s, $reject)); }));
		}' unless defined(&strcspn);
	    } else {
		eval 'sub strcspn {
		    my($s, $reject) = @_;
    		    eval q( &__extension__ ({ \'char\'  &__r0,  &__r1,  &__r2; ( &__builtin_constant_p ($reject)  &&  &__string2_1bptr_p ($reject) ? (( &__r0 = (( &__const \'char\' *) ($reject))[0],  &__r0 == ord(\'\\\\0\')		      	 ? strlen (s)							      	 : ((__r1 = ((__const char *) (reject))[1], __r1 == \'\\\\0\')	      	    ? __strcspn_c1 (s, __r0)					      	    : ((__r2 = ((__const char *) (reject))[2], __r2 == \'\\\\0\')	      	       ? __strcspn_c2 (s, __r0, __r1)				      	       : (((__const char *) (reject))[3] == \'\\\\0\') ?  &__strcspn_c3 ($s,  &__r0,  &__r1,  &__r2) :  &strcspn ($s, $reject))))) :  &strcspn ($s, $reject)); }));
		}' unless defined(&strcspn);
	    }
	}
    }
    if(!defined (defined(&_HAVE_STRING_ARCH_strspn) ? &_HAVE_STRING_ARCH_strspn : 0) || defined (defined(&_FORCE_INLINES) ? &_FORCE_INLINES : 0)) {
	unless(defined(&_HAVE_STRING_ARCH_strspn)) {
	    if( &__GNUC_PREREQ (3, 2)) {
		eval 'sub strspn {
		    my($s, $accept) = @_;
    		    eval q( &__extension__ ({ \'char\'  &__a0,  &__a1,  &__a2; ( &__builtin_constant_p ($accept)  &&  &__string2_1bptr_p ($accept) ? (( &__builtin_constant_p ($s)  &&  &__string2_1bptr_p ($s)) ?  &__builtin_strspn ($s, $accept) : (( &__a0 = (( &__const \'char\' *) ($accept))[0],  &__a0 == ord(\'\\\\0\')	      	    ? ((void) (s), 0)						      	    : ((__a1 = ((__const char *) (accept))[1], __a1 == \'\\\\0\')	      	       ? __strspn_c1 (s, __a0)					      	       : ((__a2 = ((__const char *) (accept))[2], __a2 == \'\\\\0\')	      		  ? __strspn_c2 (s, __a0, __a1)				      		  : (((__const char *) (accept))[3] == \'\\\\0\') ?  &__strspn_c3 ($s,  &__a0,  &__a1,  &__a2) :  &__builtin_strspn ($s, $accept)))))) :  &__builtin_strspn ($s, $accept)); }));
		}' unless defined(&strspn);
	    } else {
		eval 'sub strspn {
		    my($s, $accept) = @_;
    		    eval q( &__extension__ ({ \'char\'  &__a0,  &__a1,  &__a2; ( &__builtin_constant_p ($accept)  &&  &__string2_1bptr_p ($accept) ? (( &__a0 = (( &__const \'char\' *) ($accept))[0],  &__a0 == ord(\'\\\\0\')		      	 ? ((void) (s), 0)						      	 : ((__a1 = ((__const char *) (accept))[1], __a1 == \'\\\\0\')	      	    ? __strspn_c1 (s, __a0)					      	    : ((__a2 = ((__const char *) (accept))[2], __a2 == \'\\\\0\')	      	       ? __strspn_c2 (s, __a0, __a1)				      	       : (((__const char *) (accept))[3] == \'\\\\0\') ?  &__strspn_c3 ($s,  &__a0,  &__a1,  &__a2) :  &strspn ($s, $accept))))) :  &strspn ($s, $accept)); }));
		}' unless defined(&strspn);
	    }
	}
    }
    if(!defined (defined(&_HAVE_STRING_ARCH_strpbrk) ? &_HAVE_STRING_ARCH_strpbrk : 0) || defined (defined(&_FORCE_INLINES) ? &_FORCE_INLINES : 0)) {
	unless(defined(&_HAVE_STRING_ARCH_strpbrk)) {
	    if( &__GNUC_PREREQ (3, 2)) {
		eval 'sub strpbrk {
		    my($s, $accept) = @_;
    		    eval q( &__extension__ ({ \'char\'  &__a0,  &__a1,  &__a2; ( &__builtin_constant_p ($accept)  &&  &__string2_1bptr_p ($accept) ? (( &__builtin_constant_p ($s)  &&  &__string2_1bptr_p ($s)) ?  &__builtin_strpbrk ($s, $accept) : (( &__a0 = (( &__const \'char\' *) ($accept))[0],  &__a0 == ord(\'\\\\0\')	      	    ? ((void) (s), (char *) NULL)				      	    : ((__a1 = ((__const char *) (accept))[1], __a1 == \'\\\\0\')	      	       ? __builtin_strchr (s, __a0)				      	       : ((__a2 = ((__const char *) (accept))[2], __a2 == \'\\\\0\')	      		  ? __strpbrk_c2 (s, __a0, __a1)			      		  : (((__const char *) (accept))[3] == \'\\\\0\') ?  &__strpbrk_c3 ($s,  &__a0,  &__a1,  &__a2) :  &__builtin_strpbrk ($s, $accept)))))) :  &__builtin_strpbrk ($s, $accept)); }));
		}' unless defined(&strpbrk);
	    } else {
		eval 'sub strpbrk {
		    my($s, $accept) = @_;
    		    eval q( &__extension__ ({ \'char\'  &__a0,  &__a1,  &__a2; ( &__builtin_constant_p ($accept)  &&  &__string2_1bptr_p ($accept) ? (( &__a0 = (( &__const \'char\' *) ($accept))[0],  &__a0 == ord(\'\\\\0\')		      	 ? ((void) (s), (char *) NULL)					      	 : ((__a1 = ((__const char *) (accept))[1], __a1 == \'\\\\0\')	      	    ? strchr (s, __a0)						      	    : ((__a2 = ((__const char *) (accept))[2], __a2 == \'\\\\0\')	      	       ? __strpbrk_c2 (s, __a0, __a1)				      	       : (((__const char *) (accept))[3] == \'\\\\0\') ?  &__strpbrk_c3 ($s,  &__a0,  &__a1,  &__a2) :  &strpbrk ($s, $accept))))) :  &strpbrk ($s, $accept)); }));
		}' unless defined(&strpbrk);
	    }
	}
    }
    if(!defined (defined(&_HAVE_STRING_ARCH_strstr) ? &_HAVE_STRING_ARCH_strstr : 0)  && ! &__GNUC_PREREQ (2, 97)) {
	eval 'sub strstr {
	    my($haystack, $needle) = @_;
    	    eval q(( &__extension__ ( &__builtin_constant_p ($needle)  &&  &__string2_1bptr_p ($needle) ? ((( &__const \'char\' *) )[0] == ord(\'\\\\0\'		      		     ?   (haystack)			      		     : (((__const char *) (needle))[1] == \'\\\\0\') ?  &strchr ($haystack, (( &__const \'char\' *) ($needle))[0]) :  &strstr ($haystack, $needle))) :  &strstr ($haystack, $needle))));
	}' unless defined(&strstr);
    }
    if(!defined (defined(&_HAVE_STRING_ARCH_strtok_r) ? &_HAVE_STRING_ARCH_strtok_r : 0) || defined (defined(&_FORCE_INLINES) ? &_FORCE_INLINES : 0)) {
	unless(defined(&_HAVE_STRING_ARCH_strtok_r)) {
	    eval 'sub __strtok_r {
	        my($s, $sep, $nextp) = @_;
    		eval q(( &__extension__ ( &__builtin_constant_p ($sep)  &&  &__string2_1bptr_p ($sep) ? ((( &__const \'char\' *) ($sep))[0] != ord(\'\\\\0\'		      		     && ((__const char *) (sep))[1] == \'\\\\0\') ?  &__strtok_r_1c ($s, (( &__const \'char\' *) ($sep))[0], $nextp) :  &__strtok_r ($s, $sep, $nextp)) :  &__strtok_r ($s, $sep, $nextp))));
	    }' unless defined(&__strtok_r);
	}
	if(defined (defined(&__USE_POSIX) ? &__USE_POSIX : 0) || defined (defined(&__USE_MISC) ? &__USE_MISC : 0)) {
	    eval 'sub strtok_r {
	        my($s, $sep, $nextp) = @_;
    		eval q( &__strtok_r ($s, $sep, $nextp));
	    }' unless defined(&strtok_r);
	}
    }
    if(!defined (defined(&_HAVE_STRING_ARCH_strsep) ? &_HAVE_STRING_ARCH_strsep : 0) || defined (defined(&_FORCE_INLINES) ? &_FORCE_INLINES : 0)) {
	unless(defined(&_HAVE_STRING_ARCH_strsep)) {
	    eval 'sub __strsep {
	        my($s, $reject) = @_;
    		eval q( &__extension__ ({ \'char\'  &__r0,  &__r1,  &__r2; ( &__builtin_constant_p ($reject)  &&  &__string2_1bptr_p ($reject)  && ( &__r0 = (( &__const \'char\' *) ($reject))[0], (( &__const \'char\' *) ($reject))[0] != ord(\'\\\\0\')				    ? ((__r1 = ((__const char *) (reject))[1],			      	 ((__const char *) (reject))[1] == \'\\\\0\')			      	 ? __strsep_1c (s, __r0)					      	 : ((__r2 = ((__const char *) (reject))[2], __r2 == \'\\\\0\')	      	    ? __strsep_2c (s, __r0, __r1)				      	    : (((__const char *) (reject))[3] == \'\\\\0\') ?  &__strsep_3c ($s,  &__r0,  &__r1,  &__r2) :  &__strsep_g ($s, $reject)))) :  &__strsep_g ($s, $reject)); }));
	    }' unless defined(&__strsep);
	}
	if(defined(&__USE_BSD)) {
	    eval 'sub strsep {
	        my($s, $reject) = @_;
    		eval q( &__strsep ($s, $reject));
	    }' unless defined(&strsep);
	}
    }
    if(defined(&__USE_MISC)) {
	if(!defined (defined(&_HAVE_STRING_ARCH_strdup) ? &_HAVE_STRING_ARCH_strdup : 0) || !defined (defined(&_HAVE_STRING_ARCH_strndup) ? &_HAVE_STRING_ARCH_strndup : 0)) {
	    eval 'sub __need_malloc_and_calloc () {1;}' unless defined(&__need_malloc_and_calloc);
	    require 'stdlib.ph';
	}
	unless(defined(&_HAVE_STRING_ARCH_strdup)) {
	    eval 'sub __strdup {
	        my($s) = @_;
    		eval q(( &__extension__ ( &__builtin_constant_p ($s)  &&  &__string2_1bptr_p ($s) ? ((( &__const \'char\' *) )[0] == ord(\'\\\\0\') ?  &calloc (1, 1) : ({ \'size_t\'  &__len =  &strlen + 1; \'char\' * &__retval =  &malloc ;  &if ( &__retval !=  &NULL)  &__retval =  &memcpy ( &__retval, $s,  &__len);  &__retval; })) :  &__strdup ($s))));
	    }' unless defined(&__strdup);
	    if(defined (defined(&__USE_SVID) ? &__USE_SVID : 0) || defined (defined(&__USE_BSD) ? &__USE_BSD : 0) || defined (defined(&__USE_XOPEN_EXTENDED) ? &__USE_XOPEN_EXTENDED : 0)) {
		eval 'sub strdup {
		    my($s) = @_;
    		    eval q( &__strdup ($s));
		}' unless defined(&strdup);
	    }
	}
	unless(defined(&_HAVE_STRING_ARCH_strndup)) {
	    eval 'sub __strndup {
	        my($s, $n) = @_;
    		eval q(( &__extension__ ( &__builtin_constant_p ($s)  &&  &__string2_1bptr_p ($s) ? ((( &__const \'char\' *) )[0] == ord(\'\\\\0\'			      		     ?  calloc (1, 1)				      		     : ({ size_t __len = strlen  + 1;		      			  size_t __n = ;				      			  char *__retval;				      			  if (__n < __len)				      			    __len = __n + 1;				      			  __retval =  malloc ;		      			  if (__retval != NULL)				      			    {						      			      __retval[__len - 1] = \'\\\\0\');  &__retval =  &memcpy ( &__retval, $s,  &__len - 1); }  &__retval; })) :  &__strndup ($s, $n))));
	    }' unless defined(&__strndup);
	    if(defined(&__USE_GNU)) {
		eval 'sub strndup {
		    my($s, $n) = @_;
    		    eval q( &__strndup ($s, $n));
		}' unless defined(&strndup);
	    }
	}
    }
    unless(defined(&_FORCE_INLINES)) {
	undef(&__STRING_INLINE) if defined(&__STRING_INLINE);
    }
}
1;
