require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DB_H_)) {
    eval 'sub _DB_H_ () {1;}' unless defined(&_DB_H_);
    unless(defined(&__NO_SYSTEM_INCLUDES)) {
	require 'sys/types.ph';
	require 'inttypes.ph';
	require 'stdint.ph';
	require 'stddef.ph';
	require 'stdio.ph';
	require 'unistd.ph';
	require 'pthread.ph';
    }
    if(defined( &__cplusplus)) {
    }
    undef(&__P) if defined(&__P);
    eval 'sub __P {
        my($protos) = @_;
	    eval q($protos);
    }' unless defined(&__P);
    eval 'sub DB_VERSION_MAJOR () {4;}' unless defined(&DB_VERSION_MAJOR);
    eval 'sub DB_VERSION_MINOR () {5;}' unless defined(&DB_VERSION_MINOR);
    eval 'sub DB_VERSION_PATCH () {20;}' unless defined(&DB_VERSION_PATCH);
    eval 'sub DB_VERSION_STRING () {"Berkeley DB 4.5.20: (September 20, 2006)";}' unless defined(&DB_VERSION_STRING);
    unless(defined(&__BIT_TYPES_DEFINED__)) {
	eval 'sub __BIT_TYPES_DEFINED__ () {1;}' unless defined(&__BIT_TYPES_DEFINED__);
    }
    eval 'sub DB_MAX_PAGES () {0xffffffff;}' unless defined(&DB_MAX_PAGES);
    eval 'sub DB_MAX_RECORDS () {0xffffffff;}' unless defined(&DB_MAX_RECORDS);
    eval 'sub DB_DBT_APPMALLOC () {0x1;}' unless defined(&DB_DBT_APPMALLOC);
    eval 'sub DB_DBT_ISSET () {0x2;}' unless defined(&DB_DBT_ISSET);
    eval 'sub DB_DBT_MALLOC () {0x4;}' unless defined(&DB_DBT_MALLOC);
    eval 'sub DB_DBT_PARTIAL () {0x8;}' unless defined(&DB_DBT_PARTIAL);
    eval 'sub DB_DBT_REALLOC () {0x10;}' unless defined(&DB_DBT_REALLOC);
    eval 'sub DB_DBT_USERCOPY () {0x20;}' unless defined(&DB_DBT_USERCOPY);
    eval 'sub DB_DBT_USERMEM () {0x40;}' unless defined(&DB_DBT_USERMEM);
    eval 'sub DB_DBT_DUPOK () {0x80;}' unless defined(&DB_DBT_DUPOK);
    eval 'sub DB_CREATE () {0x1;}' unless defined(&DB_CREATE);
    eval 'sub DB_DURABLE_UNKNOWN () {0x2;}' unless defined(&DB_DURABLE_UNKNOWN);
    eval 'sub DB_FORCE () {0x4;}' unless defined(&DB_FORCE);
    eval 'sub DB_MULTIVERSION () {0x8;}' unless defined(&DB_MULTIVERSION);
    eval 'sub DB_NOMMAP () {0x10;}' unless defined(&DB_NOMMAP);
    eval 'sub DB_RDONLY () {0x20;}' unless defined(&DB_RDONLY);
    eval 'sub DB_RECOVER () {0x40;}' unless defined(&DB_RECOVER);
    eval 'sub DB_THREAD () {0x80;}' unless defined(&DB_THREAD);
    eval 'sub DB_TRUNCATE () {0x100;}' unless defined(&DB_TRUNCATE);
    eval 'sub DB_TXN_NOSYNC () {0x200;}' unless defined(&DB_TXN_NOSYNC);
    eval 'sub DB_TXN_NOT_DURABLE () {0x400;}' unless defined(&DB_TXN_NOT_DURABLE);
    eval 'sub DB_TXN_WRITE_NOSYNC () {0x800;}' unless defined(&DB_TXN_WRITE_NOSYNC);
    eval 'sub DB_USE_ENVIRON () {0x1000;}' unless defined(&DB_USE_ENVIRON);
    eval 'sub DB_USE_ENVIRON_ROOT () {0x2000;}' unless defined(&DB_USE_ENVIRON_ROOT);
    eval 'sub DB_AUTO_COMMIT () {0x2000000;}' unless defined(&DB_AUTO_COMMIT);
    eval 'sub DB_READ_COMMITTED () {0x4000000;}' unless defined(&DB_READ_COMMITTED);
    eval 'sub DB_DEGREE_2 () {0x4000000;}' unless defined(&DB_DEGREE_2);
    eval 'sub DB_READ_UNCOMMITTED () {0x8000000;}' unless defined(&DB_READ_UNCOMMITTED);
    eval 'sub DB_DIRTY_READ () {0x8000000;}' unless defined(&DB_DIRTY_READ);
    eval 'sub DB_TXN_SNAPSHOT () {0x10000000;}' unless defined(&DB_TXN_SNAPSHOT);
    eval 'sub DB_CXX_NO_EXCEPTIONS () {0x1;}' unless defined(&DB_CXX_NO_EXCEPTIONS);
    eval 'sub DB_RPCCLIENT () {0x2;}' unless defined(&DB_RPCCLIENT);
    eval 'sub DB_XA_CREATE () {0x2;}' unless defined(&DB_XA_CREATE);
    eval 'sub DB_INIT_CDB () {0x4000;}' unless defined(&DB_INIT_CDB);
    eval 'sub DB_INIT_LOCK () {0x8000;}' unless defined(&DB_INIT_LOCK);
    eval 'sub DB_INIT_LOG () {0x10000;}' unless defined(&DB_INIT_LOG);
    eval 'sub DB_INIT_MPOOL () {0x20000;}' unless defined(&DB_INIT_MPOOL);
    eval 'sub DB_INIT_REP () {0x40000;}' unless defined(&DB_INIT_REP);
    eval 'sub DB_INIT_TXN () {0x80000;}' unless defined(&DB_INIT_TXN);
    eval 'sub DB_LOCKDOWN () {0x100000;}' unless defined(&DB_LOCKDOWN);
    eval 'sub DB_PRIVATE () {0x200000;}' unless defined(&DB_PRIVATE);
    eval 'sub DB_RECOVER_FATAL () {0x400000;}' unless defined(&DB_RECOVER_FATAL);
    eval 'sub DB_REGISTER () {0x800000;}' unless defined(&DB_REGISTER);
    eval 'sub DB_SYSTEM_MEM () {0x1000000;}' unless defined(&DB_SYSTEM_MEM);
    eval 'sub DB_JOINENV () {0x;}' unless defined(&DB_JOINENV);
    eval 'sub DB_EXCL () {0x4000;}' unless defined(&DB_EXCL);
    eval 'sub DB_FCNTL_LOCKING () {0x8000;}' unless defined(&DB_FCNTL_LOCKING);
    eval 'sub DB_NO_AUTO_COMMIT () {0x10000;}' unless defined(&DB_NO_AUTO_COMMIT);
    eval 'sub DB_RDWRMASTER () {0x20000;}' unless defined(&DB_RDWRMASTER);
    eval 'sub DB_WRITEOPEN () {0x40000;}' unless defined(&DB_WRITEOPEN);
    eval 'sub DB_IMMUTABLE_KEY () {0x4000;}' unless defined(&DB_IMMUTABLE_KEY);
    eval 'sub DB_TXN_NOWAIT () {0x4000;}' unless defined(&DB_TXN_NOWAIT);
    eval 'sub DB_TXN_SYNC () {0x8000;}' unless defined(&DB_TXN_SYNC);
    eval 'sub DB_ENCRYPT_AES () {0x1;}' unless defined(&DB_ENCRYPT_AES);
    eval 'sub DB_CDB_ALLDB () {0x4000;}' unless defined(&DB_CDB_ALLDB);
    eval 'sub DB_DIRECT_DB () {0x8000;}' unless defined(&DB_DIRECT_DB);
    eval 'sub DB_DIRECT_LOG () {0x10000;}' unless defined(&DB_DIRECT_LOG);
    eval 'sub DB_DSYNC_DB () {0x20000;}' unless defined(&DB_DSYNC_DB);
    eval 'sub DB_DSYNC_LOG () {0x40000;}' unless defined(&DB_DSYNC_LOG);
    eval 'sub DB_LOG_AUTOREMOVE () {0x80000;}' unless defined(&DB_LOG_AUTOREMOVE);
    eval 'sub DB_LOG_INMEMORY () {0x100000;}' unless defined(&DB_LOG_INMEMORY);
    eval 'sub DB_NOLOCKING () {0x200000;}' unless defined(&DB_NOLOCKING);
    eval 'sub DB_NOPANIC () {0x400000;}' unless defined(&DB_NOPANIC);
    eval 'sub DB_OVERWRITE () {0x800000;}' unless defined(&DB_OVERWRITE);
    eval 'sub DB_PANIC_ENVIRONMENT () {0x1000000;}' unless defined(&DB_PANIC_ENVIRONMENT);
    eval 'sub DB_REGION_INIT () {0x20000000;}' unless defined(&DB_REGION_INIT);
    eval 'sub DB_TIME_NOTGRANTED () {0x40000000;}' unless defined(&DB_TIME_NOTGRANTED);
    eval 'sub DB_YIELDCPU () {0x80000000;}' unless defined(&DB_YIELDCPU);
    eval 'sub DB_UPGRADE () {0x1;}' unless defined(&DB_UPGRADE);
    eval 'sub DB_VERIFY () {0x2;}' unless defined(&DB_VERIFY);
    eval 'sub DB_FREELIST_ONLY () {0x4000;}' unless defined(&DB_FREELIST_ONLY);
    eval 'sub DB_FREE_SPACE () {0x8000;}' unless defined(&DB_FREE_SPACE);
    eval 'sub DB_COMPACT_FLAGS () {( &DB_FREELIST_ONLY |  &DB_FREE_SPACE);}' unless defined(&DB_COMPACT_FLAGS);
    eval 'sub DB_DIRECT () {0x4000;}' unless defined(&DB_DIRECT);
    eval 'sub DB_EXTENT () {0x8000;}' unless defined(&DB_EXTENT);
    eval 'sub DB_ODDFILESIZE () {0x10000;}' unless defined(&DB_ODDFILESIZE);
    eval 'sub DB_CHKSUM () {0x4000;}' unless defined(&DB_CHKSUM);
    eval 'sub DB_DUP () {0x8000;}' unless defined(&DB_DUP);
    eval 'sub DB_DUPSORT () {0x10000;}' unless defined(&DB_DUPSORT);
    eval 'sub DB_ENCRYPT () {0x20000;}' unless defined(&DB_ENCRYPT);
    eval 'sub DB_INORDER () {0x40000;}' unless defined(&DB_INORDER);
    eval 'sub DB_RECNUM () {0x80000;}' unless defined(&DB_RECNUM);
    eval 'sub DB_RENUMBER () {0x100000;}' unless defined(&DB_RENUMBER);
    eval 'sub DB_REVSPLITOFF () {0x200000;}' unless defined(&DB_REVSPLITOFF);
    eval 'sub DB_SNAPSHOT () {0x400000;}' unless defined(&DB_SNAPSHOT);
    eval 'sub DB_FAST_STAT () {0x1;}' unless defined(&DB_FAST_STAT);
    eval 'sub DB_STAT_ALL () {0x2;}' unless defined(&DB_STAT_ALL);
    eval 'sub DB_STAT_CLEAR () {0x4;}' unless defined(&DB_STAT_CLEAR);
    eval 'sub DB_STAT_LOCK_CONF () {0x8;}' unless defined(&DB_STAT_LOCK_CONF);
    eval 'sub DB_STAT_LOCK_LOCKERS () {0x10;}' unless defined(&DB_STAT_LOCK_LOCKERS);
    eval 'sub DB_STAT_LOCK_OBJECTS () {0x20;}' unless defined(&DB_STAT_LOCK_OBJECTS);
    eval 'sub DB_STAT_LOCK_PARAMS () {0x40;}' unless defined(&DB_STAT_LOCK_PARAMS);
    eval 'sub DB_STAT_MEMP_HASH () {0x80;}' unless defined(&DB_STAT_MEMP_HASH);
    eval 'sub DB_STAT_NOERROR () {0x100;}' unless defined(&DB_STAT_NOERROR);
    eval 'sub DB_STAT_SUBSYSTEM () {0x200;}' unless defined(&DB_STAT_SUBSYSTEM);
    eval 'sub DB_JOIN_NOSORT () {0x1;}' unless defined(&DB_JOIN_NOSORT);
    eval 'sub DB_AGGRESSIVE () {0x1;}' unless defined(&DB_AGGRESSIVE);
    eval 'sub DB_NOORDERCHK () {0x2;}' unless defined(&DB_NOORDERCHK);
    eval 'sub DB_ORDERCHKONLY () {0x4;}' unless defined(&DB_ORDERCHKONLY);
    eval 'sub DB_PR_PAGE () {0x8;}' unless defined(&DB_PR_PAGE);
    eval 'sub DB_PR_RECOVERYTEST () {0x10;}' unless defined(&DB_PR_RECOVERYTEST);
    eval 'sub DB_PRINTABLE () {0x20;}' unless defined(&DB_PRINTABLE);
    eval 'sub DB_SALVAGE () {0x40;}' unless defined(&DB_SALVAGE);
    eval 'sub DB_UNREF () {0x80;}' unless defined(&DB_UNREF);
    eval 'sub DB_REP_ANYWHERE () {0x1;}' unless defined(&DB_REP_ANYWHERE);
    eval 'sub DB_REP_NOBUFFER () {0x2;}' unless defined(&DB_REP_NOBUFFER);
    eval 'sub DB_REP_PERMANENT () {0x4;}' unless defined(&DB_REP_PERMANENT);
    eval 'sub DB_REP_REREQUEST () {0x8;}' unless defined(&DB_REP_REREQUEST);
    eval 'sub DB_MUTEX_ALLOCATED () {0x1;}' unless defined(&DB_MUTEX_ALLOCATED);
    eval 'sub DB_MUTEX_LOCKED () {0x2;}' unless defined(&DB_MUTEX_LOCKED);
    eval 'sub DB_MUTEX_LOGICAL_LOCK () {0x4;}' unless defined(&DB_MUTEX_LOGICAL_LOCK);
    eval 'sub DB_MUTEX_PROCESS_ONLY () {0x8;}' unless defined(&DB_MUTEX_PROCESS_ONLY);
    eval 'sub DB_MUTEX_SELF_BLOCK () {0x10;}' unless defined(&DB_MUTEX_SELF_BLOCK);
    eval 'sub DB_THREADID_STRLEN () {128;}' unless defined(&DB_THREADID_STRLEN);
    eval 'sub DB_LOCKVERSION () {1;}' unless defined(&DB_LOCKVERSION);
    eval 'sub DB_FILE_ID_LEN () {20;}' unless defined(&DB_FILE_ID_LEN);
    eval 'sub DB_LOCK_NORUN () {0;}' unless defined(&DB_LOCK_NORUN);
    eval 'sub DB_LOCK_DEFAULT () {1;}' unless defined(&DB_LOCK_DEFAULT);
    eval 'sub DB_LOCK_EXPIRE () {2;}' unless defined(&DB_LOCK_EXPIRE);
    eval 'sub DB_LOCK_MAXLOCKS () {3;}' unless defined(&DB_LOCK_MAXLOCKS);
    eval 'sub DB_LOCK_MAXWRITE () {4;}' unless defined(&DB_LOCK_MAXWRITE);
    eval 'sub DB_LOCK_MINLOCKS () {5;}' unless defined(&DB_LOCK_MINLOCKS);
    eval 'sub DB_LOCK_MINWRITE () {6;}' unless defined(&DB_LOCK_MINWRITE);
    eval 'sub DB_LOCK_OLDEST () {7;}' unless defined(&DB_LOCK_OLDEST);
    eval 'sub DB_LOCK_RANDOM () {8;}' unless defined(&DB_LOCK_RANDOM);
    eval 'sub DB_LOCK_YOUNGEST () {9;}' unless defined(&DB_LOCK_YOUNGEST);
    eval 'sub DB_LOCK_ABORT () {0x1;}' unless defined(&DB_LOCK_ABORT);
    eval 'sub DB_LOCK_NOWAIT () {0x2;}' unless defined(&DB_LOCK_NOWAIT);
    eval 'sub DB_LOCK_RECORD () {0x4;}' unless defined(&DB_LOCK_RECORD);
    eval 'sub DB_LOCK_SET_TIMEOUT () {0x8;}' unless defined(&DB_LOCK_SET_TIMEOUT);
    eval 'sub DB_LOCK_SWITCH () {0x10;}' unless defined(&DB_LOCK_SWITCH);
    eval 'sub DB_LOCK_UPGRADE () {0x20;}' unless defined(&DB_LOCK_UPGRADE);
    eval("sub DB_LOCK_NG () { 0; }") unless defined(&DB_LOCK_NG);
    eval("sub DB_LOCK_READ () { 1; }") unless defined(&DB_LOCK_READ);
    eval("sub DB_LOCK_WRITE () { 2; }") unless defined(&DB_LOCK_WRITE);
    eval("sub DB_LOCK_WAIT () { 3; }") unless defined(&DB_LOCK_WAIT);
    eval("sub DB_LOCK_IWRITE () { 4; }") unless defined(&DB_LOCK_IWRITE);
    eval("sub DB_LOCK_IREAD () { 5; }") unless defined(&DB_LOCK_IREAD);
    eval("sub DB_LOCK_IWR () { 6; }") unless defined(&DB_LOCK_IWR);
    eval("sub DB_LOCK_READ_UNCOMMITTED () { 7; }") unless defined(&DB_LOCK_READ_UNCOMMITTED);
    eval("sub DB_LOCK_WWRITE () { 8; }") unless defined(&DB_LOCK_WWRITE);
    eval("sub DB_LOCK_DUMP () { 0; }") unless defined(&DB_LOCK_DUMP);
    eval("sub DB_LOCK_GET () { 1; }") unless defined(&DB_LOCK_GET);
    eval("sub DB_LOCK_GET_TIMEOUT () { 2; }") unless defined(&DB_LOCK_GET_TIMEOUT);
    eval("sub DB_LOCK_INHERIT () { 3; }") unless defined(&DB_LOCK_INHERIT);
    eval("sub DB_LOCK_PUT () { 4; }") unless defined(&DB_LOCK_PUT);
    eval("sub DB_LOCK_PUT_ALL () { 5; }") unless defined(&DB_LOCK_PUT_ALL);
    eval("sub DB_LOCK_PUT_OBJ () { 6; }") unless defined(&DB_LOCK_PUT_OBJ);
    eval("sub DB_LOCK_PUT_READ () { 7; }") unless defined(&DB_LOCK_PUT_READ);
    eval("sub DB_LOCK_TIMEOUT () { 8; }") unless defined(&DB_LOCK_TIMEOUT);
    eval("sub DB_LOCK_TRADE () { 9; }") unless defined(&DB_LOCK_TRADE);
    eval("sub DB_LOCK_UPGRADE_WRITE () { 10; }") unless defined(&DB_LOCK_UPGRADE_WRITE);
    eval("sub DB_LSTAT_ABORTED () { 1; }") unless defined(&DB_LSTAT_ABORTED);
    eval("sub DB_LSTAT_EXPIRED () { 2; }") unless defined(&DB_LSTAT_EXPIRED);
    eval("sub DB_LSTAT_FREE () { 3; }") unless defined(&DB_LSTAT_FREE);
    eval("sub DB_LSTAT_HELD () { 4; }") unless defined(&DB_LSTAT_HELD);
    eval("sub DB_LSTAT_PENDING () { 5; }") unless defined(&DB_LSTAT_PENDING);
    eval("sub DB_LSTAT_WAITING () { 6; }") unless defined(&DB_LSTAT_WAITING);
    eval 'sub DB_HANDLE_LOCK () {1;}' unless defined(&DB_HANDLE_LOCK);
    eval 'sub DB_RECORD_LOCK () {2;}' unless defined(&DB_RECORD_LOCK);
    eval 'sub DB_PAGE_LOCK () {3;}' unless defined(&DB_PAGE_LOCK);
    eval 'sub DB_LOGVERSION () {12;}' unless defined(&DB_LOGVERSION);
    eval 'sub DB_LOGOLDVER () {8;}' unless defined(&DB_LOGOLDVER);
    eval 'sub DB_LOGMAGIC () {0x40988;}' unless defined(&DB_LOGMAGIC);
    eval 'sub DB_ARCH_ABS () {0x1;}' unless defined(&DB_ARCH_ABS);
    eval 'sub DB_ARCH_DATA () {0x2;}' unless defined(&DB_ARCH_DATA);
    eval 'sub DB_ARCH_LOG () {0x4;}' unless defined(&DB_ARCH_LOG);
    eval 'sub DB_ARCH_REMOVE () {0x8;}' unless defined(&DB_ARCH_REMOVE);
    eval 'sub DB_FLUSH () {0x1;}' unless defined(&DB_FLUSH);
    eval 'sub DB_LOG_CHKPNT () {0x2;}' unless defined(&DB_LOG_CHKPNT);
    eval 'sub DB_LOG_COMMIT () {0x4;}' unless defined(&DB_LOG_COMMIT);
    eval 'sub DB_LOG_NOCOPY () {0x8;}' unless defined(&DB_LOG_NOCOPY);
    eval 'sub DB_LOG_NOT_DURABLE () {0x10;}' unless defined(&DB_LOG_NOT_DURABLE);
    eval 'sub DB_LOG_WRNOSYNC () {0x20;}' unless defined(&DB_LOG_WRNOSYNC);
    eval 'sub DB_user_BEGIN () {10000;}' unless defined(&DB_user_BEGIN);
    eval 'sub DB_debug_FLAG () {0x80000000;}' unless defined(&DB_debug_FLAG);
    eval 'sub DB_LOG_DISK () {0x1;}' unless defined(&DB_LOG_DISK);
    eval 'sub DB_LOG_LOCKED () {0x2;}' unless defined(&DB_LOG_LOCKED);
    eval 'sub DB_LOG_SILENT_ERR () {0x4;}' unless defined(&DB_LOG_SILENT_ERR);
    eval 'sub DB_SET_TXN_LSNP {
        my($txn, $blsnp, $llsnp) = @_;
	    eval q((($txn)-> &set_txn_lsnp($txn, $blsnp, $llsnp)));
    }' unless defined(&DB_SET_TXN_LSNP);
    eval 'sub DB_MPOOL_CREATE () {0x1;}' unless defined(&DB_MPOOL_CREATE);
    eval 'sub DB_MPOOL_DIRTY () {0x2;}' unless defined(&DB_MPOOL_DIRTY);
    eval 'sub DB_MPOOL_EDIT () {0x4;}' unless defined(&DB_MPOOL_EDIT);
    eval 'sub DB_MPOOL_FREE () {0x8;}' unless defined(&DB_MPOOL_FREE);
    eval 'sub DB_MPOOL_LAST () {0x10;}' unless defined(&DB_MPOOL_LAST);
    eval 'sub DB_MPOOL_NEW () {0x20;}' unless defined(&DB_MPOOL_NEW);
    eval 'sub DB_MPOOL_DISCARD () {0x1;}' unless defined(&DB_MPOOL_DISCARD);
    eval 'sub DB_MPOOL_NOFILE () {0x1;}' unless defined(&DB_MPOOL_NOFILE);
    eval 'sub DB_MPOOL_UNLINK () {0x2;}' unless defined(&DB_MPOOL_UNLINK);
    eval("sub DB_PRIORITY_VERY_LOW () { 1; }") unless defined(&DB_PRIORITY_VERY_LOW);
    eval("sub DB_PRIORITY_LOW () { 2; }") unless defined(&DB_PRIORITY_LOW);
    eval("sub DB_PRIORITY_DEFAULT () { 3; }") unless defined(&DB_PRIORITY_DEFAULT);
    eval("sub DB_PRIORITY_HIGH () { 4; }") unless defined(&DB_PRIORITY_HIGH);
    eval("sub DB_PRIORITY_VERY_HIGH () { 5; }") unless defined(&DB_PRIORITY_VERY_HIGH);
    eval 'sub MP_FILEID_SET () {0x1;}' unless defined(&MP_FILEID_SET);
    eval 'sub MP_FLUSH () {0x2;}' unless defined(&MP_FLUSH);
    eval 'sub MP_MULTIVERSION () {0x4;}' unless defined(&MP_MULTIVERSION);
    eval 'sub MP_OPEN_CALLED () {0x8;}' unless defined(&MP_OPEN_CALLED);
    eval 'sub MP_READONLY () {0x10;}' unless defined(&MP_READONLY);
    eval 'sub DB_TXNVERSION () {1;}' unless defined(&DB_TXNVERSION);
    eval("sub DB_TXN_ABORT () { 0; }") unless defined(&DB_TXN_ABORT);
    eval("sub DB_TXN_APPLY () { 1; }") unless defined(&DB_TXN_APPLY);
    eval("sub DB_TXN_BACKWARD_ALLOC () { 2; }") unless defined(&DB_TXN_BACKWARD_ALLOC);
    eval("sub DB_TXN_BACKWARD_ROLL () { 3; }") unless defined(&DB_TXN_BACKWARD_ROLL);
    eval("sub DB_TXN_FORWARD_ROLL () { 4; }") unless defined(&DB_TXN_FORWARD_ROLL);
    eval("sub DB_TXN_OPENFILES () { 5; }") unless defined(&DB_TXN_OPENFILES);
    eval("sub DB_TXN_POPENFILES () { 6; }") unless defined(&DB_TXN_POPENFILES);
    eval("sub DB_TXN_PRINT () { 7; }") unless defined(&DB_TXN_PRINT);
    eval 'sub DB_UNDO {
        my($op) = @_;
	    eval q((($op) ==  &DB_TXN_ABORT || ($op) ==  &DB_TXN_BACKWARD_ROLL || ($op) ==  &DB_TXN_BACKWARD_ALLOC));
    }' unless defined(&DB_UNDO);
    eval 'sub DB_REDO {
        my($op) = @_;
	    eval q((($op) ==  &DB_TXN_FORWARD_ROLL || ($op) ==  &DB_TXN_APPLY));
    }' unless defined(&DB_REDO);
    eval 'sub TXN_CHILDCOMMIT () {0x1;}' unless defined(&TXN_CHILDCOMMIT);
    eval 'sub TXN_CDSGROUP () {0x2;}' unless defined(&TXN_CDSGROUP);
    eval 'sub TXN_COMPENSATE () {0x4;}' unless defined(&TXN_COMPENSATE);
    eval 'sub TXN_DEADLOCK () {0x8;}' unless defined(&TXN_DEADLOCK);
    eval 'sub TXN_LOCKTIMEOUT () {0x10;}' unless defined(&TXN_LOCKTIMEOUT);
    eval 'sub TXN_MALLOC () {0x20;}' unless defined(&TXN_MALLOC);
    eval 'sub TXN_NOSYNC () {0x40;}' unless defined(&TXN_NOSYNC);
    eval 'sub TXN_NOWAIT () {0x80;}' unless defined(&TXN_NOWAIT);
    eval 'sub TXN_PRIVATE () {0x100;}' unless defined(&TXN_PRIVATE);
    eval 'sub TXN_READ_COMMITTED () {0x200;}' unless defined(&TXN_READ_COMMITTED);
    eval 'sub TXN_READ_UNCOMMITTED () {0x400;}' unless defined(&TXN_READ_UNCOMMITTED);
    eval 'sub TXN_RESTORED () {0x800;}' unless defined(&TXN_RESTORED);
    eval 'sub TXN_SNAPSHOT () {0x1000;}' unless defined(&TXN_SNAPSHOT);
    eval 'sub TXN_SYNC () {0x2000;}' unless defined(&TXN_SYNC);
    eval 'sub TXN_WRITE_NOSYNC () {0x4000;}' unless defined(&TXN_WRITE_NOSYNC);
    eval 'sub TXN_SYNC_FLAGS () {( &TXN_SYNC |  &TXN_NOSYNC |  &TXN_WRITE_NOSYNC);}' unless defined(&TXN_SYNC_FLAGS);
    eval 'sub DB_XIDDATASIZE () {128;}' unless defined(&DB_XIDDATASIZE);
    eval 'sub TXN_ABORTED () {1;}' unless defined(&TXN_ABORTED);
    eval 'sub TXN_COMMITTED () {2;}' unless defined(&TXN_COMMITTED);
    eval 'sub TXN_PREPARED () {3;}' unless defined(&TXN_PREPARED);
    eval 'sub TXN_RUNNING () {4;}' unless defined(&TXN_RUNNING);
    eval 'sub TXN_XA_ABORTED () {1;}' unless defined(&TXN_XA_ABORTED);
    eval 'sub TXN_XA_DEADLOCKED () {2;}' unless defined(&TXN_XA_DEADLOCKED);
    eval 'sub TXN_XA_ENDED () {3;}' unless defined(&TXN_XA_ENDED);
    eval 'sub TXN_XA_PREPARED () {4;}' unless defined(&TXN_XA_PREPARED);
    eval 'sub TXN_XA_STARTED () {5;}' unless defined(&TXN_XA_STARTED);
    eval 'sub TXN_XA_SUSPENDED () {6;}' unless defined(&TXN_XA_SUSPENDED);
    eval 'sub DB_EID_BROADCAST () {-1;}' unless defined(&DB_EID_BROADCAST);
    eval 'sub DB_EID_INVALID () {-2;}' unless defined(&DB_EID_INVALID);
    eval 'sub DB_REP_CONF_BULK () {0x1;}' unless defined(&DB_REP_CONF_BULK);
    eval 'sub DB_REP_CONF_DELAYCLIENT () {0x2;}' unless defined(&DB_REP_CONF_DELAYCLIENT);
    eval 'sub DB_REP_CONF_NOAUTOINIT () {0x4;}' unless defined(&DB_REP_CONF_NOAUTOINIT);
    eval 'sub DB_REP_CONF_NOWAIT () {0x8;}' unless defined(&DB_REP_CONF_NOWAIT);
    eval 'sub DB_REP_CLIENT () {1;}' unless defined(&DB_REP_CLIENT);
    eval 'sub DB_REP_ELECTION () {2;}' unless defined(&DB_REP_ELECTION);
    eval 'sub DB_REP_FULL_ELECTION () {3;}' unless defined(&DB_REP_FULL_ELECTION);
    eval 'sub DB_REP_MASTER () {4;}' unless defined(&DB_REP_MASTER);
    eval 'sub DB_REPMGR_ACKS_ALL () {1;}' unless defined(&DB_REPMGR_ACKS_ALL);
    eval 'sub DB_REPMGR_ACKS_ALL_PEERS () {2;}' unless defined(&DB_REPMGR_ACKS_ALL_PEERS);
    eval 'sub DB_REPMGR_ACKS_NONE () {3;}' unless defined(&DB_REPMGR_ACKS_NONE);
    eval 'sub DB_REPMGR_ACKS_ONE () {4;}' unless defined(&DB_REPMGR_ACKS_ONE);
    eval 'sub DB_REPMGR_ACKS_ONE_PEER () {5;}' unless defined(&DB_REPMGR_ACKS_ONE_PEER);
    eval 'sub DB_REPMGR_ACKS_QUORUM () {6;}' unless defined(&DB_REPMGR_ACKS_QUORUM);
    eval 'sub DB_REP_ACK_TIMEOUT () {1;}' unless defined(&DB_REP_ACK_TIMEOUT);
    eval 'sub DB_REP_ELECTION_TIMEOUT () {2;}' unless defined(&DB_REP_ELECTION_TIMEOUT);
    eval 'sub DB_REP_ELECTION_RETRY () {3;}' unless defined(&DB_REP_ELECTION_RETRY);
    eval 'sub DB_REP_CONNECTION_RETRY () {4;}' unless defined(&DB_REP_CONNECTION_RETRY);
    eval 'sub DB_EVENT_NO_SUCH_EVENT () {0;}' unless defined(&DB_EVENT_NO_SUCH_EVENT);
    eval 'sub DB_EVENT_PANIC () {1;}' unless defined(&DB_EVENT_PANIC);
    eval 'sub DB_EVENT_REP_CLIENT () {2;}' unless defined(&DB_EVENT_REP_CLIENT);
    eval 'sub DB_EVENT_REP_MASTER () {3;}' unless defined(&DB_EVENT_REP_MASTER);
    eval 'sub DB_EVENT_REP_NEWMASTER () {4;}' unless defined(&DB_EVENT_REP_NEWMASTER);
    eval 'sub DB_EVENT_REP_STARTUPDONE () {5;}' unless defined(&DB_EVENT_REP_STARTUPDONE);
    eval 'sub DB_EVENT_WRITE_FAILED () {6;}' unless defined(&DB_EVENT_WRITE_FAILED);
    eval 'sub DB_REPMGR_PEER () {0x1;}' unless defined(&DB_REPMGR_PEER);
    eval 'sub DB_REPMGR_CONNECTED () {0x1;}' unless defined(&DB_REPMGR_CONNECTED);
    eval 'sub DB_REPMGR_DISCONNECTED () {0x2;}' unless defined(&DB_REPMGR_DISCONNECTED);
    eval 'sub DB_SEQ_DEC () {0x1;}' unless defined(&DB_SEQ_DEC);
    eval 'sub DB_SEQ_INC () {0x2;}' unless defined(&DB_SEQ_INC);
    eval 'sub DB_SEQ_RANGE_SET () {0x4;}' unless defined(&DB_SEQ_RANGE_SET);
    eval 'sub DB_SEQ_WRAP () {0x8;}' unless defined(&DB_SEQ_WRAP);
    eval 'sub DB_SEQ_WRAPPED () {0x10;}' unless defined(&DB_SEQ_WRAPPED);
    eval("sub DB_BTREE () { 1; }") unless defined(&DB_BTREE);
    eval("sub DB_HASH () { 2; }") unless defined(&DB_HASH);
    eval("sub DB_RECNO () { 3; }") unless defined(&DB_RECNO);
    eval("sub DB_QUEUE () { 4; }") unless defined(&DB_QUEUE);
    eval("sub DB_UNKNOWN () { 5; }") unless defined(&DB_UNKNOWN);
    eval 'sub DB_RENAMEMAGIC () {0x30800;}' unless defined(&DB_RENAMEMAGIC);
    eval 'sub DB_BTREEVERSION () {9;}' unless defined(&DB_BTREEVERSION);
    eval 'sub DB_BTREEOLDVER () {8;}' unless defined(&DB_BTREEOLDVER);
    eval 'sub DB_BTREEMAGIC () {0x53162;}' unless defined(&DB_BTREEMAGIC);
    eval 'sub DB_HASHVERSION () {8;}' unless defined(&DB_HASHVERSION);
    eval 'sub DB_HASHOLDVER () {7;}' unless defined(&DB_HASHOLDVER);
    eval 'sub DB_HASHMAGIC () {0x61561;}' unless defined(&DB_HASHMAGIC);
    eval 'sub DB_QAMVERSION () {4;}' unless defined(&DB_QAMVERSION);
    eval 'sub DB_QAMOLDVER () {3;}' unless defined(&DB_QAMOLDVER);
    eval 'sub DB_QAMMAGIC () {0x42253;}' unless defined(&DB_QAMMAGIC);
    eval 'sub DB_SEQUENCE_VERSION () {2;}' unless defined(&DB_SEQUENCE_VERSION);
    eval 'sub DB_SEQUENCE_OLDVER () {1;}' unless defined(&DB_SEQUENCE_OLDVER);
    eval 'sub DB_AFTER () {1;}' unless defined(&DB_AFTER);
    eval 'sub DB_APPEND () {2;}' unless defined(&DB_APPEND);
    eval 'sub DB_BEFORE () {3;}' unless defined(&DB_BEFORE);
    eval 'sub DB_CONSUME () {4;}' unless defined(&DB_CONSUME);
    eval 'sub DB_CONSUME_WAIT () {5;}' unless defined(&DB_CONSUME_WAIT);
    eval 'sub DB_CURRENT () {6;}' unless defined(&DB_CURRENT);
    eval 'sub DB_FIRST () {7;}' unless defined(&DB_FIRST);
    eval 'sub DB_GET_BOTH () {8;}' unless defined(&DB_GET_BOTH);
    eval 'sub DB_GET_BOTHC () {9;}' unless defined(&DB_GET_BOTHC);
    eval 'sub DB_GET_BOTH_RANGE () {10;}' unless defined(&DB_GET_BOTH_RANGE);
    eval 'sub DB_GET_RECNO () {11;}' unless defined(&DB_GET_RECNO);
    eval 'sub DB_JOIN_ITEM () {12;}' unless defined(&DB_JOIN_ITEM);
    eval 'sub DB_KEYFIRST () {13;}' unless defined(&DB_KEYFIRST);
    eval 'sub DB_KEYLAST () {14;}' unless defined(&DB_KEYLAST);
    eval 'sub DB_LAST () {15;}' unless defined(&DB_LAST);
    eval 'sub DB_NEXT () {16;}' unless defined(&DB_NEXT);
    eval 'sub DB_NEXT_DUP () {17;}' unless defined(&DB_NEXT_DUP);
    eval 'sub DB_NEXT_NODUP () {18;}' unless defined(&DB_NEXT_NODUP);
    eval 'sub DB_NODUPDATA () {19;}' unless defined(&DB_NODUPDATA);
    eval 'sub DB_NOOVERWRITE () {20;}' unless defined(&DB_NOOVERWRITE);
    eval 'sub DB_NOSYNC () {21;}' unless defined(&DB_NOSYNC);
    eval 'sub DB_POSITION () {22;}' unless defined(&DB_POSITION);
    eval 'sub DB_PREV () {23;}' unless defined(&DB_PREV);
    eval 'sub DB_PREV_NODUP () {24;}' unless defined(&DB_PREV_NODUP);
    eval 'sub DB_SET () {25;}' unless defined(&DB_SET);
    eval 'sub DB_SET_LOCK_TIMEOUT () {26;}' unless defined(&DB_SET_LOCK_TIMEOUT);
    eval 'sub DB_SET_RANGE () {27;}' unless defined(&DB_SET_RANGE);
    eval 'sub DB_SET_RECNO () {28;}' unless defined(&DB_SET_RECNO);
    eval 'sub DB_SET_TXN_NOW () {29;}' unless defined(&DB_SET_TXN_NOW);
    eval 'sub DB_SET_TXN_TIMEOUT () {30;}' unless defined(&DB_SET_TXN_TIMEOUT);
    eval 'sub DB_UPDATE_SECONDARY () {31;}' unless defined(&DB_UPDATE_SECONDARY);
    eval 'sub DB_WRITECURSOR () {32;}' unless defined(&DB_WRITECURSOR);
    eval 'sub DB_WRITELOCK () {33;}' unless defined(&DB_WRITELOCK);
    eval 'sub DB_OPFLAGS_MASK () {0xff;}' unless defined(&DB_OPFLAGS_MASK);
    eval 'sub DB_MULTIPLE () {0x10000000;}' unless defined(&DB_MULTIPLE);
    eval 'sub DB_MULTIPLE_KEY () {0x20000000;}' unless defined(&DB_MULTIPLE_KEY);
    eval 'sub DB_RMW () {0x40000000;}' unless defined(&DB_RMW);
    eval 'sub DB_BUFFER_SMALL () {(-30999);}' unless defined(&DB_BUFFER_SMALL);
    eval 'sub DB_DONOTINDEX () {(-30998);}' unless defined(&DB_DONOTINDEX);
    eval 'sub DB_KEYEMPTY () {(-30997);}' unless defined(&DB_KEYEMPTY);
    eval 'sub DB_KEYEXIST () {(-30996);}' unless defined(&DB_KEYEXIST);
    eval 'sub DB_LOCK_DEADLOCK () {(-30995);}' unless defined(&DB_LOCK_DEADLOCK);
    eval 'sub DB_LOCK_NOTGRANTED () {(-30994);}' unless defined(&DB_LOCK_NOTGRANTED);
    eval 'sub DB_LOG_BUFFER_FULL () {(-30993);}' unless defined(&DB_LOG_BUFFER_FULL);
    eval 'sub DB_NOSERVER () {(-30992);}' unless defined(&DB_NOSERVER);
    eval 'sub DB_NOSERVER_HOME () {(-30991);}' unless defined(&DB_NOSERVER_HOME);
    eval 'sub DB_NOSERVER_ID () {(-30990);}' unless defined(&DB_NOSERVER_ID);
    eval 'sub DB_NOTFOUND () {(-30989);}' unless defined(&DB_NOTFOUND);
    eval 'sub DB_OLD_VERSION () {(-30988);}' unless defined(&DB_OLD_VERSION);
    eval 'sub DB_PAGE_NOTFOUND () {(-30987);}' unless defined(&DB_PAGE_NOTFOUND);
    eval 'sub DB_REP_DUPMASTER () {(-30986);}' unless defined(&DB_REP_DUPMASTER);
    eval 'sub DB_REP_HANDLE_DEAD () {(-30985);}' unless defined(&DB_REP_HANDLE_DEAD);
    eval 'sub DB_REP_HOLDELECTION () {(-30984);}' unless defined(&DB_REP_HOLDELECTION);
    eval 'sub DB_REP_IGNORE () {(-30983);}' unless defined(&DB_REP_IGNORE);
    eval 'sub DB_REP_ISPERM () {(-30982);}' unless defined(&DB_REP_ISPERM);
    eval 'sub DB_REP_JOIN_FAILURE () {(-30981);}' unless defined(&DB_REP_JOIN_FAILURE);
    eval 'sub DB_REP_LOCKOUT () {(-30980);}' unless defined(&DB_REP_LOCKOUT);
    eval 'sub DB_REP_NEWMASTER () {(-30979);}' unless defined(&DB_REP_NEWMASTER);
    eval 'sub DB_REP_NEWSITE () {(-30978);}' unless defined(&DB_REP_NEWSITE);
    eval 'sub DB_REP_NOTPERM () {(-30977);}' unless defined(&DB_REP_NOTPERM);
    eval 'sub DB_REP_UNAVAIL () {(-30976);}' unless defined(&DB_REP_UNAVAIL);
    eval 'sub DB_RUNRECOVERY () {(-30975);}' unless defined(&DB_RUNRECOVERY);
    eval 'sub DB_SECONDARY_BAD () {(-30974);}' unless defined(&DB_SECONDARY_BAD);
    eval 'sub DB_VERIFY_BAD () {(-30973);}' unless defined(&DB_VERIFY_BAD);
    eval 'sub DB_VERSION_MISMATCH () {(-30972);}' unless defined(&DB_VERSION_MISMATCH);
    eval 'sub DB_ALREADY_ABORTED () {(-30899);}' unless defined(&DB_ALREADY_ABORTED);
    eval 'sub DB_DELETED () {(-30898);}' unless defined(&DB_DELETED);
    eval 'sub DB_NEEDSPLIT () {(-30897);}' unless defined(&DB_NEEDSPLIT);
    eval 'sub DB_REP_BULKOVF () {(-30896);}' unless defined(&DB_REP_BULKOVF);
    eval 'sub DB_REP_EGENCHG () {(-30895);}' unless defined(&DB_REP_EGENCHG);
    eval 'sub DB_REP_LOGREADY () {(-30894);}' unless defined(&DB_REP_LOGREADY);
    eval 'sub DB_REP_PAGEDONE () {(-30893);}' unless defined(&DB_REP_PAGEDONE);
    eval 'sub DB_SURPRISE_KID () {(-30892);}' unless defined(&DB_SURPRISE_KID);
    eval 'sub DB_SWAPBYTES () {(-30891);}' unless defined(&DB_SWAPBYTES);
    eval 'sub DB_TIMEOUT () {(-30890);}' unless defined(&DB_TIMEOUT);
    eval 'sub DB_TXN_CKP () {(-30889);}' unless defined(&DB_TXN_CKP);
    eval 'sub DB_VERIFY_FATAL () {(-30888);}' unless defined(&DB_VERIFY_FATAL);
    eval 'sub DB_LOGFILEID_INVALID () {-1;}' unless defined(&DB_LOGFILEID_INVALID);
    eval 'sub DB_ASSOC_IMMUTABLE_KEY () {0x1;}' unless defined(&DB_ASSOC_IMMUTABLE_KEY);
    eval 'sub DB_OK_BTREE () {0x1;}' unless defined(&DB_OK_BTREE);
    eval 'sub DB_OK_HASH () {0x2;}' unless defined(&DB_OK_HASH);
    eval 'sub DB_OK_QUEUE () {0x4;}' unless defined(&DB_OK_QUEUE);
    eval 'sub DB_OK_RECNO () {0x8;}' unless defined(&DB_OK_RECNO);
    eval 'sub DB_AM_CHKSUM () {0x1;}' unless defined(&DB_AM_CHKSUM);
    eval 'sub DB_AM_CL_WRITER () {0x2;}' unless defined(&DB_AM_CL_WRITER);
    eval 'sub DB_AM_COMPENSATE () {0x4;}' unless defined(&DB_AM_COMPENSATE);
    eval 'sub DB_AM_CREATED () {0x8;}' unless defined(&DB_AM_CREATED);
    eval 'sub DB_AM_CREATED_MSTR () {0x10;}' unless defined(&DB_AM_CREATED_MSTR);
    eval 'sub DB_AM_DBM_ERROR () {0x20;}' unless defined(&DB_AM_DBM_ERROR);
    eval 'sub DB_AM_DELIMITER () {0x40;}' unless defined(&DB_AM_DELIMITER);
    eval 'sub DB_AM_DISCARD () {0x80;}' unless defined(&DB_AM_DISCARD);
    eval 'sub DB_AM_DUP () {0x100;}' unless defined(&DB_AM_DUP);
    eval 'sub DB_AM_DUPSORT () {0x200;}' unless defined(&DB_AM_DUPSORT);
    eval 'sub DB_AM_ENCRYPT () {0x400;}' unless defined(&DB_AM_ENCRYPT);
    eval 'sub DB_AM_FIXEDLEN () {0x800;}' unless defined(&DB_AM_FIXEDLEN);
    eval 'sub DB_AM_INMEM () {0x1000;}' unless defined(&DB_AM_INMEM);
    eval 'sub DB_AM_INORDER () {0x2000;}' unless defined(&DB_AM_INORDER);
    eval 'sub DB_AM_IN_RENAME () {0x4000;}' unless defined(&DB_AM_IN_RENAME);
    eval 'sub DB_AM_NOT_DURABLE () {0x8000;}' unless defined(&DB_AM_NOT_DURABLE);
    eval 'sub DB_AM_OPEN_CALLED () {0x10000;}' unless defined(&DB_AM_OPEN_CALLED);
    eval 'sub DB_AM_PAD () {0x20000;}' unless defined(&DB_AM_PAD);
    eval 'sub DB_AM_PGDEF () {0x40000;}' unless defined(&DB_AM_PGDEF);
    eval 'sub DB_AM_RDONLY () {0x80000;}' unless defined(&DB_AM_RDONLY);
    eval 'sub DB_AM_READ_UNCOMMITTED () {0x100000;}' unless defined(&DB_AM_READ_UNCOMMITTED);
    eval 'sub DB_AM_RECNUM () {0x200000;}' unless defined(&DB_AM_RECNUM);
    eval 'sub DB_AM_RECOVER () {0x400000;}' unless defined(&DB_AM_RECOVER);
    eval 'sub DB_AM_RENUMBER () {0x800000;}' unless defined(&DB_AM_RENUMBER);
    eval 'sub DB_AM_REVSPLITOFF () {0x1000000;}' unless defined(&DB_AM_REVSPLITOFF);
    eval 'sub DB_AM_SECONDARY () {0x2000000;}' unless defined(&DB_AM_SECONDARY);
    eval 'sub DB_AM_SNAPSHOT () {0x4000000;}' unless defined(&DB_AM_SNAPSHOT);
    eval 'sub DB_AM_SUBDB () {0x8000000;}' unless defined(&DB_AM_SUBDB);
    eval 'sub DB_AM_SWAP () {0x10000000;}' unless defined(&DB_AM_SWAP);
    eval 'sub DB_AM_TXN () {0x20000000;}' unless defined(&DB_AM_TXN);
    eval 'sub DB_AM_VERIFYING () {0x40000000;}' unless defined(&DB_AM_VERIFYING);
    eval 'sub DB_MULTIPLE_INIT {
        my($pointer, $dbt) = @_;
	    eval q(($pointer = ( &u_int8_t *)($dbt)-> &data + ($dbt)-> &ulen - $sizeof{ &u_int32_t}));
    }' unless defined(&DB_MULTIPLE_INIT);
    eval 'sub DB_MULTIPLE_NEXT {
        my($pointer, $dbt, $retdata, $retdlen) = @_;
	    eval q( &do {  &if (*(( &u_int32_t *)($pointer)) == ( &u_int32_t)-1) { $retdata =  &NULL; $pointer =  &NULL;  &break; } $retdata = ( &u_int8_t *) ($dbt)-> &data + *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retdlen = *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1;  &if ($retdlen == 0 && $retdata == ( &u_int8_t *)($dbt)-> &data) $retdata =  &NULL; }  &while (0));
    }' unless defined(&DB_MULTIPLE_NEXT);
    eval 'sub DB_MULTIPLE_KEY_NEXT {
        my($pointer, $dbt, $retkey, $retklen, $retdata, $retdlen) = @_;
	    eval q( &do {  &if (*(( &u_int32_t *)($pointer)) == ( &u_int32_t)-1) { $retdata =  &NULL; $retkey =  &NULL; $pointer =  &NULL;  &break; } $retkey = ( &u_int8_t *) ($dbt)-> &data + *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retklen = *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retdata = ( &u_int8_t *) ($dbt)-> &data + *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retdlen = *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; }  &while (0));
    }' unless defined(&DB_MULTIPLE_KEY_NEXT);
    eval 'sub DB_MULTIPLE_RECNO_NEXT {
        my($pointer, $dbt, $recno, $retdata, $retdlen) = @_;
	    eval q( &do {  &if (*(( &u_int32_t *)($pointer)) == ( &u_int32_t)0) { $recno = 0; $retdata =  &NULL; $pointer =  &NULL;  &break; } $recno = *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retdata = ( &u_int8_t *) ($dbt)-> &data + *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; $retdlen = *( &u_int32_t *)($pointer); ($pointer) = ( &u_int32_t *)($pointer) - 1; }  &while (0));
    }' unless defined(&DB_MULTIPLE_RECNO_NEXT);
    eval 'sub DBC_ACTIVE () {0x1;}' unless defined(&DBC_ACTIVE);
    eval 'sub DBC_DONTLOCK () {0x2;}' unless defined(&DBC_DONTLOCK);
    eval 'sub DBC_MULTIPLE () {0x4;}' unless defined(&DBC_MULTIPLE);
    eval 'sub DBC_MULTIPLE_KEY () {0x8;}' unless defined(&DBC_MULTIPLE_KEY);
    eval 'sub DBC_OPD () {0x10;}' unless defined(&DBC_OPD);
    eval 'sub DBC_OWN_LID () {0x20;}' unless defined(&DBC_OWN_LID);
    eval 'sub DBC_READ_COMMITTED () {0x40;}' unless defined(&DBC_READ_COMMITTED);
    eval 'sub DBC_READ_UNCOMMITTED () {0x80;}' unless defined(&DBC_READ_UNCOMMITTED);
    eval 'sub DBC_RECOVER () {0x100;}' unless defined(&DBC_RECOVER);
    eval 'sub DBC_RMW () {0x200;}' unless defined(&DBC_RMW);
    eval 'sub DBC_TRANSIENT () {0x400;}' unless defined(&DBC_TRANSIENT);
    eval 'sub DBC_WRITECURSOR () {0x800;}' unless defined(&DBC_WRITECURSOR);
    eval 'sub DBC_WRITER () {0x1000;}' unless defined(&DBC_WRITER);
    eval 'sub DB_REGION_MAGIC () {0x120897;}' unless defined(&DB_REGION_MAGIC);
    eval 'sub DB_USERCOPY_GETDATA () {0x1;}' unless defined(&DB_USERCOPY_GETDATA);
    eval 'sub DB_USERCOPY_SETDATA () {0x2;}' unless defined(&DB_USERCOPY_SETDATA);
    eval 'sub DB_VERB_DEADLOCK () {0x1;}' unless defined(&DB_VERB_DEADLOCK);
    eval 'sub DB_VERB_RECOVERY () {0x2;}' unless defined(&DB_VERB_RECOVERY);
    eval 'sub DB_VERB_REGISTER () {0x4;}' unless defined(&DB_VERB_REGISTER);
    eval 'sub DB_VERB_REPLICATION () {0x8;}' unless defined(&DB_VERB_REPLICATION);
    eval 'sub DB_VERB_WAITSFOR () {0x10;}' unless defined(&DB_VERB_WAITSFOR);
    eval 'sub DB_TEST_ELECTINIT () {1;}' unless defined(&DB_TEST_ELECTINIT);
    eval 'sub DB_TEST_ELECTVOTE1 () {2;}' unless defined(&DB_TEST_ELECTVOTE1);
    eval 'sub DB_TEST_POSTDESTROY () {3;}' unless defined(&DB_TEST_POSTDESTROY);
    eval 'sub DB_TEST_POSTLOG () {4;}' unless defined(&DB_TEST_POSTLOG);
    eval 'sub DB_TEST_POSTLOGMETA () {5;}' unless defined(&DB_TEST_POSTLOGMETA);
    eval 'sub DB_TEST_POSTOPEN () {6;}' unless defined(&DB_TEST_POSTOPEN);
    eval 'sub DB_TEST_POSTSYNC () {7;}' unless defined(&DB_TEST_POSTSYNC);
    eval 'sub DB_TEST_PREDESTROY () {8;}' unless defined(&DB_TEST_PREDESTROY);
    eval 'sub DB_TEST_PREOPEN () {9;}' unless defined(&DB_TEST_PREOPEN);
    eval 'sub DB_TEST_RECYCLE () {10;}' unless defined(&DB_TEST_RECYCLE);
    eval 'sub DB_TEST_SUBDB_LOCKS () {11;}' unless defined(&DB_TEST_SUBDB_LOCKS);
    eval 'sub DB_ENV_AUTO_COMMIT () {0x1;}' unless defined(&DB_ENV_AUTO_COMMIT);
    eval 'sub DB_ENV_CDB () {0x2;}' unless defined(&DB_ENV_CDB);
    eval 'sub DB_ENV_CDB_ALLDB () {0x4;}' unless defined(&DB_ENV_CDB_ALLDB);
    eval 'sub DB_ENV_CREATE () {0x8;}' unless defined(&DB_ENV_CREATE);
    eval 'sub DB_ENV_DBLOCAL () {0x10;}' unless defined(&DB_ENV_DBLOCAL);
    eval 'sub DB_ENV_DIRECT_DB () {0x20;}' unless defined(&DB_ENV_DIRECT_DB);
    eval 'sub DB_ENV_DIRECT_LOG () {0x40;}' unless defined(&DB_ENV_DIRECT_LOG);
    eval 'sub DB_ENV_DSYNC_DB () {0x80;}' unless defined(&DB_ENV_DSYNC_DB);
    eval 'sub DB_ENV_DSYNC_LOG () {0x100;}' unless defined(&DB_ENV_DSYNC_LOG);
    eval 'sub DB_ENV_FATAL () {0x200;}' unless defined(&DB_ENV_FATAL);
    eval 'sub DB_ENV_LOCKDOWN () {0x400;}' unless defined(&DB_ENV_LOCKDOWN);
    eval 'sub DB_ENV_LOG_AUTOREMOVE () {0x800;}' unless defined(&DB_ENV_LOG_AUTOREMOVE);
    eval 'sub DB_ENV_LOG_INMEMORY () {0x1000;}' unless defined(&DB_ENV_LOG_INMEMORY);
    eval 'sub DB_ENV_MULTIVERSION () {0x2000;}' unless defined(&DB_ENV_MULTIVERSION);
    eval 'sub DB_ENV_NOLOCKING () {0x4000;}' unless defined(&DB_ENV_NOLOCKING);
    eval 'sub DB_ENV_NOMMAP () {0x8000;}' unless defined(&DB_ENV_NOMMAP);
    eval 'sub DB_ENV_NOPANIC () {0x10000;}' unless defined(&DB_ENV_NOPANIC);
    eval 'sub DB_ENV_OPEN_CALLED () {0x20000;}' unless defined(&DB_ENV_OPEN_CALLED);
    eval 'sub DB_ENV_OVERWRITE () {0x40000;}' unless defined(&DB_ENV_OVERWRITE);
    eval 'sub DB_ENV_PRIVATE () {0x80000;}' unless defined(&DB_ENV_PRIVATE);
    eval 'sub DB_ENV_REGION_INIT () {0x100000;}' unless defined(&DB_ENV_REGION_INIT);
    eval 'sub DB_ENV_RPCCLIENT () {0x200000;}' unless defined(&DB_ENV_RPCCLIENT);
    eval 'sub DB_ENV_RPCCLIENT_GIVEN () {0x400000;}' unless defined(&DB_ENV_RPCCLIENT_GIVEN);
    eval 'sub DB_ENV_SYSTEM_MEM () {0x800000;}' unless defined(&DB_ENV_SYSTEM_MEM);
    eval 'sub DB_ENV_THREAD () {0x1000000;}' unless defined(&DB_ENV_THREAD);
    eval 'sub DB_ENV_TIME_NOTGRANTED () {0x2000000;}' unless defined(&DB_ENV_TIME_NOTGRANTED);
    eval 'sub DB_ENV_TXN_NOSYNC () {0x4000000;}' unless defined(&DB_ENV_TXN_NOSYNC);
    eval 'sub DB_ENV_TXN_SNAPSHOT () {0x8000000;}' unless defined(&DB_ENV_TXN_SNAPSHOT);
    eval 'sub DB_ENV_TXN_WRITE_NOSYNC () {0x10000000;}' unless defined(&DB_ENV_TXN_WRITE_NOSYNC);
    eval 'sub DB_ENV_YIELDCPU () {0x20000000;}' unless defined(&DB_ENV_YIELDCPU);
    unless(defined(&DB_DBM_HSEARCH)) {
	eval 'sub DB_DBM_HSEARCH () {0;}' unless defined(&DB_DBM_HSEARCH);
    }
    if((defined(&DB_DBM_HSEARCH) ? &DB_DBM_HSEARCH : 0) != 0) {
	eval 'sub DBM_INSERT () {0;}' unless defined(&DBM_INSERT);
	eval 'sub DBM_REPLACE () {1;}' unless defined(&DBM_REPLACE);
	eval 'sub DBM_SUFFIX () {".db";}' unless defined(&DBM_SUFFIX);
	if(defined( &_XPG4_2)) {
	} else {
	}
	eval 'sub dbm_clearerr {
	    my($a) = @_;
    	    eval q( &__db_ndbm_clearerr($a));
	}' unless defined(&dbm_clearerr);
	eval 'sub dbm_close {
	    my($a) = @_;
    	    eval q( &__db_ndbm_close($a));
	}' unless defined(&dbm_close);
	eval 'sub dbm_delete {
	    my($a, $b) = @_;
    	    eval q( &__db_ndbm_delete($a, $b));
	}' unless defined(&dbm_delete);
	eval 'sub dbm_dirfno {
	    my($a) = @_;
    	    eval q( &__db_ndbm_dirfno($a));
	}' unless defined(&dbm_dirfno);
	eval 'sub dbm_error {
	    my($a) = @_;
    	    eval q( &__db_ndbm_error($a));
	}' unless defined(&dbm_error);
	eval 'sub dbm_fetch {
	    my($a, $b) = @_;
    	    eval q( &__db_ndbm_fetch($a, $b));
	}' unless defined(&dbm_fetch);
	eval 'sub dbm_firstkey {
	    my($a) = @_;
    	    eval q( &__db_ndbm_firstkey($a));
	}' unless defined(&dbm_firstkey);
	eval 'sub dbm_nextkey {
	    my($a) = @_;
    	    eval q( &__db_ndbm_nextkey($a));
	}' unless defined(&dbm_nextkey);
	eval 'sub dbm_open {
	    my($a, $b, $c) = @_;
    	    eval q( &__db_ndbm_open($a, $b, $c));
	}' unless defined(&dbm_open);
	eval 'sub dbm_pagfno {
	    my($a) = @_;
    	    eval q( &__db_ndbm_pagfno($a));
	}' unless defined(&dbm_pagfno);
	eval 'sub dbm_rdonly {
	    my($a) = @_;
    	    eval q( &__db_ndbm_rdonly($a));
	}' unless defined(&dbm_rdonly);
	eval 'sub dbm_store {
	    my($a, $b, $c, $d) = @_;
    	    eval q( &__db_ndbm_store($a, $b, $c, $d));
	}' unless defined(&dbm_store);
	eval 'sub dbminit {
	    my($a) = @_;
    	    eval q( &__db_dbm_init($a));
	}' unless defined(&dbminit);
	eval 'sub dbmclose () { &__db_dbm_close;}' unless defined(&dbmclose);
	if(!defined( &__cplusplus)) {
	    eval 'sub delete {
	        my($a) = @_;
    		eval q( &__db_dbm_delete($a));
	    }' unless defined(&delete);
	}
	eval 'sub fetch {
	    my($a) = @_;
    	    eval q( &__db_dbm_fetch($a));
	}' unless defined(&fetch);
	eval 'sub firstkey () { &__db_dbm_firstkey;}' unless defined(&firstkey);
	eval 'sub nextkey {
	    my($a) = @_;
    	    eval q( &__db_dbm_nextkey($a));
	}' unless defined(&nextkey);
	eval 'sub store {
	    my($a, $b) = @_;
    	    eval q( &__db_dbm_store($a, $b));
	}' unless defined(&store);
	eval("sub FIND () { 0; }") unless defined(&FIND);
	eval("sub ENTER () { 1; }") unless defined(&ENTER);
	eval 'sub hcreate {
	    my($a) = @_;
    	    eval q( &__db_hcreate($a));
	}' unless defined(&hcreate);
	eval 'sub hdestroy () { &__db_hdestroy;}' unless defined(&hdestroy);
	eval 'sub hsearch {
	    my($a, $b) = @_;
    	    eval q( &__db_hsearch($a, $b));
	}' unless defined(&hsearch);
    }
    if(defined( &__cplusplus)) {
    }
}
unless(defined(&_DB_EXT_PROT_IN_)) {
    eval 'sub _DB_EXT_PROT_IN_ () {1;}' unless defined(&_DB_EXT_PROT_IN_);
    if(defined( &__cplusplus)) {
    }
    if((defined(&DB_DBM_HSEARCH) ? &DB_DBM_HSEARCH : 0) != 0) {
    }
    if((defined(&DB_DBM_HSEARCH) ? &DB_DBM_HSEARCH : 0) != 0) {
    }
    if(defined( &__cplusplus)) {
    }
}
1;
