/*
 * CPM2 Internal Memory Map
 * Copyright (c) 1999 Dan Malek (dmalek@jlc.net)
 *
 * The Internal Memory Map for devices with CPM2 on them.  This
 * is the superset of all CPM2 devices (8260, 8266, 8280, 8272,
 * 8560). 
 */
#ifdef __KERNEL__
#ifndef __IMMAP_CPM2__
#define __IMMAP_CPM2__

/* System configuration registers.
*/
typedef	struct sys_82xx_conf {
	__u32	sc_siumcr;
	__u32	sc_sypcr;
	__u8	res1[6];
	__u16	sc_swsr;
	__u8	res2[20];
	__u32	sc_bcr;
	__u8	sc_ppc_acr;
	__u8	res3[3];
	__u32	sc_ppc_alrh;
	__u32	sc_ppc_alrl;
	__u8	sc_lcl_acr;
	__u8	res4[3];
	__u32	sc_lcl_alrh;
	__u32	sc_lcl_alrl;
	__u32	sc_tescr1;
	__u32	sc_tescr2;
	__u32	sc_ltescr1;
	__u32	sc_ltescr2;
	__u32	sc_pdtea;
	__u8	sc_pdtem;
	__u8	res5[3];
	__u32	sc_ldtea;
	__u8	sc_ldtem;
	__u8	res6[163];
} sysconf_82xx_cpm2_t;

typedef	struct sys_85xx_conf {
	__u32	sc_cear;
	__u16	sc_ceer;
	__u16	sc_cemr;
	__u8	res1[70];
	__u32	sc_smaer;
	__u8	res2[4];
	__u32	sc_smevr;
	__u32	sc_smctr;
	__u32	sc_lmaer;
	__u8	res3[4];
	__u32	sc_lmevr;
	__u32	sc_lmctr;
	__u8	res4[144];
} sysconf_85xx_cpm2_t;

typedef union sys_conf {
	sysconf_82xx_cpm2_t	siu_82xx;
	sysconf_85xx_cpm2_t	siu_85xx;
} sysconf_cpm2_t;



/* Memory controller registers.
*/
typedef struct	mem_ctlr {
	__u32	memc_br0;
	__u32	memc_or0;
	__u32	memc_br1;
	__u32	memc_or1;
	__u32	memc_br2;
	__u32	memc_or2;
	__u32	memc_br3;
	__u32	memc_or3;
	__u32	memc_br4;
	__u32	memc_or4;
	__u32	memc_br5;
	__u32	memc_or5;
	__u32	memc_br6;
	__u32	memc_or6;
	__u32	memc_br7;
	__u32	memc_or7;
	__u32	memc_br8;
	__u32	memc_or8;
	__u32	memc_br9;
	__u32	memc_or9;
	__u32	memc_br10;
	__u32	memc_or10;
	__u32	memc_br11;
	__u32	memc_or11;
	__u8	res1[8];
	__u32	memc_mar;
	__u8	res2[4];
	__u32	memc_mamr;
	__u32	memc_mbmr;
	__u32	memc_mcmr;
	__u8	res3[8];
	__u16	memc_mptpr;
	__u8	res4[2];
	__u32	memc_mdr;
	__u8	res5[4];
	__u32	memc_psdmr;
	__u32	memc_lsdmr;
	__u8	memc_purt;
	__u8	res6[3];
	__u8	memc_psrt;
	__u8	res7[3];
	__u8	memc_lurt;
	__u8	res8[3];
	__u8	memc_lsrt;
	__u8	res9[3];
	__u32	memc_immr;
	__u32	memc_pcibr0;
	__u32	memc_pcibr1;
	__u8	res10[16];
	__u32	memc_pcimsk0;
	__u32	memc_pcimsk1;
	__u8	res11[52];
} memctl_cpm2_t;

/* System Integration Timers.
*/
typedef struct	sys_int_timers {
	__u8	res1[32];
	__u16	sit_tmcntsc;
	__u8	res2[2];
	__u32	sit_tmcnt;
	__u8	res3[4];
	__u32	sit_tmcntal;
	__u8	res4[16];
	__u16	sit_piscr;
	__u8	res5[2];
	__u32	sit_pitc;
	__u32	sit_pitr;
	__u8      res6[94];
	__u8	res7[390];
} sit_cpm2_t;

#define PISCR_PIRQ_MASK		((__u16)0xff00)
#define PISCR_PS		((__u16)0x0080)
#define PISCR_PIE		((__u16)0x0004)
#define PISCR_PTF		((__u16)0x0002)
#define PISCR_PTE		((__u16)0x0001)

/* PCI Controller.
*/
typedef struct pci_ctlr {
	__u32	pci_omisr;
	__u32	pci_omimr;
	__u8	res1[8];
	__u32	pci_ifqpr;
	__u32	pci_ofqpr;
	__u8	res2[8];
	__u32	pci_imr0;
	__u32	pci_imr1;
	__u32	pci_omr0;
	__u32	pci_omr1;
	__u32	pci_odr;
	__u8	res3[4];
	__u32	pci_idr;
	__u8	res4[20];
	__u32	pci_imisr;
	__u32	pci_imimr;
	__u8	res5[24];
	__u32	pci_ifhpr;
	__u8	res6[4];
	__u32	pci_iftpr;
	__u8	res7[4];
	__u32	pci_iphpr;
	__u8	res8[4];
	__u32	pci_iptpr;
	__u8	res9[4];
	__u32	pci_ofhpr;
	__u8	res10[4];
	__u32	pci_oftpr;
	__u8	res11[4];
	__u32	pci_ophpr;
	__u8	res12[4];
	__u32	pci_optpr;
	__u8	res13[8];
	__u32	pci_mucr;
	__u8	res14[8];
	__u32	pci_qbar;
	__u8	res15[12];
	__u32	pci_dmamr0;
	__u32	pci_dmasr0;
	__u32	pci_dmacdar0;
	__u8	res16[4];
	__u32	pci_dmasar0;
	__u8	res17[4];
	__u32	pci_dmadar0;
	__u8	res18[4];
	__u32	pci_dmabcr0;
	__u32	pci_dmandar0;
	__u8	res19[86];
	__u32	pci_dmamr1;
	__u32	pci_dmasr1;
	__u32	pci_dmacdar1;
	__u8	res20[4];
	__u32	pci_dmasar1;
	__u8	res21[4];
	__u32	pci_dmadar1;
	__u8	res22[4];
	__u32	pci_dmabcr1;
	__u32	pci_dmandar1;
	__u8	res23[88];
	__u32	pci_dmamr2;
	__u32	pci_dmasr2;
	__u32	pci_dmacdar2;
	__u8	res24[4];
	__u32	pci_dmasar2;
	__u8	res25[4];
	__u32	pci_dmadar2;
	__u8	res26[4];
	__u32	pci_dmabcr2;
	__u32	pci_dmandar2;
	__u8	res27[88];
	__u32	pci_dmamr3;
	__u32	pci_dmasr3;
	__u32	pci_dmacdar3;
	__u8	res28[4];
	__u32	pci_dmasar3;
	__u8	res29[4];
	__u32	pci_dmadar3;
	__u8	res30[4];
	__u32	pci_dmabcr3;
	__u32	pci_dmandar3;
	__u8	res31[344];
	__u32	pci_potar0;
	__u8	res32[4];
	__u32	pci_pobar0;
	__u8	res33[4];
	__u32	pci_pocmr0;
	__u8	res34[4];
	__u32	pci_potar1;
	__u8	res35[4];
	__u32	pci_pobar1;
	__u8	res36[4];
	__u32	pci_pocmr1;
	__u8	res37[4];
	__u32	pci_potar2;
	__u8	res38[4];
	__u32	pci_pobar2;
	__u8	res39[4];
	__u32	pci_pocmr2;
	__u8	res40[50];
	__u32	pci_ptcr;
	__u32	pci_gpcr;
	__u32	pci_gcr;
	__u32	pci_esr;
	__u32	pci_emr;
	__u32	pci_ecr;
	__u32	pci_eacr;
	__u8	res41[4];
	__u32	pci_edcr;
	__u8	res42[4];
	__u32	pci_eccr;
	__u8	res43[44];
	__u32	pci_pitar1;
	__u8	res44[4];
	__u32	pci_pibar1;
	__u8	res45[4];
	__u32	pci_picmr1;
	__u8	res46[4];
	__u32	pci_pitar0;
	__u8	res47[4];
	__u32	pci_pibar0;
	__u8	res48[4];
	__u32	pci_picmr0;
	__u8	res49[4];
	__u32	pci_cfg_addr;
	__u32	pci_cfg_data;
	__u32	pci_int_ack;
	__u8	res50[756];
} pci_cpm2_t;

/* Interrupt Controller.
*/
typedef struct interrupt_controller {
	__u16	ic_sicr;
	__u8	res1[2];
	__u32	ic_sivec;
	__u32	ic_sipnrh;
	__u32	ic_sipnrl;
	__u32	ic_siprr;
	__u32	ic_scprrh;
	__u32	ic_scprrl;
	__u32	ic_simrh;
	__u32	ic_simrl;
	__u32	ic_siexr;
	__u8	res2[88];
} intctl_cpm2_t;

/* Clocks and Reset.
*/
typedef struct clk_and_reset {
	__u32	car_sccr;
	__u8	res1[4];
	__u32	car_scmr;
	__u8	res2[4];
	__u32	car_rsr;
	__u32	car_rmr;
	__u8	res[104];
} car_cpm2_t;

/* Input/Output Port control/status registers.
 * Names consistent with processor manual, although they are different
 * from the original 8xx names.......
 */
typedef struct io_port {
	__u32	iop_pdira;
	__u32	iop_ppara;
	__u32	iop_psora;
	__u32	iop_podra;
	__u32	iop_pdata;
	__u8	res1[12];
	__u32	iop_pdirb;
	__u32	iop_pparb;
	__u32	iop_psorb;
	__u32	iop_podrb;
	__u32	iop_pdatb;
	__u8	res2[12];
	__u32	iop_pdirc;
	__u32	iop_pparc;
	__u32	iop_psorc;
	__u32	iop_podrc;
	__u32	iop_pdatc;
	__u8	res3[12];
	__u32	iop_pdird;
	__u32	iop_ppard;
	__u32	iop_psord;
	__u32	iop_podrd;
	__u32	iop_pdatd;
	__u8	res4[12];
} iop_cpm2_t;

/* Communication Processor Module Timers
*/
typedef struct cpm_timers {
	__u8	cpmt_tgcr1;
	__u8	res1[3];
	__u8	cpmt_tgcr2;
	__u8	res2[11];
	__u16	cpmt_tmr1;
	__u16	cpmt_tmr2;
	__u16	cpmt_trr1;
	__u16	cpmt_trr2;
	__u16	cpmt_tcr1;
	__u16	cpmt_tcr2;
	__u16	cpmt_tcn1;
	__u16	cpmt_tcn2;
	__u16	cpmt_tmr3;
	__u16	cpmt_tmr4;
	__u16	cpmt_trr3;
	__u16	cpmt_trr4;
	__u16	cpmt_tcr3;
	__u16	cpmt_tcr4;
	__u16	cpmt_tcn3;
	__u16	cpmt_tcn4;
	__u16	cpmt_ter1;
	__u16	cpmt_ter2;
	__u16	cpmt_ter3;
	__u16	cpmt_ter4;
	__u8	res3[584];
} cpmtimer_cpm2_t;

/* DMA control/status registers.
*/
typedef struct sdma_csr {
	__u8	res0[24];
	__u8	sdma_sdsr;
	__u8	res1[3];
	__u8	sdma_sdmr;
	__u8	res2[3];
	__u8	sdma_idsr1;
	__u8	res3[3];
	__u8	sdma_idmr1;
	__u8	res4[3];
	__u8	sdma_idsr2;
	__u8	res5[3];
	__u8	sdma_idmr2;
	__u8	res6[3];
	__u8	sdma_idsr3;
	__u8	res7[3];
	__u8	sdma_idmr3;
	__u8	res8[3];
	__u8	sdma_idsr4;
	__u8	res9[3];
	__u8	sdma_idmr4;
	__u8	res10[707];
} sdma_cpm2_t;

/* Fast controllers
*/
typedef struct fcc {
	__u32	fcc_gfmr;
	__u32	fcc_fpsmr;
	__u16	fcc_ftodr;
	__u8	res1[2];
	__u16	fcc_fdsr;
	__u8	res2[2];
	__u16	fcc_fcce;
	__u8	res3[2];
	__u16	fcc_fccm;
	__u8	res4[2];
	__u8	fcc_fccs;
	__u8	res5[3];
	__u8	fcc_ftirr_phy[4];
} fcc_t;

/* Fast controllers continued
 */
typedef struct fcc_c {
	__u32	fcc_firper;
	__u32	fcc_firer;
	__u32	fcc_firsr_hi;
	__u32	fcc_firsr_lo;
	__u8	fcc_gfemr;
	__u8	res1[15];
} fcc_c_t;

/* TC Layer
 */
typedef struct tclayer {
	__u16	tc_tcmode;
	__u16	tc_cdsmr;
	__u16	tc_tcer;
	__u16	tc_rcc;
	__u16	tc_tcmr;
	__u16	tc_fcc;
	__u16	tc_ccc;
	__u16	tc_icc;
	__u16	tc_tcc;
	__u16	tc_ecc;
	__u8	res1[12];
} tclayer_t;


/* I2C
*/
typedef struct i2c {
	__u8	i2c_i2mod;
	__u8	res1[3];
	__u8	i2c_i2add;
	__u8	res2[3];
	__u8	i2c_i2brg;
	__u8	res3[3];
	__u8	i2c_i2com;
	__u8	res4[3];
	__u8	i2c_i2cer;
	__u8	res5[3];
	__u8	i2c_i2cmr;
	__u8	res6[331];
} i2c_cpm2_t;

typedef struct scc {		/* Serial communication channels */
	__u32	scc_gsmrl;
	__u32	scc_gsmrh;
	__u16	scc_psmr;
	__u8	res1[2];
	__u16	scc_todr;
	__u16	scc_dsr;
	__u16	scc_scce;
	__u8	res2[2];
	__u16	scc_sccm;
	__u8	res3;
	__u8	scc_sccs;
	__u8	res4[8];
} scc_t;

typedef struct smc {		/* Serial management channels */
	__u8	res1[2];
	__u16	smc_smcmr;
	__u8	res2[2];
	__u8	smc_smce;
	__u8	res3[3];
	__u8	smc_smcm;
	__u8	res4[5];
} smc_t;

/* Serial Peripheral Interface.
*/
typedef struct spi_ctrl {
	__u16	spi_spmode;
	__u8	res1[4];
	__u8	spi_spie;
	__u8	res2[3];
	__u8	spi_spim;
	__u8	res3[2];
	__u8	spi_spcom;
	__u8	res4[82];
} spictl_cpm2_t;

/* CPM Mux.
*/
typedef struct cpmux {
	__u8	cmx_si1cr;
	__u8	res1;
	__u8	cmx_si2cr;
	__u8	res2;
	__u32	cmx_fcr;
	__u32	cmx_scr;
	__u8	cmx_smr;
	__u8	res3;
	__u16	cmx_uar;
	__u8	res4[16];
} cpmux_t;

/* SIRAM control
*/
typedef struct siram {
	__u16	si_amr;
	__u16	si_bmr;
	__u16	si_cmr;
	__u16	si_dmr;
	__u8	si_gmr;
	__u8	res1;
	__u8	si_cmdr;
	__u8	res2;
	__u8	si_str;
	__u8	res3;
	__u16	si_rsr;
} siramctl_t;

typedef struct mcc {
	__u16	mcc_mcce;
	__u8	res1[2];
	__u16	mcc_mccm;
	__u8	res2[2];
	__u8	mcc_mccf;
	__u8	res3[7];
} mcc_t;

typedef struct comm_proc {
	__u32	cp_cpcr;
	__u32	cp_rccr;
	__u8	res1[14];
	__u16	cp_rter;
	__u8	res2[2];
	__u16	cp_rtmr;
	__u16	cp_rtscr;
	__u8	res3[2];
	__u32	cp_rtsr;
	__u8	res4[12];
} cpm_cpm2_t;

/* USB Controller.
*/
typedef struct usb_ctlr {
	__u8	usb_usmod;
	__u8	usb_usadr;
	__u8	usb_uscom;
	__u8	res1[1];
	__u16	usb_usep1;
	__u16	usb_usep2;
	__u16	usb_usep3;
	__u16	usb_usep4;
	__u8	res2[4];
	__u16	usb_usber;
	__u8	res3[2];
	__u16	usb_usbmr;
	__u8	usb_usbs;
	__u8	res4[7];
} usb_cpm2_t;

/* ...and the whole thing wrapped up....
*/

typedef struct immap {
	/* Some references are into the unique and known dpram spaces,
	 * others are from the generic base.
	 */
#define im_dprambase	im_dpram1
	__u8		im_dpram1[16*1024];
	__u8		res1[16*1024];
	__u8		im_dpram2[4*1024];
	__u8		res2[8*1024];
	__u8		im_dpram3[4*1024];
	__u8		res3[16*1024];

	sysconf_cpm2_t	im_siu_conf;	/* SIU Configuration */
	memctl_cpm2_t	im_memctl;	/* Memory Controller */
	sit_cpm2_t	im_sit;		/* System Integration Timers */
	pci_cpm2_t	im_pci;		/* PCI Controller */
	intctl_cpm2_t	im_intctl;	/* Interrupt Controller */
	car_cpm2_t	im_clkrst;	/* Clocks and reset */
	iop_cpm2_t	im_ioport;	/* IO Port control/status */
	cpmtimer_cpm2_t	im_cpmtimer;	/* CPM timers */
	sdma_cpm2_t	im_sdma;	/* SDMA control/status */

	fcc_t		im_fcc[3];	/* Three FCCs */
	__u8		res4z[32];
	fcc_c_t		im_fcc_c[3];	/* Continued FCCs */

	__u8		res4[32];

	tclayer_t	im_tclayer[8];	/* Eight TCLayers */
	__u16		tc_tcgsr;
	__u16		tc_tcger;
	
	/* First set of baud rate generators.
	*/
	__u8		res[236];
	__u32		im_brgc5;
	__u32		im_brgc6;
	__u32		im_brgc7;
	__u32		im_brgc8;

	__u8		res5[608];

	i2c_cpm2_t	im_i2c;		/* I2C control/status */
	cpm_cpm2_t	im_cpm;		/* Communication processor */

	/* Second set of baud rate generators.
	*/
	__u32		im_brgc1;
	__u32		im_brgc2;
	__u32		im_brgc3;
	__u32		im_brgc4;

	scc_t		im_scc[4];	/* Four SCCs */
	smc_t		im_smc[2];	/* Couple of SMCs */
	spictl_cpm2_t	im_spi;		/* A SPI */
	cpmux_t		im_cpmux;	/* CPM clock route mux */
	siramctl_t	im_siramctl1;	/* First SI RAM Control */
	mcc_t		im_mcc1;	/* First MCC */
	siramctl_t	im_siramctl2;	/* Second SI RAM Control */
	mcc_t		im_mcc2;	/* Second MCC */
	usb_cpm2_t	im_usb;		/* USB Controller */

	__u8		res6[1153];

	__u16		im_si1txram[256];
	__u8		res7[512];
	__u16		im_si1rxram[256];
	__u8		res8[512];
	__u16		im_si2txram[256];
	__u8		res9[512];
	__u16		im_si2rxram[256];
	__u8		res10[512];
	__u8		res11[4096];
} cpm2_map_t;

extern cpm2_map_t	*cpm2_immr;

#endif /* __IMMAP_CPM2__ */
#endif /* __KERNEL__ */
