/* linux/spi/ads7846.h */

/* Touchscreen characteristics vary between boards and models.  The
 * platform_data for the device's "struct device" holds this information.
 *
 * It's OK if the min/max values are zero.
 */
struct ads7846_platform_data {
	__u16	model;			/* 7843, 7845, 7846. */
	__u16	vref_delay_usecs;	/* 0 for external vref; etc */
	__u16	x_plate_ohms;
	__u16	y_plate_ohms;

	__u16	x_min, x_max;
	__u16	y_min, y_max;
	__u16	pressure_min, pressure_max;

	__u16	debounce_max;		/* max number of additional readings
					 * per sample */
	__u16	debounce_tol;		/* tolerance used for filtering */
	__u16	debounce_rep;		/* additional consecutive good readings
					 * required after the first two */
	int	(*get_pendown_state)(void);
};

