#ifndef _ASM_POWERPC_CACHE_H
#define _ASM_POWERPC_CACHE_H

#include <linux/config.h>

/* bytes per L1 cache line */
#if defined(CONFIG_8xx) || defined(CONFIG_403GCX)
#define L1_CACHE_SHIFT		4
#define MAX_COPY_PREFETCH	1
#elif defined(CONFIG_PPC32)
#define L1_CACHE_SHIFT		5
#define MAX_COPY_PREFETCH	4
#else /* CONFIG_PPC64 */
#define L1_CACHE_SHIFT		7
#endif

#define	L1_CACHE_BYTES		(1 << L1_CACHE_SHIFT)

#define	SMP_CACHE_BYTES		L1_CACHE_BYTES

#if defined(__powerpc64__) && !defined(__ASSEMBLY__)
struct ppc64_caches {
	__u32	dsize;			/* L1 d-cache size */
	__u32	dline_size;		/* L1 d-cache line size	*/
	__u32	log_dline_size;
	__u32	dlines_per_page;
	__u32	isize;			/* L1 i-cache size */
	__u32	iline_size;		/* L1 i-cache line size	*/
	__u32	log_iline_size;
	__u32	ilines_per_page;
};

extern struct ppc64_caches ppc64_caches;
#endif /* __powerpc64__ && ! __ASSEMBLY__ */

#endif /* _ASM_POWERPC_CACHE_H */
