/*
 * This file contains the "hypervisor call" interface which is used to
 * drive the hypervisor from SLIC.
 */
#ifndef _ASM_POWERPC_ISERIES_HV_CALL_XM_H
#define _ASM_POWERPC_ISERIES_HV_CALL_XM_H

#include <asm/iseries/hv_call_sc.h>
#include <asm/iseries/hv_types.h>

#define HvCallXmGetTceTableParms	HvCallXm +  0
#define HvCallXmTestBus			HvCallXm +  1
#define HvCallXmConnectBusUnit		HvCallXm +  2
#define HvCallXmLoadTod			HvCallXm +  8
#define HvCallXmTestBusUnit		HvCallXm +  9
#define HvCallXmSetTce			HvCallXm + 11
#define HvCallXmSetTces			HvCallXm + 13

/*
 * Structure passed to HvCallXm_getTceTableParms
 */
struct iommu_table_cb {
	unsigned long	itc_busno;	/* Bus number for this tce table */
	unsigned long	itc_start;	/* Will be NULL for secondary */
	unsigned long	itc_totalsize;	/* Size (in pages) of whole table */
	unsigned long	itc_offset;	/* Index into real tce table of the
					   start of our section */
	unsigned long	itc_size;	/* Size (in pages) of our section */
	unsigned long	itc_index;	/* Index of this tce table */
	unsigned short	itc_maxtables;	/* Max num of tables for partition */
	unsigned char	itc_virtbus;	/* Flag to indicate virtual bus */
	unsigned char	itc_slotno;	/* IOA Tce Slot Index */
	unsigned char	itc_rsvd[4];
};

static __inline__ void HvCallXm_getTceTableParms(__u64 cb)
{
	HvCall1(HvCallXmGetTceTableParms, cb);
}

static __inline__ __u64 HvCallXm_setTce(__u64 tceTableToken, __u64 tceOffset, __u64 tce)
{
	return HvCall3(HvCallXmSetTce, tceTableToken, tceOffset, tce);
}

static __inline__ __u64 HvCallXm_setTces(__u64 tceTableToken, __u64 tceOffset,
		__u64 numTces, __u64 tce1, __u64 tce2, __u64 tce3, __u64 tce4)
{
	return HvCall7(HvCallXmSetTces, tceTableToken, tceOffset, numTces,
			     tce1, tce2, tce3, tce4);
}

static __inline__ __u64 HvCallXm_testBus(__u16 busNumber)
{
	return HvCall1(HvCallXmTestBus, busNumber);
}

static __inline__ __u64 HvCallXm_testBusUnit(__u16 busNumber, __u8 subBusNumber,
		__u8 deviceId)
{
	return HvCall2(HvCallXmTestBusUnit, busNumber,
			(subBusNumber << 8) | deviceId);
}

static __inline__ __u64 HvCallXm_connectBusUnit(__u16 busNumber, __u8 subBusNumber,
		__u8 deviceId, __u64 interruptToken)
{
	return HvCall5(HvCallXmConnectBusUnit, busNumber,
			(subBusNumber << 8) | deviceId, interruptToken, 0,
			0 /* HvLpConfig::mapDsaToQueueIndex(HvLpDSA(busNumber, xBoard, xCard)) */);
}

static __inline__ __u64 HvCallXm_loadTod(void)
{
	return HvCall0(HvCallXmLoadTod);
}

#endif /* _ASM_POWERPC_ISERIES_HV_CALL_XM_H */
