require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_POWERPC_CPUTABLE_H)) {
    eval 'sub __ASM_POWERPC_CPUTABLE_H () {1;}' unless defined(&__ASM_POWERPC_CPUTABLE_H);
    require 'asm/asm-compat.ph';
    eval 'sub PPC_FEATURE_32 () {0x80000000;}' unless defined(&PPC_FEATURE_32);
    eval 'sub PPC_FEATURE_64 () {0x40000000;}' unless defined(&PPC_FEATURE_64);
    eval 'sub PPC_FEATURE_601_INSTR () {0x20000000;}' unless defined(&PPC_FEATURE_601_INSTR);
    eval 'sub PPC_FEATURE_HAS_ALTIVEC () {0x10000000;}' unless defined(&PPC_FEATURE_HAS_ALTIVEC);
    eval 'sub PPC_FEATURE_HAS_FPU () {0x8000000;}' unless defined(&PPC_FEATURE_HAS_FPU);
    eval 'sub PPC_FEATURE_HAS_MMU () {0x4000000;}' unless defined(&PPC_FEATURE_HAS_MMU);
    eval 'sub PPC_FEATURE_HAS_4xxMAC () {0x2000000;}' unless defined(&PPC_FEATURE_HAS_4xxMAC);
    eval 'sub PPC_FEATURE_UNIFIED_CACHE () {0x1000000;}' unless defined(&PPC_FEATURE_UNIFIED_CACHE);
    eval 'sub PPC_FEATURE_HAS_SPE () {0x800000;}' unless defined(&PPC_FEATURE_HAS_SPE);
    eval 'sub PPC_FEATURE_HAS_EFP_SINGLE () {0x400000;}' unless defined(&PPC_FEATURE_HAS_EFP_SINGLE);
    eval 'sub PPC_FEATURE_HAS_EFP_DOUBLE () {0x200000;}' unless defined(&PPC_FEATURE_HAS_EFP_DOUBLE);
    eval 'sub PPC_FEATURE_NO_TB () {0x100000;}' unless defined(&PPC_FEATURE_NO_TB);
    eval 'sub PPC_FEATURE_POWER4 () {0x80000;}' unless defined(&PPC_FEATURE_POWER4);
    eval 'sub PPC_FEATURE_POWER5 () {0x40000;}' unless defined(&PPC_FEATURE_POWER5);
    eval 'sub PPC_FEATURE_POWER5_PLUS () {0x20000;}' unless defined(&PPC_FEATURE_POWER5_PLUS);
    eval 'sub PPC_FEATURE_CELL () {0x10000;}' unless defined(&PPC_FEATURE_CELL);
    eval 'sub PPC_FEATURE_BOOKE () {0x8000;}' unless defined(&PPC_FEATURE_BOOKE);
    eval 'sub PPC_FEATURE_SMT () {0x4000;}' unless defined(&PPC_FEATURE_SMT);
    eval 'sub PPC_FEATURE_ICACHE_SNOOP () {0x2000;}' unless defined(&PPC_FEATURE_ICACHE_SNOOP);
    eval 'sub PPC_FEATURE_ARCH_2_05 () {0x1000;}' unless defined(&PPC_FEATURE_ARCH_2_05);
    if(defined(&__KERNEL__)) {
	unless(defined(&__ASSEMBLY__)) {
	    eval("sub PPC_OPROFILE_INVALID () { 0; }") unless defined(&PPC_OPROFILE_INVALID);
	    eval("sub PPC_OPROFILE_RS64 () { 1; }") unless defined(&PPC_OPROFILE_RS64);
	    eval("sub PPC_OPROFILE_POWER4 () { 2; }") unless defined(&PPC_OPROFILE_POWER4);
	    eval("sub PPC_OPROFILE_G4 () { 3; }") unless defined(&PPC_OPROFILE_G4);
	    eval("sub PPC_OPROFILE_BOOKE () { 4; }") unless defined(&PPC_OPROFILE_BOOKE);
	}
	eval 'sub CPU_FTR_SPLIT_ID_CACHE () { &ASM_CONST(0x1);}' unless defined(&CPU_FTR_SPLIT_ID_CACHE);
	eval 'sub CPU_FTR_L2CR () { &ASM_CONST(0x2);}' unless defined(&CPU_FTR_L2CR);
	eval 'sub CPU_FTR_SPEC7450 () { &ASM_CONST(0x4);}' unless defined(&CPU_FTR_SPEC7450);
	eval 'sub CPU_FTR_ALTIVEC () { &ASM_CONST(0x8);}' unless defined(&CPU_FTR_ALTIVEC);
	eval 'sub CPU_FTR_TAU () { &ASM_CONST(0x10);}' unless defined(&CPU_FTR_TAU);
	eval 'sub CPU_FTR_CAN_DOZE () { &ASM_CONST(0x20);}' unless defined(&CPU_FTR_CAN_DOZE);
	eval 'sub CPU_FTR_USE_TB () { &ASM_CONST(0x40);}' unless defined(&CPU_FTR_USE_TB);
	eval 'sub CPU_FTR_604_PERF_MON () { &ASM_CONST(0x80);}' unless defined(&CPU_FTR_604_PERF_MON);
	eval 'sub CPU_FTR_601 () { &ASM_CONST(0x100);}' unless defined(&CPU_FTR_601);
	eval 'sub CPU_FTR_HPTE_TABLE () { &ASM_CONST(0x200);}' unless defined(&CPU_FTR_HPTE_TABLE);
	eval 'sub CPU_FTR_CAN_NAP () { &ASM_CONST(0x400);}' unless defined(&CPU_FTR_CAN_NAP);
	eval 'sub CPU_FTR_L3CR () { &ASM_CONST(0x800);}' unless defined(&CPU_FTR_L3CR);
	eval 'sub CPU_FTR_L3_DISABLE_NAP () { &ASM_CONST(0x1000);}' unless defined(&CPU_FTR_L3_DISABLE_NAP);
	eval 'sub CPU_FTR_NAP_DISABLE_L2_PR () { &ASM_CONST(0x2000);}' unless defined(&CPU_FTR_NAP_DISABLE_L2_PR);
	eval 'sub CPU_FTR_DUAL_PLL_750FX () { &ASM_CONST(0x4000);}' unless defined(&CPU_FTR_DUAL_PLL_750FX);
	eval 'sub CPU_FTR_NO_DPM () { &ASM_CONST(0x8000);}' unless defined(&CPU_FTR_NO_DPM);
	eval 'sub CPU_FTR_HAS_HIGH_BATS () { &ASM_CONST(0x10000);}' unless defined(&CPU_FTR_HAS_HIGH_BATS);
	eval 'sub CPU_FTR_NEED_COHERENT () { &ASM_CONST(0x20000);}' unless defined(&CPU_FTR_NEED_COHERENT);
	eval 'sub CPU_FTR_NO_BTIC () { &ASM_CONST(0x40000);}' unless defined(&CPU_FTR_NO_BTIC);
	eval 'sub CPU_FTR_BIG_PHYS () { &ASM_CONST(0x80000);}' unless defined(&CPU_FTR_BIG_PHYS);
	eval 'sub CPU_FTR_NODSISRALIGN () { &ASM_CONST(0x100000);}' unless defined(&CPU_FTR_NODSISRALIGN);
	if(defined(&__powerpc64__)) {
	    eval 'sub CPU_FTR_SLB () { &ASM_CONST(0x100000000);}' unless defined(&CPU_FTR_SLB);
	    eval 'sub CPU_FTR_16M_PAGE () { &ASM_CONST(0x200000000);}' unless defined(&CPU_FTR_16M_PAGE);
	    eval 'sub CPU_FTR_TLBIEL () { &ASM_CONST(0x400000000);}' unless defined(&CPU_FTR_TLBIEL);
	    eval 'sub CPU_FTR_NOEXECUTE () { &ASM_CONST(0x800000000);}' unless defined(&CPU_FTR_NOEXECUTE);
	    eval 'sub CPU_FTR_IABR () { &ASM_CONST(0x2000000000);}' unless defined(&CPU_FTR_IABR);
	    eval 'sub CPU_FTR_MMCRA () { &ASM_CONST(0x4000000000);}' unless defined(&CPU_FTR_MMCRA);
	    eval 'sub CPU_FTR_CTRL () { &ASM_CONST(0x8000000000);}' unless defined(&CPU_FTR_CTRL);
	    eval 'sub CPU_FTR_SMT () { &ASM_CONST(0x10000000000);}' unless defined(&CPU_FTR_SMT);
	    eval 'sub CPU_FTR_COHERENT_ICACHE () { &ASM_CONST(0x20000000000);}' unless defined(&CPU_FTR_COHERENT_ICACHE);
	    eval 'sub CPU_FTR_LOCKLESS_TLBIE () { &ASM_CONST(0x40000000000);}' unless defined(&CPU_FTR_LOCKLESS_TLBIE);
	    eval 'sub CPU_FTR_MMCRA_SIHV () { &ASM_CONST(0x80000000000);}' unless defined(&CPU_FTR_MMCRA_SIHV);
	    eval 'sub CPU_FTR_CI_LARGE_PAGE () { &ASM_CONST(0x100000000000);}' unless defined(&CPU_FTR_CI_LARGE_PAGE);
	    eval 'sub CPU_FTR_PAUSE_ZERO () { &ASM_CONST(0x200000000000);}' unless defined(&CPU_FTR_PAUSE_ZERO);
	    eval 'sub CPU_FTR_PURR () { &ASM_CONST(0x400000000000);}' unless defined(&CPU_FTR_PURR);
	} else {
	    eval 'sub CPU_FTR_SLB () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_SLB);
	    eval 'sub CPU_FTR_16M_PAGE () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_16M_PAGE);
	    eval 'sub CPU_FTR_TLBIEL () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_TLBIEL);
	    eval 'sub CPU_FTR_NOEXECUTE () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_NOEXECUTE);
	    eval 'sub CPU_FTR_IABR () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_IABR);
	    eval 'sub CPU_FTR_MMCRA () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_MMCRA);
	    eval 'sub CPU_FTR_CTRL () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_CTRL);
	    eval 'sub CPU_FTR_SMT () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_SMT);
	    eval 'sub CPU_FTR_COHERENT_ICACHE () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_COHERENT_ICACHE);
	    eval 'sub CPU_FTR_LOCKLESS_TLBIE () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_LOCKLESS_TLBIE);
	    eval 'sub CPU_FTR_MMCRA_SIHV () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_MMCRA_SIHV);
	    eval 'sub CPU_FTR_CI_LARGE_PAGE () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_CI_LARGE_PAGE);
	    eval 'sub CPU_FTR_PURR () { &ASM_CONST(0x);}' unless defined(&CPU_FTR_PURR);
	}
	unless(defined(&__ASSEMBLY__)) {
	    eval 'sub CPU_FTR_PPCAS_ARCH_V2_BASE () {( &CPU_FTR_SLB |  &CPU_FTR_TLBIEL |  &CPU_FTR_NOEXECUTE |  &CPU_FTR_NODSISRALIGN |  &CPU_FTR_CTRL);}' unless defined(&CPU_FTR_PPCAS_ARCH_V2_BASE);
	    if(defined(&CONFIG_PPC_ISERIES)) {
		eval 'sub CPU_FTR_PPCAS_ARCH_V2 () {( &CPU_FTR_PPCAS_ARCH_V2_BASE);}' unless defined(&CPU_FTR_PPCAS_ARCH_V2);
	    } else {
		eval 'sub CPU_FTR_PPCAS_ARCH_V2 () {( &CPU_FTR_PPCAS_ARCH_V2_BASE |  &CPU_FTR_16M_PAGE);}' unless defined(&CPU_FTR_PPCAS_ARCH_V2);
	    }
	    if(defined(&CONFIG_ALTIVEC)) {
		eval 'sub CPU_FTR_ALTIVEC_COMP () { &CPU_FTR_ALTIVEC;}' unless defined(&CPU_FTR_ALTIVEC_COMP);
		eval 'sub PPC_FEATURE_HAS_ALTIVEC_COMP () { &PPC_FEATURE_HAS_ALTIVEC;}' unless defined(&PPC_FEATURE_HAS_ALTIVEC_COMP);
	    } else {
		eval 'sub CPU_FTR_ALTIVEC_COMP () {0;}' unless defined(&CPU_FTR_ALTIVEC_COMP);
		eval 'sub PPC_FEATURE_HAS_ALTIVEC_COMP () {0;}' unless defined(&PPC_FEATURE_HAS_ALTIVEC_COMP);
	    }
	    if(defined( &CONFIG_SMP) || defined( &CONFIG_MPC10X_BRIDGE) || defined( &CONFIG_PPC_83xx)) {
		eval 'sub CPU_FTR_COMMON () { &CPU_FTR_NEED_COHERENT;}' unless defined(&CPU_FTR_COMMON);
	    } else {
		eval 'sub CPU_FTR_COMMON () {0;}' unless defined(&CPU_FTR_COMMON);
	    }
	    unless(defined(&CONFIG_BDI_SWITCH)) {
		eval 'sub CPU_FTR_MAYBE_CAN_DOZE () { &CPU_FTR_CAN_DOZE;}' unless defined(&CPU_FTR_MAYBE_CAN_DOZE);
		eval 'sub CPU_FTR_MAYBE_CAN_NAP () { &CPU_FTR_CAN_NAP;}' unless defined(&CPU_FTR_MAYBE_CAN_NAP);
	    } else {
		eval 'sub CPU_FTR_MAYBE_CAN_DOZE () {0;}' unless defined(&CPU_FTR_MAYBE_CAN_DOZE);
		eval 'sub CPU_FTR_MAYBE_CAN_NAP () {0;}' unless defined(&CPU_FTR_MAYBE_CAN_NAP);
	    }
	    eval 'sub CLASSIC_PPC () {(!defined( &CONFIG_8xx)  && !defined( &CONFIG_4xx)  && !defined( &CONFIG_POWER3)  && !defined( &CONFIG_POWER4)  && !defined( &CONFIG_BOOKE));}' unless defined(&CLASSIC_PPC);
	    eval 'sub CPU_FTRS_PPC601 () {( &CPU_FTR_COMMON |  &CPU_FTR_601 |  &CPU_FTR_HPTE_TABLE);}' unless defined(&CPU_FTRS_PPC601);
	    eval 'sub CPU_FTRS_603 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_MAYBE_CAN_NAP);}' unless defined(&CPU_FTRS_603);
	    eval 'sub CPU_FTRS_604 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_604_PERF_MON |  &CPU_FTR_HPTE_TABLE);}' unless defined(&CPU_FTRS_604);
	    eval 'sub CPU_FTRS_740_NOTAU () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_L2CR |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_MAYBE_CAN_NAP);}' unless defined(&CPU_FTRS_740_NOTAU);
	    eval 'sub CPU_FTRS_740 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_L2CR |  &CPU_FTR_TAU |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_MAYBE_CAN_NAP);}' unless defined(&CPU_FTRS_740);
	    eval 'sub CPU_FTRS_750 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_L2CR |  &CPU_FTR_TAU |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_MAYBE_CAN_NAP);}' unless defined(&CPU_FTRS_750);
	    eval 'sub CPU_FTRS_750FX1 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_L2CR |  &CPU_FTR_TAU |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_DUAL_PLL_750FX |  &CPU_FTR_NO_DPM);}' unless defined(&CPU_FTRS_750FX1);
	    eval 'sub CPU_FTRS_750FX2 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_L2CR |  &CPU_FTR_TAU |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_NO_DPM);}' unless defined(&CPU_FTRS_750FX2);
	    eval 'sub CPU_FTRS_750FX () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_L2CR |  &CPU_FTR_TAU |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_DUAL_PLL_750FX |  &CPU_FTR_HAS_HIGH_BATS);}' unless defined(&CPU_FTRS_750FX);
	    eval 'sub CPU_FTRS_750GX () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_L2CR |  &CPU_FTR_TAU |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_DUAL_PLL_750FX |  &CPU_FTR_HAS_HIGH_BATS);}' unless defined(&CPU_FTRS_750GX);
	    eval 'sub CPU_FTRS_7400_NOTAU () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_L2CR |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_MAYBE_CAN_NAP);}' unless defined(&CPU_FTRS_7400_NOTAU);
	    eval 'sub CPU_FTRS_7400 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_L2CR |  &CPU_FTR_TAU |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_MAYBE_CAN_NAP);}' unless defined(&CPU_FTRS_7400);
	    eval 'sub CPU_FTRS_7450_20 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_L2CR |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_L3CR |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_SPEC7450 |  &CPU_FTR_NEED_COHERENT);}' unless defined(&CPU_FTRS_7450_20);
	    eval 'sub CPU_FTRS_7450_21 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_L2CR |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_L3CR |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_SPEC7450 |  &CPU_FTR_NAP_DISABLE_L2_PR |  &CPU_FTR_L3_DISABLE_NAP |  &CPU_FTR_NEED_COHERENT);}' unless defined(&CPU_FTRS_7450_21);
	    eval 'sub CPU_FTRS_7450_23 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_L2CR |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_L3CR |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_SPEC7450 |  &CPU_FTR_NAP_DISABLE_L2_PR |  &CPU_FTR_NEED_COHERENT);}' unless defined(&CPU_FTRS_7450_23);
	    eval 'sub CPU_FTRS_7455_1 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_L2CR |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_L3CR |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_SPEC7450 |  &CPU_FTR_HAS_HIGH_BATS |  &CPU_FTR_NEED_COHERENT);}' unless defined(&CPU_FTRS_7455_1);
	    eval 'sub CPU_FTRS_7455_20 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_L2CR |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_L3CR |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_SPEC7450 |  &CPU_FTR_NAP_DISABLE_L2_PR |  &CPU_FTR_L3_DISABLE_NAP |  &CPU_FTR_NEED_COHERENT |  &CPU_FTR_HAS_HIGH_BATS);}' unless defined(&CPU_FTRS_7455_20);
	    eval 'sub CPU_FTRS_7455 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_L2CR |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_L3CR |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_SPEC7450 |  &CPU_FTR_NAP_DISABLE_L2_PR |  &CPU_FTR_HAS_HIGH_BATS |  &CPU_FTR_NEED_COHERENT);}' unless defined(&CPU_FTRS_7455);
	    eval 'sub CPU_FTRS_7447_10 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_L2CR |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_L3CR |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_SPEC7450 |  &CPU_FTR_NAP_DISABLE_L2_PR |  &CPU_FTR_HAS_HIGH_BATS |  &CPU_FTR_NEED_COHERENT |  &CPU_FTR_NO_BTIC);}' unless defined(&CPU_FTRS_7447_10);
	    eval 'sub CPU_FTRS_7447 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_L2CR |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_L3CR |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_SPEC7450 |  &CPU_FTR_NAP_DISABLE_L2_PR |  &CPU_FTR_HAS_HIGH_BATS |  &CPU_FTR_NEED_COHERENT);}' unless defined(&CPU_FTRS_7447);
	    eval 'sub CPU_FTRS_7447A () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_L2CR |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_SPEC7450 |  &CPU_FTR_NAP_DISABLE_L2_PR |  &CPU_FTR_HAS_HIGH_BATS |  &CPU_FTR_NEED_COHERENT);}' unless defined(&CPU_FTRS_7447A);
	    eval 'sub CPU_FTRS_82XX () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB);}' unless defined(&CPU_FTRS_82XX);
	    eval 'sub CPU_FTRS_G2_LE () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_HAS_HIGH_BATS);}' unless defined(&CPU_FTRS_G2_LE);
	    eval 'sub CPU_FTRS_E300 () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_MAYBE_CAN_DOZE |  &CPU_FTR_USE_TB |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_HAS_HIGH_BATS |  &CPU_FTR_COMMON);}' unless defined(&CPU_FTRS_E300);
	    eval 'sub CPU_FTRS_CLASSIC32 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE);}' unless defined(&CPU_FTRS_CLASSIC32);
	    eval 'sub CPU_FTRS_POWER3_32 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE);}' unless defined(&CPU_FTRS_POWER3_32);
	    eval 'sub CPU_FTRS_POWER4_32 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_NODSISRALIGN);}' unless defined(&CPU_FTRS_POWER4_32);
	    eval 'sub CPU_FTRS_970_32 () {( &CPU_FTR_COMMON |  &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_MAYBE_CAN_NAP |  &CPU_FTR_NODSISRALIGN);}' unless defined(&CPU_FTRS_970_32);
	    eval 'sub CPU_FTRS_8XX () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB);}' unless defined(&CPU_FTRS_8XX);
	    eval 'sub CPU_FTRS_40X () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_NODSISRALIGN);}' unless defined(&CPU_FTRS_40X);
	    eval 'sub CPU_FTRS_44X () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_NODSISRALIGN);}' unless defined(&CPU_FTRS_44X);
	    eval 'sub CPU_FTRS_E200 () {( &CPU_FTR_USE_TB |  &CPU_FTR_NODSISRALIGN);}' unless defined(&CPU_FTRS_E200);
	    eval 'sub CPU_FTRS_E500 () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_NODSISRALIGN);}' unless defined(&CPU_FTRS_E500);
	    eval 'sub CPU_FTRS_E500_2 () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_BIG_PHYS |  &CPU_FTR_NODSISRALIGN);}' unless defined(&CPU_FTRS_E500_2);
	    eval 'sub CPU_FTRS_GENERIC_32 () {( &CPU_FTR_COMMON |  &CPU_FTR_NODSISRALIGN);}' unless defined(&CPU_FTRS_GENERIC_32);
	    if(defined(&__powerpc64__)) {
		eval 'sub CPU_FTRS_POWER3 () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_IABR);}' unless defined(&CPU_FTRS_POWER3);
		eval 'sub CPU_FTRS_RS64 () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_IABR |  &CPU_FTR_MMCRA |  &CPU_FTR_CTRL);}' unless defined(&CPU_FTRS_RS64);
		eval 'sub CPU_FTRS_POWER4 () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_PPCAS_ARCH_V2 |  &CPU_FTR_MMCRA);}' unless defined(&CPU_FTRS_POWER4);
		eval 'sub CPU_FTRS_PPC970 () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_PPCAS_ARCH_V2 |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_CAN_NAP |  &CPU_FTR_MMCRA);}' unless defined(&CPU_FTRS_PPC970);
		eval 'sub CPU_FTRS_POWER5 () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_PPCAS_ARCH_V2 |  &CPU_FTR_MMCRA |  &CPU_FTR_SMT |  &CPU_FTR_COHERENT_ICACHE |  &CPU_FTR_LOCKLESS_TLBIE |  &CPU_FTR_MMCRA_SIHV |  &CPU_FTR_PURR);}' unless defined(&CPU_FTRS_POWER5);
		eval 'sub CPU_FTRS_POWER6 () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_PPCAS_ARCH_V2 |  &CPU_FTR_MMCRA |  &CPU_FTR_SMT |  &CPU_FTR_COHERENT_ICACHE |  &CPU_FTR_LOCKLESS_TLBIE |  &CPU_FTR_PURR |  &CPU_FTR_CI_LARGE_PAGE);}' unless defined(&CPU_FTRS_POWER6);
		eval 'sub CPU_FTRS_CELL () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_PPCAS_ARCH_V2 |  &CPU_FTR_ALTIVEC_COMP |  &CPU_FTR_MMCRA |  &CPU_FTR_SMT |  &CPU_FTR_CTRL |  &CPU_FTR_PAUSE_ZERO |  &CPU_FTR_CI_LARGE_PAGE);}' unless defined(&CPU_FTRS_CELL);
		eval 'sub CPU_FTRS_COMPATIBLE () {( &CPU_FTR_SPLIT_ID_CACHE |  &CPU_FTR_USE_TB |  &CPU_FTR_HPTE_TABLE |  &CPU_FTR_PPCAS_ARCH_V2);}' unless defined(&CPU_FTRS_COMPATIBLE);
	    }
	    if(defined(&__powerpc64__)) {
		eval 'sub CPU_FTRS_POSSIBLE () {( &CPU_FTRS_POWER3 |  &CPU_FTRS_RS64 |  &CPU_FTRS_POWER4 |  &CPU_FTRS_PPC970 |  &CPU_FTRS_POWER5 |  &CPU_FTRS_POWER6 |  &CPU_FTRS_CELL |  &CPU_FTR_CI_LARGE_PAGE);}' unless defined(&CPU_FTRS_POSSIBLE);
	    } else {
		eval("sub CPU_FTRS_POSSIBLE () { 0; }") unless defined(&CPU_FTRS_POSSIBLE);
	    }
	    if(defined(&__powerpc64__)) {
		eval 'sub CPU_FTRS_ALWAYS () {( &CPU_FTRS_POWER3 &  &CPU_FTRS_RS64 &  &CPU_FTRS_POWER4 &  &CPU_FTRS_PPC970 &  &CPU_FTRS_POWER5 &  &CPU_FTRS_POWER6 &  &CPU_FTRS_CELL &  &CPU_FTRS_POSSIBLE);}' unless defined(&CPU_FTRS_ALWAYS);
	    } else {
		eval("sub CPU_FTRS_ALWAYS () { CPU_FTRS_POSSIBLE; }") unless defined(&CPU_FTRS_ALWAYS);
	    }
	    eval 'sub cpu_has_feature {
	        my($feature) = @_;
    		eval q({ ( &CPU_FTRS_ALWAYS & $feature) || ( &CPU_FTRS_POSSIBLE &  ($cur_cpu_spec->{cpu_features})  & $feature); });
	    }' unless defined(&cpu_has_feature);
	}
	if(defined(&__ASSEMBLY__)) {
	    eval 'sub BEGIN_FTR_SECTION () {98:;}' unless defined(&BEGIN_FTR_SECTION);
	    unless(defined(&__powerpc64__)) {
		eval 'sub END_FTR_SECTION {
		    my($msk, $val) = @_;
    		    eval q(99: . &section  &__ftr_fixup,\\"a\\"; . &align 2; .\'long msk\'; .\'long val\'; .\'long 98b\'; .\'long 99b\'; . &previous);
		}' unless defined(&END_FTR_SECTION);
	    } else {
		eval 'sub END_FTR_SECTION {
		    my($msk, $val) = @_;
    		    eval q(99: . &section  &__ftr_fixup,\\"a\\"; . &align 3; .\'llong msk\'; .\'llong val\'; .\'llong 98b\'; .\'llong 99b\'; . &previous);
		}' unless defined(&END_FTR_SECTION);
	    }
	    eval 'sub END_FTR_SECTION_IFSET {
	        my($msk) = @_;
    		eval q( &END_FTR_SECTION(($msk), ($msk)));
	    }' unless defined(&END_FTR_SECTION_IFSET);
	    eval 'sub END_FTR_SECTION_IFCLR {
	        my($msk) = @_;
    		eval q( &END_FTR_SECTION(($msk), 0));
	    }' unless defined(&END_FTR_SECTION_IFCLR);
	}
    }
}
1;
