require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_DMA_MAPPING_H)) {
    eval 'sub _ASM_DMA_MAPPING_H () {1;}' unless defined(&_ASM_DMA_MAPPING_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/types.ph';
	require 'linux/cache.ph';
	require 'linux/mm.ph';
	require 'asm/scatterlist.ph';
	require 'asm/io.ph';
	eval 'sub DMA_ERROR_CODE () {(~( &dma_addr_t)0x);}' unless defined(&DMA_ERROR_CODE);
	if(defined(&CONFIG_NOT_COHERENT_CACHE)) {
	} else {
	    eval 'sub __dma_alloc_coherent {
	        my($gfp, $size, $handle) = @_;
    		eval q( &NULL);
	    }' unless defined(&__dma_alloc_coherent);
	    eval 'sub __dma_free_coherent {
	        my($size, $addr) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&__dma_free_coherent);
	    eval 'sub __dma_sync {
	        my($addr, $size, $rw) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&__dma_sync);
	    eval 'sub __dma_sync_page {
	        my($pg, $off, $sz, $rw) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&__dma_sync_page);
	}
	if(defined(&CONFIG_PPC64)) {
	} else {
	    eval 'sub dma_supported {
	        my($dev, $mask) = @_;
    		eval q((1));
	    }' unless defined(&dma_supported);
	    eval 'sub dma_set_mask {
	        my($dev,$dma_mask) = @_;
    		eval q({  &if (! ($dev->{dma_mask}) || ! &dma_supported($dev,  &mask)) - &EIO; * ($dev->{dma_mask}) = $dma_mask; 0; });
	    }' unless defined(&dma_set_mask);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub void {
	        eval q(* &dma_alloc_coherent(\'struct device\' * &dev, \'size_t\'  &size,  &dma_addr_t *  &dma_handle,  &gfp_t  &gfp) { });
	    }' unless defined(&void);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub dma_free_coherent {
	        my($dev,$size,$vaddr,$dma_handle) = @_;
    		eval q({ });
	    }' unless defined(&dma_free_coherent);
	    eval 'sub dma_map_single {
	        my($dev,$ptr,$size,$direction) = @_;
    		eval q({  &BUG_ON($direction ==  &DMA_NONE);  &__dma_sync($ptr, $size, $direction);  &virt_to_bus($ptr); });
	    }' unless defined(&dma_map_single);
	    eval 'sub dma_unmap_single {
	        my($dev, $addr, $size, $dir) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_unmap_single);
	    eval 'sub dma_map_page {
	        my($dev,$page,$offset,$size,$direction) = @_;
    		eval q({  &BUG_ON($direction ==  &DMA_NONE);  &__dma_sync_page($page, $offset, $size, $direction);  &page_to_bus($page) + $offset; });
	    }' unless defined(&dma_map_page);
	    eval 'sub dma_unmap_page {
	        my($dev, $handle, $size, $dir) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_unmap_page);
	    eval 'sub dma_map_sg {
	        my($dev,$sg,$nents,$direction) = @_;
    		eval q({ \'int\'  &i;  &BUG_ON($direction ==  &DMA_NONE);  &for ( &i = 0;  &i < $nents;  &i++, $sg++) {  &BUG_ON(! ($sg->{page}));  &__dma_sync_page( ($sg->{page}),  ($sg->{offset}),  ($sg->{length}), $direction);  ($sg->{dma_address}) =  &page_to_bus( ($sg->{page})) +  ($sg->{offset}); } $nents; });
	    }' unless defined(&dma_map_sg);
	    eval 'sub dma_unmap_sg {
	        my($dev, $sg, $nents, $dir) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_unmap_sg);
	}
	eval 'sub dma_sync_single_for_cpu {
	    my($dev,$dma_handle,$size,$direction) = @_;
    	    eval q({  &BUG_ON($direction ==  &DMA_NONE);  &__dma_sync( &bus_to_virt($dma_handle), $size, $direction); });
	}' unless defined(&dma_sync_single_for_cpu);
	eval 'sub dma_sync_single_for_device {
	    my($dev,$dma_handle,$size,$direction) = @_;
    	    eval q({  &BUG_ON($direction ==  &DMA_NONE);  &__dma_sync( &bus_to_virt($dma_handle), $size, $direction); });
	}' unless defined(&dma_sync_single_for_device);
	eval 'sub dma_sync_sg_for_cpu {
	    my($dev,$sg,$nents,$direction) = @_;
    	    eval q({ \'int\'  &i;  &BUG_ON($direction ==  &DMA_NONE);  &for ( &i = 0;  &i < $nents;  &i++, $sg++)  &__dma_sync_page( ($sg->{page}),  ($sg->{offset}),  ($sg->{length}), $direction); });
	}' unless defined(&dma_sync_sg_for_cpu);
	eval 'sub dma_sync_sg_for_device {
	    my($dev,$sg,$nents,$direction) = @_;
    	    eval q({ \'int\'  &i;  &BUG_ON($direction ==  &DMA_NONE);  &for ( &i = 0;  &i < $nents;  &i++, $sg++)  &__dma_sync_page( ($sg->{page}),  ($sg->{offset}),  ($sg->{length}), $direction); });
	}' unless defined(&dma_sync_sg_for_device);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub dma_mapping_error {
	    my($dma_addr) = @_;
    	    eval q({ });
	}' unless defined(&dma_mapping_error);
	eval 'sub dma_alloc_noncoherent {
	    my($d, $s, $h, $f) = @_;
    	    eval q( &dma_alloc_coherent($d, $s, $h, $f));
	}' unless defined(&dma_alloc_noncoherent);
	eval 'sub dma_free_noncoherent {
	    my($d, $s, $v, $h) = @_;
    	    eval q( &dma_free_coherent($d, $s, $v, $h));
	}' unless defined(&dma_free_noncoherent);
	if(defined(&CONFIG_NOT_COHERENT_CACHE)) {
	    eval 'sub dma_is_consistent {
	        my($d) = @_;
    		eval q((0));
	    }' unless defined(&dma_is_consistent);
	} else {
	    eval 'sub dma_is_consistent {
	        my($d) = @_;
    		eval q((1));
	    }' unless defined(&dma_is_consistent);
	}
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub dma_get_cache_alignment {
	    my($void) = @_;
    	    eval q({ });
	}' unless defined(&dma_get_cache_alignment);
	eval 'sub dma_sync_single_range_for_cpu {
	    my($dev,$dma_handle,$offset,$size,$direction) = @_;
    	    eval q({  &dma_sync_single_for_cpu($dev, $dma_handle, $offset + $size, $direction); });
	}' unless defined(&dma_sync_single_range_for_cpu);
	eval 'sub dma_sync_single_range_for_device {
	    my($dev,$dma_handle,$offset,$size,$direction) = @_;
    	    eval q({  &dma_sync_single_for_device($dev, $dma_handle, $offset + $size, $direction); });
	}' unless defined(&dma_sync_single_range_for_device);
	eval 'sub dma_cache_sync {
	    my($vaddr,$size,$direction) = @_;
    	    eval q({  &BUG_ON($direction ==  &DMA_NONE);  &__dma_sync($vaddr, $size, $direction); });
	}' unless defined(&dma_cache_sync);
    }
}
1;
