require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_DMA_H)) {
    eval 'sub _ASM_POWERPC_DMA_H () {1;}' unless defined(&_ASM_POWERPC_DMA_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'asm/io.ph';
	require 'linux/spinlock.ph';
	require 'asm/system.ph';
	unless(defined(&MAX_DMA_CHANNELS)) {
	    eval 'sub MAX_DMA_CHANNELS () {8;}' unless defined(&MAX_DMA_CHANNELS);
	}
	eval 'sub MAX_DMA_ADDRESS () {(~0);}' unless defined(&MAX_DMA_ADDRESS);
	if(!defined( &CONFIG_PPC_ISERIES) || defined( &CONFIG_PCI)) {
	    if(defined(&HAVE_REALLY_SLOW_DMA_CONTROLLER)) {
		eval 'sub dma_outb () { &outb_p;}' unless defined(&dma_outb);
	    } else {
		eval 'sub dma_outb () { &outb;}' unless defined(&dma_outb);
	    }
	    eval 'sub dma_inb () { &inb;}' unless defined(&dma_inb);
	    if(defined( &CONFIG_SOUND_CS4232)  && defined( &CONFIG_PPC_PREP)) {
		eval 'sub SND_DMA1 () { &ppc_cs4232_dma;}' unless defined(&SND_DMA1);
		eval 'sub SND_DMA2 () { &ppc_cs4232_dma2;}' unless defined(&SND_DMA2);
	    } else {
		eval 'sub SND_DMA1 () {-1;}' unless defined(&SND_DMA1);
		eval 'sub SND_DMA2 () {-1;}' unless defined(&SND_DMA2);
	    }
	    eval 'sub IO_DMA1_BASE () {0x;}' unless defined(&IO_DMA1_BASE);
	    eval 'sub IO_DMA2_BASE () {0xc0;}' unless defined(&IO_DMA2_BASE);
	    eval 'sub DMA1_CMD_REG () {0x8;}' unless defined(&DMA1_CMD_REG);
	    eval 'sub DMA1_STAT_REG () {0x8;}' unless defined(&DMA1_STAT_REG);
	    eval 'sub DMA1_REQ_REG () {0x9;}' unless defined(&DMA1_REQ_REG);
	    eval 'sub DMA1_MASK_REG () {0xa;}' unless defined(&DMA1_MASK_REG);
	    eval 'sub DMA1_MODE_REG () {0xb;}' unless defined(&DMA1_MODE_REG);
	    eval 'sub DMA1_CLEAR_FF_REG () {0xc;}' unless defined(&DMA1_CLEAR_FF_REG);
	    eval 'sub DMA1_TEMP_REG () {0xd;}' unless defined(&DMA1_TEMP_REG);
	    eval 'sub DMA1_RESET_REG () {0xd;}' unless defined(&DMA1_RESET_REG);
	    eval 'sub DMA1_CLR_MASK_REG () {0xe;}' unless defined(&DMA1_CLR_MASK_REG);
	    eval 'sub DMA1_MASK_ALL_REG () {0xf;}' unless defined(&DMA1_MASK_ALL_REG);
	    eval 'sub DMA2_CMD_REG () {0xd0;}' unless defined(&DMA2_CMD_REG);
	    eval 'sub DMA2_STAT_REG () {0xd0;}' unless defined(&DMA2_STAT_REG);
	    eval 'sub DMA2_REQ_REG () {0xd2;}' unless defined(&DMA2_REQ_REG);
	    eval 'sub DMA2_MASK_REG () {0xd4;}' unless defined(&DMA2_MASK_REG);
	    eval 'sub DMA2_MODE_REG () {0xd6;}' unless defined(&DMA2_MODE_REG);
	    eval 'sub DMA2_CLEAR_FF_REG () {0xd8;}' unless defined(&DMA2_CLEAR_FF_REG);
	    eval 'sub DMA2_TEMP_REG () {0xda;}' unless defined(&DMA2_TEMP_REG);
	    eval 'sub DMA2_RESET_REG () {0xda;}' unless defined(&DMA2_RESET_REG);
	    eval 'sub DMA2_CLR_MASK_REG () {0xdc;}' unless defined(&DMA2_CLR_MASK_REG);
	    eval 'sub DMA2_MASK_ALL_REG () {0xde;}' unless defined(&DMA2_MASK_ALL_REG);
	    eval 'sub DMA_ADDR_0 () {0x;}' unless defined(&DMA_ADDR_0);
	    eval 'sub DMA_ADDR_1 () {0x2;}' unless defined(&DMA_ADDR_1);
	    eval 'sub DMA_ADDR_2 () {0x4;}' unless defined(&DMA_ADDR_2);
	    eval 'sub DMA_ADDR_3 () {0x6;}' unless defined(&DMA_ADDR_3);
	    eval 'sub DMA_ADDR_4 () {0xc0;}' unless defined(&DMA_ADDR_4);
	    eval 'sub DMA_ADDR_5 () {0xc4;}' unless defined(&DMA_ADDR_5);
	    eval 'sub DMA_ADDR_6 () {0xc8;}' unless defined(&DMA_ADDR_6);
	    eval 'sub DMA_ADDR_7 () {0xcc;}' unless defined(&DMA_ADDR_7);
	    eval 'sub DMA_CNT_0 () {0x1;}' unless defined(&DMA_CNT_0);
	    eval 'sub DMA_CNT_1 () {0x3;}' unless defined(&DMA_CNT_1);
	    eval 'sub DMA_CNT_2 () {0x5;}' unless defined(&DMA_CNT_2);
	    eval 'sub DMA_CNT_3 () {0x7;}' unless defined(&DMA_CNT_3);
	    eval 'sub DMA_CNT_4 () {0xc2;}' unless defined(&DMA_CNT_4);
	    eval 'sub DMA_CNT_5 () {0xc6;}' unless defined(&DMA_CNT_5);
	    eval 'sub DMA_CNT_6 () {0xca;}' unless defined(&DMA_CNT_6);
	    eval 'sub DMA_CNT_7 () {0xce;}' unless defined(&DMA_CNT_7);
	    eval 'sub DMA_LO_PAGE_0 () {0x87;}' unless defined(&DMA_LO_PAGE_0);
	    eval 'sub DMA_LO_PAGE_1 () {0x83;}' unless defined(&DMA_LO_PAGE_1);
	    eval 'sub DMA_LO_PAGE_2 () {0x81;}' unless defined(&DMA_LO_PAGE_2);
	    eval 'sub DMA_LO_PAGE_3 () {0x82;}' unless defined(&DMA_LO_PAGE_3);
	    eval 'sub DMA_LO_PAGE_5 () {0x8b;}' unless defined(&DMA_LO_PAGE_5);
	    eval 'sub DMA_LO_PAGE_6 () {0x89;}' unless defined(&DMA_LO_PAGE_6);
	    eval 'sub DMA_LO_PAGE_7 () {0x8a;}' unless defined(&DMA_LO_PAGE_7);
	    eval 'sub DMA_HI_PAGE_0 () {0x487;}' unless defined(&DMA_HI_PAGE_0);
	    eval 'sub DMA_HI_PAGE_1 () {0x483;}' unless defined(&DMA_HI_PAGE_1);
	    eval 'sub DMA_HI_PAGE_2 () {0x481;}' unless defined(&DMA_HI_PAGE_2);
	    eval 'sub DMA_HI_PAGE_3 () {0x482;}' unless defined(&DMA_HI_PAGE_3);
	    eval 'sub DMA_HI_PAGE_5 () {0x48b;}' unless defined(&DMA_HI_PAGE_5);
	    eval 'sub DMA_HI_PAGE_6 () {0x489;}' unless defined(&DMA_HI_PAGE_6);
	    eval 'sub DMA_HI_PAGE_7 () {0x48a;}' unless defined(&DMA_HI_PAGE_7);
	    eval 'sub DMA1_EXT_REG () {0x40b;}' unless defined(&DMA1_EXT_REG);
	    eval 'sub DMA2_EXT_REG () {0x4d6;}' unless defined(&DMA2_EXT_REG);
	    unless(defined(&__powerpc64__)) {
	    } else {
		eval 'sub DMA_MODE_READ () {0x44;}' unless defined(&DMA_MODE_READ);
		eval 'sub DMA_MODE_WRITE () {0x48;}' unless defined(&DMA_MODE_WRITE);
	    }
	    eval 'sub DMA_MODE_CASCADE () {0xc0;}' unless defined(&DMA_MODE_CASCADE);
	    eval 'sub DMA_AUTOINIT () {0x10;}' unless defined(&DMA_AUTOINIT);
	    eval 'sub claim_dma_lock {
	        my($void) = @_;
    		eval q({ my $flags;  &spin_lock_irqsave( &dma_spin_lock,  $flags);  $flags; });
	    }' unless defined(&claim_dma_lock);
	    eval 'sub release_dma_lock {
	        my($flags) = @_;
    		eval q({  &spin_unlock_irqrestore( &dma_spin_lock, $flags); });
	    }' unless defined(&release_dma_lock);
	    eval 'sub disable_dma {
	        my($dmanr) = @_;
    		eval q({  &if ($dmanr <= 3)  &dma_outb($dmanr | 4,  &DMA1_MASK_REG);  &else  &dma_outb(($dmanr & 3) | 4,  &DMA2_MASK_REG); });
	    }' unless defined(&disable_dma);
	    if(defined(&CONFIG_PCI)) {
	    } else {
		eval 'sub isa_dma_bridge_buggy () {(0);}' unless defined(&isa_dma_bridge_buggy);
	    }
	}
    }
}
1;
