require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_PPC64_EEH_H)) {
    eval 'sub _PPC64_EEH_H () {1;}' unless defined(&_PPC64_EEH_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/init.ph';
	require 'linux/list.ph';
	require 'linux/string.ph';
	if(defined(&CONFIG_EEH)) {
	    eval 'sub EEH_MODE_SUPPORTED () {(1<<0);}' unless defined(&EEH_MODE_SUPPORTED);
	    eval 'sub EEH_MODE_NOCHECK () {(1<<1);}' unless defined(&EEH_MODE_NOCHECK);
	    eval 'sub EEH_MODE_ISOLATED () {(1<<2);}' unless defined(&EEH_MODE_ISOLATED);
	    eval 'sub EEH_MODE_RECOVERING () {(1<<3);}' unless defined(&EEH_MODE_RECOVERING);
	    eval 'sub EEH_MODE_IRQ_DISABLED () {(1<<4);}' unless defined(&EEH_MODE_IRQ_DISABLED);
	    eval 'sub EEH_MAX_ALLOWED_FREEZES () {5;}' unless defined(&EEH_MAX_ALLOWED_FREEZES);
	    eval 'sub EEH_POSSIBLE_ERROR {
	        my($val, $type) = @_;
    		eval q((($val) == ($type)~0 &&  &eeh_subsystem_enabled));
	    }' unless defined(&EEH_POSSIBLE_ERROR);
	    eval 'sub EEH_IO_ERROR_VALUE {
	        my($size) = @_;
    		eval q((~0 >> ((4- ($size)) * 8)));
	    }' unless defined(&EEH_IO_ERROR_VALUE);
	} else {
	    eval 'sub eeh_check_failure {
	        my($token,$val) = @_;
    		eval q({ $val; });
	    }' unless defined(&eeh_check_failure);
	    eval 'sub eeh_dn_check_failure {
	        my($dn,$dev) = @_;
    		eval q({ 0; });
	    }' unless defined(&eeh_dn_check_failure);
	    eval 'sub EEH_POSSIBLE_ERROR {
	        my($val, $type) = @_;
    		eval q((0));
	    }' unless defined(&EEH_POSSIBLE_ERROR);
	    eval 'sub EEH_IO_ERROR_VALUE {
	        my($size) = @_;
    		eval q((-1));
	    }' unless defined(&EEH_IO_ERROR_VALUE);
	}
	eval 'sub eeh_writeb {
	    my($val,$addr) = @_;
    	    eval q({  &out_8($addr, $val); });
	}' unless defined(&eeh_writeb);
	eval 'sub eeh_readw {
	    my($addr) = @_;
    	    eval q({  &__u16  &val =  &in_le16($addr);  &if ( &EEH_POSSIBLE_ERROR( &val,  &__u16))  &eeh_check_failure($addr,  &val);  &val; });
	}' unless defined(&eeh_readw);
	eval 'sub eeh_writew {
	    my($val,$addr) = @_;
    	    eval q({  &out_le16($addr, $val); });
	}' unless defined(&eeh_writew);
	eval 'sub eeh_raw_readw {
	    my($addr) = @_;
    	    eval q({  &__u16  &val =  &in_be16($addr);  &if ( &EEH_POSSIBLE_ERROR( &val,  &__u16))  &eeh_check_failure($addr,  &val);  &val; });
	}' unless defined(&eeh_raw_readw);
	eval 'sub eeh_raw_writew {
	    my($val,$addr) = @_;
    	    eval q({  &volatile  &__u16  &__iomem * &vaddr = ( &volatile  &__u16  &__iomem *) $addr;  &out_be16( &vaddr, $val); });
	}' unless defined(&eeh_raw_writew);
	eval 'sub eeh_readl {
	    my($addr) = @_;
    	    eval q({  &__u32  &val =  &in_le32($addr);  &if ( &EEH_POSSIBLE_ERROR( &val,  &__u32))  &eeh_check_failure($addr,  &val);  &val; });
	}' unless defined(&eeh_readl);
	eval 'sub eeh_writel {
	    my($val,$addr) = @_;
    	    eval q({  &out_le32($addr, $val); });
	}' unless defined(&eeh_writel);
	eval 'sub eeh_raw_readl {
	    my($addr) = @_;
    	    eval q({  &__u32  &val =  &in_be32($addr);  &if ( &EEH_POSSIBLE_ERROR( &val,  &__u32))  &eeh_check_failure($addr,  &val);  &val; });
	}' unless defined(&eeh_raw_readl);
	eval 'sub eeh_raw_writel {
	    my($val,$addr) = @_;
    	    eval q({  &out_be32($addr, $val); });
	}' unless defined(&eeh_raw_writel);
	eval 'sub eeh_readq {
	    my($addr) = @_;
    	    eval q({  &__u64  &val =  &in_le64($addr);  &if ( &EEH_POSSIBLE_ERROR( &val,  &__u64))  &eeh_check_failure($addr,  &val);  &val; });
	}' unless defined(&eeh_readq);
	eval 'sub eeh_writeq {
	    my($val,$addr) = @_;
    	    eval q({  &out_le64($addr, $val); });
	}' unless defined(&eeh_writeq);
	eval 'sub eeh_raw_readq {
	    my($addr) = @_;
    	    eval q({  &__u64  &val =  &in_be64($addr);  &if ( &EEH_POSSIBLE_ERROR( &val,  &__u64))  &eeh_check_failure($addr,  &val);  &val; });
	}' unless defined(&eeh_raw_readq);
	eval 'sub eeh_raw_writeq {
	    my($val,$addr) = @_;
    	    eval q({  &out_be64($addr, $val); });
	}' unless defined(&eeh_raw_writeq);
	eval 'sub EEH_CHECK_ALIGN {
	    my($v,$a) = @_;
    	    eval q((((($v)) & (($a) - 1)) == 0));
	}' unless defined(&EEH_CHECK_ALIGN);
	eval 'sub eeh_memset_io {
	    my($addr,$c,$n) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&eeh_memset_io);
	eval 'sub eeh_memcpy_fromio {
	    my($dest,$src,$n) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&eeh_memcpy_fromio);
	eval 'sub eeh_memcpy_toio {
	    my($dest,$src,$n) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&eeh_memcpy_toio);
	undef(&EEH_CHECK_ALIGN) if defined(&EEH_CHECK_ALIGN);
	eval 'sub eeh_inb {
	    my($port) = @_;
    	    eval q({  &__u8  &val;  &if (! &_IO_IS_VALID($port)) ~0;  &val =  &in_8(( &__u8  &__iomem *)($port+ &pci_io_base));  &if ( &EEH_POSSIBLE_ERROR( &val,  &__u8))  &eeh_check_failure(( &void  &__iomem *)($port),  &val);  &val; });
	}' unless defined(&eeh_inb);
	eval 'sub eeh_outb {
	    my($val,$port) = @_;
    	    eval q({  &if ( &_IO_IS_VALID($port))  &out_8(( &__u8  &__iomem *)($port+ &pci_io_base), $val); });
	}' unless defined(&eeh_outb);
	eval 'sub eeh_inw {
	    my($port) = @_;
    	    eval q({  &__u16  &val;  &if (! &_IO_IS_VALID($port)) ~0;  &val =  &in_le16(( &__u16  &__iomem *)($port+ &pci_io_base));  &if ( &EEH_POSSIBLE_ERROR( &val,  &__u16))  &eeh_check_failure(( &void  &__iomem *)($port),  &val);  &val; });
	}' unless defined(&eeh_inw);
	eval 'sub eeh_outw {
	    my($val,$port) = @_;
    	    eval q({  &if ( &_IO_IS_VALID($port))  &out_le16(( &__u16  &__iomem *)($port+ &pci_io_base), $val); });
	}' unless defined(&eeh_outw);
	eval 'sub eeh_inl {
	    my($port) = @_;
    	    eval q({  &__u32  &val;  &if (! &_IO_IS_VALID($port)) ~0;  &val =  &in_le32(( &__u32  &__iomem *)($port+ &pci_io_base));  &if ( &EEH_POSSIBLE_ERROR( &val,  &__u32))  &eeh_check_failure(( &void  &__iomem *)($port),  &val);  &val; });
	}' unless defined(&eeh_inl);
	eval 'sub eeh_outl {
	    my($val,$port) = @_;
    	    eval q({  &if ( &_IO_IS_VALID($port))  &out_le32(( &__u32  &__iomem *)($port+ &pci_io_base), $val); });
	}' unless defined(&eeh_outl);
	eval 'sub eeh_insw_ns {
	    my($port,$buf,$ns) = @_;
    	    eval q({  &_insw_ns(( &__u16  &__iomem *)($port+ &pci_io_base), $buf, $ns);  &if ( &EEH_POSSIBLE_ERROR((*((( &__u16*)$buf)+$ns-1)),  &__u16))  &eeh_check_failure(( &void  &__iomem *)($port), *( &__u16*)$buf); });
	}' unless defined(&eeh_insw_ns);
	eval 'sub eeh_insl_ns {
	    my($port,$buf,$nl) = @_;
    	    eval q({  &_insl_ns(( &__u32  &__iomem *)($port+ &pci_io_base), $buf, $nl);  &if ( &EEH_POSSIBLE_ERROR((*((( &__u32*)$buf)+$nl-1)),  &__u32))  &eeh_check_failure(( &void  &__iomem *)($port), *( &__u32*)$buf); });
	}' unless defined(&eeh_insl_ns);
    }
}
1;
