require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_POWERPC_FLOPPY_H)) {
    eval 'sub __ASM_POWERPC_FLOPPY_H () {1;}' unless defined(&__ASM_POWERPC_FLOPPY_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'asm/machdep.ph';
	eval 'sub fd_inb {
	    my($port) = @_;
    	    eval q( &inb_p($port));
	}' unless defined(&fd_inb);
	eval 'sub fd_outb {
	    my($value,$port) = @_;
    	    eval q( &outb_p($value,$port));
	}' unless defined(&fd_outb);
	eval 'sub fd_enable_dma () {
	    eval q( &enable_dma( &FLOPPY_DMA));
	}' unless defined(&fd_enable_dma);
	eval 'sub fd_disable_dma () {
	    eval q( &disable_dma( &FLOPPY_DMA));
	}' unless defined(&fd_disable_dma);
	eval 'sub fd_request_dma () {
	    eval q( &request_dma( &FLOPPY_DMA, \\"floppy\\"));
	}' unless defined(&fd_request_dma);
	eval 'sub fd_free_dma () {
	    eval q( &free_dma( &FLOPPY_DMA));
	}' unless defined(&fd_free_dma);
	eval 'sub fd_clear_dma_ff () {
	    eval q( &clear_dma_ff( &FLOPPY_DMA));
	}' unless defined(&fd_clear_dma_ff);
	eval 'sub fd_set_dma_mode {
	    my($mode) = @_;
    	    eval q( &set_dma_mode( &FLOPPY_DMA, $mode));
	}' unless defined(&fd_set_dma_mode);
	eval 'sub fd_set_dma_count {
	    my($count) = @_;
    	    eval q( &set_dma_count( &FLOPPY_DMA, $count));
	}' unless defined(&fd_set_dma_count);
	eval 'sub fd_enable_irq () {
	    eval q( &enable_irq( &FLOPPY_IRQ));
	}' unless defined(&fd_enable_irq);
	eval 'sub fd_disable_irq () {
	    eval q( &disable_irq( &FLOPPY_IRQ));
	}' unless defined(&fd_disable_irq);
	eval 'sub fd_cacheflush {
	    my($addr,$size) = @_;
    	    eval q();
	}' unless defined(&fd_cacheflush);
	eval 'sub fd_request_irq () {
	    eval q( &request_irq( &FLOPPY_IRQ,  &floppy_interrupt,  &SA_INTERRUPT| &SA_SAMPLE_RANDOM, \\"floppy\\",  &NULL));
	}' unless defined(&fd_request_irq);
	eval 'sub fd_free_irq () {
	    eval q( &free_irq( &FLOPPY_IRQ,  &NULL););
	}' unless defined(&fd_free_irq);
	if(defined(&CONFIG_PCI)) {
	    require 'linux/pci.ph';
	    require 'asm/ppc-pci.ph';
	    eval 'sub fd_dma_setup {
	        my($addr,$size,$mode,$io) = @_;
    		eval q( &powerpc_fd_dma_setup($addr,$size,$mode,$io));
	    }' unless defined(&fd_dma_setup);
	    eval 'sub powerpc_fd_dma_setup {
	        my($addr,$size,$mode,$io) = @_;
    		eval q({ my $prev_size;  &dma_addr_t  &bus_addr = 0; \'char\' * &prev_addr; \'int\'  &prev_dir; \'int\'  &dir;  &dir = ($mode ==  &DMA_MODE_READ) ?  &PCI_DMA_FROMDEVICE :  &PCI_DMA_TODEVICE;  &if ( &bus_addr  && ($addr !=  &prev_addr || $size !=  $prev_size ||  &dir !=  &prev_dir)) {  &pci_unmap_single( &ppc64_isabridge_dev,  &bus_addr,  $prev_size,  &prev_dir);  &bus_addr = 0; }  &if (! &bus_addr)  &bus_addr =  &pci_map_single( &ppc64_isabridge_dev, $addr, $size,  &dir);  &prev_addr = $addr;  $prev_size = $size;  &prev_dir =  &dir;  &fd_clear_dma_ff();  &fd_cacheflush($addr, $size);  &fd_set_dma_mode($mode);  &set_dma_addr( &FLOPPY_DMA,  &bus_addr);  &fd_set_dma_count($size);  &virtual_dma_port = $io;  &fd_enable_dma(); 0; });
	    }' unless defined(&powerpc_fd_dma_setup);
	}
	eval 'sub FLOPPY0_TYPE () {6;}' unless defined(&FLOPPY0_TYPE);
	eval 'sub FLOPPY1_TYPE () {0;}' unless defined(&FLOPPY1_TYPE);
	eval 'sub N_FDC () {2;}' unless defined(&N_FDC);
	eval 'sub N_DRIVE () {8;}' unless defined(&N_DRIVE);
	eval 'sub FLOPPY_MOTOR_MASK () {0xf0;}' unless defined(&FLOPPY_MOTOR_MASK);
	eval 'sub CROSS_64KB {
	    my($a,$s) = @_;
    	    eval q((0));
	}' unless defined(&CROSS_64KB);
	eval 'sub EXTRA_FLOPPY_PARAMS () {1;}' unless defined(&EXTRA_FLOPPY_PARAMS);
    }
}
1;
