require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_IO_H)) {
    eval 'sub _ASM_POWERPC_IO_H () {1;}' unless defined(&_ASM_POWERPC_IO_H);
    if(defined(&__KERNEL__)) {
	unless(defined(&CONFIG_PPC64)) {
	    require 'asm-ppc/io.ph';
	} else {
	    require 'linux/compiler.ph';
	    require 'asm/page.ph';
	    require 'asm/byteorder.ph';
	    if(defined(&CONFIG_PPC_ISERIES)) {
		require 'asm/iseries/iseries_io.ph';
	    }
	    require 'asm/synch.ph';
	    require 'asm/delay.ph';
	    require 'asm-generic/iomap.ph';
	    eval 'sub __ide_mm_insw {
	        my($p, $a, $c) = @_;
    		eval q( &_insw_ns(( &volatile  &__u16  &__iomem *)($p), ($a), ($c)));
	    }' unless defined(&__ide_mm_insw);
	    eval 'sub __ide_mm_insl {
	        my($p, $a, $c) = @_;
    		eval q( &_insl_ns(( &volatile  &__u32  &__iomem *)($p), ($a), ($c)));
	    }' unless defined(&__ide_mm_insl);
	    eval 'sub __ide_mm_outsw {
	        my($p, $a, $c) = @_;
    		eval q( &_outsw_ns(( &volatile  &__u16  &__iomem *)($p), ($a), ($c)));
	    }' unless defined(&__ide_mm_outsw);
	    eval 'sub __ide_mm_outsl {
	        my($p, $a, $c) = @_;
    		eval q( &_outsl_ns(( &volatile  &__u32  &__iomem *)($p), ($a), ($c)));
	    }' unless defined(&__ide_mm_outsl);
	    eval 'sub SIO_CONFIG_RA () {0x398;}' unless defined(&SIO_CONFIG_RA);
	    eval 'sub SIO_CONFIG_RD () {0x399;}' unless defined(&SIO_CONFIG_RD);
	    eval 'sub SLOW_DOWN_IO () {1;}' unless defined(&SLOW_DOWN_IO);
	    eval 'sub MAX_ISA_PORT () {0x10000;}' unless defined(&MAX_ISA_PORT);
	    eval 'sub _IO_IS_VALID {
	        my($port) = @_;
    		eval q((($port) >=  &MAX_ISA_PORT || (1<< ($port>> &PAGE_SHIFT)) &  &io_page_mask));
	    }' unless defined(&_IO_IS_VALID);
	    if(defined(&CONFIG_PPC_ISERIES)) {
		eval 'sub __raw_readb {
		    my($addr) = @_;
    		    eval q({  &BUG(); 0; });
		}' unless defined(&__raw_readb);
		eval 'sub __raw_readw {
		    my($addr) = @_;
    		    eval q({  &BUG(); 0; });
		}' unless defined(&__raw_readw);
		eval 'sub __raw_readl {
		    my($addr) = @_;
    		    eval q({  &BUG(); 0; });
		}' unless defined(&__raw_readl);
		eval 'sub __raw_readq {
		    my($addr) = @_;
    		    eval q({  &BUG(); 0; });
		}' unless defined(&__raw_readq);
		eval 'sub __raw_writeb {
		    my($v, $addr) = @_;
    		    eval q({  &BUG(); 0; });
		}' unless defined(&__raw_writeb);
		eval 'sub __raw_writew {
		    my($v, $addr) = @_;
    		    eval q({  &BUG(); 0; });
		}' unless defined(&__raw_writew);
		eval 'sub __raw_writel {
		    my($v, $addr) = @_;
    		    eval q({  &BUG(); 0; });
		}' unless defined(&__raw_writel);
		eval 'sub __raw_writeq {
		    my($v, $addr) = @_;
    		    eval q({  &BUG(); 0; });
		}' unless defined(&__raw_writeq);
		eval 'sub readb {
		    my($addr) = @_;
    		    eval q( &iSeries_Read_Byte($addr));
		}' unless defined(&readb);
		eval 'sub readw {
		    my($addr) = @_;
    		    eval q( &iSeries_Read_Word($addr));
		}' unless defined(&readw);
		eval 'sub readl {
		    my($addr) = @_;
    		    eval q( &iSeries_Read_Long($addr));
		}' unless defined(&readl);
		eval 'sub writeb {
		    my($data, $addr) = @_;
    		    eval q( &iSeries_Write_Byte(($data),($addr)));
		}' unless defined(&writeb);
		eval 'sub writew {
		    my($data, $addr) = @_;
    		    eval q( &iSeries_Write_Word(($data),($addr)));
		}' unless defined(&writew);
		eval 'sub writel {
		    my($data, $addr) = @_;
    		    eval q( &iSeries_Write_Long(($data),($addr)));
		}' unless defined(&writel);
		eval 'sub memset_io {
		    my($a,$b,$c) = @_;
    		    eval q( &iSeries_memset_io(($a),($b),($c)));
		}' unless defined(&memset_io);
		eval 'sub memcpy_fromio {
		    my($a,$b,$c) = @_;
    		    eval q( &iSeries_memcpy_fromio(($a), ($b), ($c)));
		}' unless defined(&memcpy_fromio);
		eval 'sub memcpy_toio {
		    my($a,$b,$c) = @_;
    		    eval q( &iSeries_memcpy_toio(($a), ($b), ($c)));
		}' unless defined(&memcpy_toio);
		eval 'sub inb {
		    my($addr) = @_;
    		    eval q( &readb((( &void  &__iomem *)($addr))));
		}' unless defined(&inb);
		eval 'sub inw {
		    my($addr) = @_;
    		    eval q( &readw((( &void  &__iomem *)($addr))));
		}' unless defined(&inw);
		eval 'sub inl {
		    my($addr) = @_;
    		    eval q( &readl((( &void  &__iomem *)($addr))));
		}' unless defined(&inl);
		eval 'sub outb {
		    my($data,$addr) = @_;
    		    eval q( &writeb($data,(( &void  &__iomem *)($addr))));
		}' unless defined(&outb);
		eval 'sub outw {
		    my($data,$addr) = @_;
    		    eval q( &writew($data,(( &void  &__iomem *)($addr))));
		}' unless defined(&outw);
		eval 'sub outl {
		    my($data,$addr) = @_;
    		    eval q( &writel($data,(( &void  &__iomem *)($addr))));
		}' unless defined(&outl);
		eval 'sub insw_ns {
		    my($port, $buf, $ns) = @_;
    		    eval q( &_insw_ns(( &__u16  &__iomem *)(($port)+ &pci_io_base), ($buf), ($ns)));
		}' unless defined(&insw_ns);
		eval 'sub insl_ns {
		    my($port, $buf, $nl) = @_;
    		    eval q( &_insl_ns(( &__u32  &__iomem *)(($port)+ &pci_io_base), ($buf), ($nl)));
		}' unless defined(&insl_ns);
	    } else {
		eval 'sub __raw_readb {
		    my($addr) = @_;
    		    eval q({ *( &volatile my $__force *)$addr; });
		}' unless defined(&__raw_readb);
		eval 'sub __raw_readw {
		    my($addr) = @_;
    		    eval q({ *( &volatile my $__force *)$addr; });
		}' unless defined(&__raw_readw);
		eval 'sub __raw_readl {
		    my($addr) = @_;
    		    eval q({ *( &volatile my $__force *)$addr; });
		}' unless defined(&__raw_readl);
		eval 'sub __raw_readq {
		    my($addr) = @_;
    		    eval q({ *( &volatile my $__force *)$addr; });
		}' unless defined(&__raw_readq);
		eval 'sub __raw_writeb {
		    my($v,$addr) = @_;
    		    eval q({ *( &volatile my $__force *)$addr = $v; });
		}' unless defined(&__raw_writeb);
		eval 'sub __raw_writew {
		    my($v,$addr) = @_;
    		    eval q({ *( &volatile my $__force *)$addr = $v; });
		}' unless defined(&__raw_writew);
		eval 'sub __raw_writel {
		    my($v,$addr) = @_;
    		    eval q({ *( &volatile my $__force *)$addr = $v; });
		}' unless defined(&__raw_writel);
		eval 'sub __raw_writeq {
		    my($v,$addr) = @_;
    		    eval q({ *( &volatile my $__force *)$addr = $v; });
		}' unless defined(&__raw_writeq);
		eval 'sub readb {
		    my($addr) = @_;
    		    eval q( &eeh_readb($addr));
		}' unless defined(&readb);
		eval 'sub readw {
		    my($addr) = @_;
    		    eval q( &eeh_readw($addr));
		}' unless defined(&readw);
		eval 'sub readl {
		    my($addr) = @_;
    		    eval q( &eeh_readl($addr));
		}' unless defined(&readl);
		eval 'sub readq {
		    my($addr) = @_;
    		    eval q( &eeh_readq($addr));
		}' unless defined(&readq);
		eval 'sub writeb {
		    my($data, $addr) = @_;
    		    eval q( &eeh_writeb(($data), ($addr)));
		}' unless defined(&writeb);
		eval 'sub writew {
		    my($data, $addr) = @_;
    		    eval q( &eeh_writew(($data), ($addr)));
		}' unless defined(&writew);
		eval 'sub writel {
		    my($data, $addr) = @_;
    		    eval q( &eeh_writel(($data), ($addr)));
		}' unless defined(&writel);
		eval 'sub writeq {
		    my($data, $addr) = @_;
    		    eval q( &eeh_writeq(($data), ($addr)));
		}' unless defined(&writeq);
		eval 'sub memset_io {
		    my($a,$b,$c) = @_;
    		    eval q( &eeh_memset_io(($a),($b),($c)));
		}' unless defined(&memset_io);
		eval 'sub memcpy_fromio {
		    my($a,$b,$c) = @_;
    		    eval q( &eeh_memcpy_fromio(($a),($b),($c)));
		}' unless defined(&memcpy_fromio);
		eval 'sub memcpy_toio {
		    my($a,$b,$c) = @_;
    		    eval q( &eeh_memcpy_toio(($a),($b),($c)));
		}' unless defined(&memcpy_toio);
		eval 'sub inb {
		    my($port) = @_;
    		    eval q( &eeh_inb($port));
		}' unless defined(&inb);
		eval 'sub outb {
		    my($val, $port) = @_;
    		    eval q( &eeh_outb($val, $port));
		}' unless defined(&outb);
		eval 'sub inw {
		    my($port) = @_;
    		    eval q( &eeh_inw($port));
		}' unless defined(&inw);
		eval 'sub outw {
		    my($val, $port) = @_;
    		    eval q( &eeh_outw($val, $port));
		}' unless defined(&outw);
		eval 'sub inl {
		    my($port) = @_;
    		    eval q( &eeh_inl($port));
		}' unless defined(&inl);
		eval 'sub outl {
		    my($val, $port) = @_;
    		    eval q( &eeh_outl($val, $port));
		}' unless defined(&outl);
		eval 'sub insb {
		    my($port, $buf, $ns) = @_;
    		    eval q( &eeh_insb(($port), ($buf), ($ns)));
		}' unless defined(&insb);
		eval 'sub insw {
		    my($port, $buf, $ns) = @_;
    		    eval q( &eeh_insw_ns(($port), ($buf), ($ns)));
		}' unless defined(&insw);
		eval 'sub insl {
		    my($port, $buf, $nl) = @_;
    		    eval q( &eeh_insl_ns(($port), ($buf), ($nl)));
		}' unless defined(&insl);
		eval 'sub insw_ns {
		    my($port, $buf, $ns) = @_;
    		    eval q( &eeh_insw_ns(($port), ($buf), ($ns)));
		}' unless defined(&insw_ns);
		eval 'sub insl_ns {
		    my($port, $buf, $nl) = @_;
    		    eval q( &eeh_insl_ns(($port), ($buf), ($nl)));
		}' unless defined(&insl_ns);
		eval 'sub outsb {
		    my($port, $buf, $ns) = @_;
    		    eval q( &_outsb(( &__u8  &__iomem *)(($port)+ &pci_io_base), ($buf), ($ns)));
		}' unless defined(&outsb);
		eval 'sub outsw {
		    my($port, $buf, $ns) = @_;
    		    eval q( &_outsw_ns(( &__u16  &__iomem *)(($port)+ &pci_io_base), ($buf), ($ns)));
		}' unless defined(&outsw);
		eval 'sub outsl {
		    my($port, $buf, $nl) = @_;
    		    eval q( &_outsl_ns(( &__u32  &__iomem *)(($port)+ &pci_io_base), ($buf), ($nl)));
		}' unless defined(&outsl);
	    }
	    eval 'sub readb_relaxed {
	        my($addr) = @_;
    		eval q( &readb($addr));
	    }' unless defined(&readb_relaxed);
	    eval 'sub readw_relaxed {
	        my($addr) = @_;
    		eval q( &readw($addr));
	    }' unless defined(&readw_relaxed);
	    eval 'sub readl_relaxed {
	        my($addr) = @_;
    		eval q( &readl($addr));
	    }' unless defined(&readl_relaxed);
	    eval 'sub readq_relaxed {
	        my($addr) = @_;
    		eval q( &readq($addr));
	    }' unless defined(&readq_relaxed);
	    eval 'sub mmiowb () {
	        eval q();
	    }' unless defined(&mmiowb);
	    eval 'sub inb_p {
	        my($port) = @_;
    		eval q( &inb($port));
	    }' unless defined(&inb_p);
	    eval 'sub outb_p {
	        my($val, $port) = @_;
    		eval q(( &udelay(1),  &outb(($val), ($port))));
	    }' unless defined(&outb_p);
	    eval 'sub inw_p {
	        my($port) = @_;
    		eval q( &inw($port));
	    }' unless defined(&inw_p);
	    eval 'sub outw_p {
	        my($val, $port) = @_;
    		eval q(( &udelay(1),  &outw(($val), ($port))));
	    }' unless defined(&outw_p);
	    eval 'sub inl_p {
	        my($port) = @_;
    		eval q( &inl($port));
	    }' unless defined(&inl_p);
	    eval 'sub outl_p {
	        my($val, $port) = @_;
    		eval q(( &udelay(1),  &outl(($val), ($port))));
	    }' unless defined(&outl_p);
	    eval 'sub outsw_ns {
	        my($port, $buf, $ns) = @_;
    		eval q( &_outsw_ns(( &__u16  &__iomem *)(($port)+ &pci_io_base), ($buf), ($ns)));
	    }' unless defined(&outsw_ns);
	    eval 'sub outsl_ns {
	        my($port, $buf, $nl) = @_;
    		eval q( &_outsl_ns(( &__u32  &__iomem *)(($port)+ &pci_io_base), ($buf), ($nl)));
	    }' unless defined(&outsl_ns);
	    eval 'sub IO_SPACE_LIMIT () {~(0);}' unless defined(&IO_SPACE_LIMIT);
	    eval 'sub ioremap_nocache {
	        my($addr, $size) = @_;
    		eval q( &ioremap(($addr), ($size)));
	    }' unless defined(&ioremap_nocache);
	    eval 'sub page_to_phys {
	        my($page) = @_;
    		eval q(( &page_to_pfn($page) <<  &PAGE_SHIFT));
	    }' unless defined(&page_to_phys);
	    eval 'sub BIO_VMERGE_BOUNDARY () {0;}' unless defined(&BIO_VMERGE_BOUNDARY);
	    eval 'sub iosync {
	        my($void) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&iosync);
	    eval 'sub iobarrier_rw () {
	        eval q( &eieio());
	    }' unless defined(&iobarrier_rw);
	    eval 'sub iobarrier_r () {
	        eval q( &eieio());
	    }' unless defined(&iobarrier_r);
	    eval 'sub iobarrier_w () {
	        eval q( &eieio());
	    }' unless defined(&iobarrier_w);
	    eval 'sub out_8 {
	        my($addr,$val) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&out_8);
	    eval 'sub in_le16 {
	        my($addr) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&in_le16);
	    eval 'sub in_be16 {
	        my($addr) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&in_be16);
	    eval 'sub out_le16 {
	        my($addr,$val) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&out_le16);
	    eval 'sub out_be16 {
	        my($addr,$val) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&out_be16);
	    eval 'sub in_le32 {
	        my($addr) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&in_le32);
	    eval 'sub in_be32 {
	        my($addr) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&in_be32);
	    eval 'sub out_le32 {
	        my($addr,$val) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&out_le32);
	    eval 'sub out_be32 {
	        my($addr,$val) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&out_be32);
	    eval 'sub in_le64 {
	        my($addr) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&in_le64);
	    eval 'sub in_be64 {
	        my($addr) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&in_be64);
	    eval 'sub out_le64 {
	        my($addr,$val) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&out_le64);
	    eval 'sub out_be64 {
	        my($addr,$val) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&out_be64);
	    unless(defined(&CONFIG_PPC_ISERIES)) {
		require 'asm/eeh.ph';
	    }
	    unless(defined(&CONFIG_PPC_ISERIES)) {
	    }
	    eval 'sub dma_cache_inv {
	        my($_start,$_size) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_cache_inv);
	    eval 'sub dma_cache_wback {
	        my($_start,$_size) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_cache_wback);
	    eval 'sub dma_cache_wback_inv {
	        my($_start,$_size) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_cache_wback_inv);
	    eval 'sub xlate_dev_mem_ptr {
	        my($p) = @_;
    		eval q( &__va($p));
	    }' unless defined(&xlate_dev_mem_ptr);
	    eval 'sub xlate_dev_kmem_ptr {
	        my($p) = @_;
    		eval q($p);
	    }' unless defined(&xlate_dev_kmem_ptr);
	}
    }
}
1;
