require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&PTE_INDEX_SIZE)) {
    sub PTE_INDEX_SIZE () {	9;}
}
unless(defined(&PMD_INDEX_SIZE)) {
    sub PMD_INDEX_SIZE () {	7;}
}
unless(defined(&PUD_INDEX_SIZE)) {
    sub PUD_INDEX_SIZE () {	7;}
}
unless(defined(&PGD_INDEX_SIZE)) {
    sub PGD_INDEX_SIZE () {	9;}
}
unless(defined(&PTE_TABLE_SIZE)) {
    sub PTE_TABLE_SIZE () {	($sizeof{ &pte_t} <<  &PTE_INDEX_SIZE);}
}
unless(defined(&PMD_TABLE_SIZE)) {
    sub PMD_TABLE_SIZE () {	($sizeof{ &pmd_t} <<  &PMD_INDEX_SIZE);}
}
unless(defined(&PUD_TABLE_SIZE)) {
    sub PUD_TABLE_SIZE () {	($sizeof{ &pud_t} <<  &PUD_INDEX_SIZE);}
}
unless(defined(&PGD_TABLE_SIZE)) {
    sub PGD_TABLE_SIZE () {	($sizeof{ &pgd_t} <<  &PGD_INDEX_SIZE);}
}
unless(defined(&PTRS_PER_PTE)) {
    sub PTRS_PER_PTE () {	(1<<  &PTE_INDEX_SIZE);}
}
unless(defined(&PTRS_PER_PMD)) {
    sub PTRS_PER_PMD () {	(1<<  &PMD_INDEX_SIZE);}
}
unless(defined(&PTRS_PER_PUD)) {
    sub PTRS_PER_PUD () {	(1<<  &PMD_INDEX_SIZE);}
}
unless(defined(&PTRS_PER_PGD)) {
    sub PTRS_PER_PGD () {	(1<<  &PGD_INDEX_SIZE);}
}
unless(defined(&PMD_SHIFT)) {
    sub PMD_SHIFT () {	( &PAGE_SHIFT +  &PTE_INDEX_SIZE);}
}
unless(defined(&PMD_SIZE)) {
    sub PMD_SIZE () {	(1 <<  &PMD_SHIFT);}
}
unless(defined(&PMD_MASK)) {
    sub PMD_MASK () {	(~( &PMD_SIZE-1));}
}
unless(defined(&MIN_HUGEPTE_SHIFT)) {
    sub MIN_HUGEPTE_SHIFT () {	 &PMD_SHIFT;}
}
unless(defined(&PUD_SHIFT)) {
    sub PUD_SHIFT () {	( &PMD_SHIFT +  &PMD_INDEX_SIZE);}
}
unless(defined(&PUD_SIZE)) {
    sub PUD_SIZE () {	(1 <<  &PUD_SHIFT);}
}
unless(defined(&PUD_MASK)) {
    sub PUD_MASK () {	(~( &PUD_SIZE-1));}
}
unless(defined(&PGDIR_SHIFT)) {
    sub PGDIR_SHIFT () {	( &PUD_SHIFT +  &PUD_INDEX_SIZE);}
}
unless(defined(&PGDIR_SIZE)) {
    sub PGDIR_SIZE () {	(1 <<  &PGDIR_SHIFT);}
}
unless(defined(&PGDIR_MASK)) {
    sub PGDIR_MASK () {	(~( &PGDIR_SIZE-1));}
}
unless(defined(&_PAGE_SECONDARY)) {
    sub _PAGE_SECONDARY () {	0x8000;}
}
unless(defined(&_PAGE_GROUP_IX)) {
    sub _PAGE_GROUP_IX () {	0x7000;}
}
unless(defined(&_PAGE_F_SECOND)) {
    sub _PAGE_F_SECOND () {	 &_PAGE_SECONDARY;}
}
unless(defined(&_PAGE_F_GIX)) {
    sub _PAGE_F_GIX () {	 &_PAGE_GROUP_IX;}
}
unless(defined(&_PAGE_HPTEFLAGS)) {
    sub _PAGE_HPTEFLAGS () {	( &_PAGE_BUSY |  &_PAGE_HASHPTE |  &_PAGE_SECONDARY |  &_PAGE_GROUP_IX);}
}
unless(defined(&_PAGE_CHG_MASK)) {
    sub _PAGE_CHG_MASK () {	( &PAGE_MASK |  &_PAGE_ACCESSED |  &_PAGE_DIRTY |  &_PAGE_HPTEFLAGS);}
}
unless(defined(&PMD_MASKED_BITS)) {
    sub PMD_MASKED_BITS () {	0;}
}
unless(defined(&PUD_MASKED_BITS)) {
    sub PUD_MASKED_BITS () {	0;}
}
unless(defined(&PGD_MASKED_BITS)) {
    sub PGD_MASKED_BITS () {	0;}
}
unless(defined(&PTE_RPN_SHIFT)) {
    sub PTE_RPN_SHIFT () {	(17);}
}
if(defined(&STRICT_MM_TYPECHECKS)) {
    eval 'sub __real_pte {
        my($e,$p) = @_;
	    eval q((( &real_pte_t){($e)}));
    }' unless defined(&__real_pte);
    eval 'sub __rpte_to_pte {
        my($r) = @_;
	    eval q((($r). &pte));
    }' unless defined(&__rpte_to_pte);
} else {
    eval 'sub __real_pte {
        my($e,$p) = @_;
	    eval q(($e));
    }' unless defined(&__real_pte);
    eval 'sub __rpte_to_pte {
        my($r) = @_;
	    eval q(( &__pte($r)));
    }' unless defined(&__rpte_to_pte);
}
unless(defined(&__rpte_to_hidx)) {
    sub __rpte_to_hidx {
	my($r,$index) = @_;
	eval q(( &pte_val( &__rpte_to_pte($r)) >> 12));
    }
}
unless(defined(&pte_iterate_hashed_subpages)) {
    sub pte_iterate_hashed_subpages {
	my($rpte, $psize, $va, $index, $shift) = @_;
	eval q( &do { $index = 0; $shift =  ($mmu_psize_defs[$psize]->{shift}););
    }
}
unless(defined(&pte_iterate_hashed_end)) {
    sub pte_iterate_hashed_end () {
	eval q(}  &while(0));
    }
}
unless(defined(&pgd_none)) {
    sub pgd_none {
	my($pgd) = @_;
	eval q((! &pgd_val($pgd)));
    }
}
unless(defined(&pgd_bad)) {
    sub pgd_bad {
	my($pgd) = @_;
	eval q(( &pgd_val($pgd) == 0));
    }
}
unless(defined(&pgd_present)) {
    sub pgd_present {
	my($pgd) = @_;
	eval q(( &pgd_val($pgd) != 0));
    }
}
unless(defined(&pgd_clear)) {
    sub pgd_clear {
	my($pgdp) = @_;
	eval q(( &pgd_val(*($pgdp)) = 0));
    }
}
unless(defined(&pgd_page)) {
    sub pgd_page {
	my($pgd) = @_;
	eval q(( &pgd_val($pgd) & ~ &PGD_MASKED_BITS));
    }
}
unless(defined(&pud_offset)) {
    sub pud_offset {
	my($pgdp, $addr) = @_;
	eval q(((( &pud_t *)  &pgd_page(*($pgdp))) + ((($addr) >>  &PUD_SHIFT) & ( &PTRS_PER_PUD - 1))));
    }
}
unless(defined(&pud_ERROR)) {
    sub pud_ERROR {
	my($e) = @_;
	eval q( &printk(\"%s:%d: bad pud %08lx.\\n\",  &__FILE__,  &__LINE__,  &pud_val($e)));
    }
}
1;
