require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_PGTABLE_64K_H)) {
    eval 'sub _ASM_POWERPC_PGTABLE_64K_H () {1;}' unless defined(&_ASM_POWERPC_PGTABLE_64K_H);
    if(defined(&__KERNEL__)) {
	require 'asm-generic/pgtable-nopud.ph';
	eval 'sub PTE_INDEX_SIZE () {12;}' unless defined(&PTE_INDEX_SIZE);
	eval 'sub PMD_INDEX_SIZE () {12;}' unless defined(&PMD_INDEX_SIZE);
	eval 'sub PUD_INDEX_SIZE () {0;}' unless defined(&PUD_INDEX_SIZE);
	eval 'sub PGD_INDEX_SIZE () {4;}' unless defined(&PGD_INDEX_SIZE);
	eval 'sub PTE_TABLE_SIZE () {($sizeof{ &real_pte_t} <<  &PTE_INDEX_SIZE);}' unless defined(&PTE_TABLE_SIZE);
	eval 'sub PMD_TABLE_SIZE () {($sizeof{ &pmd_t} <<  &PMD_INDEX_SIZE);}' unless defined(&PMD_TABLE_SIZE);
	eval 'sub PGD_TABLE_SIZE () {($sizeof{ &pgd_t} <<  &PGD_INDEX_SIZE);}' unless defined(&PGD_TABLE_SIZE);
	eval 'sub PTRS_PER_PTE () {(1<<  &PTE_INDEX_SIZE);}' unless defined(&PTRS_PER_PTE);
	eval 'sub PTRS_PER_PMD () {(1<<  &PMD_INDEX_SIZE);}' unless defined(&PTRS_PER_PMD);
	eval 'sub PTRS_PER_PGD () {(1<<  &PGD_INDEX_SIZE);}' unless defined(&PTRS_PER_PGD);
	eval 'sub MIN_HUGEPTE_SHIFT () { &PAGE_SHIFT;}' unless defined(&MIN_HUGEPTE_SHIFT);
	eval 'sub PMD_SHIFT () {( &PAGE_SHIFT +  &PTE_INDEX_SIZE);}' unless defined(&PMD_SHIFT);
	eval 'sub PMD_SIZE () {(1 <<  &PMD_SHIFT);}' unless defined(&PMD_SIZE);
	eval 'sub PMD_MASK () {(~( &PMD_SIZE-1));}' unless defined(&PMD_MASK);
	eval 'sub PGDIR_SHIFT () {( &PMD_SHIFT +  &PMD_INDEX_SIZE);}' unless defined(&PGDIR_SHIFT);
	eval 'sub PGDIR_SIZE () {(1 <<  &PGDIR_SHIFT);}' unless defined(&PGDIR_SIZE);
	eval 'sub PGDIR_MASK () {(~( &PGDIR_SIZE-1));}' unless defined(&PGDIR_MASK);
	eval 'sub _PAGE_HPTE_SUB () {0xffff000;}' unless defined(&_PAGE_HPTE_SUB);
	eval 'sub _PAGE_HPTE_SUB0 () {0x8000000;}' unless defined(&_PAGE_HPTE_SUB0);
	eval 'sub _PAGE_COMBO () {0x10000000;}' unless defined(&_PAGE_COMBO);
	eval 'sub _PAGE_F_SECOND () {0x8000;}' unless defined(&_PAGE_F_SECOND);
	eval 'sub _PAGE_F_GIX () {0x7000;}' unless defined(&_PAGE_F_GIX);
	eval 'sub _PAGE_HPTEFLAGS () {( &_PAGE_BUSY |  &_PAGE_HASHPTE |  &_PAGE_HPTE_SUB |  &_PAGE_COMBO);}' unless defined(&_PAGE_HPTEFLAGS);
	eval 'sub PTE_RPN_SHIFT () {(32);}' unless defined(&PTE_RPN_SHIFT);
	eval 'sub PTE_RPN_MAX () {(1 << (64-  &PTE_RPN_SHIFT));}' unless defined(&PTE_RPN_MAX);
	eval 'sub PTE_RPN_MASK () {(~((1<< &PTE_RPN_SHIFT)-1));}' unless defined(&PTE_RPN_MASK);
	eval 'sub _PAGE_CHG_MASK () {( &PTE_RPN_MASK |  &_PAGE_HPTEFLAGS |  &_PAGE_DIRTY |  &_PAGE_ACCESSED);}' unless defined(&_PAGE_CHG_MASK);
	eval 'sub PMD_MASKED_BITS () {0x1ff;}' unless defined(&PMD_MASKED_BITS);
	eval 'sub PUD_MASKED_BITS () {0x1ff;}' unless defined(&PUD_MASKED_BITS);
	unless(defined(&__ASSEMBLY__)) {
	    eval 'sub __real_pte {
	        my($e,$p) = @_;
    		eval q((( &real_pte_t) { ($e),  &pte_val(*(($p) +  &PTRS_PER_PTE)) }));
	    }' unless defined(&__real_pte);
	    eval 'sub __rpte_to_hidx {
	        my($r,$index) = @_;
    		eval q((( &pte_val(($r). &pte) &  &_PAGE_COMBO) ? ((($r). &hidx >> (($index)<<2)) & 0xf) : (( &pte_val(($r). &pte) >> 12) & 0xf)));
	    }' unless defined(&__rpte_to_hidx);
	    eval 'sub __rpte_to_pte {
	        my($r) = @_;
    		eval q((($r). &pte));
	    }' unless defined(&__rpte_to_pte);
	    eval 'sub __rpte_sub_valid {
	        my($rpte, $index) = @_;
    		eval q(( &pte_val( ($rpte->{pte})) & ( &_PAGE_HPTE_SUB0 >> ($index))));
	    }' unless defined(&__rpte_sub_valid);
	    eval 'sub pte_iterate_hashed_subpages {
	        my($rpte, $psize, $va, $index, $shift) = @_;
    		eval q( &do { \'unsigned long __end\' = $va +  &PAGE_SIZE; \'unsigned __split\' = ($psize ==  &MMU_PAGE_4K || $psize ==  &MMU_PAGE_64K_AP); $shift =  ($mmu_psize_defs[$psize]->{shift});  &for ($index = 0; $va <  &__end; $index++, $va += (1<< $shift)) {  &if (! &__split ||  &__rpte_sub_valid($rpte, $index))  &do {);
	    }' unless defined(&pte_iterate_hashed_subpages);
	    eval 'sub pte_iterate_hashed_end () {
	        eval q(}  &while(0); } }  &while(0));
	    }' unless defined(&pte_iterate_hashed_end);
	}
    }
}
1;
