require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_PPC_ASM_H)) {
    eval 'sub _ASM_POWERPC_PPC_ASM_H () {1;}' unless defined(&_ASM_POWERPC_PPC_ASM_H);
    require 'linux/stringify.ph';
    require 'linux/config.ph';
    require 'asm/asm-compat.ph';
    unless(defined(&__ASSEMBLY__)) {
	die("__FILE__\ should\ only\ be\ used\ in\ assembler\ files");
    } else {
	eval 'sub SZL () {( &BITS_PER_LONG/8);}' unless defined(&SZL);
	unless(defined(&CONFIG_VIRT_CPU_ACCOUNTING)) {
	    eval 'sub ACCOUNT_CPU_USER_ENTRY {
	        my($ra, $rb) = @_;
    		eval q();
	    }' unless defined(&ACCOUNT_CPU_USER_ENTRY);
	    eval 'sub ACCOUNT_CPU_USER_EXIT {
	        my($ra, $rb) = @_;
    		eval q();
	    }' unless defined(&ACCOUNT_CPU_USER_EXIT);
	} else {
	    eval 'sub ACCOUNT_CPU_USER_ENTRY {
	        my($ra, $rb) = @_;
    		eval q( &beq 2 &f;  &BEGIN_FTR_SECTION;  &mfspr $ra, &SPRN_PURR;  &END_FTR_SECTION_IFSET( &CPU_FTR_PURR);  &BEGIN_FTR_SECTION;  &mftb $ra;  &END_FTR_SECTION_IFCLR( &CPU_FTR_PURR);  &ld $rb, &PACA_STARTPURR( &r13);  &std $ra, &PACA_STARTPURR( &r13);  &subf $rb,$rb,$ra;  &ld $ra, &PACA_USER_TIME( &r13);  &add $ra,$ra,$rb;  &std $ra, &PACA_USER_TIME( &r13); 2:);
	    }' unless defined(&ACCOUNT_CPU_USER_ENTRY);
	    eval 'sub ACCOUNT_CPU_USER_EXIT {
	        my($ra, $rb) = @_;
    		eval q( &BEGIN_FTR_SECTION;  &mfspr $ra, &SPRN_PURR;  &END_FTR_SECTION_IFSET( &CPU_FTR_PURR);  &BEGIN_FTR_SECTION;  &mftb $ra;  &END_FTR_SECTION_IFCLR( &CPU_FTR_PURR);  &ld $rb, &PACA_STARTPURR( &r13);  &std $ra, &PACA_STARTPURR( &r13);  &subf $rb,$rb,$ra;  &ld $ra, &PACA_SYSTEM_TIME( &r13);  &add $ra,$ra,$rb;  &std $ra, &PACA_SYSTEM_TIME( &r13););
	    }' unless defined(&ACCOUNT_CPU_USER_EXIT);
	}
	if(defined(&__powerpc64__)) {
	    eval 'sub SAVE_GPR {
	        my($n, $base) = @_;
    		eval q( &std $n, &GPR0+8*($n)($base));
	    }' unless defined(&SAVE_GPR);
	    eval 'sub REST_GPR {
	        my($n, $base) = @_;
    		eval q( &ld $n, &GPR0+8*($n)($base));
	    }' unless defined(&REST_GPR);
	    eval 'sub SAVE_NVGPRS {
	        my($base) = @_;
    		eval q( &SAVE_8GPRS(14, $base);  &SAVE_10GPRS(22, $base));
	    }' unless defined(&SAVE_NVGPRS);
	    eval 'sub REST_NVGPRS {
	        my($base) = @_;
    		eval q( &REST_8GPRS(14, $base);  &REST_10GPRS(22, $base));
	    }' unless defined(&REST_NVGPRS);
	} else {
	    eval 'sub SAVE_GPR {
	        my($n, $base) = @_;
    		eval q( &stw $n, &GPR0+4*($n)($base));
	    }' unless defined(&SAVE_GPR);
	    eval 'sub REST_GPR {
	        my($n, $base) = @_;
    		eval q( &lwz $n, &GPR0+4*($n)($base));
	    }' unless defined(&REST_GPR);
	    eval 'sub SAVE_NVGPRS {
	        my($base) = @_;
    		eval q( &SAVE_GPR(13, $base);  &SAVE_8GPRS(14, $base);  &SAVE_10GPRS(22, $base));
	    }' unless defined(&SAVE_NVGPRS);
	    eval 'sub REST_NVGPRS {
	        my($base) = @_;
    		eval q( &REST_GPR(13, $base);  &REST_8GPRS(14, $base);  &REST_10GPRS(22, $base));
	    }' unless defined(&REST_NVGPRS);
	}
	eval 'sub SAVE_2GPRS {
	    my($n, $base) = @_;
    	    eval q( &SAVE_GPR($n, $base);  &SAVE_GPR($n+1, $base));
	}' unless defined(&SAVE_2GPRS);
	eval 'sub SAVE_4GPRS {
	    my($n, $base) = @_;
    	    eval q( &SAVE_2GPRS($n, $base);  &SAVE_2GPRS($n+2, $base));
	}' unless defined(&SAVE_4GPRS);
	eval 'sub SAVE_8GPRS {
	    my($n, $base) = @_;
    	    eval q( &SAVE_4GPRS($n, $base);  &SAVE_4GPRS($n+4, $base));
	}' unless defined(&SAVE_8GPRS);
	eval 'sub SAVE_10GPRS {
	    my($n, $base) = @_;
    	    eval q( &SAVE_8GPRS($n, $base);  &SAVE_2GPRS($n+8, $base));
	}' unless defined(&SAVE_10GPRS);
	eval 'sub REST_2GPRS {
	    my($n, $base) = @_;
    	    eval q( &REST_GPR($n, $base);  &REST_GPR($n+1, $base));
	}' unless defined(&REST_2GPRS);
	eval 'sub REST_4GPRS {
	    my($n, $base) = @_;
    	    eval q( &REST_2GPRS($n, $base);  &REST_2GPRS($n+2, $base));
	}' unless defined(&REST_4GPRS);
	eval 'sub REST_8GPRS {
	    my($n, $base) = @_;
    	    eval q( &REST_4GPRS($n, $base);  &REST_4GPRS($n+4, $base));
	}' unless defined(&REST_8GPRS);
	eval 'sub REST_10GPRS {
	    my($n, $base) = @_;
    	    eval q( &REST_8GPRS($n, $base);  &REST_2GPRS($n+8, $base));
	}' unless defined(&REST_10GPRS);
	eval 'sub SAVE_FPR {
	    my($n, $base) = @_;
    	    eval q( &stfd $n, &THREAD_FPR0+8*($n)($base));
	}' unless defined(&SAVE_FPR);
	eval 'sub SAVE_2FPRS {
	    my($n, $base) = @_;
    	    eval q( &SAVE_FPR($n, $base);  &SAVE_FPR($n+1, $base));
	}' unless defined(&SAVE_2FPRS);
	eval 'sub SAVE_4FPRS {
	    my($n, $base) = @_;
    	    eval q( &SAVE_2FPRS($n, $base);  &SAVE_2FPRS($n+2, $base));
	}' unless defined(&SAVE_4FPRS);
	eval 'sub SAVE_8FPRS {
	    my($n, $base) = @_;
    	    eval q( &SAVE_4FPRS($n, $base);  &SAVE_4FPRS($n+4, $base));
	}' unless defined(&SAVE_8FPRS);
	eval 'sub SAVE_16FPRS {
	    my($n, $base) = @_;
    	    eval q( &SAVE_8FPRS($n, $base);  &SAVE_8FPRS($n+8, $base));
	}' unless defined(&SAVE_16FPRS);
	eval 'sub SAVE_32FPRS {
	    my($n, $base) = @_;
    	    eval q( &SAVE_16FPRS($n, $base);  &SAVE_16FPRS($n+16, $base));
	}' unless defined(&SAVE_32FPRS);
	eval 'sub REST_FPR {
	    my($n, $base) = @_;
    	    eval q( &lfd $n, &THREAD_FPR0+8*($n)($base));
	}' unless defined(&REST_FPR);
	eval 'sub REST_2FPRS {
	    my($n, $base) = @_;
    	    eval q( &REST_FPR($n, $base);  &REST_FPR($n+1, $base));
	}' unless defined(&REST_2FPRS);
	eval 'sub REST_4FPRS {
	    my($n, $base) = @_;
    	    eval q( &REST_2FPRS($n, $base);  &REST_2FPRS($n+2, $base));
	}' unless defined(&REST_4FPRS);
	eval 'sub REST_8FPRS {
	    my($n, $base) = @_;
    	    eval q( &REST_4FPRS($n, $base);  &REST_4FPRS($n+4, $base));
	}' unless defined(&REST_8FPRS);
	eval 'sub REST_16FPRS {
	    my($n, $base) = @_;
    	    eval q( &REST_8FPRS($n, $base);  &REST_8FPRS($n+8, $base));
	}' unless defined(&REST_16FPRS);
	eval 'sub REST_32FPRS {
	    my($n, $base) = @_;
    	    eval q( &REST_16FPRS($n, $base);  &REST_16FPRS($n+16, $base));
	}' unless defined(&REST_32FPRS);
	eval 'sub SAVE_VR {
	    my($n,$b,$base) = @_;
    	    eval q( &li $b, &THREAD_VR0+(16*($n));  &stvx $n,$b,$base);
	}' unless defined(&SAVE_VR);
	eval 'sub SAVE_2VRS {
	    my($n,$b,$base) = @_;
    	    eval q( &SAVE_VR($n,$b,$base);  &SAVE_VR($n+1,$b,$base));
	}' unless defined(&SAVE_2VRS);
	eval 'sub SAVE_4VRS {
	    my($n,$b,$base) = @_;
    	    eval q( &SAVE_2VRS($n,$b,$base);  &SAVE_2VRS($n+2,$b,$base));
	}' unless defined(&SAVE_4VRS);
	eval 'sub SAVE_8VRS {
	    my($n,$b,$base) = @_;
    	    eval q( &SAVE_4VRS($n,$b,$base);  &SAVE_4VRS($n+4,$b,$base));
	}' unless defined(&SAVE_8VRS);
	eval 'sub SAVE_16VRS {
	    my($n,$b,$base) = @_;
    	    eval q( &SAVE_8VRS($n,$b,$base);  &SAVE_8VRS($n+8,$b,$base));
	}' unless defined(&SAVE_16VRS);
	eval 'sub SAVE_32VRS {
	    my($n,$b,$base) = @_;
    	    eval q( &SAVE_16VRS($n,$b,$base);  &SAVE_16VRS($n+16,$b,$base));
	}' unless defined(&SAVE_32VRS);
	eval 'sub REST_VR {
	    my($n,$b,$base) = @_;
    	    eval q( &li $b, &THREAD_VR0+(16*($n));  &lvx $n,$b,$base);
	}' unless defined(&REST_VR);
	eval 'sub REST_2VRS {
	    my($n,$b,$base) = @_;
    	    eval q( &REST_VR($n,$b,$base);  &REST_VR($n+1,$b,$base));
	}' unless defined(&REST_2VRS);
	eval 'sub REST_4VRS {
	    my($n,$b,$base) = @_;
    	    eval q( &REST_2VRS($n,$b,$base);  &REST_2VRS($n+2,$b,$base));
	}' unless defined(&REST_4VRS);
	eval 'sub REST_8VRS {
	    my($n,$b,$base) = @_;
    	    eval q( &REST_4VRS($n,$b,$base);  &REST_4VRS($n+4,$b,$base));
	}' unless defined(&REST_8VRS);
	eval 'sub REST_16VRS {
	    my($n,$b,$base) = @_;
    	    eval q( &REST_8VRS($n,$b,$base);  &REST_8VRS($n+8,$b,$base));
	}' unless defined(&REST_16VRS);
	eval 'sub REST_32VRS {
	    my($n,$b,$base) = @_;
    	    eval q( &REST_16VRS($n,$b,$base);  &REST_16VRS($n+16,$b,$base));
	}' unless defined(&REST_32VRS);
	eval 'sub SAVE_EVR {
	    my($n,$s,$base) = @_;
    	    eval q( &evmergehi $s,$s,$n;  &stw $s, &THREAD_EVR0+4*($n)($base));
	}' unless defined(&SAVE_EVR);
	eval 'sub SAVE_2EVRS {
	    my($n,$s,$base) = @_;
    	    eval q( &SAVE_EVR($n,$s,$base);  &SAVE_EVR($n+1,$s,$base));
	}' unless defined(&SAVE_2EVRS);
	eval 'sub SAVE_4EVRS {
	    my($n,$s,$base) = @_;
    	    eval q( &SAVE_2EVRS($n,$s,$base);  &SAVE_2EVRS($n+2,$s,$base));
	}' unless defined(&SAVE_4EVRS);
	eval 'sub SAVE_8EVRS {
	    my($n,$s,$base) = @_;
    	    eval q( &SAVE_4EVRS($n,$s,$base);  &SAVE_4EVRS($n+4,$s,$base));
	}' unless defined(&SAVE_8EVRS);
	eval 'sub SAVE_16EVRS {
	    my($n,$s,$base) = @_;
    	    eval q( &SAVE_8EVRS($n,$s,$base);  &SAVE_8EVRS($n+8,$s,$base));
	}' unless defined(&SAVE_16EVRS);
	eval 'sub SAVE_32EVRS {
	    my($n,$s,$base) = @_;
    	    eval q( &SAVE_16EVRS($n,$s,$base);  &SAVE_16EVRS($n+16,$s,$base));
	}' unless defined(&SAVE_32EVRS);
	eval 'sub REST_EVR {
	    my($n,$s,$base) = @_;
    	    eval q( &lwz $s, &THREAD_EVR0+4*($n)($base);  &evmergelo $n,$s,$n);
	}' unless defined(&REST_EVR);
	eval 'sub REST_2EVRS {
	    my($n,$s,$base) = @_;
    	    eval q( &REST_EVR($n,$s,$base);  &REST_EVR($n+1,$s,$base));
	}' unless defined(&REST_2EVRS);
	eval 'sub REST_4EVRS {
	    my($n,$s,$base) = @_;
    	    eval q( &REST_2EVRS($n,$s,$base);  &REST_2EVRS($n+2,$s,$base));
	}' unless defined(&REST_4EVRS);
	eval 'sub REST_8EVRS {
	    my($n,$s,$base) = @_;
    	    eval q( &REST_4EVRS($n,$s,$base);  &REST_4EVRS($n+4,$s,$base));
	}' unless defined(&REST_8EVRS);
	eval 'sub REST_16EVRS {
	    my($n,$s,$base) = @_;
    	    eval q( &REST_8EVRS($n,$s,$base);  &REST_8EVRS($n+8,$s,$base));
	}' unless defined(&REST_16EVRS);
	eval 'sub REST_32EVRS {
	    my($n,$s,$base) = @_;
    	    eval q( &REST_16EVRS($n,$s,$base);  &REST_16EVRS($n+16,$s,$base));
	}' unless defined(&REST_32EVRS);
	eval 'sub HMT_VERY_LOW () { &or 31,31,31  &very  &low  &priority;}' unless defined(&HMT_VERY_LOW);
	eval 'sub HMT_LOW () { &or 1,1,1;}' unless defined(&HMT_LOW);
	eval 'sub HMT_MEDIUM_LOW () { &or 6,6,6  &medium  &low  &priority;}' unless defined(&HMT_MEDIUM_LOW);
	eval 'sub HMT_MEDIUM () { &or 2,2,2;}' unless defined(&HMT_MEDIUM);
	eval 'sub HMT_MEDIUM_HIGH () { &or 5,5,5  &medium  &high  &priority;}' unless defined(&HMT_MEDIUM_HIGH);
	eval 'sub HMT_HIGH () { &or 3,3,3;}' unless defined(&HMT_HIGH);
	eval 'sub RFCI () {.\'long 0x4c000066\';}' unless defined(&RFCI);
	eval 'sub RFDI () {.\'long 0x4c00004e\';}' unless defined(&RFDI);
	eval 'sub RFMCI () {.\'long 0x4c00004c\';}' unless defined(&RFMCI);
	if(defined(&__KERNEL__)) {
	    if(defined(&CONFIG_PPC64)) {
		eval 'sub XGLUE {
		    my($a,$b) = @_;
    		    eval q($a$b);
		}' unless defined(&XGLUE);
		eval 'sub GLUE {
		    my($a,$b) = @_;
    		    eval q( &XGLUE($a,$b));
		}' unless defined(&GLUE);
		eval 'sub _GLOBAL {
		    my($name) = @_;
    		    eval q(. &section \\".text\\"; . &align 2; . &globl $name; . &globl  &GLUE(.,$name); . &section \\".opd\\",\\"aw\\"; $name: . &quad  &GLUE(.,$name); . &quad . &TOC.@ &tocbase; . &quad 0; . &previous; . &type  &GLUE(.,$name),@ &function;  &GLUE(.,$name):);
		}' unless defined(&_GLOBAL);
		eval 'sub _KPROBE {
		    my($name) = @_;
    		    eval q(. &section \\".kprobes.text\\",\\"a\\"; . &align 2; . &globl $name; . &globl  &GLUE(.,$name); . &section \\".opd\\",\\"aw\\"; $name: . &quad  &GLUE(.,$name); . &quad . &TOC.@ &tocbase; . &quad 0; . &previous; . &type  &GLUE(.,$name),@ &function;  &GLUE(.,$name):);
		}' unless defined(&_KPROBE);
		eval 'sub _STATIC {
		    my($name) = @_;
    		    eval q(. &section \\".text\\"; . &align 2; . &section \\".opd\\",\\"aw\\"; $name: . &quad  &GLUE(.,$name); . &quad . &TOC.@ &tocbase; . &quad 0; . &previous; . &type  &GLUE(.,$name),@ &function;  &GLUE(.,$name):);
		}' unless defined(&_STATIC);
	    } else {
		eval 'sub _GLOBAL {
		    my($n) = @_;
    		    eval q(. &text; . &stabs  &__stringify($n: &F-1), &N_FUN,0,0,$n; . &globl $n; $n:);
		}' unless defined(&_GLOBAL);
		eval 'sub _KPROBE {
		    my($n) = @_;
    		    eval q(. &section \\".kprobes.text\\",\\"a\\"; . &globl $n; $n:);
		}' unless defined(&_KPROBE);
	    }
	    if(defined(&__powerpc64__)) {
		eval 'sub LOAD_REG_IMMEDIATE {
		    my($reg,$expr) = @_;
    		    eval q( &lis ($reg),($expr)@ &highest;  &ori ($reg),($reg),($expr)@ &higher;  &rldicr ($reg),($reg),32,31;  &oris ($reg),($reg),($expr)@ &h;  &ori ($reg),($reg),($expr)@ &l;);
		}' unless defined(&LOAD_REG_IMMEDIATE);
		eval 'sub LOAD_REG_ADDR {
		    my($reg,$name) = @_;
    		    eval q( &ld ($reg),$name@ &got( &r2));
		}' unless defined(&LOAD_REG_ADDR);
		eval 'sub LOAD_REG_ADDRBASE {
		    my($reg,$name) = @_;
    		    eval q( &LOAD_REG_ADDR($reg,$name));
		}' unless defined(&LOAD_REG_ADDRBASE);
		eval 'sub ADDROFF {
		    my($name) = @_;
    		    eval q(0);
		}' unless defined(&ADDROFF);
		eval 'sub LRSAVE () {16;}' unless defined(&LRSAVE);
	    } else {
		eval 'sub LOAD_REG_IMMEDIATE {
		    my($reg,$expr) = @_;
    		    eval q( &lis ($reg),($expr)@ &ha;  &addi ($reg),($reg),($expr)@ &l;);
		}' unless defined(&LOAD_REG_IMMEDIATE);
		eval 'sub LOAD_REG_ADDR {
		    my($reg,$name) = @_;
    		    eval q( &LOAD_REG_IMMEDIATE($reg, $name));
		}' unless defined(&LOAD_REG_ADDR);
		eval 'sub LOAD_REG_ADDRBASE {
		    my($reg, $name) = @_;
    		    eval q( &lis ($reg),$name@ &ha);
		}' unless defined(&LOAD_REG_ADDRBASE);
		eval 'sub ADDROFF {
		    my($name) = @_;
    		    eval q($name@ &l);
		}' unless defined(&ADDROFF);
		eval 'sub LRSAVE () {4;}' unless defined(&LRSAVE);
	    }
	    if(defined(&CONFIG_PPC601_SYNC_FIX)) {
		eval 'sub SYNC () { &BEGIN_FTR_SECTION  &sync;  &isync;  &END_FTR_SECTION_IFSET( &CPU_FTR_601);}' unless defined(&SYNC);
		eval 'sub SYNC_601 () { &BEGIN_FTR_SECTION  &sync;  &END_FTR_SECTION_IFSET( &CPU_FTR_601);}' unless defined(&SYNC_601);
		eval 'sub ISYNC_601 () { &BEGIN_FTR_SECTION  &isync;  &END_FTR_SECTION_IFSET( &CPU_FTR_601);}' unless defined(&ISYNC_601);
	    } else {
		eval 'sub SYNC () {1;}' unless defined(&SYNC);
		eval 'sub SYNC_601 () {1;}' unless defined(&SYNC_601);
		eval 'sub ISYNC_601 () {1;}' unless defined(&ISYNC_601);
	    }
	    unless(defined(&CONFIG_SMP)) {
		eval 'sub TLBSYNC () {1;}' unless defined(&TLBSYNC);
	    } else {
		eval 'sub TLBSYNC () { &BEGIN_FTR_SECTION  &tlbsync;  &sync;  &END_FTR_SECTION_IFCLR( &CPU_FTR_601);}' unless defined(&TLBSYNC);
	    }
	    if(!defined( &CONFIG_4xx)  && !defined( &CONFIG_8xx)) {
		eval 'sub tlbia () { &li  &r4,1024;  &mtctr  &r4;  &lis  &r4, &KERNELBASE@ &h; 0:  &tlbie  &r4;  &addi  &r4, &r4,0x1000;  &bdnz 0 &b;}' unless defined(&tlbia);
	    }
	    if(defined(&CONFIG_IBM440EP_ERR42)) {
		eval 'sub PPC440EP_ERR42 () { &isync;}' unless defined(&PPC440EP_ERR42);
	    } else {
		eval 'sub PPC440EP_ERR42 () {1;}' unless defined(&PPC440EP_ERR42);
	    }
	    if(defined( &CONFIG_BOOKE)) {
		eval 'sub toreal {
		    my($rd) = @_;
    		    eval q();
		}' unless defined(&toreal);
		eval 'sub fromreal {
		    my($rd) = @_;
    		    eval q();
		}' unless defined(&fromreal);
		eval 'sub tophys {
		    my($rd,$rs) = @_;
    		    eval q( &addis $rd,$rs,0);
		}' unless defined(&tophys);
		eval 'sub tovirt {
		    my($rd,$rs) = @_;
    		    eval q( &addis $rd,$rs,0);
		}' unless defined(&tovirt);
	    }
 elsif(defined( &CONFIG_PPC64)) {
		eval 'sub toreal {
		    my($rd) = @_;
    		    eval q();
		}' unless defined(&toreal);
		eval 'sub fromreal {
		    my($rd) = @_;
    		    eval q();
		}' unless defined(&fromreal);
		eval 'sub tophys {
		    my($rd,$rs) = @_;
    		    eval q( &clrldi $rd,$rs,2);
		}' unless defined(&tophys);
		eval 'sub tovirt {
		    my($rd,$rs) = @_;
    		    eval q( &rotldi $rd,$rs,16;  &ori $rd,$rd,(( &KERNELBASE>>48)&0xffff);  &rotldi $rd,$rd,48);
		}' unless defined(&tovirt);
	    } else {
		eval 'sub toreal {
		    my($rd) = @_;
    		    eval q( &tophys($rd,$rd));
		}' unless defined(&toreal);
		eval 'sub fromreal {
		    my($rd) = @_;
    		    eval q( &tovirt($rd,$rd));
		}' unless defined(&fromreal);
		eval 'sub tophys {
		    my($rd,$rs) = @_;
    		    eval q(0:  &addis $rd,$rs,- &KERNELBASE@ &h; . &section \\".vtop_fixup\\",\\"aw\\"; . &align 1; .\'long 0b\'; . &previous);
		}' unless defined(&tophys);
		eval 'sub tovirt {
		    my($rd,$rs) = @_;
    		    eval q(0:  &addis $rd,$rs, &KERNELBASE@ &h; . &section \\".ptov_fixup\\",\\"aw\\"; . &align 1; .\'long 0b\'; . &previous);
		}' unless defined(&tovirt);
	    }
	    if(defined(&CONFIG_PPC64)) {
		eval 'sub RFI () { &rfid;}' unless defined(&RFI);
		eval 'sub MTMSRD {
		    my($r) = @_;
    		    eval q( &mtmsrd $r);
		}' unless defined(&MTMSRD);
	    } else {
		eval 'sub FIX_SRR1 {
		    my($ra, $rb) = @_;
    		    eval q();
		}' unless defined(&FIX_SRR1);
		unless(defined(&CONFIG_40x)) {
		    eval 'sub RFI () { &rfi;}' unless defined(&RFI);
		} else {
		    eval 'sub RFI () { &rfi;  &b .;}' unless defined(&RFI);
		}
		eval 'sub MTMSRD {
		    my($r) = @_;
    		    eval q( &mtmsr $r);
		}' unless defined(&MTMSRD);
		eval 'sub CLR_TOP32 {
		    my($r) = @_;
    		    eval q();
		}' unless defined(&CLR_TOP32);
	    }
	}
	eval 'sub cr0 () {0;}' unless defined(&cr0);
	eval 'sub cr1 () {1;}' unless defined(&cr1);
	eval 'sub cr2 () {2;}' unless defined(&cr2);
	eval 'sub cr3 () {3;}' unless defined(&cr3);
	eval 'sub cr4 () {4;}' unless defined(&cr4);
	eval 'sub cr5 () {5;}' unless defined(&cr5);
	eval 'sub cr6 () {6;}' unless defined(&cr6);
	eval 'sub cr7 () {7;}' unless defined(&cr7);
	eval 'sub r0 () {0;}' unless defined(&r0);
	eval 'sub r1 () {1;}' unless defined(&r1);
	eval 'sub r2 () {2;}' unless defined(&r2);
	eval 'sub r3 () {3;}' unless defined(&r3);
	eval 'sub r4 () {4;}' unless defined(&r4);
	eval 'sub r5 () {5;}' unless defined(&r5);
	eval 'sub r6 () {6;}' unless defined(&r6);
	eval 'sub r7 () {7;}' unless defined(&r7);
	eval 'sub r8 () {8;}' unless defined(&r8);
	eval 'sub r9 () {9;}' unless defined(&r9);
	eval 'sub r10 () {10;}' unless defined(&r10);
	eval 'sub r11 () {11;}' unless defined(&r11);
	eval 'sub r12 () {12;}' unless defined(&r12);
	eval 'sub r13 () {13;}' unless defined(&r13);
	eval 'sub r14 () {14;}' unless defined(&r14);
	eval 'sub r15 () {15;}' unless defined(&r15);
	eval 'sub r16 () {16;}' unless defined(&r16);
	eval 'sub r17 () {17;}' unless defined(&r17);
	eval 'sub r18 () {18;}' unless defined(&r18);
	eval 'sub r19 () {19;}' unless defined(&r19);
	eval 'sub r20 () {20;}' unless defined(&r20);
	eval 'sub r21 () {21;}' unless defined(&r21);
	eval 'sub r22 () {22;}' unless defined(&r22);
	eval 'sub r23 () {23;}' unless defined(&r23);
	eval 'sub r24 () {24;}' unless defined(&r24);
	eval 'sub r25 () {25;}' unless defined(&r25);
	eval 'sub r26 () {26;}' unless defined(&r26);
	eval 'sub r27 () {27;}' unless defined(&r27);
	eval 'sub r28 () {28;}' unless defined(&r28);
	eval 'sub r29 () {29;}' unless defined(&r29);
	eval 'sub r30 () {30;}' unless defined(&r30);
	eval 'sub r31 () {31;}' unless defined(&r31);
	eval 'sub fr0 () {0;}' unless defined(&fr0);
	eval 'sub fr1 () {1;}' unless defined(&fr1);
	eval 'sub fr2 () {2;}' unless defined(&fr2);
	eval 'sub fr3 () {3;}' unless defined(&fr3);
	eval 'sub fr4 () {4;}' unless defined(&fr4);
	eval 'sub fr5 () {5;}' unless defined(&fr5);
	eval 'sub fr6 () {6;}' unless defined(&fr6);
	eval 'sub fr7 () {7;}' unless defined(&fr7);
	eval 'sub fr8 () {8;}' unless defined(&fr8);
	eval 'sub fr9 () {9;}' unless defined(&fr9);
	eval 'sub fr10 () {10;}' unless defined(&fr10);
	eval 'sub fr11 () {11;}' unless defined(&fr11);
	eval 'sub fr12 () {12;}' unless defined(&fr12);
	eval 'sub fr13 () {13;}' unless defined(&fr13);
	eval 'sub fr14 () {14;}' unless defined(&fr14);
	eval 'sub fr15 () {15;}' unless defined(&fr15);
	eval 'sub fr16 () {16;}' unless defined(&fr16);
	eval 'sub fr17 () {17;}' unless defined(&fr17);
	eval 'sub fr18 () {18;}' unless defined(&fr18);
	eval 'sub fr19 () {19;}' unless defined(&fr19);
	eval 'sub fr20 () {20;}' unless defined(&fr20);
	eval 'sub fr21 () {21;}' unless defined(&fr21);
	eval 'sub fr22 () {22;}' unless defined(&fr22);
	eval 'sub fr23 () {23;}' unless defined(&fr23);
	eval 'sub fr24 () {24;}' unless defined(&fr24);
	eval 'sub fr25 () {25;}' unless defined(&fr25);
	eval 'sub fr26 () {26;}' unless defined(&fr26);
	eval 'sub fr27 () {27;}' unless defined(&fr27);
	eval 'sub fr28 () {28;}' unless defined(&fr28);
	eval 'sub fr29 () {29;}' unless defined(&fr29);
	eval 'sub fr30 () {30;}' unless defined(&fr30);
	eval 'sub fr31 () {31;}' unless defined(&fr31);
	eval 'sub vr0 () {0;}' unless defined(&vr0);
	eval 'sub vr1 () {1;}' unless defined(&vr1);
	eval 'sub vr2 () {2;}' unless defined(&vr2);
	eval 'sub vr3 () {3;}' unless defined(&vr3);
	eval 'sub vr4 () {4;}' unless defined(&vr4);
	eval 'sub vr5 () {5;}' unless defined(&vr5);
	eval 'sub vr6 () {6;}' unless defined(&vr6);
	eval 'sub vr7 () {7;}' unless defined(&vr7);
	eval 'sub vr8 () {8;}' unless defined(&vr8);
	eval 'sub vr9 () {9;}' unless defined(&vr9);
	eval 'sub vr10 () {10;}' unless defined(&vr10);
	eval 'sub vr11 () {11;}' unless defined(&vr11);
	eval 'sub vr12 () {12;}' unless defined(&vr12);
	eval 'sub vr13 () {13;}' unless defined(&vr13);
	eval 'sub vr14 () {14;}' unless defined(&vr14);
	eval 'sub vr15 () {15;}' unless defined(&vr15);
	eval 'sub vr16 () {16;}' unless defined(&vr16);
	eval 'sub vr17 () {17;}' unless defined(&vr17);
	eval 'sub vr18 () {18;}' unless defined(&vr18);
	eval 'sub vr19 () {19;}' unless defined(&vr19);
	eval 'sub vr20 () {20;}' unless defined(&vr20);
	eval 'sub vr21 () {21;}' unless defined(&vr21);
	eval 'sub vr22 () {22;}' unless defined(&vr22);
	eval 'sub vr23 () {23;}' unless defined(&vr23);
	eval 'sub vr24 () {24;}' unless defined(&vr24);
	eval 'sub vr25 () {25;}' unless defined(&vr25);
	eval 'sub vr26 () {26;}' unless defined(&vr26);
	eval 'sub vr27 () {27;}' unless defined(&vr27);
	eval 'sub vr28 () {28;}' unless defined(&vr28);
	eval 'sub vr29 () {29;}' unless defined(&vr29);
	eval 'sub vr30 () {30;}' unless defined(&vr30);
	eval 'sub vr31 () {31;}' unless defined(&vr31);
	eval 'sub evr0 () {0;}' unless defined(&evr0);
	eval 'sub evr1 () {1;}' unless defined(&evr1);
	eval 'sub evr2 () {2;}' unless defined(&evr2);
	eval 'sub evr3 () {3;}' unless defined(&evr3);
	eval 'sub evr4 () {4;}' unless defined(&evr4);
	eval 'sub evr5 () {5;}' unless defined(&evr5);
	eval 'sub evr6 () {6;}' unless defined(&evr6);
	eval 'sub evr7 () {7;}' unless defined(&evr7);
	eval 'sub evr8 () {8;}' unless defined(&evr8);
	eval 'sub evr9 () {9;}' unless defined(&evr9);
	eval 'sub evr10 () {10;}' unless defined(&evr10);
	eval 'sub evr11 () {11;}' unless defined(&evr11);
	eval 'sub evr12 () {12;}' unless defined(&evr12);
	eval 'sub evr13 () {13;}' unless defined(&evr13);
	eval 'sub evr14 () {14;}' unless defined(&evr14);
	eval 'sub evr15 () {15;}' unless defined(&evr15);
	eval 'sub evr16 () {16;}' unless defined(&evr16);
	eval 'sub evr17 () {17;}' unless defined(&evr17);
	eval 'sub evr18 () {18;}' unless defined(&evr18);
	eval 'sub evr19 () {19;}' unless defined(&evr19);
	eval 'sub evr20 () {20;}' unless defined(&evr20);
	eval 'sub evr21 () {21;}' unless defined(&evr21);
	eval 'sub evr22 () {22;}' unless defined(&evr22);
	eval 'sub evr23 () {23;}' unless defined(&evr23);
	eval 'sub evr24 () {24;}' unless defined(&evr24);
	eval 'sub evr25 () {25;}' unless defined(&evr25);
	eval 'sub evr26 () {26;}' unless defined(&evr26);
	eval 'sub evr27 () {27;}' unless defined(&evr27);
	eval 'sub evr28 () {28;}' unless defined(&evr28);
	eval 'sub evr29 () {29;}' unless defined(&evr29);
	eval 'sub evr30 () {30;}' unless defined(&evr30);
	eval 'sub evr31 () {31;}' unless defined(&evr31);
	eval 'sub N_FUN () {36;}' unless defined(&N_FUN);
	eval 'sub N_RSYM () {64;}' unless defined(&N_RSYM);
	eval 'sub N_SLINE () {68;}' unless defined(&N_SLINE);
	eval 'sub N_SO () {100;}' unless defined(&N_SO);
    }
}
1;
