require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_POWERPC_RTAS_H)) {
    eval 'sub _POWERPC_RTAS_H () {1;}' unless defined(&_POWERPC_RTAS_H);
    if(defined(&__KERNEL__)) {
	require 'linux/spinlock.ph';
	require 'asm/page.ph';
	eval 'sub RTAS_UNKNOWN_SERVICE () {(-1);}' unless defined(&RTAS_UNKNOWN_SERVICE);
	eval 'sub RTAS_INSTANTIATE_MAX () {(1<<30);}' unless defined(&RTAS_INSTANTIATE_MAX);
	eval 'sub RTAS_RMOBUF_MAX () {(64* 1024);}' unless defined(&RTAS_RMOBUF_MAX);
	eval 'sub RTAS_BUSY () {-2;}' unless defined(&RTAS_BUSY);
	eval 'sub RTAS_EXTENDED_DELAY_MIN () {9900;}' unless defined(&RTAS_EXTENDED_DELAY_MIN);
	eval 'sub RTAS_EXTENDED_DELAY_MAX () {9905;}' unless defined(&RTAS_EXTENDED_DELAY_MAX);
	eval 'sub RTAS_INTERNAL_ERROR () {0x80000000;}' unless defined(&RTAS_INTERNAL_ERROR);
	eval 'sub RTAS_EPOW_WARNING () {0x40000000;}' unless defined(&RTAS_EPOW_WARNING);
	eval 'sub RTAS_POWERMGM_EVENTS () {0x20000000;}' unless defined(&RTAS_POWERMGM_EVENTS);
	eval 'sub RTAS_HOTPLUG_EVENTS () {0x10000000;}' unless defined(&RTAS_HOTPLUG_EVENTS);
	eval 'sub RTAS_EVENT_SCAN_ALL_EVENTS () {0xf0000000;}' unless defined(&RTAS_EVENT_SCAN_ALL_EVENTS);
	eval 'sub RTAS_SEVERITY_FATAL () {0x5;}' unless defined(&RTAS_SEVERITY_FATAL);
	eval 'sub RTAS_SEVERITY_ERROR () {0x4;}' unless defined(&RTAS_SEVERITY_ERROR);
	eval 'sub RTAS_SEVERITY_ERROR_SYNC () {0x3;}' unless defined(&RTAS_SEVERITY_ERROR_SYNC);
	eval 'sub RTAS_SEVERITY_WARNING () {0x2;}' unless defined(&RTAS_SEVERITY_WARNING);
	eval 'sub RTAS_SEVERITY_EVENT () {0x1;}' unless defined(&RTAS_SEVERITY_EVENT);
	eval 'sub RTAS_SEVERITY_NO_ERROR () {0x;}' unless defined(&RTAS_SEVERITY_NO_ERROR);
	eval 'sub RTAS_DISP_FULLY_RECOVERED () {0x;}' unless defined(&RTAS_DISP_FULLY_RECOVERED);
	eval 'sub RTAS_DISP_LIMITED_RECOVERY () {0x1;}' unless defined(&RTAS_DISP_LIMITED_RECOVERY);
	eval 'sub RTAS_DISP_NOT_RECOVERED () {0x2;}' unless defined(&RTAS_DISP_NOT_RECOVERED);
	eval 'sub RTAS_INITIATOR_UNKNOWN () {0x;}' unless defined(&RTAS_INITIATOR_UNKNOWN);
	eval 'sub RTAS_INITIATOR_CPU () {0x1;}' unless defined(&RTAS_INITIATOR_CPU);
	eval 'sub RTAS_INITIATOR_PCI () {0x2;}' unless defined(&RTAS_INITIATOR_PCI);
	eval 'sub RTAS_INITIATOR_ISA () {0x3;}' unless defined(&RTAS_INITIATOR_ISA);
	eval 'sub RTAS_INITIATOR_MEMORY () {0x4;}' unless defined(&RTAS_INITIATOR_MEMORY);
	eval 'sub RTAS_INITIATOR_POWERMGM () {0x5;}' unless defined(&RTAS_INITIATOR_POWERMGM);
	eval 'sub RTAS_TARGET_UNKNOWN () {0x;}' unless defined(&RTAS_TARGET_UNKNOWN);
	eval 'sub RTAS_TARGET_CPU () {0x1;}' unless defined(&RTAS_TARGET_CPU);
	eval 'sub RTAS_TARGET_PCI () {0x2;}' unless defined(&RTAS_TARGET_PCI);
	eval 'sub RTAS_TARGET_ISA () {0x3;}' unless defined(&RTAS_TARGET_ISA);
	eval 'sub RTAS_TARGET_MEMORY () {0x4;}' unless defined(&RTAS_TARGET_MEMORY);
	eval 'sub RTAS_TARGET_POWERMGM () {0x5;}' unless defined(&RTAS_TARGET_POWERMGM);
	eval 'sub RTAS_TYPE_RETRY () {0x1;}' unless defined(&RTAS_TYPE_RETRY);
	eval 'sub RTAS_TYPE_TCE_ERR () {0x2;}' unless defined(&RTAS_TYPE_TCE_ERR);
	eval 'sub RTAS_TYPE_INTERN_DEV_FAIL () {0x3;}' unless defined(&RTAS_TYPE_INTERN_DEV_FAIL);
	eval 'sub RTAS_TYPE_TIMEOUT () {0x4;}' unless defined(&RTAS_TYPE_TIMEOUT);
	eval 'sub RTAS_TYPE_DATA_PARITY () {0x5;}' unless defined(&RTAS_TYPE_DATA_PARITY);
	eval 'sub RTAS_TYPE_ADDR_PARITY () {0x6;}' unless defined(&RTAS_TYPE_ADDR_PARITY);
	eval 'sub RTAS_TYPE_CACHE_PARITY () {0x7;}' unless defined(&RTAS_TYPE_CACHE_PARITY);
	eval 'sub RTAS_TYPE_ADDR_INVALID () {0x8;}' unless defined(&RTAS_TYPE_ADDR_INVALID);
	eval 'sub RTAS_TYPE_ECC_UNCORR () {0x9;}' unless defined(&RTAS_TYPE_ECC_UNCORR);
	eval 'sub RTAS_TYPE_ECC_CORR () {0xa;}' unless defined(&RTAS_TYPE_ECC_CORR);
	eval 'sub RTAS_TYPE_EPOW () {0x40;}' unless defined(&RTAS_TYPE_EPOW);
	eval 'sub RTAS_TYPE_PLATFORM () {0xe0;}' unless defined(&RTAS_TYPE_PLATFORM);
	eval 'sub RTAS_TYPE_IO () {0xe1;}' unless defined(&RTAS_TYPE_IO);
	eval 'sub RTAS_TYPE_INFO () {0xe2;}' unless defined(&RTAS_TYPE_INFO);
	eval 'sub RTAS_TYPE_DEALLOC () {0xe3;}' unless defined(&RTAS_TYPE_DEALLOC);
	eval 'sub RTAS_TYPE_DUMP () {0xe4;}' unless defined(&RTAS_TYPE_DUMP);
	eval 'sub RTAS_TYPE_PMGM_POWER_SW_ON () {0x60;}' unless defined(&RTAS_TYPE_PMGM_POWER_SW_ON);
	eval 'sub RTAS_TYPE_PMGM_POWER_SW_OFF () {0x61;}' unless defined(&RTAS_TYPE_PMGM_POWER_SW_OFF);
	eval 'sub RTAS_TYPE_PMGM_LID_OPEN () {0x62;}' unless defined(&RTAS_TYPE_PMGM_LID_OPEN);
	eval 'sub RTAS_TYPE_PMGM_LID_CLOSE () {0x63;}' unless defined(&RTAS_TYPE_PMGM_LID_CLOSE);
	eval 'sub RTAS_TYPE_PMGM_SLEEP_BTN () {0x64;}' unless defined(&RTAS_TYPE_PMGM_SLEEP_BTN);
	eval 'sub RTAS_TYPE_PMGM_WAKE_BTN () {0x65;}' unless defined(&RTAS_TYPE_PMGM_WAKE_BTN);
	eval 'sub RTAS_TYPE_PMGM_BATTERY_WARN () {0x66;}' unless defined(&RTAS_TYPE_PMGM_BATTERY_WARN);
	eval 'sub RTAS_TYPE_PMGM_BATTERY_CRIT () {0x67;}' unless defined(&RTAS_TYPE_PMGM_BATTERY_CRIT);
	eval 'sub RTAS_TYPE_PMGM_SWITCH_TO_BAT () {0x68;}' unless defined(&RTAS_TYPE_PMGM_SWITCH_TO_BAT);
	eval 'sub RTAS_TYPE_PMGM_SWITCH_TO_AC () {0x69;}' unless defined(&RTAS_TYPE_PMGM_SWITCH_TO_AC);
	eval 'sub RTAS_TYPE_PMGM_KBD_OR_MOUSE () {0x6a;}' unless defined(&RTAS_TYPE_PMGM_KBD_OR_MOUSE);
	eval 'sub RTAS_TYPE_PMGM_ENCLOS_OPEN () {0x6b;}' unless defined(&RTAS_TYPE_PMGM_ENCLOS_OPEN);
	eval 'sub RTAS_TYPE_PMGM_ENCLOS_CLOSED () {0x6c;}' unless defined(&RTAS_TYPE_PMGM_ENCLOS_CLOSED);
	eval 'sub RTAS_TYPE_PMGM_RING_INDICATE () {0x6d;}' unless defined(&RTAS_TYPE_PMGM_RING_INDICATE);
	eval 'sub RTAS_TYPE_PMGM_LAN_ATTENTION () {0x6e;}' unless defined(&RTAS_TYPE_PMGM_LAN_ATTENTION);
	eval 'sub RTAS_TYPE_PMGM_TIME_ALARM () {0x6f;}' unless defined(&RTAS_TYPE_PMGM_TIME_ALARM);
	eval 'sub RTAS_TYPE_PMGM_CONFIG_CHANGE () {0x70;}' unless defined(&RTAS_TYPE_PMGM_CONFIG_CHANGE);
	eval 'sub RTAS_TYPE_PMGM_SERVICE_PROC () {0x71;}' unless defined(&RTAS_TYPE_PMGM_SERVICE_PROC);
	eval 'sub rtas_is_extended_busy {
	    my($status) = @_;
    	    eval q({ $status >= 9900 && $status <= 9909; });
	}' unless defined(&rtas_is_extended_busy);
	eval 'sub ERR_FLAG_ALREADY_LOGGED () {0x;}' unless defined(&ERR_FLAG_ALREADY_LOGGED);
	eval 'sub ERR_FLAG_BOOT () {0x1;}' unless defined(&ERR_FLAG_BOOT);
	eval 'sub ERR_TYPE_RTAS_LOG () {0x2;}' unless defined(&ERR_TYPE_RTAS_LOG);
	eval 'sub ERR_TYPE_KERNEL_PANIC () {0x4;}' unless defined(&ERR_TYPE_KERNEL_PANIC);
	eval 'sub ERR_TYPE_MASK () {( &ERR_TYPE_RTAS_LOG |  &ERR_TYPE_KERNEL_PANIC);}' unless defined(&ERR_TYPE_MASK);
	eval 'sub RTAS_DEBUG () { &KERN_DEBUG "RTAS: ";}' unless defined(&RTAS_DEBUG);
	eval 'sub RTAS_ERROR_LOG_MAX () {2048;}' unless defined(&RTAS_ERROR_LOG_MAX);
	eval 'sub EVENT_SCAN_ALL_EVENTS () {0xf0000000;}' unless defined(&EVENT_SCAN_ALL_EVENTS);
	eval 'sub SURVEILLANCE_TOKEN () {9000;}' unless defined(&SURVEILLANCE_TOKEN);
	eval 'sub LOG_NUMBER () {64;}' unless defined(&LOG_NUMBER);
	eval 'sub LOG_NUMBER_MASK () {( &LOG_NUMBER-1);}' unless defined(&LOG_NUMBER_MASK);
	eval 'sub RTAS_DATA_BUF_SIZE () {4096;}' unless defined(&RTAS_DATA_BUF_SIZE);
	eval 'sub GLOBAL_INTERRUPT_QUEUE () {9005;}' unless defined(&GLOBAL_INTERRUPT_QUEUE);
    }
}
1;
