require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SMU_H)) {
    eval 'sub _SMU_H () {1;}' unless defined(&_SMU_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/list.ph';
    }
    require 'linux/types.ph';
    eval 'sub SMU_CMD_PARTITION_COMMAND () {0x3e;}' unless defined(&SMU_CMD_PARTITION_COMMAND);
    eval 'sub SMU_CMD_PARTITION_LATEST () {0x1;}' unless defined(&SMU_CMD_PARTITION_LATEST);
    eval 'sub SMU_CMD_PARTITION_BASE () {0x2;}' unless defined(&SMU_CMD_PARTITION_BASE);
    eval 'sub SMU_CMD_PARTITION_UPDATE () {0x3;}' unless defined(&SMU_CMD_PARTITION_UPDATE);
    eval 'sub SMU_CMD_FAN_COMMAND () {0x4a;}' unless defined(&SMU_CMD_FAN_COMMAND);
    eval 'sub SMU_CMD_BATTERY_COMMAND () {0x6f;}' unless defined(&SMU_CMD_BATTERY_COMMAND);
    eval 'sub SMU_CMD_GET_BATTERY_INFO () {0x;}' unless defined(&SMU_CMD_GET_BATTERY_INFO);
    eval 'sub SMU_CMD_RTC_COMMAND () {0x8e;}' unless defined(&SMU_CMD_RTC_COMMAND);
    eval 'sub SMU_CMD_RTC_SET_PWRUP_TIMER () {0x;}' unless defined(&SMU_CMD_RTC_SET_PWRUP_TIMER);
    eval 'sub SMU_CMD_RTC_GET_PWRUP_TIMER () {0x1;}' unless defined(&SMU_CMD_RTC_GET_PWRUP_TIMER);
    eval 'sub SMU_CMD_RTC_STOP_PWRUP_TIMER () {0x2;}' unless defined(&SMU_CMD_RTC_STOP_PWRUP_TIMER);
    eval 'sub SMU_CMD_RTC_SET_PRAM_BYTE_ACC () {0x20;}' unless defined(&SMU_CMD_RTC_SET_PRAM_BYTE_ACC);
    eval 'sub SMU_CMD_RTC_SET_PRAM_AUTOINC () {0x21;}' unless defined(&SMU_CMD_RTC_SET_PRAM_AUTOINC);
    eval 'sub SMU_CMD_RTC_SET_PRAM_LO_BYTES () {0x22;}' unless defined(&SMU_CMD_RTC_SET_PRAM_LO_BYTES);
    eval 'sub SMU_CMD_RTC_SET_PRAM_HI_BYTES () {0x23;}' unless defined(&SMU_CMD_RTC_SET_PRAM_HI_BYTES);
    eval 'sub SMU_CMD_RTC_GET_PRAM_BYTE () {0x28;}' unless defined(&SMU_CMD_RTC_GET_PRAM_BYTE);
    eval 'sub SMU_CMD_RTC_GET_PRAM_LO_BYTES () {0x29;}' unless defined(&SMU_CMD_RTC_GET_PRAM_LO_BYTES);
    eval 'sub SMU_CMD_RTC_GET_PRAM_HI_BYTES () {0x2a;}' unless defined(&SMU_CMD_RTC_GET_PRAM_HI_BYTES);
    eval 'sub SMU_CMD_RTC_SET_DATETIME () {0x80;}' unless defined(&SMU_CMD_RTC_SET_DATETIME);
    eval 'sub SMU_CMD_RTC_GET_DATETIME () {0x81;}' unless defined(&SMU_CMD_RTC_GET_DATETIME);
    eval 'sub SMU_CMD_I2C_COMMAND () {0x9a;}' unless defined(&SMU_CMD_I2C_COMMAND);
    eval 'sub SMU_I2C_TRANSFER_SIMPLE () {0x;}' unless defined(&SMU_I2C_TRANSFER_SIMPLE);
    eval 'sub SMU_I2C_TRANSFER_STDSUB () {0x1;}' unless defined(&SMU_I2C_TRANSFER_STDSUB);
    eval 'sub SMU_I2C_TRANSFER_COMBINED () {0x2;}' unless defined(&SMU_I2C_TRANSFER_COMBINED);
    eval 'sub SMU_CMD_POWER_COMMAND () {0xaa;}' unless defined(&SMU_CMD_POWER_COMMAND);
    eval 'sub SMU_CMD_POWER_RESTART () {"RESTART";}' unless defined(&SMU_CMD_POWER_RESTART);
    eval 'sub SMU_CMD_POWER_SHUTDOWN () {"SHUTDOWN";}' unless defined(&SMU_CMD_POWER_SHUTDOWN);
    eval 'sub SMU_CMD_POWER_VOLTAGE_SLEW () {"VSLEW";}' unless defined(&SMU_CMD_POWER_VOLTAGE_SLEW);
    eval 'sub SMU_CMD_READ_ADC () {0xd8;}' unless defined(&SMU_CMD_READ_ADC);
    eval 'sub SMU_CMD_MISC_df_COMMAND () {0xdf;}' unless defined(&SMU_CMD_MISC_df_COMMAND);
    eval 'sub SMU_CMD_MISC_df_SET_DISPLAY_LIT () {0x2;}' unless defined(&SMU_CMD_MISC_df_SET_DISPLAY_LIT);
    eval 'sub SMU_CMD_MISC_df_NMI_OPTION () {0x4;}' unless defined(&SMU_CMD_MISC_df_NMI_OPTION);
    eval 'sub SMU_CMD_VERSION_COMMAND () {0xea;}' unless defined(&SMU_CMD_VERSION_COMMAND);
    eval 'sub SMU_CMD_MISC_ee_COMMAND () {0xee;}' unless defined(&SMU_CMD_MISC_ee_COMMAND);
    eval 'sub SMU_CMD_MISC_ee_GET_DATABLOCK_REC () {0x2;}' unless defined(&SMU_CMD_MISC_ee_GET_DATABLOCK_REC);
    eval 'sub SMU_CMD_MISC_ee_LEDS_CTRL () {0x4;}' unless defined(&SMU_CMD_MISC_ee_LEDS_CTRL);
    eval 'sub SMU_CMD_MISC_ee_GET_DATA () {0x5;}' unless defined(&SMU_CMD_MISC_ee_GET_DATA);
    if(defined(&__KERNEL__)) {
	eval 'sub smu_spinwait_simple {
	    my($scmd) = @_;
    	    eval q({  &smu_spinwait_cmd( ($scmd->{cmd})); });
	}' unless defined(&smu_spinwait_simple);
	eval 'sub SMU_I2C_READ_MAX () {0x1d;}' unless defined(&SMU_I2C_READ_MAX);
	eval 'sub SMU_I2C_WRITE_MAX () {0x15;}' unless defined(&SMU_I2C_WRITE_MAX);
    }
    eval 'sub SMU_U16_MIX {
        my($x) = @_;
	    eval q( &le16_to_cpu($x););
    }' unless defined(&SMU_U16_MIX);
    eval 'sub SMU_U32_MIX {
        my($x) = @_;
	    eval q((((($x) & 0xff00ff00) >> 8)|((($x) & 0xff00ff) << 8)));
    }' unless defined(&SMU_U32_MIX);
    eval 'sub SMU_SDB_FVT_ID () {0x12;}' unless defined(&SMU_SDB_FVT_ID);
    eval 'sub SMU_SDB_CPUVCP_ID () {0x21;}' unless defined(&SMU_SDB_CPUVCP_ID);
    eval 'sub SMU_SDB_CPUDIODE_ID () {0x18;}' unless defined(&SMU_SDB_CPUDIODE_ID);
    eval 'sub SMU_SDB_SLOTSPOW_ID () {0x78;}' unless defined(&SMU_SDB_SLOTSPOW_ID);
    eval 'sub SMU_SDB_SENSORTREE_ID () {0x25;}' unless defined(&SMU_SDB_SENSORTREE_ID);
    eval 'sub SMU_SDB_CPUPIDDATA_ID () {0x17;}' unless defined(&SMU_SDB_CPUPIDDATA_ID);
    eval 'sub SMU_SDB_DEBUG_SWITCHES_ID () {0x5;}' unless defined(&SMU_SDB_DEBUG_SWITCHES_ID);
    if(defined(&__KERNEL__)) {
    }
    eval 'sub SMU_CMDTYPE_SMU () {0;}' unless defined(&SMU_CMDTYPE_SMU);
    eval 'sub SMU_CMDTYPE_WANTS_EVENTS () {1;}' unless defined(&SMU_CMDTYPE_WANTS_EVENTS);
    eval 'sub SMU_CMDTYPE_GET_PARTITION () {2;}' unless defined(&SMU_CMDTYPE_GET_PARTITION);
}
1;
