require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_SYSTEM_H)) {
    eval 'sub _ASM_POWERPC_SYSTEM_H () {1;}' unless defined(&_ASM_POWERPC_SYSTEM_H);
    require 'linux/kernel.ph';
    require 'asm/hw_irq.ph';
    require 'asm/atomic.ph';
    eval 'sub mb () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&mb);
    eval 'sub rmb () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&rmb);
    eval 'sub wmb () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&wmb);
    eval 'sub read_barrier_depends () {
        eval q( &do { }  &while(0));
    }' unless defined(&read_barrier_depends);
    eval 'sub set_mb {
        my($var, $value) = @_;
	    eval q( &do { $var = $value;  &mb(); }  &while (0));
    }' unless defined(&set_mb);
    eval 'sub set_wmb {
        my($var, $value) = @_;
	    eval q( &do { $var = $value;  &wmb(); }  &while (0));
    }' unless defined(&set_wmb);
    if(defined(&CONFIG_SMP)) {
	eval 'sub smp_mb () {
	    eval q( &mb());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &rmb());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&smp_wmb);
	eval 'sub smp_read_barrier_depends () {
	    eval q( &read_barrier_depends());
	}' unless defined(&smp_read_barrier_depends);
    } else {
	eval 'sub smp_mb () {
	    eval q( &barrier());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &barrier());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &barrier());
	}' unless defined(&smp_wmb);
	eval 'sub smp_read_barrier_depends () {
	    eval q( &do { }  &while(0));
	}' unless defined(&smp_read_barrier_depends);
    }
    if(defined(&__KERNEL__)) {
	if(defined(&CONFIG_DEBUGGER)) {
	    eval 'sub DEBUGGER_BOILERPLATE {
	        my($__NAME) = @_;
    		eval q( &static  &__inline__ \'int\' $__NAME(\'struct pt_regs\' * &regs) {  &if ( &unlikely( &__  $__NAME))  &return  &__  $__NAME( &regs);  &return 0; });
	    }' unless defined(&DEBUGGER_BOILERPLATE);
	    if(defined(&CONFIG_XMON)) {
	    }
	} else {
	    if(defined(&CONFIG_6xx)) {
	    } else {
		eval 'sub _get_L2CR () {
		    eval q(0);
		}' unless defined(&_get_L2CR);
		eval 'sub _get_L3CR () {
		    eval q(0);
		}' unless defined(&_get_L3CR);
		eval 'sub _set_L2CR {
		    my($val) = @_;
    		    eval q( &do { }  &while(0));
		}' unless defined(&_set_L2CR);
		eval 'sub _set_L3CR {
		    my($val) = @_;
    		    eval q( &do { }  &while(0));
		}' unless defined(&_set_L3CR);
	    }
	    unless(defined(&CONFIG_SMP)) {
	    } else {
		eval 'sub discard_lazy_cpu_state {
		    my($void) = @_;
    		    eval q({ });
		}' unless defined(&discard_lazy_cpu_state);
	    }
	    if(defined(&CONFIG_ALTIVEC)) {
	    } else {
		eval 'sub flush_altivec_to_thread {
		    my($t) = @_;
    		    eval q({ });
		}' unless defined(&flush_altivec_to_thread);
	    }
	    if(defined(&CONFIG_SPE)) {
	    } else {
		eval 'sub flush_spe_to_thread {
		    my($t) = @_;
    		    eval q({ });
		}' unless defined(&flush_spe_to_thread);
	    }
	    if(defined(&CONFIG_BOOKE_WDT)) {
	    }
	    eval 'sub switch_to {
	        my($prev, $next, $last) = @_;
    		eval q((($last) =  &__switch_to(($prev), ($next))));
	    }' unless defined(&switch_to);
	    if(defined(&CONFIG_PPC64)) {
		eval 'sub __xchg_u64 {
		    my($p,$val) = @_;
    		    eval q(\\"(assembly code)\\");
		}' unless defined(&__xchg_u64);
	    }
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub __xchg {
	        my($ptr,$x,$size) = @_;
    		eval q({  &switch ($size) {  &case 4:  &__xchg_u32($ptr, $x); }  &__xchg_called_with_bad_pointer(); $x; });
	    }' unless defined(&__xchg);
	    eval 'sub xchg {
	        my($ptr,$x) = @_;
    		eval q(({  &__typeof__(*($ptr))  &_x_ = ($x); ( &__typeof__(*($ptr)))  &__xchg(($ptr),  &_x_, $sizeof{($ptr)}); }));
	    }' unless defined(&xchg);
	    eval 'sub tas {
	        my($ptr) = @_;
    		eval q(( &xchg(($ptr),1)));
	    }' unless defined(&tas);
	    eval 'sub __HAVE_ARCH_CMPXCHG () {1;}' unless defined(&__HAVE_ARCH_CMPXCHG);
	    eval 'sub __cmpxchg_u32 {
	        my($p,$old,$new) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&__cmpxchg_u32);
	    if(defined(&CONFIG_PPC64)) {
		eval 'sub __cmpxchg_u64 {
		    my($p,$old,$new) = @_;
    		    eval q(\\"(assembly code)\\");
		}' unless defined(&__cmpxchg_u64);
	    }
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub __cmpxchg {
	        my($ptr,$old,$new,$size) = @_;
    		eval q({  &switch ($size) {  &case 4:  &__cmpxchg_u32($ptr, $old, $new); }  &__cmpxchg_called_with_bad_pointer(); $old; });
	    }' unless defined(&__cmpxchg);
	    eval 'sub cmpxchg {
	        my($ptr,$o,$n) = @_;
    		eval q(({  &__typeof__(*($ptr))  &_o_ = ($o);  &__typeof__(*($ptr))  &_n_ = ($n); ( &__typeof__(*($ptr)))  &__cmpxchg(($ptr),  &_o_,  &_n_, $sizeof{($ptr)}); }));
	    }' unless defined(&cmpxchg);
	    if(defined(&CONFIG_PPC64)) {
		eval 'sub NET_IP_ALIGN () {0;}' unless defined(&NET_IP_ALIGN);
		eval 'sub NET_SKB_PAD () { &L1_CACHE_BYTES;}' unless defined(&NET_SKB_PAD);
	    }
	    eval 'sub arch_align_stack {
	        my($x) = @_;
    		eval q(($x));
	    }' unless defined(&arch_align_stack);
	    eval 'sub PTRRELOC {
	        my($x) = @_;
    		eval q((( &typeof($x))  &add_reloc_offset(($x))));
	    }' unless defined(&PTRRELOC);
	    eval 'sub create_instruction {
	        my($addr,$instr) = @_;
    		eval q({ \'unsigned int\' * &p;  &p = $addr; * &p = $instr;  &asm (\\"dcbst 0, %0; sync; icbi 0,%0; sync; isync\\" : : \\"r\\" ( &p)); });
	    }' unless defined(&create_instruction);
	    eval 'sub BRANCH_SET_LINK () {0x1;}' unless defined(&BRANCH_SET_LINK);
	    eval 'sub BRANCH_ABSOLUTE () {0x2;}' unless defined(&BRANCH_ABSOLUTE);
	    eval 'sub create_branch {
	        my($addr,$target,$flags) = @_;
    		eval q({ my $instruction;  &if (! ($flags &  &BRANCH_ABSOLUTE)) $target = $target - $addr;  $instruction = 0x48000000 | ($flags & 0x3) | ($target & 0x3fffffc);  &create_instruction($addr,  $instruction); });
	    }' unless defined(&create_branch);
# some #ifdef were dropped here -- fill in the blanks
	    eval 'sub create_function_call {
	        my($addr,$func) = @_;
    		eval q({ my $func_addr;  &create_branch($addr,  $func_addr,  &BRANCH_SET_LINK); });
	    }' unless defined(&create_function_call);
	    if(defined(&CONFIG_VIRT_CPU_ACCOUNTING)) {
	    }
	}
    }
1;
