require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_CODA_FS)) {
    eval 'sub _LINUX_CODA_FS () {1;}' unless defined(&_LINUX_CODA_FS);
    require 'linux/kernel.ph';
    require 'linux/param.ph';
    require 'linux/mm.ph';
    require 'linux/vmalloc.ph';
    require 'linux/slab.ph';
    require 'linux/wait.ph';
    require 'linux/types.ph';
    require 'linux/fs.ph';
    require 'linux/coda_fs_i.ph';
    eval 'sub CODA_ALLOC {
        my($ptr, $cast, $size) = @_;
	    eval q( &do {  &if ($size <  &PAGE_SIZE) $ptr = ($cast) &kmalloc( $size,  &GFP_KERNEL);  &else $ptr = ($cast) &vmalloc( $size);  &if (!$ptr)  &printk(\\"kernel malloc returns 0 at %s:%d\\\\n\\",  &__FILE__,  &__LINE__);  &else  &memset( $ptr, 0, $size ); }  &while (0));
    }' unless defined(&CODA_ALLOC);
    eval 'sub CODA_FREE {
        my($ptr,$size) = @_;
	    eval q( &do {  &if ($size <  &PAGE_SIZE)  &kfree(($ptr));  &else  &vfree(($ptr)); }  &while (0));
    }' unless defined(&CODA_FREE);
    eval 'sub CodaFid {
        eval q(* &coda_i2f(\'struct inode\' * &inode) { ( &ITOC( &inode)-> &c_fid); });
    }' unless defined(&CodaFid);
    eval 'sub char {
        eval q(* &coda_i2s(\'struct inode\' * &inode) {  &coda_f2s(( &ITOC( &inode)-> &c_fid)); });
    }' unless defined(&char);
}
1;
