require '_h2ph_pre.ph';

no warnings 'redefine';

require 'linux/config.ph';
require 'linux/fb.ph';
unless(defined(&CLCD_TIM0)) {
    sub CLCD_TIM0 () {	0x;}
}
unless(defined(&CLCD_TIM1)) {
    sub CLCD_TIM1 () {	0x4;}
}
unless(defined(&CLCD_TIM2)) {
    sub CLCD_TIM2 () {	0x8;}
}
unless(defined(&CLCD_TIM3)) {
    sub CLCD_TIM3 () {	0xc;}
}
unless(defined(&CLCD_UBAS)) {
    sub CLCD_UBAS () {	0x10;}
}
unless(defined(&CLCD_LBAS)) {
    sub CLCD_LBAS () {	0x14;}
}
if(!defined( &CONFIG_ARCH_VERSATILE)  && !defined( &CONFIG_ARCH_REALVIEW)) {
    eval 'sub CLCD_IENB () {0x18;}' unless defined(&CLCD_IENB);
    eval 'sub CLCD_CNTL () {0x1c;}' unless defined(&CLCD_CNTL);
} else {
    eval 'sub CLCD_IENB () {0x1c;}' unless defined(&CLCD_IENB);
    eval 'sub CLCD_CNTL () {0x18;}' unless defined(&CLCD_CNTL);
}
unless(defined(&CLCD_STAT)) {
    sub CLCD_STAT () {	0x20;}
}
unless(defined(&CLCD_INTR)) {
    sub CLCD_INTR () {	0x24;}
}
unless(defined(&CLCD_UCUR)) {
    sub CLCD_UCUR () {	0x28;}
}
unless(defined(&CLCD_LCUR)) {
    sub CLCD_LCUR () {	0x2c;}
}
unless(defined(&CLCD_PALL)) {
    sub CLCD_PALL () {	0x200;}
}
unless(defined(&CLCD_PALETTE)) {
    sub CLCD_PALETTE () {	0x200;}
}
unless(defined(&TIM2_CLKSEL)) {
    sub TIM2_CLKSEL () {	(1<< 5);}
}
unless(defined(&TIM2_IVS)) {
    sub TIM2_IVS () {	(1<< 11);}
}
unless(defined(&TIM2_IHS)) {
    sub TIM2_IHS () {	(1<< 12);}
}
unless(defined(&TIM2_IPC)) {
    sub TIM2_IPC () {	(1<< 13);}
}
unless(defined(&TIM2_IOE)) {
    sub TIM2_IOE () {	(1<< 14);}
}
unless(defined(&TIM2_BCD)) {
    sub TIM2_BCD () {	(1<< 26);}
}
unless(defined(&CNTL_LCDEN)) {
    sub CNTL_LCDEN () {	(1<< 0);}
}
unless(defined(&CNTL_LCDBPP1)) {
    sub CNTL_LCDBPP1 () {	(0<< 1);}
}
unless(defined(&CNTL_LCDBPP2)) {
    sub CNTL_LCDBPP2 () {	(1<< 1);}
}
unless(defined(&CNTL_LCDBPP4)) {
    sub CNTL_LCDBPP4 () {	(2<< 1);}
}
unless(defined(&CNTL_LCDBPP8)) {
    sub CNTL_LCDBPP8 () {	(3<< 1);}
}
unless(defined(&CNTL_LCDBPP16)) {
    sub CNTL_LCDBPP16 () {	(4<< 1);}
}
unless(defined(&CNTL_LCDBPP16_565)) {
    sub CNTL_LCDBPP16_565 () {	(6<< 1);}
}
unless(defined(&CNTL_LCDBPP24)) {
    sub CNTL_LCDBPP24 () {	(5<< 1);}
}
unless(defined(&CNTL_LCDBW)) {
    sub CNTL_LCDBW () {	(1<< 4);}
}
unless(defined(&CNTL_LCDTFT)) {
    sub CNTL_LCDTFT () {	(1<< 5);}
}
unless(defined(&CNTL_LCDMONO8)) {
    sub CNTL_LCDMONO8 () {	(1<< 6);}
}
unless(defined(&CNTL_LCDDUAL)) {
    sub CNTL_LCDDUAL () {	(1<< 7);}
}
unless(defined(&CNTL_BGR)) {
    sub CNTL_BGR () {	(1<< 8);}
}
unless(defined(&CNTL_BEBO)) {
    sub CNTL_BEBO () {	(1<< 9);}
}
unless(defined(&CNTL_BEPO)) {
    sub CNTL_BEPO () {	(1<< 10);}
}
unless(defined(&CNTL_LCDPWR)) {
    sub CNTL_LCDPWR () {	(1<< 11);}
}
unless(defined(&CNTL_LCDVCOMP)) {
    sub CNTL_LCDVCOMP {
	my($x) = @_;
	eval q((($x) << 12));
    }
}
unless(defined(&CNTL_LDMAFIFOTIME)) {
    sub CNTL_LDMAFIFOTIME () {	(1<< 15);}
}
unless(defined(&CNTL_WATERMARK)) {
    sub CNTL_WATERMARK () {	(1<< 16);}
}
unless(defined(&clcdfb_decode)) {
    sub clcdfb_decode {
	my($fb,$regs) = @_;
	eval q({  &__u32  &val,  &cpl;  &val = (( ($fb->{fb}->{var}->{xres}) / 16) - 1) << 2;  &val |= ( ($fb->{fb}->{var}->{hsync_len}) - 1) << 8;  &val |= ( ($fb->{fb}->{var}->{right_margin}) - 1) << 16;  &val |= ( ($fb->{fb}->{var}->{left_margin}) - 1) << 24;  ($regs->{tim0}) =  &val;  &val =  ($fb->{fb}->{var}->{yres});  &if ( ($fb->{panel}->{cntl}) &  &CNTL_LCDDUAL)  &val /= 2;  &val -= 1;  &val |= ( ($fb->{fb}->{var}->{vsync_len}) - 1) << 10;  &val |=  ($fb->{fb}->{var}->{lower_margin}) << 16;  &val |=  ($fb->{fb}->{var}->{upper_margin}) << 24;  ($regs->{tim1}) =  &val;  &val =  ($fb->{panel}->{tim2});  &val |=  ($fb->{fb}->{var}->{sync}) &  &FB_SYNC_HOR_HIGH_ACT ? 0:  &TIM2_IHS;  &val |=  ($fb->{fb}->{var}->{sync}) &  &FB_SYNC_VERT_HIGH_ACT ? 0:  &TIM2_IVS;  &cpl =  ($fb->{fb}->{var}->{xres_virtual});  &if ( ($fb->{panel}->{cntl}) &  &CNTL_LCDTFT) ;  &else  &if (! ($fb->{fb}->{var}->{grayscale}))  &cpl =  &cpl * 8/ 3;  &else  &if ( ($fb->{panel}->{cntl}) &  &CNTL_LCDMONO8)  &cpl /= 8;  &else  &cpl /= 4;  ($regs->{tim2}) =  &val | (( &cpl - 1) << 16);  ($regs->{tim3}) =  ($fb->{panel}->{tim3});  &val =  ($fb->{panel}->{cntl});  &if ( ($fb->{fb}->{var}->{grayscale}))  &val |=  &CNTL_LCDBW;  &switch ( ($fb->{fb}->{var}->{bits_per_pixel})) {  &case 1:  &val |=  &CNTL_LCDBPP1;  &break;  &case 2:  &val |=  &CNTL_LCDBPP2;  &break;  &case 4:  &val |=  &CNTL_LCDBPP4;  &break;  &case 8:  &val |=  &CNTL_LCDBPP8;  &break;  &case 16:  &if (( ($fb->{dev}->{periphid}) & 0xfffff) == 0x41110)  &val |=  &CNTL_LCDBPP16;  &else  &if ( ($fb->{fb}->{var}->{green}->{length}) == 5)  &val |=  &CNTL_LCDBPP16;  &else  &val |=  &CNTL_LCDBPP16_565;  &break;  &case 32:  &val |=  &CNTL_LCDBPP24;  &break; }  ($regs->{cntl}) =  &val;  ($regs->{pixclock}) =  ($fb->{fb}->{var}->{pixclock}); });
    }
}
unless(defined(&clcdfb_check)) {
    sub clcdfb_check {
	my($fb,$var) = @_;
	eval q({  ($var->{xres_virtual}) =  ($var->{xres}) = ( ($var->{xres}) + 15) & ~15;  ($var->{yres_virtual}) =  ($var->{yres}) = ( ($var->{yres}) + 1) & ~1;  &define  &CHECK( &e, &l, &h) ( ($var->{e}) <  &l ||  ($var->{e}) >  &h)  &if ( &CHECK( &right_margin, (5+1), 256) ||  &CHECK( &left_margin, (5+1), 256) ||  &CHECK( &hsync_len, (5+1), 256) ||  ($var->{xres}) > 4096||  ($var->{lower_margin}) > 255||  ($var->{upper_margin}) > 255||  ($var->{vsync_len}) > 32||  ($var->{yres}) > 1024) - &EINVAL;  &undef  &CHECK  &if ( ($var->{grayscale}) !=  ($fb->{fb}->{var}->{grayscale}) || ( ($var->{vmode}) &  &FB_VMODE_MASK) !=  &FB_VMODE_NONINTERLACED) - &EINVAL;  &define  &CHECK( &e) ( ($var->{e}) !=  ($fb->{fb}->{var}->{e}))  &if ( ($fb->{panel}->{fixedtimings})  && ( &CHECK( &xres) ||  &CHECK( &yres) ||  &CHECK( &bits_per_pixel) ||  &CHECK( &pixclock) ||  &CHECK( &left_margin) ||  &CHECK( &right_margin) ||  &CHECK( &upper_margin) ||  &CHECK( &lower_margin) ||  &CHECK( &hsync_len) ||  &CHECK( &vsync_len) ||  &CHECK( &sync))) - &EINVAL;  &undef  &CHECK  ($var->{nonstd}) = 0;  ($var->{accel_flags}) = 0; 0; });
    }
}
1;
