require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_BACKING_DEV_H)) {
    eval 'sub _LINUX_BACKING_DEV_H () {1;}' unless defined(&_LINUX_BACKING_DEV_H);
    require 'asm/atomic.ph';
    eval("sub BDI_pdflush () { 0; }") unless defined(&BDI_pdflush);
    eval("sub BDI_write_congested () { 1; }") unless defined(&BDI_write_congested);
    eval("sub BDI_read_congested () { 2; }") unless defined(&BDI_read_congested);
    eval("sub BDI_unused () { 3; }") unless defined(&BDI_unused);
    eval 'sub BDI_CAP_NO_ACCT_DIRTY () {0x1;}' unless defined(&BDI_CAP_NO_ACCT_DIRTY);
    eval 'sub BDI_CAP_NO_WRITEBACK () {0x2;}' unless defined(&BDI_CAP_NO_WRITEBACK);
    eval 'sub BDI_CAP_MAP_COPY () {0x4;}' unless defined(&BDI_CAP_MAP_COPY);
    eval 'sub BDI_CAP_MAP_DIRECT () {0x8;}' unless defined(&BDI_CAP_MAP_DIRECT);
    eval 'sub BDI_CAP_READ_MAP () {0x10;}' unless defined(&BDI_CAP_READ_MAP);
    eval 'sub BDI_CAP_WRITE_MAP () {0x20;}' unless defined(&BDI_CAP_WRITE_MAP);
    eval 'sub BDI_CAP_EXEC_MAP () {0x40;}' unless defined(&BDI_CAP_EXEC_MAP);
    eval 'sub BDI_CAP_VMFLAGS () {( &BDI_CAP_READ_MAP |  &BDI_CAP_WRITE_MAP |  &BDI_CAP_EXEC_MAP);}' unless defined(&BDI_CAP_VMFLAGS);
    if(defined( &VM_MAYREAD)  && ((defined(&BDI_CAP_READ_MAP) ? &BDI_CAP_READ_MAP : 0) != (defined(&VM_MAYREAD) ? &VM_MAYREAD : 0) || (defined(&BDI_CAP_WRITE_MAP) ? &BDI_CAP_WRITE_MAP : 0) != (defined(&VM_MAYWRITE) ? &VM_MAYWRITE : 0) || (defined(&BDI_CAP_EXEC_MAP) ? &BDI_CAP_EXEC_MAP : 0) != (defined(&VM_MAYEXEC) ? &VM_MAYEXEC : 0))) {
	die("please\ change\ backing_dev_info\:\:capabilities\ flags");
    }
    eval 'sub bdi_congested {
        my($bdi,$bdi_bits) = @_;
	    eval q({  &if ( ($bdi->{congested_fn}))  ($bdi->{congested_fn})( ($bdi->{congested_data}), $bdi_bits); ( ($bdi->{state}) & $bdi_bits); });
    }' unless defined(&bdi_congested);
    eval 'sub bdi_read_congested {
        my($bdi) = @_;
	    eval q({  &bdi_congested($bdi, 1<<  &BDI_read_congested); });
    }' unless defined(&bdi_read_congested);
    eval 'sub bdi_write_congested {
        my($bdi) = @_;
	    eval q({  &bdi_congested($bdi, 1<<  &BDI_write_congested); });
    }' unless defined(&bdi_write_congested);
    eval 'sub bdi_rw_congested {
        my($bdi) = @_;
	    eval q({  &bdi_congested($bdi, (1<<  &BDI_read_congested)| (1<<  &BDI_write_congested)); });
    }' unless defined(&bdi_rw_congested);
    eval 'sub bdi_cap_writeback_dirty {
        my($bdi) = @_;
	    eval q((!(($bdi)-> &capabilities &  &BDI_CAP_NO_WRITEBACK)));
    }' unless defined(&bdi_cap_writeback_dirty);
    eval 'sub bdi_cap_account_dirty {
        my($bdi) = @_;
	    eval q((!(($bdi)-> &capabilities &  &BDI_CAP_NO_ACCT_DIRTY)));
    }' unless defined(&bdi_cap_account_dirty);
    eval 'sub mapping_cap_writeback_dirty {
        my($mapping) = @_;
	    eval q( &bdi_cap_writeback_dirty(($mapping)-> &backing_dev_info));
    }' unless defined(&mapping_cap_writeback_dirty);
    eval 'sub mapping_cap_account_dirty {
        my($mapping) = @_;
	    eval q( &bdi_cap_account_dirty(($mapping)-> &backing_dev_info));
    }' unless defined(&mapping_cap_account_dirty);
}
1;
