require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_GAMEPORT_H)) {
    eval 'sub _GAMEPORT_H () {1;}' unless defined(&_GAMEPORT_H);
    require 'asm/io.ph';
    require 'linux/list.ph';
    require 'linux/mutex.ph';
    require 'linux/device.ph';
    require 'linux/timer.ph';
    eval 'sub to_gameport_port {
        my($d) = @_;
	    eval q( &container_of($d, \'struct gameport\',  &dev));
    }' unless defined(&to_gameport_port);
    eval 'sub to_gameport_driver {
        my($d) = @_;
	    eval q( &container_of($d, \'struct gameport_driver\',  &driver));
    }' unless defined(&to_gameport_driver);
    if(defined( &CONFIG_GAMEPORT) || (defined( &MODULE)  && defined( &CONFIG_GAMEPORT_MODULE))) {
	eval 'sub gameport_register_port {
	    my($gameport) = @_;
    	    eval q({  &__gameport_register_port($gameport,  &THIS_MODULE); });
	}' unless defined(&gameport_register_port);
    } else {
	eval 'sub gameport_register_port {
	    my($gameport) = @_;
    	    eval q({ ; });
	}' unless defined(&gameport_register_port);
	eval 'sub gameport_unregister_port {
	    my($gameport) = @_;
    	    eval q({ ; });
	}' unless defined(&gameport_unregister_port);
	eval 'sub gameport_set_phys {
	    my($gameport,$fmt) = @_;
    	    eval q({ ; });
	}' unless defined(&gameport_set_phys);
    }
    eval 'sub gameport {
        eval q(* &gameport_allocate_port( &void) { \'struct gameport\' * &gameport =  &kcalloc(1, $sizeof{\'struct gameport\'},  &GFP_KERNEL);  &gameport; });
    }' unless defined(&gameport);
    eval 'sub gameport_free_port {
        my($gameport) = @_;
	    eval q({  &kfree($gameport); });
    }' unless defined(&gameport_free_port);
    eval 'sub gameport_set_name {
        my($gameport,$name) = @_;
	    eval q({  &strlcpy( ($gameport->{name}), $name, $sizeof{ ($gameport->{name})}); });
    }' unless defined(&gameport_set_name);
    eval 'sub gameport_set_drvdata {
        my($gameport,$data) = @_;
	    eval q({  &dev_set_drvdata( ($gameport->{dev}), $data); });
    }' unless defined(&gameport_set_drvdata);
    eval 'sub gameport_unpin_driver {
        my($gameport) = @_;
	    eval q({  &mutex_unlock( ($gameport->{drv_mutex})); });
    }' unless defined(&gameport_unpin_driver);
    eval 'sub gameport_register_driver {
        my($drv) = @_;
	    eval q({  &__gameport_register_driver($drv,  &THIS_MODULE); });
    }' unless defined(&gameport_register_driver);
    eval 'sub GAMEPORT_MODE_DISABLED () {0;}' unless defined(&GAMEPORT_MODE_DISABLED);
    eval 'sub GAMEPORT_MODE_RAW () {1;}' unless defined(&GAMEPORT_MODE_RAW);
    eval 'sub GAMEPORT_MODE_COOKED () {2;}' unless defined(&GAMEPORT_MODE_COOKED);
    eval 'sub GAMEPORT_ID_VENDOR_ANALOG () {0x1;}' unless defined(&GAMEPORT_ID_VENDOR_ANALOG);
    eval 'sub GAMEPORT_ID_VENDOR_MADCATZ () {0x2;}' unless defined(&GAMEPORT_ID_VENDOR_MADCATZ);
    eval 'sub GAMEPORT_ID_VENDOR_LOGITECH () {0x3;}' unless defined(&GAMEPORT_ID_VENDOR_LOGITECH);
    eval 'sub GAMEPORT_ID_VENDOR_CREATIVE () {0x4;}' unless defined(&GAMEPORT_ID_VENDOR_CREATIVE);
    eval 'sub GAMEPORT_ID_VENDOR_GENIUS () {0x5;}' unless defined(&GAMEPORT_ID_VENDOR_GENIUS);
    eval 'sub GAMEPORT_ID_VENDOR_INTERACT () {0x6;}' unless defined(&GAMEPORT_ID_VENDOR_INTERACT);
    eval 'sub GAMEPORT_ID_VENDOR_MICROSOFT () {0x7;}' unless defined(&GAMEPORT_ID_VENDOR_MICROSOFT);
    eval 'sub GAMEPORT_ID_VENDOR_THRUSTMASTER () {0x8;}' unless defined(&GAMEPORT_ID_VENDOR_THRUSTMASTER);
    eval 'sub GAMEPORT_ID_VENDOR_GRAVIS () {0x9;}' unless defined(&GAMEPORT_ID_VENDOR_GRAVIS);
    eval 'sub GAMEPORT_ID_VENDOR_GUILLEMOT () {0xa;}' unless defined(&GAMEPORT_ID_VENDOR_GUILLEMOT);
    eval 'sub gameport_trigger {
        my($gameport) = @_;
	    eval q({  &if ( ($gameport->{trigger}))  ($gameport->{trigger})($gameport);  &else  &outb(0xff,  ($gameport->{io})); });
    }' unless defined(&gameport_trigger);
    eval 'sub gameport_read {
        my($gameport) = @_;
	    eval q({  &if ( ($gameport->{read}))  ($gameport->{read})($gameport);  &else  &inb( ($gameport->{io})); });
    }' unless defined(&gameport_read);
    eval 'sub gameport_cooked_read {
        my($gameport,$axes,$buttons) = @_;
	    eval q({  &if ( ($gameport->{cooked_read}))  ($gameport->{cooked_read})($gameport, $axes, $buttons);  &else -1; });
    }' unless defined(&gameport_cooked_read);
    eval 'sub gameport_calibrate {
        my($gameport,$axes,$max) = @_;
	    eval q({  &if ( ($gameport->{calibrate}))  ($gameport->{calibrate})($gameport, $axes, $max);  &else -1; });
    }' unless defined(&gameport_calibrate);
    eval 'sub gameport_time {
        my($gameport,$time) = @_;
	    eval q({ ($time *  ($gameport->{speed})) / 1000; });
    }' unless defined(&gameport_time);
    eval 'sub gameport_set_poll_handler {
        eval q((\'struct gameport\' * &gameport,  &void (* &handler)) {  ($gameport->{poll_handler}) =  &handler; });
    }' unless defined(&gameport_set_poll_handler);
    eval 'sub gameport_set_poll_interval {
        my($gameport,$msecs) = @_;
	    eval q({  ($gameport->{poll_interval}) = $msecs; });
    }' unless defined(&gameport_set_poll_interval);
}
1;
