require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_LIBATA_H__)) {
    eval 'sub __LINUX_LIBATA_H__ () {1;}' unless defined(&__LINUX_LIBATA_H__);
    require 'linux/delay.ph';
    require 'linux/interrupt.ph';
    require 'linux/pci.ph';
    require 'linux/dma-mapping.ph';
    require 'asm/io.ph';
    require 'linux/ata.ph';
    require 'linux/workqueue.ph';
    undef(&ATA_DEBUG) if defined(&ATA_DEBUG);
    undef(&ATA_VERBOSE_DEBUG) if defined(&ATA_VERBOSE_DEBUG);
    undef(&ATA_IRQ_TRAP) if defined(&ATA_IRQ_TRAP);
    undef(&ATA_NDEBUG) if defined(&ATA_NDEBUG);
    undef(&ATA_ENABLE_PATA) if defined(&ATA_ENABLE_PATA);
    undef(&ATAPI_ENABLE_DMADIR) if defined(&ATAPI_ENABLE_DMADIR);
    if(defined(&ATA_DEBUG)) {
	eval 'sub DPRINTK () {( &fmt,  &args...)  &printk( &KERN_ERR "%s: "  &fmt,  &__FUNCTION__,   &args);}' unless defined(&DPRINTK);
	if(defined(&ATA_VERBOSE_DEBUG)) {
	    eval 'sub VPRINTK () {( &fmt,  &args...)  &printk( &KERN_ERR "%s: "  &fmt,  &__FUNCTION__,   &args);}' unless defined(&VPRINTK);
	} else {
	    eval 'sub VPRINTK () {( &fmt,  &args...);}' unless defined(&VPRINTK);
	}
    } else {
	eval 'sub DPRINTK () {( &fmt,  &args...);}' unless defined(&DPRINTK);
	eval 'sub VPRINTK () {( &fmt,  &args...);}' unless defined(&VPRINTK);
    }
    eval 'sub BPRINTK () {( &fmt,  &args...)  &if ( ($ap->{flags}) &  &ATA_FLAG_DEBUGMSG)  &printk( &KERN_ERR "%s: "  &fmt,  &__FUNCTION__,   &args);}' unless defined(&BPRINTK);
    eval 'sub HAVE_LIBATA_MSG () {1;}' unless defined(&HAVE_LIBATA_MSG);
    eval("sub ATA_MSG_DRV () { 0x0001; }") unless defined(&ATA_MSG_DRV);
    eval("sub ATA_MSG_INFO () { 0x0002; }") unless defined(&ATA_MSG_INFO);
    eval("sub ATA_MSG_PROBE () { 0x0004; }") unless defined(&ATA_MSG_PROBE);
    eval("sub ATA_MSG_WARN () { 0x0008; }") unless defined(&ATA_MSG_WARN);
    eval("sub ATA_MSG_MALLOC () { 0x0010; }") unless defined(&ATA_MSG_MALLOC);
    eval("sub ATA_MSG_CTL () { 0x0020; }") unless defined(&ATA_MSG_CTL);
    eval("sub ATA_MSG_INTR () { 0x0040; }") unless defined(&ATA_MSG_INTR);
    eval("sub ATA_MSG_ERR () { 0x0080; }") unless defined(&ATA_MSG_ERR);
    eval 'sub ata_msg_drv {
        my($p) = @_;
	    eval q((($p)-> &msg_enable &  &ATA_MSG_DRV));
    }' unless defined(&ata_msg_drv);
    eval 'sub ata_msg_info {
        my($p) = @_;
	    eval q((($p)-> &msg_enable &  &ATA_MSG_INFO));
    }' unless defined(&ata_msg_info);
    eval 'sub ata_msg_probe {
        my($p) = @_;
	    eval q((($p)-> &msg_enable &  &ATA_MSG_PROBE));
    }' unless defined(&ata_msg_probe);
    eval 'sub ata_msg_warn {
        my($p) = @_;
	    eval q((($p)-> &msg_enable &  &ATA_MSG_WARN));
    }' unless defined(&ata_msg_warn);
    eval 'sub ata_msg_malloc {
        my($p) = @_;
	    eval q((($p)-> &msg_enable &  &ATA_MSG_MALLOC));
    }' unless defined(&ata_msg_malloc);
    eval 'sub ata_msg_ctl {
        my($p) = @_;
	    eval q((($p)-> &msg_enable &  &ATA_MSG_CTL));
    }' unless defined(&ata_msg_ctl);
    eval 'sub ata_msg_intr {
        my($p) = @_;
	    eval q((($p)-> &msg_enable &  &ATA_MSG_INTR));
    }' unless defined(&ata_msg_intr);
    eval 'sub ata_msg_err {
        my($p) = @_;
	    eval q((($p)-> &msg_enable &  &ATA_MSG_ERR));
    }' unless defined(&ata_msg_err);
    eval 'sub ata_msg_init {
        my($dval,$default_msg_enable_bits) = @_;
	    eval q({  &if ($dval < 0|| $dval >= ($sizeof{ &__u32} * 8)) $default_msg_enable_bits;  &if (!$dval) 0; (1<< $dval) - 1; });
    }' unless defined(&ata_msg_init);
    eval 'sub ATA_TAG_POISON () {0xfafbfcfd;}' unless defined(&ATA_TAG_POISON);
    eval("sub LIBATA_MAX_PRD () { ATA_MAX_PRD/2; }") unless defined(&LIBATA_MAX_PRD);
    eval("sub ATA_MAX_PORTS () { 8; }") unless defined(&ATA_MAX_PORTS);
    eval("sub ATA_DEF_QUEUE () { 1; }") unless defined(&ATA_DEF_QUEUE);
    eval("sub ATA_MAX_QUEUE () { 1; }") unless defined(&ATA_MAX_QUEUE);
    eval("sub ATA_MAX_SECTORS () { 200; }") unless defined(&ATA_MAX_SECTORS);
    eval("sub ATA_MAX_BUS () { 2; }") unless defined(&ATA_MAX_BUS);
    eval("sub ATA_DEF_BUSY_WAIT () { 10000; }") unless defined(&ATA_DEF_BUSY_WAIT);
    eval("sub ATA_SHORT_PAUSE () { (HZ>>6)+1; }") unless defined(&ATA_SHORT_PAUSE);
    eval("sub ATA_SHT_EMULATED () { 1; }") unless defined(&ATA_SHT_EMULATED);
    eval("sub ATA_SHT_CMD_PER_LUN () { 1; }") unless defined(&ATA_SHT_CMD_PER_LUN);
    eval("sub ATA_SHT_THIS_ID () { -1; }") unless defined(&ATA_SHT_THIS_ID);
    eval("sub ATA_SHT_USE_CLUSTERING () { 1; }") unless defined(&ATA_SHT_USE_CLUSTERING);
    eval("sub ATA_DFLAG_LBA48 () { (1<<0); }") unless defined(&ATA_DFLAG_LBA48);
    eval("sub ATA_DFLAG_PIO () { (1<<1); }") unless defined(&ATA_DFLAG_PIO);
    eval("sub ATA_DFLAG_LBA () { (1<<2); }") unless defined(&ATA_DFLAG_LBA);
    eval("sub ATA_DEV_UNKNOWN () { 0; }") unless defined(&ATA_DEV_UNKNOWN);
    eval("sub ATA_DEV_ATA () { 1; }") unless defined(&ATA_DEV_ATA);
    eval("sub ATA_DEV_ATA_UNSUP () { 2; }") unless defined(&ATA_DEV_ATA_UNSUP);
    eval("sub ATA_DEV_ATAPI () { 3; }") unless defined(&ATA_DEV_ATAPI);
    eval("sub ATA_DEV_ATAPI_UNSUP () { 4; }") unless defined(&ATA_DEV_ATAPI_UNSUP);
    eval("sub ATA_DEV_NONE () { 5; }") unless defined(&ATA_DEV_NONE);
    eval("sub ATA_FLAG_SLAVE_POSS () { (1<<1); }") unless defined(&ATA_FLAG_SLAVE_POSS);
    eval("sub ATA_FLAG_PORT_DISABLED () { (1<<2); }") unless defined(&ATA_FLAG_PORT_DISABLED);
    eval("sub ATA_FLAG_SATA () { (1<<3); }") unless defined(&ATA_FLAG_SATA);
    eval("sub ATA_FLAG_NO_LEGACY () { (1<<4); }") unless defined(&ATA_FLAG_NO_LEGACY);
    eval("sub ATA_FLAG_SRST () { (1<<5); }") unless defined(&ATA_FLAG_SRST);
    eval("sub ATA_FLAG_MMIO () { (1<<6); }") unless defined(&ATA_FLAG_MMIO);
    eval("sub ATA_FLAG_SATA_RESET () { (1<<7); }") unless defined(&ATA_FLAG_SATA_RESET);
    eval("sub ATA_FLAG_PIO_DMA () { (1<<8); }") unless defined(&ATA_FLAG_PIO_DMA);
    eval("sub ATA_FLAG_NOINTR () { (1<<9); }") unless defined(&ATA_FLAG_NOINTR);
    eval("sub ATA_FLAG_DEBUGMSG () { (1<<10); }") unless defined(&ATA_FLAG_DEBUGMSG);
    eval("sub ATA_FLAG_NO_ATAPI () { (1<<11); }") unless defined(&ATA_FLAG_NO_ATAPI);
    eval("sub ATA_FLAG_SUSPENDED () { (1<<12); }") unless defined(&ATA_FLAG_SUSPENDED);
    eval("sub ATA_FLAG_PIO_LBA48 () { (1<<13); }") unless defined(&ATA_FLAG_PIO_LBA48);
    eval("sub ATA_FLAG_IRQ_MASK () { (1<<14); }") unless defined(&ATA_FLAG_IRQ_MASK);
    eval("sub ATA_FLAG_FLUSH_PORT_TASK () { (1<<15); }") unless defined(&ATA_FLAG_FLUSH_PORT_TASK);
    eval("sub ATA_FLAG_IN_EH () { (1<<16); }") unless defined(&ATA_FLAG_IN_EH);
    eval("sub ATA_QCFLAG_ACTIVE () { (1<<1); }") unless defined(&ATA_QCFLAG_ACTIVE);
    eval("sub ATA_QCFLAG_SG () { (1<<3); }") unless defined(&ATA_QCFLAG_SG);
    eval("sub ATA_QCFLAG_SINGLE () { (1<<4); }") unless defined(&ATA_QCFLAG_SINGLE);
    eval("sub ATA_QCFLAG_DMAMAP () { ATA_QCFLAG_SG|ATA_QCFLAG_SINGLE; }") unless defined(&ATA_QCFLAG_DMAMAP);
    eval("sub ATA_QCFLAG_EH_SCHEDULED () { (1<<5); }") unless defined(&ATA_QCFLAG_EH_SCHEDULED);
    eval("sub ATA_HOST_SIMPLEX () { (1<<0); }") unless defined(&ATA_HOST_SIMPLEX);
    eval("sub ATA_TMOUT_PIO () { 30*HZ; }") unless defined(&ATA_TMOUT_PIO);
    eval("sub ATA_TMOUT_BOOT () { 30*HZ; }") unless defined(&ATA_TMOUT_BOOT);
    eval("sub ATA_TMOUT_BOOT_QUICK () { 7*HZ; }") unless defined(&ATA_TMOUT_BOOT_QUICK);
    eval("sub ATA_TMOUT_CDB () { 30*HZ; }") unless defined(&ATA_TMOUT_CDB);
    eval("sub ATA_TMOUT_CDB_QUICK () { 5*HZ; }") unless defined(&ATA_TMOUT_CDB_QUICK);
    eval("sub ATA_TMOUT_INTERNAL () { 30*HZ; }") unless defined(&ATA_TMOUT_INTERNAL);
    eval("sub ATA_TMOUT_INTERNAL_QUICK () { 5*HZ; }") unless defined(&ATA_TMOUT_INTERNAL_QUICK);
    eval("sub BUS_UNKNOWN () { 0; }") unless defined(&BUS_UNKNOWN);
    eval("sub BUS_DMA () { 1; }") unless defined(&BUS_DMA);
    eval("sub BUS_IDLE () { 2; }") unless defined(&BUS_IDLE);
    eval("sub BUS_NOINTR () { 3; }") unless defined(&BUS_NOINTR);
    eval("sub BUS_NODATA () { 4; }") unless defined(&BUS_NODATA);
    eval("sub BUS_TIMER () { 5; }") unless defined(&BUS_TIMER);
    eval("sub BUS_PIO () { 6; }") unless defined(&BUS_PIO);
    eval("sub BUS_EDD () { 7; }") unless defined(&BUS_EDD);
    eval("sub BUS_IDENTIFY () { 8; }") unless defined(&BUS_IDENTIFY);
    eval("sub BUS_PACKET () { 9; }") unless defined(&BUS_PACKET);
    eval("sub PORT_UNKNOWN () { 0; }") unless defined(&PORT_UNKNOWN);
    eval("sub PORT_ENABLED () { 1; }") unless defined(&PORT_ENABLED);
    eval("sub PORT_DISABLED () { 2; }") unless defined(&PORT_DISABLED);
    eval("sub ATA_BITS_PIO () { 5; }") unless defined(&ATA_BITS_PIO);
    eval("sub ATA_BITS_MWDMA () { 3; }") unless defined(&ATA_BITS_MWDMA);
    eval("sub ATA_BITS_UDMA () { 8; }") unless defined(&ATA_BITS_UDMA);
    eval("sub ATA_SHIFT_PIO () { 0; }") unless defined(&ATA_SHIFT_PIO);
    eval("sub ATA_SHIFT_MWDMA () { ATA_SHIFT_PIO+ATA_BITS_PIO; }") unless defined(&ATA_SHIFT_MWDMA);
    eval("sub ATA_SHIFT_UDMA () { ATA_SHIFT_MWDMA+ATA_BITS_MWDMA; }") unless defined(&ATA_SHIFT_UDMA);
    eval("sub ATA_MASK_PIO () { ((1<<ATA_BITS_PIO)-1)<<ATA_SHIFT_PIO; }") unless defined(&ATA_MASK_PIO);
    eval("sub ATA_MASK_MWDMA () { ((1<<ATA_BITS_MWDMA)-1)<<ATA_SHIFT_MWDMA; }") unless defined(&ATA_MASK_MWDMA);
    eval("sub ATA_MASK_UDMA () { ((1<<ATA_BITS_UDMA)-1)<<ATA_SHIFT_UDMA; }") unless defined(&ATA_MASK_UDMA);
    eval("sub ATA_DMA_PAD_SZ () { 4; }") unless defined(&ATA_DMA_PAD_SZ);
    eval("sub ATA_DMA_PAD_BUF_SZ () { ATA_DMA_PAD_SZ*ATA_MAX_QUEUE; }") unless defined(&ATA_DMA_PAD_BUF_SZ);
    eval("sub ATA_PORT_PRIMARY () { (1<<0); }") unless defined(&ATA_PORT_PRIMARY);
    eval("sub ATA_PORT_SECONDARY () { (1<<1); }") unless defined(&ATA_PORT_SECONDARY);
    eval("sub HSM_ST_UNKNOWN () { 0; }") unless defined(&HSM_ST_UNKNOWN);
    eval("sub HSM_ST_IDLE () { 1; }") unless defined(&HSM_ST_IDLE);
    eval("sub HSM_ST_POLL () { 2; }") unless defined(&HSM_ST_POLL);
    eval("sub HSM_ST_TMOUT () { 3; }") unless defined(&HSM_ST_TMOUT);
    eval("sub HSM_ST () { 4; }") unless defined(&HSM_ST);
    eval("sub HSM_ST_LAST () { 5; }") unless defined(&HSM_ST_LAST);
    eval("sub HSM_ST_LAST_POLL () { 6; }") unless defined(&HSM_ST_LAST_POLL);
    eval("sub HSM_ST_ERR () { 7; }") unless defined(&HSM_ST_ERR);
    eval("sub AC_ERR_DEV () { (1<<0); }") unless defined(&AC_ERR_DEV);
    eval("sub AC_ERR_HSM () { (1<<1); }") unless defined(&AC_ERR_HSM);
    eval("sub AC_ERR_TIMEOUT () { (1<<2); }") unless defined(&AC_ERR_TIMEOUT);
    eval("sub AC_ERR_MEDIA () { (1<<3); }") unless defined(&AC_ERR_MEDIA);
    eval("sub AC_ERR_ATA_BUS () { (1<<4); }") unless defined(&AC_ERR_ATA_BUS);
    eval("sub AC_ERR_HOST_BUS () { (1<<5); }") unless defined(&AC_ERR_HOST_BUS);
    eval("sub AC_ERR_SYSTEM () { (1<<6); }") unless defined(&AC_ERR_SYSTEM);
    eval("sub AC_ERR_INVALID () { (1<<7); }") unless defined(&AC_ERR_INVALID);
    eval("sub AC_ERR_OTHER () { (1<<8); }") unless defined(&AC_ERR_OTHER);
    eval 'sub FIT {
        my($v,$vmin,$vmax) = @_;
	    eval q( &max_t(\'short\', &min_t(\'short\',$v,$vmax),$vmin));
    }' unless defined(&FIT);
    if(defined(&CONFIG_PCI)) {
    }
    eval("sub ATA_TIMING_SETUP () { (1<<0); }") unless defined(&ATA_TIMING_SETUP);
    eval("sub ATA_TIMING_ACT8B () { (1<<1); }") unless defined(&ATA_TIMING_ACT8B);
    eval("sub ATA_TIMING_REC8B () { (1<<2); }") unless defined(&ATA_TIMING_REC8B);
    eval("sub ATA_TIMING_CYC8B () { (1<<3); }") unless defined(&ATA_TIMING_CYC8B);
    eval("sub ATA_TIMING_8BIT () { ATA_TIMING_ACT8B|ATA_TIMING_REC8B|ATA_TIMING_CYC8B; }") unless defined(&ATA_TIMING_8BIT);
    eval("sub ATA_TIMING_ACTIVE () { (1<<4); }") unless defined(&ATA_TIMING_ACTIVE);
    eval("sub ATA_TIMING_RECOVER () { (1<<5); }") unless defined(&ATA_TIMING_RECOVER);
    eval("sub ATA_TIMING_CYCLE () { (1<<6); }") unless defined(&ATA_TIMING_CYCLE);
    eval("sub ATA_TIMING_UDMA () { (1<<7); }") unless defined(&ATA_TIMING_UDMA);
    eval("sub ATA_TIMING_ALL () { ATA_TIMING_SETUP|ATA_TIMING_ACT8B|ATA_TIMING_REC8B|ATA_TIMING_CYC8B|ATA_TIMING_ACTIVE|ATA_TIMING_RECOVER|ATA_TIMING_CYCLE|ATA_TIMING_UDMA; }") unless defined(&ATA_TIMING_ALL);
    if(defined(&CONFIG_PCI)) {
    }
    eval 'sub ata_sg_is_last {
        my($sg,$qc) = @_;
	    eval q({  &if ($sg ==  ($qc->{pad_sgent})) 1;  &if ( ($qc->{pad_len})) 0;  &if ((($sg -  ($qc->{__sg})) + 1) ==  ($qc->{n_elem})) 1; 0; });
    }' unless defined(&ata_sg_is_last);
    eval 'sub ata_qc_first_sg {
        my($qc) = @_;
	    eval q({  &if ( ($qc->{n_elem}))  ($qc->{__sg});  &if ( ($qc->{pad_len}))  ($qc->{pad_sgent});  &NULL; });
    }' unless defined(&ata_qc_first_sg);
    eval 'sub ata_qc_next_sg {
        my($sg,$qc) = @_;
	    eval q({  &if ($sg ==  ($qc->{pad_sgent}))  &NULL;  &if (++$sg -  ($qc->{__sg}) <  ($qc->{n_elem})) $sg;  &if ( ($qc->{pad_len}))  ($qc->{pad_sgent});  &NULL; });
    }' unless defined(&ata_qc_next_sg);
    eval 'sub ata_for_each_sg {
        my($sg, $qc) = @_;
	    eval q( &for ($sg =  &ata_qc_first_sg($qc); $sg; $sg =  &ata_qc_next_sg($sg, $qc)));
    }' unless defined(&ata_for_each_sg);
    eval 'sub ata_tag_valid {
        my($tag) = @_;
	    eval q({ ($tag <  &ATA_MAX_QUEUE) ? 1: 0; });
    }' unless defined(&ata_tag_valid);
    eval 'sub ata_class_present {
        my($class) = @_;
	    eval q({ $class ==  &ATA_DEV_ATA || $class ==  &ATA_DEV_ATAPI; });
    }' unless defined(&ata_class_present);
    eval 'sub ata_dev_present {
        my($dev) = @_;
	    eval q({  &ata_class_present( ($dev->{class})); });
    }' unless defined(&ata_dev_present);
    eval 'sub ata_chk_status {
        my($ap) = @_;
	    eval q({  ($ap->{ops}->{check_status})($ap); });
    }' unless defined(&ata_chk_status);
    eval 'sub ata_qc_set_polling {
        my($qc) = @_;
	    eval q({  ($qc->{tf}->{ctl}) |=  &ATA_NIEN; });
    }' unless defined(&ata_qc_set_polling);
    eval 'sub ata_queued_cmd {
        eval q(* &ata_qc_from_tag (\'struct ata_port\' * &ap, my $tag) {  &if ( &likely( &ata_tag_valid( $tag)))  ($ap->{qcmd[$tag]});  &NULL; });
    }' unless defined(&ata_queued_cmd);
    eval 'sub ata_tf_init {
        my($ap,$tf,$device) = @_;
	    eval q({  &memset($tf, 0, $sizeof{$tf});  ($tf->{ctl}) =  ($ap->{ctl});  &if ($device == 0)  ($tf->{device}) =  &ATA_DEVICE_OBS;  &else  ($tf->{device}) =  &ATA_DEVICE_OBS |  &ATA_DEV1; });
    }' unless defined(&ata_tf_init);
    eval 'sub ata_qc_reinit {
        my($qc) = @_;
	    eval q({  ($qc->{__sg}) =  &NULL;  ($qc->{flags}) = 0;  ($qc->{cursect}) =  ($qc->{cursg}) =  ($qc->{cursg_ofs}) = 0;  ($qc->{nsect}) = 0;  ($qc->{nbytes}) =  ($qc->{curbytes}) = 0;  ($qc->{err_mask}) = 0;  &ata_tf_init( ($qc->{ap}),  ($qc->{tf}),  ($qc->{dev}->{devno})); });
    }' unless defined(&ata_qc_reinit);
    eval 'sub scr_read {
        my($ap,$reg) = @_;
	    eval q({  ($ap->{ops}->{scr_read})($ap, $reg); });
    }' unless defined(&scr_read);
    eval 'sub scr_write {
        my($ap,$reg,$val) = @_;
	    eval q({  ($ap->{ops}->{scr_write})($ap, $reg, $val); });
    }' unless defined(&scr_write);
    eval 'sub scr_write_flush {
        my($ap,$reg,$val) = @_;
	    eval q({  ($ap->{ops}->{scr_write})($ap, $reg, $val); ( &void)  ($ap->{ops}->{scr_read})($ap, $reg); });
    }' unless defined(&scr_write_flush);
    eval 'sub sata_dev_present {
        my($ap) = @_;
	    eval q({ (( &scr_read($ap,  &SCR_STATUS) & 0xf) == 0x3) ? 1: 0; });
    }' unless defined(&sata_dev_present);
    eval 'sub ata_try_flush_cache {
        my($dev) = @_;
	    eval q({  &ata_id_wcache_enabled( ($dev->{id})) ||  &ata_id_has_flush( ($dev->{id})) ||  &ata_id_has_flush_ext( ($dev->{id})); });
    }' unless defined(&ata_try_flush_cache);
    eval 'sub ac_err_mask {
        my($status) = @_;
	    eval q({  &if ($status &  &ATA_BUSY)  &AC_ERR_HSM;  &if ($status & ( &ATA_ERR |  &ATA_DF))  &AC_ERR_DEV; 0; });
    }' unless defined(&ac_err_mask);
    eval 'sub __ac_err_mask {
        my($status) = @_;
	    eval q({ my $mask =  &ac_err_mask($status);  &if ( $mask == 0)  &AC_ERR_OTHER;  $mask; });
    }' unless defined(&__ac_err_mask);
    eval 'sub ata_pad_alloc {
        my($ap,$dev) = @_;
	    eval q({  ($ap->{pad_dma}) = 0;  ($ap->{pad}) =  &dma_alloc_coherent($dev,  &ATA_DMA_PAD_BUF_SZ,  ($ap->{pad_dma}),  &GFP_KERNEL); ( ($ap->{pad}) ==  &NULL) ? - &ENOMEM : 0; });
    }' unless defined(&ata_pad_alloc);
    eval 'sub ata_pad_free {
        my($ap,$dev) = @_;
	    eval q({  &dma_free_coherent($dev,  &ATA_DMA_PAD_BUF_SZ,  ($ap->{pad}),  ($ap->{pad_dma})); });
    }' unless defined(&ata_pad_free);
}
1;
