require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_NETDEVICE_H)) {
    eval 'sub _LINUX_NETDEVICE_H () {1;}' unless defined(&_LINUX_NETDEVICE_H);
    require 'linux/if.ph';
    require 'linux/if_ether.ph';
    require 'linux/if_packet.ph';
    if(defined(&__KERNEL__)) {
	require 'asm/atomic.ph';
	require 'asm/cache.ph';
	require 'asm/byteorder.ph';
	require 'linux/config.ph';
	require 'linux/device.ph';
	require 'linux/percpu.ph';
	eval 'sub SET_ETHTOOL_OPS {
	    my($netdev,$ops) = @_;
    	    eval q(( ($netdev)-> &ethtool_ops = ($ops) ));
	}' unless defined(&SET_ETHTOOL_OPS);
	eval 'sub HAVE_ALLOC_NETDEV () {1;}' unless defined(&HAVE_ALLOC_NETDEV);
	eval 'sub HAVE_FREE_NETDEV () {1;}' unless defined(&HAVE_FREE_NETDEV);
	eval 'sub HAVE_NETDEV_PRIV () {1;}' unless defined(&HAVE_NETDEV_PRIV);
	eval 'sub NET_XMIT_SUCCESS () {0;}' unless defined(&NET_XMIT_SUCCESS);
	eval 'sub NET_XMIT_DROP () {1;}' unless defined(&NET_XMIT_DROP);
	eval 'sub NET_XMIT_CN () {2;}' unless defined(&NET_XMIT_CN);
	eval 'sub NET_XMIT_POLICED () {3;}' unless defined(&NET_XMIT_POLICED);
	eval 'sub NET_XMIT_BYPASS () {4;}' unless defined(&NET_XMIT_BYPASS);
	eval 'sub NET_RX_SUCCESS () {0;}' unless defined(&NET_RX_SUCCESS);
	eval 'sub NET_RX_DROP () {1;}' unless defined(&NET_RX_DROP);
	eval 'sub NET_RX_CN_LOW () {2;}' unless defined(&NET_RX_CN_LOW);
	eval 'sub NET_RX_CN_MOD () {3;}' unless defined(&NET_RX_CN_MOD);
	eval 'sub NET_RX_CN_HIGH () {4;}' unless defined(&NET_RX_CN_HIGH);
	eval 'sub NET_RX_BAD () {5;}' unless defined(&NET_RX_BAD);
	eval 'sub net_xmit_errno {
	    my($e) = @_;
    	    eval q((($e) !=  &NET_XMIT_CN ? - &ENOBUFS : 0));
	}' unless defined(&net_xmit_errno);
    }
    eval 'sub MAX_ADDR_LEN () {32;}' unless defined(&MAX_ADDR_LEN);
    eval 'sub NETDEV_TX_OK () {0;}' unless defined(&NETDEV_TX_OK);
    eval 'sub NETDEV_TX_BUSY () {1;}' unless defined(&NETDEV_TX_BUSY);
    eval 'sub NETDEV_TX_LOCKED () {-1;}' unless defined(&NETDEV_TX_LOCKED);
    if(!defined( &CONFIG_AX25)  && !defined( &CONFIG_AX25_MODULE)  && !defined( &CONFIG_TR)) {
	eval 'sub LL_MAX_HEADER () {32;}' unless defined(&LL_MAX_HEADER);
    } else {
	if(defined( &CONFIG_AX25) || defined( &CONFIG_AX25_MODULE)) {
	    eval 'sub LL_MAX_HEADER () {96;}' unless defined(&LL_MAX_HEADER);
	} else {
	    eval 'sub LL_MAX_HEADER () {48;}' unless defined(&LL_MAX_HEADER);
	}
    }
    if(!defined( &CONFIG_NET_IPIP)  && !defined( &CONFIG_IPV6)  && !defined( &CONFIG_IPV6_MODULE)) {
	eval 'sub MAX_HEADER () { &LL_MAX_HEADER;}' unless defined(&MAX_HEADER);
    } else {
	eval 'sub MAX_HEADER () {( &LL_MAX_HEADER + 48);}' unless defined(&MAX_HEADER);
    }
    eval("sub IF_PORT_UNKNOWN () { 0; }") unless defined(&IF_PORT_UNKNOWN);
    eval("sub IF_PORT_10BASE2 () { 1; }") unless defined(&IF_PORT_10BASE2);
    eval("sub IF_PORT_10BASET () { 2; }") unless defined(&IF_PORT_10BASET);
    eval("sub IF_PORT_AUI () { 3; }") unless defined(&IF_PORT_AUI);
    eval("sub IF_PORT_100BASET () { 4; }") unless defined(&IF_PORT_100BASET);
    eval("sub IF_PORT_100BASETX () { 5; }") unless defined(&IF_PORT_100BASETX);
    eval("sub IF_PORT_100BASEFX () { 6; }") unless defined(&IF_PORT_100BASEFX);
    if(defined(&__KERNEL__)) {
	require 'linux/cache.ph';
	require 'linux/skbuff.ph';
	eval 'sub HH_DATA_MOD () {16;}' unless defined(&HH_DATA_MOD);
	eval 'sub HH_DATA_OFF {
	    my($__len) = @_;
    	    eval q(( &HH_DATA_MOD - ((($__len - 1) & ( &HH_DATA_MOD - 1)) + 1)));
	}' unless defined(&HH_DATA_OFF);
	eval 'sub HH_DATA_ALIGN {
	    my($__len) = @_;
    	    eval q(((($__len)+( &HH_DATA_MOD-1))&~( &HH_DATA_MOD - 1)));
	}' unless defined(&HH_DATA_ALIGN);
	eval 'sub LL_RESERVED_SPACE {
	    my($dev) = @_;
    	    eval q(((($dev)-> &hard_header_len&~( &HH_DATA_MOD - 1)) +  &HH_DATA_MOD));
	}' unless defined(&LL_RESERVED_SPACE);
	eval 'sub LL_RESERVED_SPACE_EXTRA {
	    my($dev,$extra) = @_;
    	    eval q((((($dev)-> &hard_header_len+$extra)&~( &HH_DATA_MOD - 1)) +  &HH_DATA_MOD));
	}' unless defined(&LL_RESERVED_SPACE_EXTRA);
	eval("sub __LINK_STATE_XOFF () { 0; }") unless defined(&__LINK_STATE_XOFF);
	eval("sub __LINK_STATE_START () { 1; }") unless defined(&__LINK_STATE_START);
	eval("sub __LINK_STATE_PRESENT () { 2; }") unless defined(&__LINK_STATE_PRESENT);
	eval("sub __LINK_STATE_SCHED () { 3; }") unless defined(&__LINK_STATE_SCHED);
	eval("sub __LINK_STATE_NOCARRIER () { 4; }") unless defined(&__LINK_STATE_NOCARRIER);
	eval("sub __LINK_STATE_RX_SCHED () { 5; }") unless defined(&__LINK_STATE_RX_SCHED);
	eval("sub __LINK_STATE_LINKWATCH_PENDING () { 6; }") unless defined(&__LINK_STATE_LINKWATCH_PENDING);
	eval("sub __LINK_STATE_DORMANT () { 7; }") unless defined(&__LINK_STATE_DORMANT);
	eval 'sub NETDEV_BOOT_SETUP_MAX () {8;}' unless defined(&NETDEV_BOOT_SETUP_MAX);
	eval 'sub NETIF_F_SG () {1;}' unless defined(&NETIF_F_SG);
	eval 'sub NETIF_F_IP_CSUM () {2;}' unless defined(&NETIF_F_IP_CSUM);
	eval 'sub NETIF_F_NO_CSUM () {4;}' unless defined(&NETIF_F_NO_CSUM);
	eval 'sub NETIF_F_HW_CSUM () {8;}' unless defined(&NETIF_F_HW_CSUM);
	eval 'sub NETIF_F_HIGHDMA () {32;}' unless defined(&NETIF_F_HIGHDMA);
	eval 'sub NETIF_F_FRAGLIST () {64;}' unless defined(&NETIF_F_FRAGLIST);
	eval 'sub NETIF_F_HW_VLAN_TX () {128;}' unless defined(&NETIF_F_HW_VLAN_TX);
	eval 'sub NETIF_F_HW_VLAN_RX () {256;}' unless defined(&NETIF_F_HW_VLAN_RX);
	eval 'sub NETIF_F_HW_VLAN_FILTER () {512;}' unless defined(&NETIF_F_HW_VLAN_FILTER);
	eval 'sub NETIF_F_VLAN_CHALLENGED () {1024;}' unless defined(&NETIF_F_VLAN_CHALLENGED);
	eval 'sub NETIF_F_TSO () {2048;}' unless defined(&NETIF_F_TSO);
	eval 'sub NETIF_F_LLTX () {4096;}' unless defined(&NETIF_F_LLTX);
	eval 'sub NETIF_F_UFO () {8192;}' unless defined(&NETIF_F_UFO);
	eval("sub NETREG_UNINITIALIZED () { 0; }") unless defined(&NETREG_UNINITIALIZED);
	eval("sub NETREG_REGISTERED () { 1; }") unless defined(&NETREG_REGISTERED);
	eval("sub NETREG_UNREGISTERING () { 2; }") unless defined(&NETREG_UNREGISTERING);
	eval("sub NETREG_UNREGISTERED () { 3; }") unless defined(&NETREG_UNREGISTERED);
	eval("sub NETREG_RELEASED () { 4; }") unless defined(&NETREG_RELEASED);
	eval 'sub HAVE_NETDEV_POLL () {1;}' unless defined(&HAVE_NETDEV_POLL);
	eval 'sub HAVE_MULTICAST () {1;}' unless defined(&HAVE_MULTICAST);
	eval 'sub HAVE_SET_MAC_ADDR () {1;}' unless defined(&HAVE_SET_MAC_ADDR);
	eval 'sub HAVE_PRIVATE_IOCTL () {1;}' unless defined(&HAVE_PRIVATE_IOCTL);
	eval 'sub HAVE_SET_CONFIG () {1;}' unless defined(&HAVE_SET_CONFIG);
	eval 'sub HAVE_HEADER_CACHE () {1;}' unless defined(&HAVE_HEADER_CACHE);
	eval 'sub HAVE_CHANGE_MTU () {1;}' unless defined(&HAVE_CHANGE_MTU);
	eval 'sub HAVE_TX_TIMEOUT () {1;}' unless defined(&HAVE_TX_TIMEOUT);
	if(defined(&CONFIG_NETPOLL)) {
	}
	if(defined(&CONFIG_NET_POLL_CONTROLLER)) {
	}
	if(defined(&CONFIG_NET_DIVERT)) {
	}
	eval 'sub NETDEV_ALIGN () {32;}' unless defined(&NETDEV_ALIGN);
	eval 'sub NETDEV_ALIGN_CONST () {( &NETDEV_ALIGN - 1);}' unless defined(&NETDEV_ALIGN_CONST);
	eval 'sub void {
	    eval q(* &netdev_priv(\'struct net_device\' * &dev) {  &dev + (($sizeof{\'struct net_device\'} +  &NETDEV_ALIGN_CONST) & ~ &NETDEV_ALIGN_CONST); });
	}' unless defined(&void);
	eval 'sub SET_MODULE_OWNER {
	    my($dev) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&SET_MODULE_OWNER);
	eval 'sub SET_NETDEV_DEV {
	    my($net, $pdev) = @_;
    	    eval q((($net)-> ($class_dev->{dev}) = ($pdev)));
	}' unless defined(&SET_NETDEV_DEV);
	require 'linux/interrupt.ph';
	require 'linux/notifier.ph';
	if(defined(&CONFIG_NETPOLL_TRAP)) {
	}
	eval 'sub unregister_gifconf {
	    my($family) = @_;
    	    eval q({  &register_gifconf($family,  &NULL); });
	}' unless defined(&unregister_gifconf);
	eval 'sub HAVE_NETIF_QUEUE () {1;}' unless defined(&HAVE_NETIF_QUEUE);
	eval 'sub netif_schedule {
	    my($dev) = @_;
    	    eval q({  &if (! &test_bit( &__LINK_STATE_XOFF,  ($dev->{state})))  &__netif_schedule($dev); });
	}' unless defined(&netif_schedule);
	eval 'sub netif_start_queue {
	    my($dev) = @_;
    	    eval q({  &clear_bit( &__LINK_STATE_XOFF,  ($dev->{state})); });
	}' unless defined(&netif_start_queue);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub netif_wake_queue {
	    my($dev) = @_;
    	    eval q({  &if ( &test_and_clear_bit( &__LINK_STATE_XOFF,  ($dev->{state})))  &__netif_schedule($dev); });
	}' unless defined(&netif_wake_queue);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub netif_stop_queue {
	    my($dev) = @_;
    	    eval q({  &set_bit( &__LINK_STATE_XOFF,  ($dev->{state})); });
	}' unless defined(&netif_stop_queue);
	eval 'sub netif_queue_stopped {
	    my($dev) = @_;
    	    eval q({  &test_bit( &__LINK_STATE_XOFF,  ($dev->{state})); });
	}' unless defined(&netif_queue_stopped);
	eval 'sub netif_running {
	    my($dev) = @_;
    	    eval q({  &test_bit( &__LINK_STATE_START,  ($dev->{state})); });
	}' unless defined(&netif_running);
	eval 'sub HAVE_NETIF_RX () {1;}' unless defined(&HAVE_NETIF_RX);
	eval 'sub HAVE_NETIF_RECEIVE_SKB () {1;}' unless defined(&HAVE_NETIF_RECEIVE_SKB);
	eval 'sub dev_put {
	    my($dev) = @_;
    	    eval q({  &atomic_dec( ($dev->{refcnt})); });
	}' unless defined(&dev_put);
	eval 'sub dev_hold {
	    my($dev) = @_;
    	    eval q({  &atomic_inc( ($dev->{refcnt})); });
	}' unless defined(&dev_hold);
	eval 'sub netif_carrier_ok {
	    my($dev) = @_;
    	    eval q({ ! &test_bit( &__LINK_STATE_NOCARRIER,  ($dev->{state})); });
	}' unless defined(&netif_carrier_ok);
	eval 'sub netif_dormant_on {
	    my($dev) = @_;
    	    eval q({  &if (! &test_and_set_bit( &__LINK_STATE_DORMANT,  ($dev->{state})))  &linkwatch_fire_event($dev); });
	}' unless defined(&netif_dormant_on);
	eval 'sub netif_dormant_off {
	    my($dev) = @_;
    	    eval q({  &if ( &test_and_clear_bit( &__LINK_STATE_DORMANT,  ($dev->{state})))  &linkwatch_fire_event($dev); });
	}' unless defined(&netif_dormant_off);
	eval 'sub netif_dormant {
	    my($dev) = @_;
    	    eval q({  &test_bit( &__LINK_STATE_DORMANT,  ($dev->{state})); });
	}' unless defined(&netif_dormant);
	eval 'sub netif_oper_up {
	    my($dev) = @_;
    	    eval q({ ( ($dev->{operstate}) ==  &IF_OPER_UP ||  ($dev->{operstate}) ==  &IF_OPER_UNKNOWN ); });
	}' unless defined(&netif_oper_up);
	eval 'sub HAVE_NETIF_MSG () {1;}' unless defined(&HAVE_NETIF_MSG);
	eval("sub NETIF_MSG_DRV () { 0x0001; }") unless defined(&NETIF_MSG_DRV);
	eval("sub NETIF_MSG_PROBE () { 0x0002; }") unless defined(&NETIF_MSG_PROBE);
	eval("sub NETIF_MSG_LINK () { 0x0004; }") unless defined(&NETIF_MSG_LINK);
	eval("sub NETIF_MSG_TIMER () { 0x0008; }") unless defined(&NETIF_MSG_TIMER);
	eval("sub NETIF_MSG_IFDOWN () { 0x0010; }") unless defined(&NETIF_MSG_IFDOWN);
	eval("sub NETIF_MSG_IFUP () { 0x0020; }") unless defined(&NETIF_MSG_IFUP);
	eval("sub NETIF_MSG_RX_ERR () { 0x0040; }") unless defined(&NETIF_MSG_RX_ERR);
	eval("sub NETIF_MSG_TX_ERR () { 0x0080; }") unless defined(&NETIF_MSG_TX_ERR);
	eval("sub NETIF_MSG_TX_QUEUED () { 0x0100; }") unless defined(&NETIF_MSG_TX_QUEUED);
	eval("sub NETIF_MSG_INTR () { 0x0200; }") unless defined(&NETIF_MSG_INTR);
	eval("sub NETIF_MSG_TX_DONE () { 0x0400; }") unless defined(&NETIF_MSG_TX_DONE);
	eval("sub NETIF_MSG_RX_STATUS () { 0x0800; }") unless defined(&NETIF_MSG_RX_STATUS);
	eval("sub NETIF_MSG_PKTDATA () { 0x1000; }") unless defined(&NETIF_MSG_PKTDATA);
	eval("sub NETIF_MSG_HW () { 0x2000; }") unless defined(&NETIF_MSG_HW);
	eval("sub NETIF_MSG_WOL () { 0x4000; }") unless defined(&NETIF_MSG_WOL);
	eval 'sub netif_msg_drv {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_DRV));
	}' unless defined(&netif_msg_drv);
	eval 'sub netif_msg_probe {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_PROBE));
	}' unless defined(&netif_msg_probe);
	eval 'sub netif_msg_link {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_LINK));
	}' unless defined(&netif_msg_link);
	eval 'sub netif_msg_timer {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_TIMER));
	}' unless defined(&netif_msg_timer);
	eval 'sub netif_msg_ifdown {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_IFDOWN));
	}' unless defined(&netif_msg_ifdown);
	eval 'sub netif_msg_ifup {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_IFUP));
	}' unless defined(&netif_msg_ifup);
	eval 'sub netif_msg_rx_err {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_RX_ERR));
	}' unless defined(&netif_msg_rx_err);
	eval 'sub netif_msg_tx_err {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_TX_ERR));
	}' unless defined(&netif_msg_tx_err);
	eval 'sub netif_msg_tx_queued {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_TX_QUEUED));
	}' unless defined(&netif_msg_tx_queued);
	eval 'sub netif_msg_intr {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_INTR));
	}' unless defined(&netif_msg_intr);
	eval 'sub netif_msg_tx_done {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_TX_DONE));
	}' unless defined(&netif_msg_tx_done);
	eval 'sub netif_msg_rx_status {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_RX_STATUS));
	}' unless defined(&netif_msg_rx_status);
	eval 'sub netif_msg_pktdata {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_PKTDATA));
	}' unless defined(&netif_msg_pktdata);
	eval 'sub netif_msg_hw {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_HW));
	}' unless defined(&netif_msg_hw);
	eval 'sub netif_msg_wol {
	    my($p) = @_;
    	    eval q((($p)-> &msg_enable &  &NETIF_MSG_WOL));
	}' unless defined(&netif_msg_wol);
	eval 'sub netif_msg_init {
	    my($debug_value,$default_msg_enable_bits) = @_;
    	    eval q({  &if ($debug_value < 0|| $debug_value >= ($sizeof{ &__u32} * 8)) $default_msg_enable_bits;  &if ($debug_value == 0) 0; (1<< $debug_value) - 1; });
	}' unless defined(&netif_msg_init);
	eval 'sub netif_poll_disable {
	    my($dev) = @_;
    	    eval q({  &while ( &test_and_set_bit( &__LINK_STATE_RX_SCHED,  ($dev->{state})))  &schedule_timeout_interruptible(1); });
	}' unless defined(&netif_poll_disable);
	eval 'sub netif_poll_enable {
	    my($dev) = @_;
    	    eval q({  &clear_bit( &__LINK_STATE_RX_SCHED,  ($dev->{state})); });
	}' unless defined(&netif_poll_enable);
	eval 'sub netif_tx_disable {
	    my($dev) = @_;
    	    eval q({  &spin_lock_bh( ($dev->{xmit_lock}));  &netif_stop_queue($dev);  &spin_unlock_bh( ($dev->{xmit_lock})); });
	}' unless defined(&netif_tx_disable);
	if(defined(&CONFIG_BUG)) {
	} else {
	    eval 'sub netdev_rx_csum_fault {
	        my($dev) = @_;
    		eval q({ });
	    }' unless defined(&netdev_rx_csum_fault);
	}
	if(defined(&CONFIG_PROC_FS)) {
	}
    }
}
1;
