require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_NFNETLINK_H)) {
    eval 'sub _NFNETLINK_H () {1;}' unless defined(&_NFNETLINK_H);
    require 'linux/types.ph';
    unless(defined(&__KERNEL__)) {
	eval 'sub NF_NETLINK_CONNTRACK_NEW () {0x1;}' unless defined(&NF_NETLINK_CONNTRACK_NEW);
	eval 'sub NF_NETLINK_CONNTRACK_UPDATE () {0x2;}' unless defined(&NF_NETLINK_CONNTRACK_UPDATE);
	eval 'sub NF_NETLINK_CONNTRACK_DESTROY () {0x4;}' unless defined(&NF_NETLINK_CONNTRACK_DESTROY);
	eval 'sub NF_NETLINK_CONNTRACK_EXP_NEW () {0x8;}' unless defined(&NF_NETLINK_CONNTRACK_EXP_NEW);
	eval 'sub NF_NETLINK_CONNTRACK_EXP_UPDATE () {0x10;}' unless defined(&NF_NETLINK_CONNTRACK_EXP_UPDATE);
	eval 'sub NF_NETLINK_CONNTRACK_EXP_DESTROY () {0x20;}' unless defined(&NF_NETLINK_CONNTRACK_EXP_DESTROY);
    }
    eval("sub NFNLGRP_NONE () { 0; }") unless defined(&NFNLGRP_NONE);
    eval("sub NFNLGRP_CONNTRACK_NEW () { 1; }") unless defined(&NFNLGRP_CONNTRACK_NEW);
    eval("sub NFNLGRP_CONNTRACK_UPDATE () { 2; }") unless defined(&NFNLGRP_CONNTRACK_UPDATE);
    eval("sub NFNLGRP_CONNTRACK_DESTROY () { 3; }") unless defined(&NFNLGRP_CONNTRACK_DESTROY);
    eval("sub NFNLGRP_CONNTRACK_EXP_NEW () { 4; }") unless defined(&NFNLGRP_CONNTRACK_EXP_NEW);
    eval("sub NFNLGRP_CONNTRACK_EXP_UPDATE () { 5; }") unless defined(&NFNLGRP_CONNTRACK_EXP_UPDATE);
    eval("sub NFNLGRP_CONNTRACK_EXP_DESTROY () { 6; }") unless defined(&NFNLGRP_CONNTRACK_EXP_DESTROY);
    eval("sub __NFNLGRP_MAX () { 7; }") unless defined(&__NFNLGRP_MAX);
    eval 'sub NFNLGRP_MAX () {( &__NFNLGRP_MAX - 1);}' unless defined(&NFNLGRP_MAX);
    eval 'sub NFNL_NFA_NEST () {0x8000;}' unless defined(&NFNL_NFA_NEST);
    eval 'sub NFA_TYPE {
        my($attr) = @_;
	    eval q((($attr)-> &nfa_type & 0x7fff));
    }' unless defined(&NFA_TYPE);
    eval 'sub NFA_ALIGNTO () {4;}' unless defined(&NFA_ALIGNTO);
    eval 'sub NFA_ALIGN {
        my($len) = @_;
	    eval q(((($len) +  &NFA_ALIGNTO - 1) & ~( &NFA_ALIGNTO - 1)));
    }' unless defined(&NFA_ALIGN);
    eval 'sub NFA_OK {
        my($nfa,$len) = @_;
	    eval q((($len) > 0 && ($nfa)-> &nfa_len >= $sizeof{\'struct nfattr\'}  && ($nfa)-> &nfa_len <= ($len)));
    }' unless defined(&NFA_OK);
    eval 'sub NFA_NEXT {
        my($nfa,$attrlen) = @_;
	    eval q((($attrlen) -=  &NFA_ALIGN(($nfa)-> &nfa_len), ((($nfa)) +  &NFA_ALIGN(($nfa)-> &nfa_len))));
    }' unless defined(&NFA_NEXT);
    eval 'sub NFA_LENGTH {
        my($len) = @_;
	    eval q(( &NFA_ALIGN($sizeof{\'struct nfattr\'}) + ($len)));
    }' unless defined(&NFA_LENGTH);
    eval 'sub NFA_SPACE {
        my($len) = @_;
	    eval q( &NFA_ALIGN( &NFA_LENGTH($len)));
    }' unless defined(&NFA_SPACE);
    eval 'sub NFA_DATA {
        my($nfa) = @_;
	    eval q((( &void *)((($nfa)) +  &NFA_LENGTH(0))));
    }' unless defined(&NFA_DATA);
    eval 'sub NFA_PAYLOAD {
        my($nfa) = @_;
	    eval q(((($nfa)-> &nfa_len) -  &NFA_LENGTH(0)));
    }' unless defined(&NFA_PAYLOAD);
    eval 'sub NFA_NEST {
        my($skb, $type) = @_;
	    eval q(({ \'struct nfattr\' * &__start =  ($skb)-> &tail;  &NFA_PUT($skb, ( &NFNL_NFA_NEST | $type), 0,  &NULL);  &__start; }));
    }' unless defined(&NFA_NEST);
    eval 'sub NFA_NEST_END {
        my($skb, $start) = @_;
	    eval q(({ -> &nfa_len = (-> &tail - ($start)); ($skb)-> &len; }));
    }' unless defined(&NFA_NEST_END);
    eval 'sub NFA_NEST_CANCEL {
        my($skb, $start) = @_;
	    eval q(({  &if ($start)  &skb_trim($skb, ($start) - ($skb)-> &data); -1; }));
    }' unless defined(&NFA_NEST_CANCEL);
    eval 'sub NFNETLINK_V0 () {0;}' unless defined(&NFNETLINK_V0);
    eval 'sub NFM_NFA {
        my($n) = @_;
	    eval q((((($n)) +  &NLMSG_ALIGN($sizeof{\'struct nfgenmsg\'}))));
    }' unless defined(&NFM_NFA);
    eval 'sub NFM_PAYLOAD {
        my($n) = @_;
	    eval q( &NLMSG_PAYLOAD($n, $sizeof{\'struct nfgenmsg\'}));
    }' unless defined(&NFM_PAYLOAD);
    eval 'sub NFNL_SUBSYS_ID {
        my($x) = @_;
	    eval q((($x & 0xff00) >> 8));
    }' unless defined(&NFNL_SUBSYS_ID);
    eval 'sub NFNL_MSG_TYPE {
        my($x) = @_;
	    eval q(($x & 0xff));
    }' unless defined(&NFNL_MSG_TYPE);
    eval 'sub NFNL_SUBSYS_NONE () {0;}' unless defined(&NFNL_SUBSYS_NONE);
    eval 'sub NFNL_SUBSYS_CTNETLINK () {1;}' unless defined(&NFNL_SUBSYS_CTNETLINK);
    eval 'sub NFNL_SUBSYS_CTNETLINK_EXP () {2;}' unless defined(&NFNL_SUBSYS_CTNETLINK_EXP);
    eval 'sub NFNL_SUBSYS_QUEUE () {3;}' unless defined(&NFNL_SUBSYS_QUEUE);
    eval 'sub NFNL_SUBSYS_ULOG () {4;}' unless defined(&NFNL_SUBSYS_ULOG);
    eval 'sub NFNL_SUBSYS_COUNT () {5;}' unless defined(&NFNL_SUBSYS_COUNT);
    if(defined(&__KERNEL__)) {
	require 'linux/netlink.ph';
	require 'linux/capability.ph';
	eval 'sub NFA_PUT {
	    my($skb, $attrtype, $attrlen, $data) = @_;
    	    eval q(({  &if ( &skb_tailroom <  &NFA_SPACE($attrlen))  &goto  &nfattr_failure;  &__nfa_fill($skb, $attrtype, $attrlen, $data); }));
	}' unless defined(&NFA_PUT);
	eval 'sub nfnl_shlock () {
	    eval q( &down( &nfnl_sem));
	}' unless defined(&nfnl_shlock);
	eval 'sub nfnl_shlock_nowait () {
	    eval q( &down_trylock( &nfnl_sem));
	}' unless defined(&nfnl_shlock_nowait);
	eval 'sub nfnl_shunlock () {
	    eval q( &do {  &up( &nfnl_sem);  &if( &nfnl  &&  ($nfnl->{sk_receive_queue}->{qlen}))  ($nfnl->{sk_data_ready})( &nfnl, 0); }  &while(0));
	}' unless defined(&nfnl_shunlock);
	eval 'sub nfattr_parse_nested {
	    my($tb, $max, $nfa) = @_;
    	    eval q( &nfattr_parse(($tb), ($max),  &NFA_DATA(($nfa)),  &NFA_PAYLOAD(($nfa))));
	}' unless defined(&nfattr_parse_nested);
	eval 'sub nfattr_bad_size {
	    my($tb, $max, $cta_min) = @_;
    	    eval q(({ \'int\'  &__i,  &__res = 0;  &for ( &__i=0;  &__i<$max;  &__i++) {  &if (!$cta_min->[ &__i])  &continue;  &if ($tb->[ &__i]  &&  &NFA_PAYLOAD($tb->[ &__i]) < $cta_min->[ &__i]){  &__res = 1;  &break; } }  &__res; }));
	}' unless defined(&nfattr_bad_size);
	eval 'sub MODULE_ALIAS_NFNL_SUBSYS {
	    my($subsys) = @_;
    	    eval q( &MODULE_ALIAS(\\"nfnetlink-subsys-\\"  &__stringify($subsys)));
	}' unless defined(&MODULE_ALIAS_NFNL_SUBSYS);
    }
}
1;
