require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_IP_CONNTRACK_H)) {
    eval 'sub _IP_CONNTRACK_H () {1;}' unless defined(&_IP_CONNTRACK_H);
    require 'linux/netfilter/nf_conntrack_common.ph';
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/netfilter_ipv4/ip_conntrack_tuple.ph';
	require 'linux/bitops.ph';
	require 'linux/compiler.ph';
	require 'asm/atomic.ph';
	require 'linux/netfilter_ipv4/ip_conntrack_tcp.ph';
	require 'linux/netfilter_ipv4/ip_conntrack_icmp.ph';
	require 'linux/netfilter_ipv4/ip_conntrack_proto_gre.ph';
	require 'linux/netfilter_ipv4/ip_conntrack_sctp.ph';
	require 'linux/netfilter_ipv4/ip_conntrack_h323.ph';
	require 'linux/netfilter_ipv4/ip_conntrack_pptp.ph';
	require 'linux/netfilter_ipv4/ip_conntrack_amanda.ph';
	require 'linux/netfilter_ipv4/ip_conntrack_ftp.ph';
	require 'linux/netfilter_ipv4/ip_conntrack_irc.ph';
	if(defined(&CONFIG_IP_NF_NAT_NEEDED)) {
	    require 'linux/netfilter_ipv4/ip_nat.ph';
	    require 'linux/netfilter_ipv4/ip_nat_pptp.ph';
	}
	require 'linux/types.ph';
	require 'linux/skbuff.ph';
	if(defined(&CONFIG_NETFILTER_DEBUG)) {
	    eval 'sub IP_NF_ASSERT {
	        my($x) = @_;
    		eval q( &do {  &if (!($x))  &printk(\\"NF_IP_ASSERT: %s:%i(%s)\\\\n\\",  &__FILE__,  &__LINE__,  &__FUNCTION__); }  &while(0));
	    }' unless defined(&IP_NF_ASSERT);
	} else {
	    eval 'sub IP_NF_ASSERT {
	        my($x) = @_;
    		eval q();
	    }' unless defined(&IP_NF_ASSERT);
	}
	if(defined(&CONFIG_IP_NF_CT_ACCT)) {
	}
	if(defined(&CONFIG_IP_NF_NAT_NEEDED)) {
	    if(defined( &CONFIG_IP_NF_TARGET_MASQUERADE) || defined( &CONFIG_IP_NF_TARGET_MASQUERADE_MODULE)) {
	    }
	}
	if(defined( &CONFIG_IP_NF_CONNTRACK_MARK)) {
	}
	if(defined(&CONFIG_IP_NF_NAT_NEEDED)) {
	}
	eval 'sub IP_CT_EXPECT_PERMANENT () {0x1;}' unless defined(&IP_CT_EXPECT_PERMANENT);
	eval 'sub tuplehash_to_ctrack {
	    my($hash) = @_;
    	    eval q({  &container_of($hash, \'struct ip_conntrack\',  $tuplehash[ ($hash->{tuple}->{dst}->{dir})]); });
	}' unless defined(&tuplehash_to_ctrack);
	eval 'sub master_ct {
	    my($conntr) = @_;
    	    eval q(( ($conntr->{master})));
	}' unless defined(&master_ct);
	eval 'sub is_dying {
	    my($ct) = @_;
    	    eval q({  &test_bit( &IPS_DYING_BIT,  ($ct->{status})); });
	}' unless defined(&is_dying);
	eval 'sub CONNTRACK_STAT_INC {
	    my($count) = @_;
    	    eval q(( &__get_cpu_var( &ip_conntrack_stat).$count++));
	}' unless defined(&CONNTRACK_STAT_INC);
	if(defined(&CONFIG_IP_NF_CONNTRACK_EVENTS)) {
	    require 'linux/notifier.ph';
	    require 'linux/interrupt.ph';
	    eval 'sub CONNTRACK_ECACHE {
	        my($x) = @_;
    		eval q(( &__get_cpu_var( &ip_conntrack_ecache).$x));
	    }' unless defined(&CONNTRACK_ECACHE);
	    eval 'sub ip_conntrack_register_notifier {
	        my($nb) = @_;
    		eval q({  &atomic_notifier_chain_register( &ip_conntrack_chain, $nb); });
	    }' unless defined(&ip_conntrack_register_notifier);
	    eval 'sub ip_conntrack_unregister_notifier {
	        my($nb) = @_;
    		eval q({  &atomic_notifier_chain_unregister( &ip_conntrack_chain, $nb); });
	    }' unless defined(&ip_conntrack_unregister_notifier);
	    eval 'sub ip_conntrack_expect_register_notifier {
	        my($nb) = @_;
    		eval q({  &atomic_notifier_chain_register( &ip_conntrack_expect_chain, $nb); });
	    }' unless defined(&ip_conntrack_expect_register_notifier);
	    eval 'sub ip_conntrack_expect_unregister_notifier {
	        my($nb) = @_;
    		eval q({  &atomic_notifier_chain_unregister( &ip_conntrack_expect_chain, $nb); });
	    }' unless defined(&ip_conntrack_expect_unregister_notifier);
	    eval 'sub ip_conntrack_event_cache {
	        my($event,$skb) = @_;
    		eval q({ \'struct ip_conntrack\' * &ct =  ($skb->{nfct}); \'struct ip_conntrack_ecache\' * &ecache;  &local_bh_disable();  &ecache = & &__get_cpu_var( &ip_conntrack_ecache);  &if ( &ct !=  ($ecache->{ct}))  &__ip_ct_event_cache_init( &ct);  ($ecache->{events}) |= $event;  &local_bh_enable(); });
	    }' unless defined(&ip_conntrack_event_cache);
	    eval 'sub ip_conntrack_event {
	        my($event,$ct) = @_;
    		eval q({  &if ( &is_confirmed($ct)  && ! &is_dying($ct))  &atomic_notifier_call_chain( &ip_conntrack_chain, $event, $ct); });
	    }' unless defined(&ip_conntrack_event);
	    eval 'sub ip_conntrack_expect_event {
	        my($event,$exp) = @_;
    		eval q({  &atomic_notifier_call_chain( &ip_conntrack_expect_chain, $event, $exp); });
	    }' unless defined(&ip_conntrack_expect_event);
	} else {
	}
    }
}
1;
