require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_NODEMASK_H)) {
    eval 'sub __LINUX_NODEMASK_H () {1;}' unless defined(&__LINUX_NODEMASK_H);
    if(defined(&__KERNEL__)) {
	require 'linux/kernel.ph';
	require 'linux/threads.ph';
	require 'linux/bitmap.ph';
	require 'linux/numa.ph';
	eval 'sub node_set {
	    my($node, $dst) = @_;
    	    eval q( &__node_set(($node), ($dst)));
	}' unless defined(&node_set);
	eval 'sub __node_set {
	    my($node,$dstp) = @_;
    	    eval q({  &set_bit($node,  ($dstp->{bits})); });
	}' unless defined(&__node_set);
	eval 'sub node_clear {
	    my($node, $dst) = @_;
    	    eval q( &__node_clear(($node), ($dst)));
	}' unless defined(&node_clear);
	eval 'sub __node_clear {
	    my($node,$dstp) = @_;
    	    eval q({  &clear_bit($node,  ($dstp->{bits})); });
	}' unless defined(&__node_clear);
	eval 'sub nodes_setall {
	    my($dst) = @_;
    	    eval q( &__nodes_setall(($dst),  &MAX_NUMNODES));
	}' unless defined(&nodes_setall);
	eval 'sub __nodes_setall {
	    my($dstp,$nbits) = @_;
    	    eval q({  &bitmap_fill( ($dstp->{bits}), $nbits); });
	}' unless defined(&__nodes_setall);
	eval 'sub nodes_clear {
	    my($dst) = @_;
    	    eval q( &__nodes_clear(($dst),  &MAX_NUMNODES));
	}' unless defined(&nodes_clear);
	eval 'sub __nodes_clear {
	    my($dstp,$nbits) = @_;
    	    eval q({  &bitmap_zero( ($dstp->{bits}), $nbits); });
	}' unless defined(&__nodes_clear);
	eval 'sub node_isset {
	    my($node, $nodemask) = @_;
    	    eval q( &test_bit(($node), ($nodemask). &bits));
	}' unless defined(&node_isset);
	eval 'sub node_test_and_set {
	    my($node, $nodemask) = @_;
    	    eval q( &__node_test_and_set(($node), ($nodemask)));
	}' unless defined(&node_test_and_set);
	eval 'sub __node_test_and_set {
	    my($node,$addr) = @_;
    	    eval q({  &test_and_set_bit($node,  ($addr->{bits})); });
	}' unless defined(&__node_test_and_set);
	eval 'sub nodes_and {
	    my($dst, $src1, $src2) = @_;
    	    eval q( &__nodes_and(($dst), ($src1), ($src2),  &MAX_NUMNODES));
	}' unless defined(&nodes_and);
	eval 'sub __nodes_and {
	    my($dstp,$src1p,$src2p,$nbits) = @_;
    	    eval q({  &bitmap_and( ($dstp->{bits}),  ($src1p->{bits}),  ($src2p->{bits}), $nbits); });
	}' unless defined(&__nodes_and);
	eval 'sub nodes_or {
	    my($dst, $src1, $src2) = @_;
    	    eval q( &__nodes_or(($dst), ($src1), ($src2),  &MAX_NUMNODES));
	}' unless defined(&nodes_or);
	eval 'sub __nodes_or {
	    my($dstp,$src1p,$src2p,$nbits) = @_;
    	    eval q({  &bitmap_or( ($dstp->{bits}),  ($src1p->{bits}),  ($src2p->{bits}), $nbits); });
	}' unless defined(&__nodes_or);
	eval 'sub nodes_xor {
	    my($dst, $src1, $src2) = @_;
    	    eval q( &__nodes_xor(($dst), ($src1), ($src2),  &MAX_NUMNODES));
	}' unless defined(&nodes_xor);
	eval 'sub __nodes_xor {
	    my($dstp,$src1p,$src2p,$nbits) = @_;
    	    eval q({  &bitmap_xor( ($dstp->{bits}),  ($src1p->{bits}),  ($src2p->{bits}), $nbits); });
	}' unless defined(&__nodes_xor);
	eval 'sub nodes_andnot {
	    my($dst, $src1, $src2) = @_;
    	    eval q( &__nodes_andnot(($dst), ($src1), ($src2),  &MAX_NUMNODES));
	}' unless defined(&nodes_andnot);
	eval 'sub __nodes_andnot {
	    my($dstp,$src1p,$src2p,$nbits) = @_;
    	    eval q({  &bitmap_andnot( ($dstp->{bits}),  ($src1p->{bits}),  ($src2p->{bits}), $nbits); });
	}' unless defined(&__nodes_andnot);
	eval 'sub nodes_complement {
	    my($dst, $src) = @_;
    	    eval q( &__nodes_complement(($dst), ($src),  &MAX_NUMNODES));
	}' unless defined(&nodes_complement);
	eval 'sub __nodes_complement {
	    my($dstp,$srcp,$nbits) = @_;
    	    eval q({  &bitmap_complement( ($dstp->{bits}),  ($srcp->{bits}), $nbits); });
	}' unless defined(&__nodes_complement);
	eval 'sub nodes_equal {
	    my($src1, $src2) = @_;
    	    eval q( &__nodes_equal(($src1), ($src2),  &MAX_NUMNODES));
	}' unless defined(&nodes_equal);
	eval 'sub __nodes_equal {
	    my($src1p,$src2p,$nbits) = @_;
    	    eval q({  &bitmap_equal( ($src1p->{bits}),  ($src2p->{bits}), $nbits); });
	}' unless defined(&__nodes_equal);
	eval 'sub nodes_intersects {
	    my($src1, $src2) = @_;
    	    eval q( &__nodes_intersects(($src1), ($src2),  &MAX_NUMNODES));
	}' unless defined(&nodes_intersects);
	eval 'sub __nodes_intersects {
	    my($src1p,$src2p,$nbits) = @_;
    	    eval q({  &bitmap_intersects( ($src1p->{bits}),  ($src2p->{bits}), $nbits); });
	}' unless defined(&__nodes_intersects);
	eval 'sub nodes_subset {
	    my($src1, $src2) = @_;
    	    eval q( &__nodes_subset(($src1), ($src2),  &MAX_NUMNODES));
	}' unless defined(&nodes_subset);
	eval 'sub __nodes_subset {
	    my($src1p,$src2p,$nbits) = @_;
    	    eval q({  &bitmap_subset( ($src1p->{bits}),  ($src2p->{bits}), $nbits); });
	}' unless defined(&__nodes_subset);
	eval 'sub nodes_empty {
	    my($src) = @_;
    	    eval q( &__nodes_empty(($src),  &MAX_NUMNODES));
	}' unless defined(&nodes_empty);
	eval 'sub __nodes_empty {
	    my($srcp,$nbits) = @_;
    	    eval q({  &bitmap_empty( ($srcp->{bits}), $nbits); });
	}' unless defined(&__nodes_empty);
	eval 'sub nodes_full {
	    my($nodemask) = @_;
    	    eval q( &__nodes_full(($nodemask),  &MAX_NUMNODES));
	}' unless defined(&nodes_full);
	eval 'sub __nodes_full {
	    my($srcp,$nbits) = @_;
    	    eval q({  &bitmap_full( ($srcp->{bits}), $nbits); });
	}' unless defined(&__nodes_full);
	eval 'sub nodes_weight {
	    my($nodemask) = @_;
    	    eval q( &__nodes_weight(($nodemask),  &MAX_NUMNODES));
	}' unless defined(&nodes_weight);
	eval 'sub __nodes_weight {
	    my($srcp,$nbits) = @_;
    	    eval q({  &bitmap_weight( ($srcp->{bits}), $nbits); });
	}' unless defined(&__nodes_weight);
	eval 'sub nodes_shift_right {
	    my($dst, $src, $n) = @_;
    	    eval q( &__nodes_shift_right(($dst), ($src), ($n),  &MAX_NUMNODES));
	}' unless defined(&nodes_shift_right);
	eval 'sub __nodes_shift_right {
	    my($dstp,$srcp,$n,$nbits) = @_;
    	    eval q({  &bitmap_shift_right( ($dstp->{bits}),  ($srcp->{bits}), $n, $nbits); });
	}' unless defined(&__nodes_shift_right);
	eval 'sub nodes_shift_left {
	    my($dst, $src, $n) = @_;
    	    eval q( &__nodes_shift_left(($dst), ($src), ($n),  &MAX_NUMNODES));
	}' unless defined(&nodes_shift_left);
	eval 'sub __nodes_shift_left {
	    my($dstp,$srcp,$n,$nbits) = @_;
    	    eval q({  &bitmap_shift_left( ($dstp->{bits}),  ($srcp->{bits}), $n, $nbits); });
	}' unless defined(&__nodes_shift_left);
	eval 'sub first_node {
	    my($src) = @_;
    	    eval q( &__first_node(($src)));
	}' unless defined(&first_node);
	eval 'sub __first_node {
	    my($srcp) = @_;
    	    eval q({  &min_t(\'int\',  &MAX_NUMNODES,  &find_first_bit( ($srcp->{bits}),  &MAX_NUMNODES)); });
	}' unless defined(&__first_node);
	eval 'sub next_node {
	    my($n, $src) = @_;
    	    eval q( &__next_node(($n), ($src)));
	}' unless defined(&next_node);
	eval 'sub __next_node {
	    my($n,$srcp) = @_;
    	    eval q({  &min_t(\'int\', &MAX_NUMNODES, &find_next_bit( ($srcp->{bits}),  &MAX_NUMNODES, $n+1)); });
	}' unless defined(&__next_node);
	eval 'sub nodemask_of_node {
	    my($node) = @_;
    	    eval q(({  &typeof( &_unused_nodemask_arg_)  &m;  &if ($sizeof{ &m} == $sizeof{\'unsigned long\'}) {  ($m->{bits[0]}) = 1<<($node); }  &else {  &nodes_clear( &m);  &node_set(($node),  &m); }  &m; }));
	}' unless defined(&nodemask_of_node);
	eval 'sub first_unset_node {
	    my($mask) = @_;
    	    eval q( &__first_unset_node(($mask)));
	}' unless defined(&first_unset_node);
	eval 'sub __first_unset_node {
	    my($maskp) = @_;
    	    eval q({  &min_t(\'int\', &MAX_NUMNODES,  &find_first_zero_bit( ($maskp->{bits}),  &MAX_NUMNODES)); });
	}' unless defined(&__first_unset_node);
	eval 'sub NODE_MASK_LAST_WORD () { &BITMAP_LAST_WORD_MASK( &MAX_NUMNODES);}' unless defined(&NODE_MASK_LAST_WORD);
	if((defined(&MAX_NUMNODES) ? &MAX_NUMNODES : 0) <= (defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0)) {
	    eval 'sub NODE_MASK_ALL () {(( &nodemask_t) { { [ &BITS_TO_LONGS( &MAX_NUMNODES)-1] =  &NODE_MASK_LAST_WORD } });}' unless defined(&NODE_MASK_ALL);
	} else {
	    eval 'sub NODE_MASK_ALL () {(( &nodemask_t) { { [0...  &BITS_TO_LONGS( &MAX_NUMNODES)-2] = ~0, [ &BITS_TO_LONGS( &MAX_NUMNODES)-1] =  &NODE_MASK_LAST_WORD } });}' unless defined(&NODE_MASK_ALL);
	}
	eval 'sub NODE_MASK_NONE () {(( &nodemask_t) { { [0...  &BITS_TO_LONGS( &MAX_NUMNODES)-1] = 0 } });}' unless defined(&NODE_MASK_NONE);
	eval 'sub nodes_addr {
	    my($src) = @_;
    	    eval q((($src). &bits));
	}' unless defined(&nodes_addr);
	eval 'sub nodemask_scnprintf {
	    my($buf, $len, $src) = @_;
    	    eval q( &__nodemask_scnprintf(($buf), ($len), ($src),  &MAX_NUMNODES));
	}' unless defined(&nodemask_scnprintf);
	eval 'sub __nodemask_scnprintf {
	    my($buf,$len,$srcp,$nbits) = @_;
    	    eval q({  &bitmap_scnprintf($buf, $len,  ($srcp->{bits}), $nbits); });
	}' unless defined(&__nodemask_scnprintf);
	eval 'sub nodemask_parse {
	    my($ubuf, $ulen, $dst) = @_;
    	    eval q( &__nodemask_parse(($ubuf), ($ulen), ($dst),  &MAX_NUMNODES));
	}' unless defined(&nodemask_parse);
	eval 'sub __nodemask_parse {
	    my($buf,$len,$dstp,$nbits) = @_;
    	    eval q({  &bitmap_parse($buf, $len,  ($dstp->{bits}), $nbits); });
	}' unless defined(&__nodemask_parse);
	eval 'sub nodelist_scnprintf {
	    my($buf, $len, $src) = @_;
    	    eval q( &__nodelist_scnprintf(($buf), ($len), ($src),  &MAX_NUMNODES));
	}' unless defined(&nodelist_scnprintf);
	eval 'sub __nodelist_scnprintf {
	    my($buf,$len,$srcp,$nbits) = @_;
    	    eval q({  &bitmap_scnlistprintf($buf, $len,  ($srcp->{bits}), $nbits); });
	}' unless defined(&__nodelist_scnprintf);
	eval 'sub nodelist_parse {
	    my($buf, $dst) = @_;
    	    eval q( &__nodelist_parse(($buf), ($dst),  &MAX_NUMNODES));
	}' unless defined(&nodelist_parse);
	eval 'sub __nodelist_parse {
	    my($buf,$dstp,$nbits) = @_;
    	    eval q({  &bitmap_parselist($buf,  ($dstp->{bits}), $nbits); });
	}' unless defined(&__nodelist_parse);
	eval 'sub node_remap {
	    my($oldbit, $old, $new) = @_;
    	    eval q( &__node_remap(($oldbit), ($old), ($new),  &MAX_NUMNODES));
	}' unless defined(&node_remap);
	eval 'sub __node_remap {
	    my($oldbit,$oldp,$newp,$nbits) = @_;
    	    eval q({  &bitmap_bitremap($oldbit,  ($oldp->{bits}),  ($newp->{bits}), $nbits); });
	}' unless defined(&__node_remap);
	eval 'sub nodes_remap {
	    my($dst, $src, $old, $new) = @_;
    	    eval q( &__nodes_remap(($dst), ($src), ($old), ($new),  &MAX_NUMNODES));
	}' unless defined(&nodes_remap);
	eval 'sub __nodes_remap {
	    my($dstp,$srcp,$oldp,$newp,$nbits) = @_;
    	    eval q({  &bitmap_remap( ($dstp->{bits}),  ($srcp->{bits}),  ($oldp->{bits}),  ($newp->{bits}), $nbits); });
	}' unless defined(&__nodes_remap);
	if((defined(&MAX_NUMNODES) ? &MAX_NUMNODES : 0) > 1) {
	    eval 'sub for_each_node_mask {
	        my($node, $mask) = @_;
    		eval q( &for (($node) =  &first_node($mask); ($node) <  &MAX_NUMNODES; ($node) =  &next_node(($node), ($mask))));
	    }' unless defined(&for_each_node_mask);
	} else {
	    eval 'sub for_each_node_mask {
	        my($node, $mask) = @_;
    		eval q( &if (! &nodes_empty($mask))  &for (($node) = 0; ($node) < 1; ($node)++));
	    }' unless defined(&for_each_node_mask);
	}
	if((defined(&MAX_NUMNODES) ? &MAX_NUMNODES : 0) > 1) {
	    eval 'sub num_online_nodes () {
	        eval q( &nodes_weight( &node_online_map));
	    }' unless defined(&num_online_nodes);
	    eval 'sub num_possible_nodes () {
	        eval q( &nodes_weight( &node_possible_map));
	    }' unless defined(&num_possible_nodes);
	    eval 'sub node_online {
	        my($node) = @_;
    		eval q( &node_isset(($node),  &node_online_map));
	    }' unless defined(&node_online);
	    eval 'sub node_possible {
	        my($node) = @_;
    		eval q( &node_isset(($node),  &node_possible_map));
	    }' unless defined(&node_possible);
	    eval 'sub first_online_node () { &first_node( &node_online_map);}' unless defined(&first_online_node);
	    eval 'sub next_online_node {
	        my($nid) = @_;
    		eval q( &next_node(($nid),  &node_online_map));
	    }' unless defined(&next_online_node);
	} else {
	    eval 'sub num_online_nodes () {
	        eval q(1);
	    }' unless defined(&num_online_nodes);
	    eval 'sub num_possible_nodes () {
	        eval q(1);
	    }' unless defined(&num_possible_nodes);
	    eval 'sub node_online {
	        my($node) = @_;
    		eval q((($node) == 0));
	    }' unless defined(&node_online);
	    eval 'sub node_possible {
	        my($node) = @_;
    		eval q((($node) == 0));
	    }' unless defined(&node_possible);
	    eval 'sub first_online_node () {0;}' unless defined(&first_online_node);
	    eval 'sub next_online_node {
	        my($nid) = @_;
    		eval q(( &MAX_NUMNODES));
	    }' unless defined(&next_online_node);
	}
	eval 'sub any_online_node {
	    my($mask) = @_;
    	    eval q(({ \'int\'  &node;  &for_each_node_mask( &node, ($mask))  &if ( &node_online( &node))  &break;  &node; }));
	}' unless defined(&any_online_node);
	eval 'sub node_set_online {
	    my($node) = @_;
    	    eval q( &set_bit(($node),  ($node_online_map->{bits})));
	}' unless defined(&node_set_online);
	eval 'sub node_set_offline {
	    my($node) = @_;
    	    eval q( &clear_bit(($node),  ($node_online_map->{bits})));
	}' unless defined(&node_set_offline);
	eval 'sub for_each_node {
	    my($node) = @_;
    	    eval q( &for_each_node_mask(($node),  &node_possible_map));
	}' unless defined(&for_each_node);
	eval 'sub for_each_online_node {
	    my($node) = @_;
    	    eval q( &for_each_node_mask(($node),  &node_online_map));
	}' unless defined(&for_each_online_node);
    }
}
1;
