require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__PHY_H)) {
    eval 'sub __PHY_H () {1;}' unless defined(&__PHY_H);
    require 'linux/spinlock.ph';
    require 'linux/device.ph';
    eval 'sub PHY_BASIC_FEATURES () {( &SUPPORTED_10baseT_Half |  &SUPPORTED_10baseT_Full |  &SUPPORTED_100baseT_Half |  &SUPPORTED_100baseT_Full |  &SUPPORTED_Autoneg |  &SUPPORTED_TP |  &SUPPORTED_MII);}' unless defined(&PHY_BASIC_FEATURES);
    eval 'sub PHY_GBIT_FEATURES () {( &PHY_BASIC_FEATURES |  &SUPPORTED_1000baseT_Half |  &SUPPORTED_1000baseT_Full);}' unless defined(&PHY_GBIT_FEATURES);
    eval 'sub PHY_POLL () {-1;}' unless defined(&PHY_POLL);
    eval 'sub PHY_IGNORE_INTERRUPT () {-2;}' unless defined(&PHY_IGNORE_INTERRUPT);
    eval 'sub PHY_HAS_INTERRUPT () {0x1;}' unless defined(&PHY_HAS_INTERRUPT);
    eval 'sub PHY_HAS_MAGICANEG () {0x2;}' unless defined(&PHY_HAS_MAGICANEG);
    eval 'sub MII_BUS_MAX () {4;}' unless defined(&MII_BUS_MAX);
    eval 'sub PHY_INIT_TIMEOUT () {100000;}' unless defined(&PHY_INIT_TIMEOUT);
    eval 'sub PHY_STATE_TIME () {1;}' unless defined(&PHY_STATE_TIME);
    eval 'sub PHY_FORCE_TIMEOUT () {10;}' unless defined(&PHY_FORCE_TIMEOUT);
    eval 'sub PHY_AN_TIMEOUT () {10;}' unless defined(&PHY_AN_TIMEOUT);
    eval 'sub PHY_MAX_ADDR () {32;}' unless defined(&PHY_MAX_ADDR);
    eval 'sub PHY_ID_FMT () {"%x:%02x";}' unless defined(&PHY_ID_FMT);
    eval 'sub PHY_INTERRUPT_DISABLED () {0x;}' unless defined(&PHY_INTERRUPT_DISABLED);
    eval 'sub PHY_INTERRUPT_ENABLED () {0x80000000;}' unless defined(&PHY_INTERRUPT_ENABLED);
    eval("sub PHY_DOWN () { 0; }") unless defined(&PHY_DOWN);
    eval("sub PHY_STARTING () { 1; }") unless defined(&PHY_STARTING);
    eval("sub PHY_READY () { 2; }") unless defined(&PHY_READY);
    eval("sub PHY_PENDING () { 3; }") unless defined(&PHY_PENDING);
    eval("sub PHY_UP () { 4; }") unless defined(&PHY_UP);
    eval("sub PHY_AN () { 5; }") unless defined(&PHY_AN);
    eval("sub PHY_RUNNING () { 6; }") unless defined(&PHY_RUNNING);
    eval("sub PHY_NOLINK () { 7; }") unless defined(&PHY_NOLINK);
    eval("sub PHY_FORCING () { 8; }") unless defined(&PHY_FORCING);
    eval("sub PHY_CHANGELINK () { 9; }") unless defined(&PHY_CHANGELINK);
    eval("sub PHY_HALTED () { 10; }") unless defined(&PHY_HALTED);
    eval("sub PHY_RESUMING () { 11; }") unless defined(&PHY_RESUMING);
    eval 'sub to_phy_device {
        my($d) = @_;
	    eval q( &container_of($d, \'struct phy_device\',  &dev));
    }' unless defined(&to_phy_device);
    eval 'sub to_phy_driver {
        my($d) = @_;
	    eval q( &container_of($d, \'struct phy_driver\',  &driver));
    }' unless defined(&to_phy_driver);
    eval 'sub phy_read_status {
        my($phydev) = @_;
	    eval q({  ($phydev->{drv}->{read_status})($phydev); });
    }' unless defined(&phy_read_status);
}
1;
