require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_REISER_FS_SB)) {
    eval 'sub _LINUX_REISER_FS_SB () {1;}' unless defined(&_LINUX_REISER_FS_SB);
    if(defined(&__KERNEL__)) {
	require 'linux/workqueue.ph';
	require 'linux/rwsem.ph';
    }
    eval("sub reiserfs_attrs_cleared () { 0x00000001; }") unless defined(&reiserfs_attrs_cleared);
    eval 'sub sb_block_count {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_block_count}))));
    }' unless defined(&sb_block_count);
    eval 'sub set_sb_block_count {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_block_count}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_block_count);
    eval 'sub sb_free_blocks {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_free_blocks}))));
    }' unless defined(&sb_free_blocks);
    eval 'sub set_sb_free_blocks {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_free_blocks}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_free_blocks);
    eval 'sub sb_root_block {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_root_block}))));
    }' unless defined(&sb_root_block);
    eval 'sub set_sb_root_block {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_root_block}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_root_block);
    eval 'sub sb_jp_journal_1st_block {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_1st_block}))));
    }' unless defined(&sb_jp_journal_1st_block);
    eval 'sub set_sb_jp_journal_1st_block {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_1st_block}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_1st_block);
    eval 'sub sb_jp_journal_dev {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_dev}))));
    }' unless defined(&sb_jp_journal_dev);
    eval 'sub set_sb_jp_journal_dev {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_dev}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_dev);
    eval 'sub sb_jp_journal_size {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_size}))));
    }' unless defined(&sb_jp_journal_size);
    eval 'sub set_sb_jp_journal_size {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_size}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_size);
    eval 'sub sb_jp_journal_trans_max {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_trans_max}))));
    }' unless defined(&sb_jp_journal_trans_max);
    eval 'sub set_sb_jp_journal_trans_max {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_trans_max}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_trans_max);
    eval 'sub sb_jp_journal_magic {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_magic}))));
    }' unless defined(&sb_jp_journal_magic);
    eval 'sub set_sb_jp_journal_magic {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_magic}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_magic);
    eval 'sub sb_jp_journal_max_batch {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_max_batch}))));
    }' unless defined(&sb_jp_journal_max_batch);
    eval 'sub set_sb_jp_journal_max_batch {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_max_batch}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_max_batch);
    eval 'sub sb_jp_jourmal_max_commit_age {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_journal}->{jp_journal_max_commit_age}))));
    }' unless defined(&sb_jp_jourmal_max_commit_age);
    eval 'sub set_sb_jp_journal_max_commit_age {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_journal}->{jp_journal_max_commit_age}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_jp_journal_max_commit_age);
    eval 'sub sb_blocksize {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_blocksize}))));
    }' unless defined(&sb_blocksize);
    eval 'sub set_sb_blocksize {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_blocksize}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_blocksize);
    eval 'sub sb_oid_maxsize {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_oid_maxsize}))));
    }' unless defined(&sb_oid_maxsize);
    eval 'sub set_sb_oid_maxsize {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_oid_maxsize}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_oid_maxsize);
    eval 'sub sb_oid_cursize {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_oid_cursize}))));
    }' unless defined(&sb_oid_cursize);
    eval 'sub set_sb_oid_cursize {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_oid_cursize}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_oid_cursize);
    eval 'sub sb_umount_state {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_umount_state}))));
    }' unless defined(&sb_umount_state);
    eval 'sub set_sb_umount_state {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_umount_state}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_umount_state);
    eval 'sub sb_fs_state {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_fs_state}))));
    }' unless defined(&sb_fs_state);
    eval 'sub set_sb_fs_state {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_fs_state}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_fs_state);
    eval 'sub sb_hash_function_code {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> ($s_v1->{s_hash_function_code}))));
    }' unless defined(&sb_hash_function_code);
    eval 'sub set_sb_hash_function_code {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_hash_function_code}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_hash_function_code);
    eval 'sub sb_tree_height {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_tree_height}))));
    }' unless defined(&sb_tree_height);
    eval 'sub set_sb_tree_height {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_tree_height}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_tree_height);
    eval 'sub sb_bmap_nr {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_bmap_nr}))));
    }' unless defined(&sb_bmap_nr);
    eval 'sub set_sb_bmap_nr {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_bmap_nr}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_bmap_nr);
    eval 'sub sb_version {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_version}))));
    }' unless defined(&sb_version);
    eval 'sub set_sb_version {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_version}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_version);
    eval 'sub sb_reserved_for_journal {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> ($s_v1->{s_reserved_for_journal}))));
    }' unless defined(&sb_reserved_for_journal);
    eval 'sub set_sb_reserved_for_journal {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> ($s_v1->{s_reserved_for_journal}) =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_reserved_for_journal);
    eval 'sub JOURNAL_BLOCK_SIZE () {4096;}' unless defined(&JOURNAL_BLOCK_SIZE);
    eval 'sub JOURNAL_MAX_CNODE () {1500;}' unless defined(&JOURNAL_MAX_CNODE);
    eval 'sub JOURNAL_HASH_SIZE () {8192;}' unless defined(&JOURNAL_HASH_SIZE);
    eval 'sub JOURNAL_NUM_BITMAPS () {5;}' unless defined(&JOURNAL_NUM_BITMAPS);
    eval("sub J_WRITERS_BLOCKED () { 1; }") unless defined(&J_WRITERS_BLOCKED);
    eval("sub J_WRITERS_QUEUED () { 2; }") unless defined(&J_WRITERS_QUEUED);
    eval("sub J_ABORTED () { 3; }") unless defined(&J_ABORTED);
    eval 'sub JOURNAL_DESC_MAGIC () {"ReIsErLB";}' unless defined(&JOURNAL_DESC_MAGIC);
    if(defined( (defined(&CONFIG_PROC_FS) ? &CONFIG_PROC_FS : 0) )  && defined( (defined(&CONFIG_REISERFS_PROC_INFO) ? &CONFIG_REISERFS_PROC_INFO : 0) )) {
    } else {
    }
    if(defined(&CONFIG_QUOTA)) {
    }
    eval 'sub REISERFS_3_5 () {0;}' unless defined(&REISERFS_3_5);
    eval 'sub REISERFS_3_6 () {1;}' unless defined(&REISERFS_3_6);
    eval("sub REISERFS_LARGETAIL () { 0; }") unless defined(&REISERFS_LARGETAIL);
    eval("sub REISERFS_SMALLTAIL () { 1; }") unless defined(&REISERFS_SMALLTAIL);
    eval("sub REPLAYONLY () { 2; }") unless defined(&REPLAYONLY);
    eval("sub REISERFS_CONVERT () { 3; }") unless defined(&REISERFS_CONVERT);
    eval("sub FORCE_TEA_HASH () { 4; }") unless defined(&FORCE_TEA_HASH);
    eval("sub FORCE_RUPASOV_HASH () { 5; }") unless defined(&FORCE_RUPASOV_HASH);
    eval("sub FORCE_R5_HASH () { 6; }") unless defined(&FORCE_R5_HASH);
    eval("sub FORCE_HASH_DETECT () { 7; }") unless defined(&FORCE_HASH_DETECT);
    eval("sub REISERFS_DATA_LOG () { 8; }") unless defined(&REISERFS_DATA_LOG);
    eval("sub REISERFS_DATA_ORDERED () { 9; }") unless defined(&REISERFS_DATA_ORDERED);
    eval("sub REISERFS_DATA_WRITEBACK () { 10; }") unless defined(&REISERFS_DATA_WRITEBACK);
    eval("sub REISERFS_NO_BORDER () { 11; }") unless defined(&REISERFS_NO_BORDER);
    eval("sub REISERFS_NO_UNHASHED_RELOCATION () { 12; }") unless defined(&REISERFS_NO_UNHASHED_RELOCATION);
    eval("sub REISERFS_HASHED_RELOCATION () { 13; }") unless defined(&REISERFS_HASHED_RELOCATION);
    eval("sub REISERFS_ATTRS () { 14; }") unless defined(&REISERFS_ATTRS);
    eval("sub REISERFS_XATTRS () { 15; }") unless defined(&REISERFS_XATTRS);
    eval("sub REISERFS_XATTRS_USER () { 16; }") unless defined(&REISERFS_XATTRS_USER);
    eval("sub REISERFS_POSIXACL () { 17; }") unless defined(&REISERFS_POSIXACL);
    eval("sub REISERFS_BARRIER_NONE () { 18; }") unless defined(&REISERFS_BARRIER_NONE);
    eval("sub REISERFS_BARRIER_FLUSH () { 19; }") unless defined(&REISERFS_BARRIER_FLUSH);
    eval("sub REISERFS_ERROR_PANIC () { 20; }") unless defined(&REISERFS_ERROR_PANIC);
    eval("sub REISERFS_ERROR_RO () { 21; }") unless defined(&REISERFS_ERROR_RO);
    eval("sub REISERFS_ERROR_CONTINUE () { 22; }") unless defined(&REISERFS_ERROR_CONTINUE);
    eval("sub REISERFS_QUOTA () { 23; }") unless defined(&REISERFS_QUOTA);
    eval("sub REISERFS_TEST1 () { 24; }") unless defined(&REISERFS_TEST1);
    eval("sub REISERFS_TEST2 () { 25; }") unless defined(&REISERFS_TEST2);
    eval("sub REISERFS_TEST3 () { 26; }") unless defined(&REISERFS_TEST3);
    eval("sub REISERFS_TEST4 () { 27; }") unless defined(&REISERFS_TEST4);
    eval("sub REISERFS_UNSUPPORTED_OPT () { 28; }") unless defined(&REISERFS_UNSUPPORTED_OPT);
    eval 'sub reiserfs_r5_hash {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &FORCE_R5_HASH)));
    }' unless defined(&reiserfs_r5_hash);
    eval 'sub reiserfs_rupasov_hash {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &FORCE_RUPASOV_HASH)));
    }' unless defined(&reiserfs_rupasov_hash);
    eval 'sub reiserfs_tea_hash {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &FORCE_TEA_HASH)));
    }' unless defined(&reiserfs_tea_hash);
    eval 'sub reiserfs_hash_detect {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &FORCE_HASH_DETECT)));
    }' unless defined(&reiserfs_hash_detect);
    eval 'sub reiserfs_no_border {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_NO_BORDER)));
    }' unless defined(&reiserfs_no_border);
    eval 'sub reiserfs_no_unhashed_relocation {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_NO_UNHASHED_RELOCATION)));
    }' unless defined(&reiserfs_no_unhashed_relocation);
    eval 'sub reiserfs_hashed_relocation {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_HASHED_RELOCATION)));
    }' unless defined(&reiserfs_hashed_relocation);
    eval 'sub reiserfs_test4 {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_TEST4)));
    }' unless defined(&reiserfs_test4);
    eval 'sub have_large_tails {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_LARGETAIL)));
    }' unless defined(&have_large_tails);
    eval 'sub have_small_tails {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_SMALLTAIL)));
    }' unless defined(&have_small_tails);
    eval 'sub replay_only {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REPLAYONLY)));
    }' unless defined(&replay_only);
    eval 'sub reiserfs_attrs {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_ATTRS)));
    }' unless defined(&reiserfs_attrs);
    eval 'sub old_format_only {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_properties & (1<<  &REISERFS_3_5)));
    }' unless defined(&old_format_only);
    eval 'sub convert_reiserfs {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_CONVERT)));
    }' unless defined(&convert_reiserfs);
    eval 'sub reiserfs_data_log {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_DATA_LOG)));
    }' unless defined(&reiserfs_data_log);
    eval 'sub reiserfs_data_ordered {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_DATA_ORDERED)));
    }' unless defined(&reiserfs_data_ordered);
    eval 'sub reiserfs_data_writeback {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_DATA_WRITEBACK)));
    }' unless defined(&reiserfs_data_writeback);
    eval 'sub reiserfs_xattrs {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_XATTRS)));
    }' unless defined(&reiserfs_xattrs);
    eval 'sub reiserfs_xattrs_user {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_XATTRS_USER)));
    }' unless defined(&reiserfs_xattrs_user);
    eval 'sub reiserfs_posixacl {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_POSIXACL)));
    }' unless defined(&reiserfs_posixacl);
    eval 'sub reiserfs_xattrs_optional {
        my($s) = @_;
	    eval q(( &reiserfs_xattrs_user($s) ||  &reiserfs_posixacl($s)));
    }' unless defined(&reiserfs_xattrs_optional);
    eval 'sub reiserfs_barrier_none {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_BARRIER_NONE)));
    }' unless defined(&reiserfs_barrier_none);
    eval 'sub reiserfs_barrier_flush {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_BARRIER_FLUSH)));
    }' unless defined(&reiserfs_barrier_flush);
    eval 'sub reiserfs_error_panic {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_ERROR_PANIC)));
    }' unless defined(&reiserfs_error_panic);
    eval 'sub reiserfs_error_ro {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<<  &REISERFS_ERROR_RO)));
    }' unless defined(&reiserfs_error_ro);
    eval 'sub CARRY_ON () {0;}' unless defined(&CARRY_ON);
    eval 'sub SCHEDULE_OCCURRED () {1;}' unless defined(&SCHEDULE_OCCURRED);
    eval 'sub SB_BUFFER_WITH_SB {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_sbh));
    }' unless defined(&SB_BUFFER_WITH_SB);
    eval 'sub SB_JOURNAL {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_journal));
    }' unless defined(&SB_JOURNAL);
    eval 'sub SB_JOURNAL_1st_RESERVED_BLOCK {
        my($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_1st_reserved_block));
    }' unless defined(&SB_JOURNAL_1st_RESERVED_BLOCK);
    eval 'sub SB_JOURNAL_LEN_FREE {
        my($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_journal_len_free));
    }' unless defined(&SB_JOURNAL_LEN_FREE);
    eval 'sub SB_AP_BITMAP {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_ap_bitmap));
    }' unless defined(&SB_AP_BITMAP);
    eval 'sub SB_DISK_JOURNAL_HEAD {
        my($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_header_bh->));
    }' unless defined(&SB_DISK_JOURNAL_HEAD);
    eval 'sub reiserfs_is_journal_aborted {
        my($journal) = @_;
	    eval q(( &unlikely ( &__reiserfs_is_journal_aborted ($journal))));
    }' unless defined(&reiserfs_is_journal_aborted);
    eval 'sub __reiserfs_is_journal_aborted {
        my($journal) = @_;
	    eval q({  &test_bit( &J_ABORTED,  ($journal->{j_state})); });
    }' unless defined(&__reiserfs_is_journal_aborted);
}
1;
