require '_h2ph_pre.ph';

no warnings 'redefine';

require 'linux/config.ph';
require 'linux/init.ph';
require 'linux/xattr.ph';
unless(defined(&REISERFS_XATTR_MAGIC)) {
    sub REISERFS_XATTR_MAGIC () {	0x52465841;}
}
if(defined(&__KERNEL__)) {
    if(defined(&CONFIG_REISERFS_FS_XATTR)) {
	eval 'sub is_reiserfs_priv_object {
	    my($inode) = @_;
    	    eval q( &IS_PRIVATE($inode));
	}' unless defined(&is_reiserfs_priv_object);
	eval 'sub has_xattr_dir {
	    my($inode) = @_;
    	    eval q(( &REISERFS_I($inode)-> &i_flags &  &i_has_xattr_dir));
	}' unless defined(&has_xattr_dir);
	if(defined(&CONFIG_REISERFS_FS_SECURITY)) {
	}
	eval 'sub reiserfs_write_lock_xattrs {
	    my($sb) = @_;
    	    eval q({  &down_write( &REISERFS_XATTR_DIR_SEM($sb)); });
	}' unless defined(&reiserfs_write_lock_xattrs);
	eval 'sub reiserfs_write_unlock_xattrs {
	    my($sb) = @_;
    	    eval q({  &up_write( &REISERFS_XATTR_DIR_SEM($sb)); });
	}' unless defined(&reiserfs_write_unlock_xattrs);
	eval 'sub reiserfs_read_lock_xattrs {
	    my($sb) = @_;
    	    eval q({  &down_read( &REISERFS_XATTR_DIR_SEM($sb)); });
	}' unless defined(&reiserfs_read_lock_xattrs);
	eval 'sub reiserfs_read_unlock_xattrs {
	    my($sb) = @_;
    	    eval q({  &up_read( &REISERFS_XATTR_DIR_SEM($sb)); });
	}' unless defined(&reiserfs_read_unlock_xattrs);
	eval 'sub reiserfs_write_lock_xattr_i {
	    my($inode) = @_;
    	    eval q({  &down_write( &REISERFS_I($inode)-> &xattr_sem); });
	}' unless defined(&reiserfs_write_lock_xattr_i);
	eval 'sub reiserfs_write_unlock_xattr_i {
	    my($inode) = @_;
    	    eval q({  &up_write( &REISERFS_I($inode)-> &xattr_sem); });
	}' unless defined(&reiserfs_write_unlock_xattr_i);
	eval 'sub reiserfs_read_lock_xattr_i {
	    my($inode) = @_;
    	    eval q({  &down_read( &REISERFS_I($inode)-> &xattr_sem); });
	}' unless defined(&reiserfs_read_lock_xattr_i);
	eval 'sub reiserfs_read_unlock_xattr_i {
	    my($inode) = @_;
    	    eval q({  &up_read( &REISERFS_I($inode)-> &xattr_sem); });
	}' unless defined(&reiserfs_read_unlock_xattr_i);
	eval 'sub reiserfs_mark_inode_private {
	    my($inode) = @_;
    	    eval q({  ($inode->{i_flags}) |=  &S_PRIVATE; });
	}' unless defined(&reiserfs_mark_inode_private);
    } else {
	eval 'sub is_reiserfs_priv_object {
	    my($inode) = @_;
    	    eval q(0);
	}' unless defined(&is_reiserfs_priv_object);
	eval 'sub reiserfs_mark_inode_private {
	    my($inode) = @_;
    	    eval q( &do {;}  &while(0));
	}' unless defined(&reiserfs_mark_inode_private);
	eval 'sub reiserfs_getxattr () { &NULL;}' unless defined(&reiserfs_getxattr);
	eval 'sub reiserfs_setxattr () { &NULL;}' unless defined(&reiserfs_setxattr);
	eval 'sub reiserfs_listxattr () { &NULL;}' unless defined(&reiserfs_listxattr);
	eval 'sub reiserfs_removexattr () { &NULL;}' unless defined(&reiserfs_removexattr);
	eval 'sub reiserfs_write_lock_xattrs {
	    my($sb) = @_;
    	    eval q( &do {;}  &while(0));
	}' unless defined(&reiserfs_write_lock_xattrs);
	eval 'sub reiserfs_write_unlock_xattrs {
	    my($sb) = @_;
    	    eval q( &do {;}  &while(0));
	}' unless defined(&reiserfs_write_unlock_xattrs);
	eval 'sub reiserfs_read_lock_xattrs {
	    my($sb) = @_;
    	    eval q();
	}' unless defined(&reiserfs_read_lock_xattrs);
	eval 'sub reiserfs_read_unlock_xattrs {
	    my($sb) = @_;
    	    eval q();
	}' unless defined(&reiserfs_read_unlock_xattrs);
	eval 'sub reiserfs_permission () { &NULL;}' unless defined(&reiserfs_permission);
	eval 'sub reiserfs_xattr_register_handlers () {
	    eval q(0);
	}' unless defined(&reiserfs_xattr_register_handlers);
	eval 'sub reiserfs_xattr_unregister_handlers () {
	    eval q();
	}' unless defined(&reiserfs_xattr_unregister_handlers);
	eval 'sub reiserfs_delete_xattrs {
	    my($inode) = @_;
    	    eval q({ 0; };);
	}' unless defined(&reiserfs_delete_xattrs);
	eval 'sub reiserfs_chown_xattrs {
	    my($inode,$attrs) = @_;
    	    eval q({ 0; };);
	}' unless defined(&reiserfs_chown_xattrs);
	eval 'sub reiserfs_xattr_init {
	    my($sb,$mount_flags) = @_;
    	    eval q({  ($sb->{s_flags}) = ( ($sb->{s_flags}) & ~ &MS_POSIXACL); 0; };);
	}' unless defined(&reiserfs_xattr_init);
    }
}
1;
