require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SMB_FS_H)) {
    eval 'sub _LINUX_SMB_FS_H () {1;}' unless defined(&_LINUX_SMB_FS_H);
    require 'linux/smb.ph';
    require 'linux/smb_fs_i.ph';
    require 'linux/smb_fs_sb.ph';
    eval 'sub SMB_IOC_GETMOUNTUID () { &_IOR(ord(\'u\'), 1,  &__kernel_old_uid_t);}' unless defined(&SMB_IOC_GETMOUNTUID);
    eval 'sub SMB_IOC_NEWCONN () { &_IOW(ord(\'u\'), 2, \'struct smb_conn_opt\');}' unless defined(&SMB_IOC_NEWCONN);
    eval 'sub SMB_IOC_GETMOUNTUID32 () { &_IOR(ord(\'u\'), 3,  &__kernel_uid32_t);}' unless defined(&SMB_IOC_GETMOUNTUID32);
    if(defined(&__KERNEL__)) {
	require 'linux/fs.ph';
	require 'linux/pagemap.ph';
	require 'linux/vmalloc.ph';
	require 'linux/smb_mount.ph';
	require 'asm/unaligned.ph';
	eval 'sub smb_sb_info {
	    eval q(* &SMB_SB(\'struct super_block\' * &sb) {  ($sb->{s_fs_info}); });
	}' unless defined(&smb_sb_info);
	eval 'sub smb_inode_info {
	    eval q(* &SMB_I(\'struct inode\' * &inode) {  &container_of( &inode, \'struct smb_inode_info\',  &vfs_inode); });
	}' unless defined(&smb_inode_info);
	eval 'sub WVAL {
	    my($buf,$pos) = @_;
    	    eval q(( &le16_to_cpu( &get_unaligned(( &__u16 *)(( &__u8 *)($buf) + ($pos))))));
	}' unless defined(&WVAL);
	eval 'sub DVAL {
	    my($buf,$pos) = @_;
    	    eval q(( &le32_to_cpu( &get_unaligned(( &__u32 *)(( &__u8 *)($buf) + ($pos))))));
	}' unless defined(&DVAL);
	eval 'sub LVAL {
	    my($buf,$pos) = @_;
    	    eval q(( &le64_to_cpu( &get_unaligned(( &__u64 *)(( &__u8 *)($buf) + ($pos))))));
	}' unless defined(&LVAL);
	eval 'sub WSET {
	    my($buf,$pos,$val) = @_;
    	    eval q( &put_unaligned( &cpu_to_le16(( &__u16)($val)), ( &__u16 *)(( &__u8 *)($buf) + ($pos))));
	}' unless defined(&WSET);
	eval 'sub DSET {
	    my($buf,$pos,$val) = @_;
    	    eval q( &put_unaligned( &cpu_to_le32(( &__u32)($val)), ( &__u32 *)(( &__u8 *)($buf) + ($pos))));
	}' unless defined(&DSET);
	eval 'sub LSET {
	    my($buf,$pos,$val) = @_;
    	    eval q( &put_unaligned( &cpu_to_le64(( &__u64)($val)), ( &__u64 *)(( &__u8 *)($buf) + ($pos))));
	}' unless defined(&LSET);
	eval 'sub smb_base {
	    my($buf) = @_;
    	    eval q((( &__u8 *)((( &__u8 *)($buf))+4)));
	}' unless defined(&smb_base);
	eval 'sub SMB_F_LOCALWRITE () {0x2;}' unless defined(&SMB_F_LOCALWRITE);
	eval 'sub SMB_CAP_RAW_MODE () {0x1;}' unless defined(&SMB_CAP_RAW_MODE);
	eval 'sub SMB_CAP_MPX_MODE () {0x2;}' unless defined(&SMB_CAP_MPX_MODE);
	eval 'sub SMB_CAP_UNICODE () {0x4;}' unless defined(&SMB_CAP_UNICODE);
	eval 'sub SMB_CAP_LARGE_FILES () {0x8;}' unless defined(&SMB_CAP_LARGE_FILES);
	eval 'sub SMB_CAP_NT_SMBS () {0x10;}' unless defined(&SMB_CAP_NT_SMBS);
	eval 'sub SMB_CAP_RPC_REMOTE_APIS () {0x20;}' unless defined(&SMB_CAP_RPC_REMOTE_APIS);
	eval 'sub SMB_CAP_STATUS32 () {0x40;}' unless defined(&SMB_CAP_STATUS32);
	eval 'sub SMB_CAP_LEVEL_II_OPLOCKS () {0x80;}' unless defined(&SMB_CAP_LEVEL_II_OPLOCKS);
	eval 'sub SMB_CAP_LOCK_AND_READ () {0x100;}' unless defined(&SMB_CAP_LOCK_AND_READ);
	eval 'sub SMB_CAP_NT_FIND () {0x200;}' unless defined(&SMB_CAP_NT_FIND);
	eval 'sub SMB_CAP_DFS () {0x1000;}' unless defined(&SMB_CAP_DFS);
	eval 'sub SMB_CAP_LARGE_READX () {0x4000;}' unless defined(&SMB_CAP_LARGE_READX);
	eval 'sub SMB_CAP_LARGE_WRITEX () {0x8000;}' unless defined(&SMB_CAP_LARGE_WRITEX);
	eval 'sub SMB_CAP_UNIX () {0x800000;}' unless defined(&SMB_CAP_UNIX);
	eval 'sub SMB_MAX_AGE {
	    my($server) = @_;
    	    eval q(((($server)-> ($mnt->{ttl}) *  &HZ) / 1000));
	}' unless defined(&SMB_MAX_AGE);
	eval 'sub smb_age_dentry {
	    my($server,$dentry) = @_;
    	    eval q({  ($dentry->{d_time}) =  &jiffies -  &SMB_MAX_AGE($server); });
	}' unless defined(&smb_age_dentry);
	eval 'sub SMB_DIRCACHE_SIZE () {(( &PAGE_CACHE_SIZE/$sizeof{\'struct dentry\' }));}' unless defined(&SMB_DIRCACHE_SIZE);
	eval 'sub SMB_FIRSTCACHE_SIZE () {((( &SMB_DIRCACHE_SIZE * $sizeof{\'struct dentry\' } - $sizeof{\'struct smb_cache_head\'}) / $sizeof{\'struct dentry\' }));}' unless defined(&SMB_FIRSTCACHE_SIZE);
	eval 'sub SMB_DIRCACHE_START () {( &SMB_DIRCACHE_SIZE -  &SMB_FIRSTCACHE_SIZE);}' unless defined(&SMB_DIRCACHE_START);
	eval 'sub SMB_OPS_NUM_STATIC () {5;}' unless defined(&SMB_OPS_NUM_STATIC);
	eval 'sub smb_is_open {
	    my($i) = @_;
    	    eval q({ ( &SMB_I($i)-> &open ==  &server_from_inode($i)-> &generation); });
	}' unless defined(&smb_is_open);
    }
}
1;
