require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SUNRPC_SCHED_H_)) {
    eval 'sub _LINUX_SUNRPC_SCHED_H_ () {1;}' unless defined(&_LINUX_SUNRPC_SCHED_H_);
    require 'linux/timer.ph';
    require 'linux/sunrpc/types.ph';
    require 'linux/spinlock.ph';
    require 'linux/wait.ph';
    require 'linux/workqueue.ph';
    require 'linux/sunrpc/xdr.ph';
    if(defined(&RPC_DEBUG)) {
    }
    if(defined(&RPC_DEBUG)) {
    }
    eval 'sub tk_auth () { ($tk_client->{cl_auth});}' unless defined(&tk_auth);
    eval 'sub tk_xprt () { ($tk_client->{cl_xprt});}' unless defined(&tk_xprt);
    eval 'sub task_for_each {
        my($task, $pos, $head) = @_;
	    eval q( &list_for_each($pos, $head)  &if (($task= &list_entry($pos, \'struct rpc_task\',  ($u->{tk_wait}->{list}))),1));
    }' unless defined(&task_for_each);
    eval 'sub task_for_first {
        my($task, $head) = @_;
	    eval q( &if (! &list_empty($head)  && (($task= &list_entry(($head)-> &next, \'struct rpc_task\',  ($u->{tk_wait}->{list}))),1)));
    }' unless defined(&task_for_first);
    eval 'sub alltask_for_each {
        my($task, $pos, $head) = @_;
	    eval q( &list_for_each($pos, $head)  &if (($task= &list_entry($pos, \'struct rpc_task\',  &tk_task)),1));
    }' unless defined(&alltask_for_each);
    eval 'sub RPC_TASK_ASYNC () {0x1;}' unless defined(&RPC_TASK_ASYNC);
    eval 'sub RPC_TASK_SWAPPER () {0x2;}' unless defined(&RPC_TASK_SWAPPER);
    eval 'sub RPC_TASK_CHILD () {0x8;}' unless defined(&RPC_TASK_CHILD);
    eval 'sub RPC_CALL_MAJORSEEN () {0x20;}' unless defined(&RPC_CALL_MAJORSEEN);
    eval 'sub RPC_TASK_ROOTCREDS () {0x40;}' unless defined(&RPC_TASK_ROOTCREDS);
    eval 'sub RPC_TASK_DYNAMIC () {0x80;}' unless defined(&RPC_TASK_DYNAMIC);
    eval 'sub RPC_TASK_KILLED () {0x100;}' unless defined(&RPC_TASK_KILLED);
    eval 'sub RPC_TASK_SOFT () {0x200;}' unless defined(&RPC_TASK_SOFT);
    eval 'sub RPC_TASK_NOINTR () {0x400;}' unless defined(&RPC_TASK_NOINTR);
    eval 'sub RPC_IS_ASYNC {
        my($t) = @_;
	    eval q((($t)-> &tk_flags &  &RPC_TASK_ASYNC));
    }' unless defined(&RPC_IS_ASYNC);
    eval 'sub RPC_IS_CHILD {
        my($t) = @_;
	    eval q((($t)-> &tk_flags &  &RPC_TASK_CHILD));
    }' unless defined(&RPC_IS_CHILD);
    eval 'sub RPC_IS_SWAPPER {
        my($t) = @_;
	    eval q((($t)-> &tk_flags &  &RPC_TASK_SWAPPER));
    }' unless defined(&RPC_IS_SWAPPER);
    eval 'sub RPC_DO_ROOTOVERRIDE {
        my($t) = @_;
	    eval q((($t)-> &tk_flags &  &RPC_TASK_ROOTCREDS));
    }' unless defined(&RPC_DO_ROOTOVERRIDE);
    eval 'sub RPC_ASSASSINATED {
        my($t) = @_;
	    eval q((($t)-> &tk_flags &  &RPC_TASK_KILLED));
    }' unless defined(&RPC_ASSASSINATED);
    eval 'sub RPC_DO_CALLBACK {
        my($t) = @_;
	    eval q((($t)-> &tk_callback !=  &NULL));
    }' unless defined(&RPC_DO_CALLBACK);
    eval 'sub RPC_IS_SOFT {
        my($t) = @_;
	    eval q((($t)-> &tk_flags &  &RPC_TASK_SOFT));
    }' unless defined(&RPC_IS_SOFT);
    eval 'sub RPC_TASK_UNINTERRUPTIBLE {
        my($t) = @_;
	    eval q((($t)-> &tk_flags &  &RPC_TASK_NOINTR));
    }' unless defined(&RPC_TASK_UNINTERRUPTIBLE);
    eval 'sub RPC_TASK_RUNNING () {0;}' unless defined(&RPC_TASK_RUNNING);
    eval 'sub RPC_TASK_QUEUED () {1;}' unless defined(&RPC_TASK_QUEUED);
    eval 'sub RPC_TASK_WAKEUP () {2;}' unless defined(&RPC_TASK_WAKEUP);
    eval 'sub RPC_TASK_HAS_TIMER () {3;}' unless defined(&RPC_TASK_HAS_TIMER);
    eval 'sub RPC_TASK_ACTIVE () {4;}' unless defined(&RPC_TASK_ACTIVE);
    eval 'sub RPC_IS_RUNNING {
        my($t) = @_;
	    eval q(( &test_bit( &RPC_TASK_RUNNING, ($t)-> &tk_runstate)));
    }' unless defined(&RPC_IS_RUNNING);
    eval 'sub rpc_set_running {
        my($t) = @_;
	    eval q(( &set_bit( &RPC_TASK_RUNNING, ($t)-> &tk_runstate)));
    }' unless defined(&rpc_set_running);
    eval 'sub rpc_test_and_set_running {
        my($t) = @_;
	    eval q(( &test_and_set_bit( &RPC_TASK_RUNNING, ($t)-> &tk_runstate)));
    }' unless defined(&rpc_test_and_set_running);
    eval 'sub rpc_clear_running {
        my($t) = @_;
	    eval q( &do {  &smp_mb__before_clear_bit();  &clear_bit( &RPC_TASK_RUNNING, ($t)-> &tk_runstate);  &smp_mb__after_clear_bit(); }  &while (0));
    }' unless defined(&rpc_clear_running);
    eval 'sub RPC_IS_QUEUED {
        my($t) = @_;
	    eval q(( &test_bit( &RPC_TASK_QUEUED, ($t)-> &tk_runstate)));
    }' unless defined(&RPC_IS_QUEUED);
    eval 'sub rpc_set_queued {
        my($t) = @_;
	    eval q(( &set_bit( &RPC_TASK_QUEUED, ($t)-> &tk_runstate)));
    }' unless defined(&rpc_set_queued);
    eval 'sub rpc_clear_queued {
        my($t) = @_;
	    eval q( &do {  &smp_mb__before_clear_bit();  &clear_bit( &RPC_TASK_QUEUED, ($t)-> &tk_runstate);  &smp_mb__after_clear_bit(); }  &while (0));
    }' unless defined(&rpc_clear_queued);
    eval 'sub rpc_start_wakeup {
        my($t) = @_;
	    eval q(( &test_and_set_bit( &RPC_TASK_WAKEUP, ($t)-> &tk_runstate) == 0));
    }' unless defined(&rpc_start_wakeup);
    eval 'sub rpc_finish_wakeup {
        my($t) = @_;
	    eval q( &do {  &smp_mb__before_clear_bit();  &clear_bit( &RPC_TASK_WAKEUP, ($t)-> &tk_runstate);  &smp_mb__after_clear_bit(); }  &while (0));
    }' unless defined(&rpc_finish_wakeup);
    eval 'sub RPC_IS_ACTIVATED {
        my($t) = @_;
	    eval q(( &test_bit( &RPC_TASK_ACTIVE, ($t)-> &tk_runstate)));
    }' unless defined(&RPC_IS_ACTIVATED);
    eval 'sub rpc_set_active {
        my($t) = @_;
	    eval q(( &set_bit( &RPC_TASK_ACTIVE, ($t)-> &tk_runstate)));
    }' unless defined(&rpc_set_active);
    eval 'sub rpc_clear_active {
        my($t) = @_;
	    eval q( &do {  &smp_mb__before_clear_bit();  &clear_bit( &RPC_TASK_ACTIVE, ($t)-> &tk_runstate);  &smp_mb__after_clear_bit(); }  &while(0));
    }' unless defined(&rpc_clear_active);
    eval 'sub RPC_PRIORITY_LOW () {0;}' unless defined(&RPC_PRIORITY_LOW);
    eval 'sub RPC_PRIORITY_NORMAL () {1;}' unless defined(&RPC_PRIORITY_NORMAL);
    eval 'sub RPC_PRIORITY_HIGH () {2;}' unless defined(&RPC_PRIORITY_HIGH);
    eval 'sub RPC_NR_PRIORITY () {( &RPC_PRIORITY_HIGH+1);}' unless defined(&RPC_NR_PRIORITY);
    if(defined(&RPC_DEBUG)) {
    }
    eval 'sub RPC_BATCH_COUNT () {16;}' unless defined(&RPC_BATCH_COUNT);
    unless(defined(&RPC_DEBUG)) {
	eval 'sub RPC_WAITQ_INIT {
	    my($var,$qname) = @_;
    	    eval q({ . &lock =  &SPIN_LOCK_UNLOCKED, . &tasks = { [0] =  &LIST_HEAD_INIT( ($var->{tasks[0]})), [1] =  &LIST_HEAD_INIT( ($var->{tasks[1]})), [2] =  &LIST_HEAD_INIT( ($var->{tasks[2]})), }, });
	}' unless defined(&RPC_WAITQ_INIT);
    } else {
	eval 'sub RPC_WAITQ_INIT {
	    my($var,$qname) = @_;
    	    eval q({ . &lock =  &SPIN_LOCK_UNLOCKED, . &tasks = { [0] =  &LIST_HEAD_INIT( ($var->{tasks[0]})), [1] =  &LIST_HEAD_INIT( ($var->{tasks[1]})), [2] =  &LIST_HEAD_INIT( ($var->{tasks[2]})), }, . &name = $qname, });
	}' unless defined(&RPC_WAITQ_INIT);
    }
    eval 'sub RPC_WAITQ {
        my($var,$qname) = @_;
	    eval q(\'struct rpc_wait_queue\' $var =  &RPC_WAITQ_INIT($var,$qname));
    }' unless defined(&RPC_WAITQ);
    eval 'sub RPC_IS_PRIORITY {
        my($q) = @_;
	    eval q((($q)-> &maxpriority > 0));
    }' unless defined(&RPC_IS_PRIORITY);
    if(defined(&RPC_DEBUG)) {
    }
    eval 'sub rpc_exit {
        my($task,$status) = @_;
	    eval q({  ($task->{tk_status}) = $status;  ($task->{tk_action}) =  &rpc_exit_task; });
    }' unless defined(&rpc_exit);
    eval 'sub rpc_wait_for_completion_task {
        my($task) = @_;
	    eval q({  &__rpc_wait_for_completion_task($task,  &NULL); });
    }' unless defined(&rpc_wait_for_completion_task);
    if(defined(&RPC_DEBUG)) {
	eval 'sub rpc_qname {
	    my($q) = @_;
    	    eval q({ (($q  &&  ($q->{name})) ?  ($q->{name}) : \\"unknown\\"); });
	}' unless defined(&rpc_qname);
    }
}
1;
