require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SUNRPC_XPRT_H)) {
    eval 'sub _LINUX_SUNRPC_XPRT_H () {1;}' unless defined(&_LINUX_SUNRPC_XPRT_H);
    require 'linux/uio.ph';
    require 'linux/socket.ph';
    require 'linux/in.ph';
    require 'linux/sunrpc/sched.ph';
    require 'linux/sunrpc/xdr.ph';
    eval 'sub RPC_MIN_SLOT_TABLE () {(2);}' unless defined(&RPC_MIN_SLOT_TABLE);
    eval 'sub RPC_DEF_SLOT_TABLE () {(16);}' unless defined(&RPC_DEF_SLOT_TABLE);
    eval 'sub RPC_MAX_SLOT_TABLE () {(128);}' unless defined(&RPC_MAX_SLOT_TABLE);
    eval 'sub RPC_CALLHDRSIZE () {6;}' unless defined(&RPC_CALLHDRSIZE);
    eval 'sub RPC_REPHDRSIZE () {4;}' unless defined(&RPC_REPHDRSIZE);
    eval 'sub RPC_MIN_RESVPORT () {(1);}' unless defined(&RPC_MIN_RESVPORT);
    eval 'sub RPC_MAX_RESVPORT () {(65535);}' unless defined(&RPC_MAX_RESVPORT);
    eval 'sub RPC_DEF_MIN_RESVPORT () {(650);}' unless defined(&RPC_DEF_MIN_RESVPORT);
    eval 'sub RPC_DEF_MAX_RESVPORT () {(1023);}' unless defined(&RPC_DEF_MAX_RESVPORT);
    eval 'sub rq_svec () { ($rq_snd_buf->{head});}' unless defined(&rq_svec);
    eval 'sub rq_slen () { ($rq_snd_buf->{len});}' unless defined(&rq_slen);
    eval 'sub XPRT_LAST_FRAG () {(1<< 0);}' unless defined(&XPRT_LAST_FRAG);
    eval 'sub XPRT_COPY_RECM () {(1<< 1);}' unless defined(&XPRT_COPY_RECM);
    eval 'sub XPRT_COPY_XID () {(1<< 2);}' unless defined(&XPRT_COPY_XID);
    eval 'sub XPRT_COPY_DATA () {(1<< 3);}' unless defined(&XPRT_COPY_DATA);
    if(defined(&__KERNEL__)) {
	eval 'sub __u32 {
	    eval q(* &xprt_skip_transport_header(\'struct rpc_xprt\' * &xprt,  &__u32 * &p) {  &p +  ($xprt->{tsh_size}); });
	}' unless defined(&__u32);
	eval 'sub XPRT_LOCKED () {(0);}' unless defined(&XPRT_LOCKED);
	eval 'sub XPRT_CONNECTED () {(1);}' unless defined(&XPRT_CONNECTED);
	eval 'sub XPRT_CONNECTING () {(2);}' unless defined(&XPRT_CONNECTING);
	eval 'sub XPRT_CLOSE_WAIT () {(3);}' unless defined(&XPRT_CLOSE_WAIT);
	eval 'sub xprt_set_connected {
	    my($xprt) = @_;
    	    eval q({  &set_bit( &XPRT_CONNECTED,  ($xprt->{state})); });
	}' unless defined(&xprt_set_connected);
	eval 'sub xprt_clear_connected {
	    my($xprt) = @_;
    	    eval q({  &clear_bit( &XPRT_CONNECTED,  ($xprt->{state})); });
	}' unless defined(&xprt_clear_connected);
	eval 'sub xprt_connected {
	    my($xprt) = @_;
    	    eval q({  &test_bit( &XPRT_CONNECTED,  ($xprt->{state})); });
	}' unless defined(&xprt_connected);
	eval 'sub xprt_test_and_set_connected {
	    my($xprt) = @_;
    	    eval q({  &test_and_set_bit( &XPRT_CONNECTED,  ($xprt->{state})); });
	}' unless defined(&xprt_test_and_set_connected);
	eval 'sub xprt_test_and_clear_connected {
	    my($xprt) = @_;
    	    eval q({  &test_and_clear_bit( &XPRT_CONNECTED,  ($xprt->{state})); });
	}' unless defined(&xprt_test_and_clear_connected);
	eval 'sub xprt_clear_connecting {
	    my($xprt) = @_;
    	    eval q({  &smp_mb__before_clear_bit();  &clear_bit( &XPRT_CONNECTING,  ($xprt->{state}));  &smp_mb__after_clear_bit(); });
	}' unless defined(&xprt_clear_connecting);
	eval 'sub xprt_connecting {
	    my($xprt) = @_;
    	    eval q({  &test_bit( &XPRT_CONNECTING,  ($xprt->{state})); });
	}' unless defined(&xprt_connecting);
	eval 'sub xprt_test_and_set_connecting {
	    my($xprt) = @_;
    	    eval q({  &test_and_set_bit( &XPRT_CONNECTING,  ($xprt->{state})); });
	}' unless defined(&xprt_test_and_set_connecting);
    }
}
1;
