require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__MPFR_H)) {
    eval 'sub __MPFR_H () {1;}' unless defined(&__MPFR_H);
    eval 'sub MPFR_VERSION_MAJOR () {2;}' unless defined(&MPFR_VERSION_MAJOR);
    eval 'sub MPFR_VERSION_MINOR () {2;}' unless defined(&MPFR_VERSION_MINOR);
    eval 'sub MPFR_VERSION_PATCHLEVEL () {0;}' unless defined(&MPFR_VERSION_PATCHLEVEL);
    eval 'sub MPFR_VERSION_STRING () {"2.2.0";}' unless defined(&MPFR_VERSION_STRING);
    eval 'sub MPFR_VERSION_NUM {
        my($a,$b,$c) = @_;
	    eval q(((($a) << 16) | (($b) << 8) | ($c)));
    }' unless defined(&MPFR_VERSION_NUM);
    eval 'sub MPFR_VERSION () { &MPFR_VERSION_NUM( &MPFR_VERSION_MAJOR, &MPFR_VERSION_MINOR, &MPFR_VERSION_PATCHLEVEL);}' unless defined(&MPFR_VERSION);
    unless(defined(&__GMP_H__)) {
	require 'gmp.ph';
    }
    if(defined ( &_GMP_H_HAVE_FILE) || defined ( &MPFR_USE_FILE)) {
	eval 'sub _MPFR_H_HAVE_FILE () {1;}' unless defined(&_MPFR_H_HAVE_FILE);
    }
    if((defined ( &INTMAX_C)  && defined ( &UINTMAX_C)) || defined ( &MPFR_USE_INTMAX_T)) {
	eval 'sub _MPFR_H_HAVE_INTMAX_T () {1;}' unless defined(&_MPFR_H_HAVE_INTMAX_T);
    }
    eval("sub GMP_RNDN () { 0; }") unless defined(&GMP_RNDN);
    eval("sub GMP_RNDZ () { 1; }") unless defined(&GMP_RNDZ);
    eval("sub GMP_RNDU () { 2; }") unless defined(&GMP_RNDU);
    eval("sub GMP_RNDD () { 3; }") unless defined(&GMP_RNDD);
    eval("sub GMP_RND_MAX () { 4; }") unless defined(&GMP_RND_MAX);
    eval("sub GMP_RNDNA () { -1; }") unless defined(&GMP_RNDNA);
    unless(defined(&_MPFR_PREC_FORMAT)) {
	if((defined(&__GMP_MP_SIZE_T_INT) ? &__GMP_MP_SIZE_T_INT : 0) == 1) {
	    eval 'sub _MPFR_PREC_FORMAT () {2;}' unless defined(&_MPFR_PREC_FORMAT);
	} else {
	    eval 'sub _MPFR_PREC_FORMAT () {3;}' unless defined(&_MPFR_PREC_FORMAT);
	}
    }
    if((defined(&_MPFR_PREC_FORMAT) ? &_MPFR_PREC_FORMAT : 0) == 1) {
    }
 elsif((defined(&_MPFR_PREC_FORMAT) ? &_MPFR_PREC_FORMAT : 0) == 2) {
    }
 elsif((defined(&_MPFR_PREC_FORMAT) ? &_MPFR_PREC_FORMAT : 0) == 3) {
    } else {
	die("Invalid MPFR Prec format");
    }
    eval 'sub MPFR_PREC_MIN () {2;}' unless defined(&MPFR_PREC_MIN);
    eval 'sub MPFR_PREC_MAX () {(( &mpfr_prec_t)(( &mpfr_prec_t)(~( &mpfr_prec_t)0)>>1));}' unless defined(&MPFR_PREC_MAX);
    eval 'sub MPFR_EMAX_DEFAULT () {(( &mp_exp_t) (( 1<< 30) - 1));}' unless defined(&MPFR_EMAX_DEFAULT);
    eval 'sub MPFR_EMIN_DEFAULT () {(-( &MPFR_EMAX_DEFAULT));}' unless defined(&MPFR_EMIN_DEFAULT);
    unless(defined(&mp_rnd_t)) {
	eval 'sub mp_rnd_t () { &mpfr_rnd_t;}' unless defined(&mp_rnd_t);
    }
    unless(defined(&mp_prec_t)) {
	eval 'sub mp_prec_t () { &mpfr_prec_t;}' unless defined(&mp_prec_t);
    }
    eval 'sub MPFR_SIGN {
        my($x) = @_;
	    eval q((($x)-> &_mpfr_sign));
    }' unless defined(&MPFR_SIGN);
    eval("sub MPFR_NAN_KIND () { 0; }") unless defined(&MPFR_NAN_KIND);
    eval("sub MPFR_INF_KIND () { 1; }") unless defined(&MPFR_INF_KIND);
    eval("sub MPFR_ZERO_KIND () { 2; }") unless defined(&MPFR_ZERO_KIND);
    eval("sub MPFR_REGULAR_KIND () { 3; }") unless defined(&MPFR_REGULAR_KIND);
    eval 'sub __MPFR_SENTINEL_ATTR () {1;}' unless defined(&__MPFR_SENTINEL_ATTR);
    if(defined ( &__GNUC__)) {
	if((defined(&__GNUC__) ? &__GNUC__ : 0) >= 4) {
	    undef(&__MPFR_SENTINEL_ATTR) if defined(&__MPFR_SENTINEL_ATTR);
	    eval 'sub __MPFR_SENTINEL_ATTR () { &__attribute__ (( &sentinel));}' unless defined(&__MPFR_SENTINEL_ATTR);
	}
    }
    if(defined ( &__GMP_PROTO)) {
	eval 'sub _MPFR_PROTO () { &__GMP_PROTO;}' unless defined(&_MPFR_PROTO);
    }
 elsif(defined ( &__STDC__) || defined ( &__cplusplus)) {
	eval 'sub _MPFR_PROTO {
	    my($x) = @_;
    	    eval q($x);
	}' unless defined(&_MPFR_PROTO);
    } else {
	eval 'sub _MPFR_PROTO {
	    my($x) = @_;
    	    eval q(());
	}' unless defined(&_MPFR_PROTO);
    }
    if(defined( &__MPFR_WITHIN_MPFR)  && (defined(&__GMP_LIBGMP_DLL) ? &__GMP_LIBGMP_DLL : 0)) {
	eval 'sub __MPFR_DECLSPEC () { &__GMP_DECLSPEC_EXPORT;}' unless defined(&__MPFR_DECLSPEC);
    } else {
	eval 'sub __MPFR_DECLSPEC () { &__GMP_DECLSPEC;}' unless defined(&__MPFR_DECLSPEC);
    }
    if(defined ( &__cplusplus)) {
    }
    if(defined(&_MPFR_H_HAVE_INTMAX_T)) {
	eval 'sub mpfr_set_sj () { &__gmpfr_set_sj;}' unless defined(&mpfr_set_sj);
	eval 'sub mpfr_set_sj_2exp () { &__gmpfr_set_sj_2exp;}' unless defined(&mpfr_set_sj_2exp);
	eval 'sub mpfr_set_uj () { &__gmpfr_set_uj;}' unless defined(&mpfr_set_uj);
	eval 'sub mpfr_set_uj_2exp () { &__gmpfr_set_uj_2exp;}' unless defined(&mpfr_set_uj_2exp);
	eval 'sub mpfr_get_sj () { &__gmpfr_mpfr_get_sj;}' unless defined(&mpfr_get_sj);
	eval 'sub mpfr_get_uj () { &__gmpfr_mpfr_get_uj;}' unless defined(&mpfr_get_uj);
    }
    if(defined(&_MPFR_H_HAVE_FILE)) {
	eval 'sub mpfr_inp_str () { &__gmpfr_inp_str;}' unless defined(&mpfr_inp_str);
	eval 'sub mpfr_out_str () { &__gmpfr_out_str;}' unless defined(&mpfr_out_str);
    }
    if(defined ( &__cplusplus)) {
    }
    if((defined(&__GMP_MP_SIZE_T_INT) ? &__GMP_MP_SIZE_T_INT : 0)) {
	eval 'sub __MPFR_EXP_NAN () {(( &mp_exp_t)((~((~0)>>1))+2));}' unless defined(&__MPFR_EXP_NAN);
	eval 'sub __MPFR_EXP_ZERO () {(( &mp_exp_t)((~((~0)>>1))+1));}' unless defined(&__MPFR_EXP_ZERO);
	eval 'sub __MPFR_EXP_INF () {(( &mp_exp_t)((~((~0)>>1))+3));}' unless defined(&__MPFR_EXP_INF);
    } else {
	eval 'sub __MPFR_EXP_NAN () {(( &mp_exp_t)((~((~0)>>1))+2));}' unless defined(&__MPFR_EXP_NAN);
	eval 'sub __MPFR_EXP_ZERO () {(( &mp_exp_t)((~((~0)>>1))+1));}' unless defined(&__MPFR_EXP_ZERO);
	eval 'sub __MPFR_EXP_INF () {(( &mp_exp_t)((~((~0)>>1))+3));}' unless defined(&__MPFR_EXP_INF);
    }
    eval 'sub MPFR_DECL_INIT {
        my($_x, $_p) = @_;
	    eval q( &mp_limb_t  &__gmpfr_local_tab_$_x->[(($_p)-1)/ &GMP_NUMB_BITS+1];  &mpfr_t $_x = {{($_p),1, &__MPFR_EXP_NAN, &__gmpfr_local_tab_$_x}});
    }' unless defined(&MPFR_DECL_INIT);
    unless(defined(&MPFR_USE_NO_MACRO)) {
	eval 'sub mpfr_nan_p {
	    my($_x) = @_;
    	    eval q((($_x)-> &_mpfr_exp ==  &__MPFR_EXP_NAN));
	}' unless defined(&mpfr_nan_p);
	eval 'sub mpfr_inf_p {
	    my($_x) = @_;
    	    eval q((($_x)-> &_mpfr_exp ==  &__MPFR_EXP_INF));
	}' unless defined(&mpfr_inf_p);
	eval 'sub mpfr_zero_p {
	    my($_x) = @_;
    	    eval q((($_x)-> &_mpfr_exp ==  &__MPFR_EXP_ZERO));
	}' unless defined(&mpfr_zero_p);
	eval 'sub mpfr_sgn {
	    my($_x) = @_;
    	    eval q(( &mpfr_zero_p($_x) ? 0:  &MPFR_SIGN($_x)));
	}' unless defined(&mpfr_sgn);
	eval 'sub mpfr_get_prec {
	    my($_x) = @_;
    	    eval q((($_x)-> &_mpfr_prec + 0));
	}' unless defined(&mpfr_get_prec);
	eval 'sub mpfr_get_exp {
	    my($_x) = @_;
    	    eval q((($_x)-> &_mpfr_exp + 0));
	}' unless defined(&mpfr_get_exp);
	eval 'sub mpfr_round {
	    my($a,$b) = @_;
    	    eval q( &mpfr_rint(($a), ($b),  &GMP_RNDNA));
	}' unless defined(&mpfr_round);
	eval 'sub mpfr_trunc {
	    my($a,$b) = @_;
    	    eval q( &mpfr_rint(($a), ($b),  &GMP_RNDZ));
	}' unless defined(&mpfr_trunc);
	eval 'sub mpfr_ceil {
	    my($a,$b) = @_;
    	    eval q( &mpfr_rint(($a), ($b),  &GMP_RNDU));
	}' unless defined(&mpfr_ceil);
	eval 'sub mpfr_floor {
	    my($a,$b) = @_;
    	    eval q( &mpfr_rint(($a), ($b),  &GMP_RNDD));
	}' unless defined(&mpfr_floor);
	eval 'sub mpfr_cmp_ui {
	    my($b,$i) = @_;
    	    eval q( &mpfr_cmp_ui_2exp(($b),($i),0));
	}' unless defined(&mpfr_cmp_ui);
	eval 'sub mpfr_cmp_si {
	    my($b,$i) = @_;
    	    eval q( &mpfr_cmp_si_2exp(($b),($i),0));
	}' unless defined(&mpfr_cmp_si);
	eval 'sub mpfr_set {
	    my($a,$b,$r) = @_;
    	    eval q( &mpfr_set4($a,$b,$r, &MPFR_SIGN($b)));
	}' unless defined(&mpfr_set);
	eval 'sub mpfr_abs {
	    my($a,$b,$r) = @_;
    	    eval q( &mpfr_set4($a,$b,$r,1));
	}' unless defined(&mpfr_abs);
	eval 'sub mpfr_cmp {
	    my($b, $c) = @_;
    	    eval q( &mpfr_cmp3($b, $c, 1));
	}' unless defined(&mpfr_cmp);
	eval 'sub mpfr_mul_2exp {
	    my($y,$x,$n,$r) = @_;
    	    eval q( &mpfr_mul_2ui(($y),($x),($n),($r)));
	}' unless defined(&mpfr_mul_2exp);
	eval 'sub mpfr_div_2exp {
	    my($y,$x,$n,$r) = @_;
    	    eval q( &mpfr_div_2ui(($y),($x),($n),($r)));
	}' unless defined(&mpfr_div_2exp);
	if(defined ( &__GNUC__)  && !defined( &__ICC)  && !defined( &__cplusplus)) {
	    if(((defined(&__GNUC__) ? &__GNUC__ : 0) >= 2)) {
		undef(&mpfr_cmp_ui) if defined(&mpfr_cmp_ui);
		eval 'sub mpfr_cmp_ui {
		    my($_f,$_u) = @_;
    		    eval q(( &__builtin_constant_p ($_u)  && ($_u) == 0?  &mpfr_sgn ($_f) :  &mpfr_cmp_ui_2exp (($_f),($_u),0)));
		}' unless defined(&mpfr_cmp_ui);
		undef(&mpfr_cmp_si) if defined(&mpfr_cmp_si);
		eval 'sub mpfr_cmp_si {
		    my($_f,$_s) = @_;
    		    eval q(( &__builtin_constant_p ($_s)  && ($_s) >= 0?  &mpfr_cmp_ui (($_f), ($_s)) :  &mpfr_cmp_si_2exp (($_f), ($_s), 0)));
		}' unless defined(&mpfr_cmp_si);
		if((defined(&__GNUC__) ? &__GNUC__ : 0) > 2|| (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 95) {
		    undef(&mpfr_set_ui) if defined(&mpfr_set_ui);
		    eval 'sub mpfr_set_ui {
		        my($_f,$_u,$_r) = @_;
    			eval q(( &__builtin_constant_p ($_u)  && ($_u) == 0?  &__extension__ ({  &mpfr_ptr  &_p = ($_f);  ($_p->{_mpfr_sign}) = 1;  ($_p->{_mpfr_exp}) =  &__MPFR_EXP_ZERO; ( &void) ($_r); 0; }) :  &mpfr_set_ui ($_f,$_u,$_r)));
		    }' unless defined(&mpfr_set_ui);
		}
		undef(&mpfr_set_si) if defined(&mpfr_set_si);
		eval 'sub mpfr_set_si {
		    my($_f,$_s,$_r) = @_;
    		    eval q(( &__builtin_constant_p ($_s)  && ($_s) >= 0?  &mpfr_set_ui (($_f), ($_s), ($_r)) :  &mpfr_set_si (($_f), ($_s), ($_r))));
		}' unless defined(&mpfr_set_si);
	    }
	}
	eval 'sub mpfr_custom_get_size {
	    my($p) = @_;
    	    eval q(( ((($p)+ &GMP_NUMB_BITS-1)/ &GMP_NUMB_BITS*$sizeof{ &mp_limb_t})));
	}' unless defined(&mpfr_custom_get_size);
	eval 'sub mpfr_custom_init {
	    my($m,$p) = @_;
    	    eval q( &do {}  &while (0));
	}' unless defined(&mpfr_custom_init);
	eval 'sub mpfr_custom_get_mantissa {
	    my($x) = @_;
    	    eval q((( &void*)(($x)-> &_mpfr_d)));
	}' unless defined(&mpfr_custom_get_mantissa);
	eval 'sub mpfr_custom_get_exp {
	    my($x) = @_;
    	    eval q((($x)-> &_mpfr_exp));
	}' unless defined(&mpfr_custom_get_exp);
	eval 'sub mpfr_custom_move {
	    my($x,$m) = @_;
    	    eval q( &do { (($x)-> &_mpfr_d = ( &mp_limb_t*)($m)); }  &while (0));
	}' unless defined(&mpfr_custom_move);
	eval 'sub mpfr_custom_init_set {
	    my($x,$k,$e,$p,$m) = @_;
    	    eval q( &do {  &mpfr_ptr  &_x = ($x);  &mp_exp_t  &_e;  &mpfr_kind_t  &_t; \'int\'  &_s,  &_k;  &_k = ($k);  &if ( &_k >= 0) {  &_t = ( &mpfr_kind_t)  &_k;  &_s = 1; }  &else {  &_t = ( &mpfr_kind_t) -$k;  &_s = -1; }  &_e =  &_t ==  &MPFR_REGULAR_KIND ? ($e) :  &_t ==  &MPFR_NAN_KIND ?  &__MPFR_EXP_NAN :  &_t ==  &MPFR_INF_KIND ?  &__MPFR_EXP_INF :  &__MPFR_EXP_ZERO;  ($_$x->{_$mpfr_prec}) = ($p);  ($_$x->{_$mpfr_sign}) =  &_s;  ($_$x->{_$mpfr_exp})  =  &_e;  ($_$x->{_$mpfr_d})  = ( &mp_limb_t*) ($m); }  &while (0));
	}' unless defined(&mpfr_custom_init_set);
	eval 'sub mpfr_custom_get_kind {
	    my($x) = @_;
    	    eval q(( -> &_mpfr_exp >  &__MPFR_EXP_INF ?  &MPFR_REGULAR_KIND* &MPFR_SIGN : -> &_mpfr_exp ==  &__MPFR_EXP_INF ?  &MPFR_INF_KIND* &MPFR_SIGN : -> &_mpfr_exp ==  &__MPFR_EXP_NAN ?  &MPFR_NAN_KIND :  &MPFR_ZERO_KIND *  &MPFR_SIGN ($x) ));
	}' unless defined(&mpfr_custom_get_kind);
    }
    eval 'sub mpfr_init_set_si {
        my($x, $i, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set_si(($x), ($i), ($rnd)) ));
    }' unless defined(&mpfr_init_set_si);
    eval 'sub mpfr_init_set_ui {
        my($x, $i, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set_ui(($x), ($i), ($rnd)) ));
    }' unless defined(&mpfr_init_set_ui);
    eval 'sub mpfr_init_set_d {
        my($x, $d, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set_d(($x), ($d), ($rnd)) ));
    }' unless defined(&mpfr_init_set_d);
    eval 'sub mpfr_init_set_z {
        my($x, $i, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set_z(($x), ($i), ($rnd)) ));
    }' unless defined(&mpfr_init_set_z);
    eval 'sub mpfr_init_set_q {
        my($x, $i, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set_q(($x), ($i), ($rnd)) ));
    }' unless defined(&mpfr_init_set_q);
    eval 'sub mpfr_init_set {
        my($x, $y, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set(($x), ($y), ($rnd)) ));
    }' unless defined(&mpfr_init_set);
    eval 'sub mpfr_init_set_f {
        my($x, $y, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set_f(($x), ($y), ($rnd)) ));
    }' unless defined(&mpfr_init_set_f);
    eval 'sub mpfr_cmp_abs () { &mpfr_cmpabs;}' unless defined(&mpfr_cmp_abs);
    eval 'sub mpfr_round_prec {
        my($x,$r,$p) = @_;
	    eval q( &mpfr_prec_round($x,$p,$r));
    }' unless defined(&mpfr_round_prec);
    eval 'sub __gmp_default_rounding_mode () {( &mpfr_get_default_rounding_mode());}' unless defined(&__gmp_default_rounding_mode);
    eval 'sub __mpfr_emin () {( &mpfr_get_emin());}' unless defined(&__mpfr_emin);
    eval 'sub __mpfr_emax () {( &mpfr_get_emax());}' unless defined(&__mpfr_emax);
    eval 'sub __mpfr_default_fp_bit_precision () {( &mpfr_get_default_fp_bit_precision());}' unless defined(&__mpfr_default_fp_bit_precision);
    eval 'sub MPFR_EMIN_MIN () { &mpfr_get_emin_min();}' unless defined(&MPFR_EMIN_MIN);
    eval 'sub MPFR_EMIN_MAX () { &mpfr_get_emin_max();}' unless defined(&MPFR_EMIN_MAX);
    eval 'sub MPFR_EMAX_MIN () { &mpfr_get_emax_min();}' unless defined(&MPFR_EMAX_MIN);
    eval 'sub MPFR_EMAX_MAX () { &mpfr_get_emax_max();}' unless defined(&MPFR_EMAX_MAX);
    eval 'sub mpfr_version () {( &mpfr_get_version());}' unless defined(&mpfr_version);
    unless(defined(&mpz_set_fr)) {
	eval 'sub mpz_set_fr () { &mpfr_get_z;}' unless defined(&mpz_set_fr);
    }
    eval 'sub mpfr_add_one_ulp {
        my($x,$r) = @_;
	    eval q(( &mpfr_sgn ($x) > 0?  &mpfr_nextabove ($x) :  &mpfr_nextbelow ($x)));
    }' unless defined(&mpfr_add_one_ulp);
    eval 'sub mpfr_sub_one_ulp {
        my($x,$r) = @_;
	    eval q(( &mpfr_sgn ($x) > 0?  &mpfr_nextbelow ($x) :  &mpfr_nextabove ($x)));
    }' unless defined(&mpfr_sub_one_ulp);
}
1;
