require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_PATCHKEY_H_INDIRECT)) {
    die("patchkey.h included directly");
}
unless(defined(&_LINUX_PATCHKEY_H)) {
    eval 'sub _LINUX_PATCHKEY_H () {1;}' unless defined(&_LINUX_PATCHKEY_H);
    if(defined(&__KERNEL__)) {
	require 'asm/byteorder.ph';
    } else {
	require 'endian.ph';
    }
    if(defined( &__KERNEL__)) {
	if(defined( &__BIG_ENDIAN)) {
	    eval 'sub _PATCHKEY {
	        my($id) = @_;
    		eval q((0xfd00|$id));
	    }' unless defined(&_PATCHKEY);
	}
 elsif(defined( &__LITTLE_ENDIAN)) {
	    eval 'sub _PATCHKEY {
	        my($id) = @_;
    		eval q((($id<<8)|0xfd));
	    }' unless defined(&_PATCHKEY);
	} else {
	    die("could not determine byte order");
	}
    }
 elsif(defined( &__BYTE_ORDER)) {
	if((defined(&__BYTE_ORDER) ? &__BYTE_ORDER : 0) == (defined(&__BIG_ENDIAN) ? &__BIG_ENDIAN : 0)) {
	    eval 'sub _PATCHKEY {
	        my($id) = @_;
    		eval q((0xfd00|$id));
	    }' unless defined(&_PATCHKEY);
	}
 elsif((defined(&__BYTE_ORDER) ? &__BYTE_ORDER : 0) == (defined(&__LITTLE_ENDIAN) ? &__LITTLE_ENDIAN : 0)) {
	    eval 'sub _PATCHKEY {
	        my($id) = @_;
    		eval q((($id<<8)|0xfd));
	    }' unless defined(&_PATCHKEY);
	} else {
	    die("could not determine byte order");
	}
    }
}
1;
