require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_RTNETLINK_H)) {
    eval 'sub __LINUX_RTNETLINK_H () {1;}' unless defined(&__LINUX_RTNETLINK_H);
    require 'linux/netlink.ph';
    eval("sub RTM_BASE () { 16; }") unless defined(&RTM_BASE);
    eval("sub RTM_NEWLINK () { 16; }") unless defined(&RTM_NEWLINK);
    eval("sub RTM_DELLINK () { 17; }") unless defined(&RTM_DELLINK);
    eval("sub RTM_GETLINK () { 18; }") unless defined(&RTM_GETLINK);
    eval("sub RTM_SETLINK () { 19; }") unless defined(&RTM_SETLINK);
    eval("sub RTM_NEWADDR () { 20; }") unless defined(&RTM_NEWADDR);
    eval("sub RTM_DELADDR () { 21; }") unless defined(&RTM_DELADDR);
    eval("sub RTM_GETADDR () { 22; }") unless defined(&RTM_GETADDR);
    eval("sub RTM_NEWROUTE () { 24; }") unless defined(&RTM_NEWROUTE);
    eval("sub RTM_DELROUTE () { 25; }") unless defined(&RTM_DELROUTE);
    eval("sub RTM_GETROUTE () { 26; }") unless defined(&RTM_GETROUTE);
    eval("sub RTM_NEWNEIGH () { 28; }") unless defined(&RTM_NEWNEIGH);
    eval("sub RTM_DELNEIGH () { 29; }") unless defined(&RTM_DELNEIGH);
    eval("sub RTM_GETNEIGH () { 30; }") unless defined(&RTM_GETNEIGH);
    eval("sub RTM_NEWRULE () { 32; }") unless defined(&RTM_NEWRULE);
    eval("sub RTM_DELRULE () { 33; }") unless defined(&RTM_DELRULE);
    eval("sub RTM_GETRULE () { 34; }") unless defined(&RTM_GETRULE);
    eval("sub RTM_NEWQDISC () { 36; }") unless defined(&RTM_NEWQDISC);
    eval("sub RTM_DELQDISC () { 37; }") unless defined(&RTM_DELQDISC);
    eval("sub RTM_GETQDISC () { 38; }") unless defined(&RTM_GETQDISC);
    eval("sub RTM_NEWTCLASS () { 40; }") unless defined(&RTM_NEWTCLASS);
    eval("sub RTM_DELTCLASS () { 41; }") unless defined(&RTM_DELTCLASS);
    eval("sub RTM_GETTCLASS () { 42; }") unless defined(&RTM_GETTCLASS);
    eval("sub RTM_NEWTFILTER () { 44; }") unless defined(&RTM_NEWTFILTER);
    eval("sub RTM_DELTFILTER () { 45; }") unless defined(&RTM_DELTFILTER);
    eval("sub RTM_GETTFILTER () { 46; }") unless defined(&RTM_GETTFILTER);
    eval("sub RTM_NEWACTION () { 48; }") unless defined(&RTM_NEWACTION);
    eval("sub RTM_DELACTION () { 49; }") unless defined(&RTM_DELACTION);
    eval("sub RTM_GETACTION () { 50; }") unless defined(&RTM_GETACTION);
    eval("sub RTM_NEWPREFIX () { 52; }") unless defined(&RTM_NEWPREFIX);
    eval("sub RTM_GETPREFIX () { 54; }") unless defined(&RTM_GETPREFIX);
    eval("sub RTM_GETMULTICAST () { 58; }") unless defined(&RTM_GETMULTICAST);
    eval("sub RTM_GETANYCAST () { 62; }") unless defined(&RTM_GETANYCAST);
    eval("sub RTM_NEWNEIGHTBL () { 64; }") unless defined(&RTM_NEWNEIGHTBL);
    eval("sub RTM_GETNEIGHTBL () { 66; }") unless defined(&RTM_GETNEIGHTBL);
    eval("sub RTM_SETNEIGHTBL () { 67; }") unless defined(&RTM_SETNEIGHTBL);
    eval("sub __RTM_MAX () { 68; }") unless defined(&__RTM_MAX);
    eval 'sub RTM_NR_MSGTYPES () {( &RTM_MAX + 1-  &RTM_BASE);}' unless defined(&RTM_NR_MSGTYPES);
    eval 'sub RTM_NR_FAMILIES () {( &RTM_NR_MSGTYPES >> 2);}' unless defined(&RTM_NR_FAMILIES);
    eval 'sub RTM_FAM {
        my($cmd) = @_;
	    eval q(((($cmd) -  &RTM_BASE) >> 2));
    }' unless defined(&RTM_FAM);
    eval 'sub RTA_ALIGNTO () {4;}' unless defined(&RTA_ALIGNTO);
    eval 'sub RTA_ALIGN {
        my($len) = @_;
	    eval q(( (($len)+ &RTA_ALIGNTO-1) & ~( &RTA_ALIGNTO-1) ));
    }' unless defined(&RTA_ALIGN);
    eval 'sub RTA_OK {
        my($rta,$len) = @_;
	    eval q(( >= $sizeof{\'struct rtattr\'}  && ($rta)-> &rta_len >= $sizeof{\'struct rtattr\'}  && ($rta)-> &rta_len <= ($len)));
    }' unless defined(&RTA_OK);
    eval 'sub RTA_NEXT {
        my($rta,$attrlen) = @_;
	    eval q((($attrlen) -=  &RTA_ALIGN(($rta)-> &rta_len), ((($rta)) +  &RTA_ALIGN(($rta)-> &rta_len))));
    }' unless defined(&RTA_NEXT);
    eval 'sub RTA_LENGTH {
        my($len) = @_;
	    eval q(( &RTA_ALIGN($sizeof{\'struct rtattr\'}) + ($len)));
    }' unless defined(&RTA_LENGTH);
    eval 'sub RTA_SPACE {
        my($len) = @_;
	    eval q( &RTA_ALIGN( &RTA_LENGTH($len)));
    }' unless defined(&RTA_SPACE);
    eval 'sub RTA_DATA {
        my($rta) = @_;
	    eval q((( &void*)((($rta)) +  &RTA_LENGTH(0))));
    }' unless defined(&RTA_DATA);
    eval 'sub RTA_PAYLOAD {
        my($rta) = @_;
	    eval q(((($rta)-> &rta_len) -  &RTA_LENGTH(0)));
    }' unless defined(&RTA_PAYLOAD);
    eval("sub RTN_UNSPEC () { 0; }") unless defined(&RTN_UNSPEC);
    eval("sub RTN_UNICAST () { 1; }") unless defined(&RTN_UNICAST);
    eval("sub RTN_LOCAL () { 2; }") unless defined(&RTN_LOCAL);
    eval("sub RTN_BROADCAST () { 3; }") unless defined(&RTN_BROADCAST);
    eval("sub RTN_ANYCAST () { 4; }") unless defined(&RTN_ANYCAST);
    eval("sub RTN_MULTICAST () { 5; }") unless defined(&RTN_MULTICAST);
    eval("sub RTN_BLACKHOLE () { 6; }") unless defined(&RTN_BLACKHOLE);
    eval("sub RTN_UNREACHABLE () { 7; }") unless defined(&RTN_UNREACHABLE);
    eval("sub RTN_PROHIBIT () { 8; }") unless defined(&RTN_PROHIBIT);
    eval("sub RTN_THROW () { 9; }") unless defined(&RTN_THROW);
    eval("sub RTN_NAT () { 10; }") unless defined(&RTN_NAT);
    eval("sub RTN_XRESOLVE () { 11; }") unless defined(&RTN_XRESOLVE);
    eval("sub __RTN_MAX () { 12; }") unless defined(&__RTN_MAX);
    eval 'sub RTN_MAX () {( &__RTN_MAX - 1);}' unless defined(&RTN_MAX);
    eval 'sub RTPROT_UNSPEC () {0;}' unless defined(&RTPROT_UNSPEC);
    eval 'sub RTPROT_REDIRECT () {1;}' unless defined(&RTPROT_REDIRECT);
    eval 'sub RTPROT_KERNEL () {2;}' unless defined(&RTPROT_KERNEL);
    eval 'sub RTPROT_BOOT () {3;}' unless defined(&RTPROT_BOOT);
    eval 'sub RTPROT_STATIC () {4;}' unless defined(&RTPROT_STATIC);
    eval 'sub RTPROT_GATED () {8;}' unless defined(&RTPROT_GATED);
    eval 'sub RTPROT_RA () {9;}' unless defined(&RTPROT_RA);
    eval 'sub RTPROT_MRT () {10;}' unless defined(&RTPROT_MRT);
    eval 'sub RTPROT_ZEBRA () {11;}' unless defined(&RTPROT_ZEBRA);
    eval 'sub RTPROT_BIRD () {12;}' unless defined(&RTPROT_BIRD);
    eval 'sub RTPROT_DNROUTED () {13;}' unless defined(&RTPROT_DNROUTED);
    eval 'sub RTPROT_XORP () {14;}' unless defined(&RTPROT_XORP);
    eval 'sub RTPROT_NTK () {15;}' unless defined(&RTPROT_NTK);
    eval("sub RT_SCOPE_UNIVERSE () { 0; }") unless defined(&RT_SCOPE_UNIVERSE);
    eval("sub RT_SCOPE_SITE () { 200; }") unless defined(&RT_SCOPE_SITE);
    eval("sub RT_SCOPE_LINK () { 253; }") unless defined(&RT_SCOPE_LINK);
    eval("sub RT_SCOPE_HOST () { 254; }") unless defined(&RT_SCOPE_HOST);
    eval("sub RT_SCOPE_NOWHERE () { 255; }") unless defined(&RT_SCOPE_NOWHERE);
    eval 'sub RTM_F_NOTIFY () {0x100;}' unless defined(&RTM_F_NOTIFY);
    eval 'sub RTM_F_CLONED () {0x200;}' unless defined(&RTM_F_CLONED);
    eval 'sub RTM_F_EQUALIZE () {0x400;}' unless defined(&RTM_F_EQUALIZE);
    eval 'sub RTM_F_PREFIX () {0x800;}' unless defined(&RTM_F_PREFIX);
    eval("sub RT_TABLE_UNSPEC () { 0; }") unless defined(&RT_TABLE_UNSPEC);
    eval("sub RT_TABLE_DEFAULT () { 253; }") unless defined(&RT_TABLE_DEFAULT);
    eval("sub RT_TABLE_MAIN () { 254; }") unless defined(&RT_TABLE_MAIN);
    eval("sub RT_TABLE_LOCAL () { 255; }") unless defined(&RT_TABLE_LOCAL);
    eval("sub __RT_TABLE_MAX () { 256; }") unless defined(&__RT_TABLE_MAX);
    eval 'sub RT_TABLE_MAX () {( &__RT_TABLE_MAX - 1);}' unless defined(&RT_TABLE_MAX);
    eval("sub RTA_UNSPEC () { 0; }") unless defined(&RTA_UNSPEC);
    eval("sub RTA_DST () { 1; }") unless defined(&RTA_DST);
    eval("sub RTA_SRC () { 2; }") unless defined(&RTA_SRC);
    eval("sub RTA_IIF () { 3; }") unless defined(&RTA_IIF);
    eval("sub RTA_OIF () { 4; }") unless defined(&RTA_OIF);
    eval("sub RTA_GATEWAY () { 5; }") unless defined(&RTA_GATEWAY);
    eval("sub RTA_PRIORITY () { 6; }") unless defined(&RTA_PRIORITY);
    eval("sub RTA_PREFSRC () { 7; }") unless defined(&RTA_PREFSRC);
    eval("sub RTA_METRICS () { 8; }") unless defined(&RTA_METRICS);
    eval("sub RTA_MULTIPATH () { 9; }") unless defined(&RTA_MULTIPATH);
    eval("sub RTA_PROTOINFO () { 10; }") unless defined(&RTA_PROTOINFO);
    eval("sub RTA_FLOW () { 11; }") unless defined(&RTA_FLOW);
    eval("sub RTA_CACHEINFO () { 12; }") unless defined(&RTA_CACHEINFO);
    eval("sub RTA_SESSION () { 13; }") unless defined(&RTA_SESSION);
    eval("sub RTA_MP_ALGO () { 14; }") unless defined(&RTA_MP_ALGO);
    eval("sub __RTA_MAX () { 15; }") unless defined(&__RTA_MAX);
    eval 'sub RTA_MAX () {( &__RTA_MAX - 1);}' unless defined(&RTA_MAX);
    eval 'sub RTM_RTA {
        my($r) = @_;
	    eval q((((($r)) +  &NLMSG_ALIGN($sizeof{\'struct rtmsg\'}))));
    }' unless defined(&RTM_RTA);
    eval 'sub RTM_PAYLOAD {
        my($n) = @_;
	    eval q( &NLMSG_PAYLOAD($n,$sizeof{\'struct rtmsg\'}));
    }' unless defined(&RTM_PAYLOAD);
    eval 'sub RTNH_F_DEAD () {1;}' unless defined(&RTNH_F_DEAD);
    eval 'sub RTNH_F_PERVASIVE () {2;}' unless defined(&RTNH_F_PERVASIVE);
    eval 'sub RTNH_F_ONLINK () {4;}' unless defined(&RTNH_F_ONLINK);
    eval 'sub RTNH_ALIGNTO () {4;}' unless defined(&RTNH_ALIGNTO);
    eval 'sub RTNH_ALIGN {
        my($len) = @_;
	    eval q(( (($len)+ &RTNH_ALIGNTO-1) & ~( &RTNH_ALIGNTO-1) ));
    }' unless defined(&RTNH_ALIGN);
    eval 'sub RTNH_OK {
        my($rtnh,$len) = @_;
	    eval q((-> &rtnh_len >=  &sizeof  && (($rtnh)-> &rtnh_len) <= ($len)));
    }' unless defined(&RTNH_OK);
    eval 'sub RTNH_NEXT {
        my($rtnh) = @_;
	    eval q((((($rtnh)) +  &RTNH_ALIGN(($rtnh)-> &rtnh_len))));
    }' unless defined(&RTNH_NEXT);
    eval 'sub RTNH_LENGTH {
        my($len) = @_;
	    eval q(( &RTNH_ALIGN($sizeof{\'struct rtnexthop\'}) + ($len)));
    }' unless defined(&RTNH_LENGTH);
    eval 'sub RTNH_SPACE {
        my($len) = @_;
	    eval q( &RTNH_ALIGN( &RTNH_LENGTH($len)));
    }' unless defined(&RTNH_SPACE);
    eval 'sub RTNH_DATA {
        my($rtnh) = @_;
	    eval q((((($rtnh)) +  &RTNH_LENGTH(0))));
    }' unless defined(&RTNH_DATA);
    eval 'sub RTNETLINK_HAVE_PEERINFO () {1;}' unless defined(&RTNETLINK_HAVE_PEERINFO);
    eval("sub RTAX_UNSPEC () { 0; }") unless defined(&RTAX_UNSPEC);
    eval("sub RTAX_LOCK () { 1; }") unless defined(&RTAX_LOCK);
    eval("sub RTAX_MTU () { 2; }") unless defined(&RTAX_MTU);
    eval("sub RTAX_WINDOW () { 3; }") unless defined(&RTAX_WINDOW);
    eval("sub RTAX_RTT () { 4; }") unless defined(&RTAX_RTT);
    eval("sub RTAX_RTTVAR () { 5; }") unless defined(&RTAX_RTTVAR);
    eval("sub RTAX_SSTHRESH () { 6; }") unless defined(&RTAX_SSTHRESH);
    eval("sub RTAX_CWND () { 7; }") unless defined(&RTAX_CWND);
    eval("sub RTAX_ADVMSS () { 8; }") unless defined(&RTAX_ADVMSS);
    eval("sub RTAX_REORDERING () { 9; }") unless defined(&RTAX_REORDERING);
    eval("sub RTAX_HOPLIMIT () { 10; }") unless defined(&RTAX_HOPLIMIT);
    eval("sub RTAX_INITCWND () { 11; }") unless defined(&RTAX_INITCWND);
    eval("sub RTAX_FEATURES () { 12; }") unless defined(&RTAX_FEATURES);
    eval("sub __RTAX_MAX () { 13; }") unless defined(&__RTAX_MAX);
    eval 'sub RTAX_MAX () {( &__RTAX_MAX - 1);}' unless defined(&RTAX_MAX);
    eval 'sub RTAX_FEATURE_ECN () {0x1;}' unless defined(&RTAX_FEATURE_ECN);
    eval 'sub RTAX_FEATURE_SACK () {0x2;}' unless defined(&RTAX_FEATURE_SACK);
    eval 'sub RTAX_FEATURE_TIMESTAMP () {0x4;}' unless defined(&RTAX_FEATURE_TIMESTAMP);
    eval 'sub RTAX_FEATURE_ALLFRAG () {0x8;}' unless defined(&RTAX_FEATURE_ALLFRAG);
    eval("sub IFA_UNSPEC () { 0; }") unless defined(&IFA_UNSPEC);
    eval("sub IFA_ADDRESS () { 1; }") unless defined(&IFA_ADDRESS);
    eval("sub IFA_LOCAL () { 2; }") unless defined(&IFA_LOCAL);
    eval("sub IFA_LABEL () { 3; }") unless defined(&IFA_LABEL);
    eval("sub IFA_BROADCAST () { 4; }") unless defined(&IFA_BROADCAST);
    eval("sub IFA_ANYCAST () { 5; }") unless defined(&IFA_ANYCAST);
    eval("sub IFA_CACHEINFO () { 6; }") unless defined(&IFA_CACHEINFO);
    eval("sub IFA_MULTICAST () { 7; }") unless defined(&IFA_MULTICAST);
    eval("sub __IFA_MAX () { 8; }") unless defined(&__IFA_MAX);
    eval 'sub IFA_MAX () {( &__IFA_MAX - 1);}' unless defined(&IFA_MAX);
    eval 'sub IFA_F_SECONDARY () {0x1;}' unless defined(&IFA_F_SECONDARY);
    eval 'sub IFA_F_TEMPORARY () { &IFA_F_SECONDARY;}' unless defined(&IFA_F_TEMPORARY);
    eval 'sub IFA_F_DEPRECATED () {0x20;}' unless defined(&IFA_F_DEPRECATED);
    eval 'sub IFA_F_TENTATIVE () {0x40;}' unless defined(&IFA_F_TENTATIVE);
    eval 'sub IFA_F_PERMANENT () {0x80;}' unless defined(&IFA_F_PERMANENT);
    eval 'sub IFA_RTA {
        my($r) = @_;
	    eval q((((($r)) +  &NLMSG_ALIGN($sizeof{\'struct ifaddrmsg\'}))));
    }' unless defined(&IFA_RTA);
    eval 'sub IFA_PAYLOAD {
        my($n) = @_;
	    eval q( &NLMSG_PAYLOAD($n,$sizeof{\'struct ifaddrmsg\'}));
    }' unless defined(&IFA_PAYLOAD);
    eval("sub NDA_UNSPEC () { 0; }") unless defined(&NDA_UNSPEC);
    eval("sub NDA_DST () { 1; }") unless defined(&NDA_DST);
    eval("sub NDA_LLADDR () { 2; }") unless defined(&NDA_LLADDR);
    eval("sub NDA_CACHEINFO () { 3; }") unless defined(&NDA_CACHEINFO);
    eval("sub NDA_PROBES () { 4; }") unless defined(&NDA_PROBES);
    eval("sub __NDA_MAX () { 5; }") unless defined(&__NDA_MAX);
    eval 'sub NDA_MAX () {( &__NDA_MAX - 1);}' unless defined(&NDA_MAX);
    eval 'sub NDA_RTA {
        my($r) = @_;
	    eval q((((($r)) +  &NLMSG_ALIGN($sizeof{\'struct ndmsg\'}))));
    }' unless defined(&NDA_RTA);
    eval 'sub NDA_PAYLOAD {
        my($n) = @_;
	    eval q( &NLMSG_PAYLOAD($n,$sizeof{\'struct ndmsg\'}));
    }' unless defined(&NDA_PAYLOAD);
    eval 'sub NTF_PROXY () {0x8;}' unless defined(&NTF_PROXY);
    eval 'sub NTF_ROUTER () {0x80;}' unless defined(&NTF_ROUTER);
    eval 'sub NUD_INCOMPLETE () {0x1;}' unless defined(&NUD_INCOMPLETE);
    eval 'sub NUD_REACHABLE () {0x2;}' unless defined(&NUD_REACHABLE);
    eval 'sub NUD_STALE () {0x4;}' unless defined(&NUD_STALE);
    eval 'sub NUD_DELAY () {0x8;}' unless defined(&NUD_DELAY);
    eval 'sub NUD_PROBE () {0x10;}' unless defined(&NUD_PROBE);
    eval 'sub NUD_FAILED () {0x20;}' unless defined(&NUD_FAILED);
    eval 'sub NUD_NOARP () {0x40;}' unless defined(&NUD_NOARP);
    eval 'sub NUD_PERMANENT () {0x80;}' unless defined(&NUD_PERMANENT);
    eval 'sub NUD_NONE () {0x;}' unless defined(&NUD_NONE);
    eval("sub NDTPA_UNSPEC () { 0; }") unless defined(&NDTPA_UNSPEC);
    eval("sub NDTPA_IFINDEX () { 1; }") unless defined(&NDTPA_IFINDEX);
    eval("sub NDTPA_REFCNT () { 2; }") unless defined(&NDTPA_REFCNT);
    eval("sub NDTPA_REACHABLE_TIME () { 3; }") unless defined(&NDTPA_REACHABLE_TIME);
    eval("sub NDTPA_BASE_REACHABLE_TIME () { 4; }") unless defined(&NDTPA_BASE_REACHABLE_TIME);
    eval("sub NDTPA_RETRANS_TIME () { 5; }") unless defined(&NDTPA_RETRANS_TIME);
    eval("sub NDTPA_GC_STALETIME () { 6; }") unless defined(&NDTPA_GC_STALETIME);
    eval("sub NDTPA_DELAY_PROBE_TIME () { 7; }") unless defined(&NDTPA_DELAY_PROBE_TIME);
    eval("sub NDTPA_QUEUE_LEN () { 8; }") unless defined(&NDTPA_QUEUE_LEN);
    eval("sub NDTPA_APP_PROBES () { 9; }") unless defined(&NDTPA_APP_PROBES);
    eval("sub NDTPA_UCAST_PROBES () { 10; }") unless defined(&NDTPA_UCAST_PROBES);
    eval("sub NDTPA_MCAST_PROBES () { 11; }") unless defined(&NDTPA_MCAST_PROBES);
    eval("sub NDTPA_ANYCAST_DELAY () { 12; }") unless defined(&NDTPA_ANYCAST_DELAY);
    eval("sub NDTPA_PROXY_DELAY () { 13; }") unless defined(&NDTPA_PROXY_DELAY);
    eval("sub NDTPA_PROXY_QLEN () { 14; }") unless defined(&NDTPA_PROXY_QLEN);
    eval("sub NDTPA_LOCKTIME () { 15; }") unless defined(&NDTPA_LOCKTIME);
    eval("sub __NDTPA_MAX () { 16; }") unless defined(&__NDTPA_MAX);
    eval 'sub NDTPA_MAX () {( &__NDTPA_MAX - 1);}' unless defined(&NDTPA_MAX);
    eval("sub NDTA_UNSPEC () { 0; }") unless defined(&NDTA_UNSPEC);
    eval("sub NDTA_NAME () { 1; }") unless defined(&NDTA_NAME);
    eval("sub NDTA_THRESH1 () { 2; }") unless defined(&NDTA_THRESH1);
    eval("sub NDTA_THRESH2 () { 3; }") unless defined(&NDTA_THRESH2);
    eval("sub NDTA_THRESH3 () { 4; }") unless defined(&NDTA_THRESH3);
    eval("sub NDTA_CONFIG () { 5; }") unless defined(&NDTA_CONFIG);
    eval("sub NDTA_PARMS () { 6; }") unless defined(&NDTA_PARMS);
    eval("sub NDTA_STATS () { 7; }") unless defined(&NDTA_STATS);
    eval("sub NDTA_GC_INTERVAL () { 8; }") unless defined(&NDTA_GC_INTERVAL);
    eval("sub __NDTA_MAX () { 9; }") unless defined(&__NDTA_MAX);
    eval 'sub NDTA_MAX () {( &__NDTA_MAX - 1);}' unless defined(&NDTA_MAX);
    eval 'sub NDTA_RTA {
        my($r) = @_;
	    eval q((((($r)) +  &NLMSG_ALIGN($sizeof{\'struct ndtmsg\'}))));
    }' unless defined(&NDTA_RTA);
    eval 'sub NDTA_PAYLOAD {
        my($n) = @_;
	    eval q( &NLMSG_PAYLOAD($n,$sizeof{\'struct ndtmsg\'}));
    }' unless defined(&NDTA_PAYLOAD);
    eval("sub PREFIX_UNSPEC () { 0; }") unless defined(&PREFIX_UNSPEC);
    eval("sub PREFIX_ADDRESS () { 1; }") unless defined(&PREFIX_ADDRESS);
    eval("sub PREFIX_CACHEINFO () { 2; }") unless defined(&PREFIX_CACHEINFO);
    eval("sub __PREFIX_MAX () { 3; }") unless defined(&__PREFIX_MAX);
    eval 'sub PREFIX_MAX () {( &__PREFIX_MAX - 1);}' unless defined(&PREFIX_MAX);
    eval("sub IFLA_UNSPEC () { 0; }") unless defined(&IFLA_UNSPEC);
    eval("sub IFLA_ADDRESS () { 1; }") unless defined(&IFLA_ADDRESS);
    eval("sub IFLA_BROADCAST () { 2; }") unless defined(&IFLA_BROADCAST);
    eval("sub IFLA_IFNAME () { 3; }") unless defined(&IFLA_IFNAME);
    eval("sub IFLA_MTU () { 4; }") unless defined(&IFLA_MTU);
    eval("sub IFLA_LINK () { 5; }") unless defined(&IFLA_LINK);
    eval("sub IFLA_QDISC () { 6; }") unless defined(&IFLA_QDISC);
    eval("sub IFLA_STATS () { 7; }") unless defined(&IFLA_STATS);
    eval("sub IFLA_COST () { 8; }") unless defined(&IFLA_COST);
    eval("sub IFLA_PRIORITY () { 9; }") unless defined(&IFLA_PRIORITY);
    eval("sub IFLA_MASTER () { 10; }") unless defined(&IFLA_MASTER);
    eval("sub IFLA_WIRELESS () { 11; }") unless defined(&IFLA_WIRELESS);
    eval("sub IFLA_PROTINFO () { 12; }") unless defined(&IFLA_PROTINFO);
    eval("sub IFLA_TXQLEN () { 13; }") unless defined(&IFLA_TXQLEN);
    eval("sub IFLA_MAP () { 14; }") unless defined(&IFLA_MAP);
    eval("sub IFLA_WEIGHT () { 15; }") unless defined(&IFLA_WEIGHT);
    eval("sub IFLA_OPERSTATE () { 16; }") unless defined(&IFLA_OPERSTATE);
    eval("sub IFLA_LINKMODE () { 17; }") unless defined(&IFLA_LINKMODE);
    eval("sub __IFLA_MAX () { 18; }") unless defined(&__IFLA_MAX);
    eval 'sub IFLA_MAX () {( &__IFLA_MAX - 1);}' unless defined(&IFLA_MAX);
    eval 'sub IFLA_RTA {
        my($r) = @_;
	    eval q((((($r)) +  &NLMSG_ALIGN($sizeof{\'struct ifinfomsg\'}))));
    }' unless defined(&IFLA_RTA);
    eval 'sub IFLA_PAYLOAD {
        my($n) = @_;
	    eval q( &NLMSG_PAYLOAD($n,$sizeof{\'struct ifinfomsg\'}));
    }' unless defined(&IFLA_PAYLOAD);
    eval("sub IFLA_INET6_UNSPEC () { 0; }") unless defined(&IFLA_INET6_UNSPEC);
    eval("sub IFLA_INET6_FLAGS () { 1; }") unless defined(&IFLA_INET6_FLAGS);
    eval("sub IFLA_INET6_CONF () { 2; }") unless defined(&IFLA_INET6_CONF);
    eval("sub IFLA_INET6_STATS () { 3; }") unless defined(&IFLA_INET6_STATS);
    eval("sub IFLA_INET6_MCAST () { 4; }") unless defined(&IFLA_INET6_MCAST);
    eval("sub IFLA_INET6_CACHEINFO () { 5; }") unless defined(&IFLA_INET6_CACHEINFO);
    eval("sub __IFLA_INET6_MAX () { 6; }") unless defined(&__IFLA_INET6_MAX);
    eval 'sub IFLA_INET6_MAX () {( &__IFLA_INET6_MAX - 1);}' unless defined(&IFLA_INET6_MAX);
    eval("sub TCA_UNSPEC () { 0; }") unless defined(&TCA_UNSPEC);
    eval("sub TCA_KIND () { 1; }") unless defined(&TCA_KIND);
    eval("sub TCA_OPTIONS () { 2; }") unless defined(&TCA_OPTIONS);
    eval("sub TCA_STATS () { 3; }") unless defined(&TCA_STATS);
    eval("sub TCA_XSTATS () { 4; }") unless defined(&TCA_XSTATS);
    eval("sub TCA_RATE () { 5; }") unless defined(&TCA_RATE);
    eval("sub TCA_FCNT () { 6; }") unless defined(&TCA_FCNT);
    eval("sub TCA_STATS2 () { 7; }") unless defined(&TCA_STATS2);
    eval("sub __TCA_MAX () { 8; }") unless defined(&__TCA_MAX);
    eval 'sub TCA_MAX () {( &__TCA_MAX - 1);}' unless defined(&TCA_MAX);
    eval 'sub TCA_RTA {
        my($r) = @_;
	    eval q((((($r)) +  &NLMSG_ALIGN($sizeof{\'struct tcmsg\'}))));
    }' unless defined(&TCA_RTA);
    eval 'sub TCA_PAYLOAD {
        my($n) = @_;
	    eval q( &NLMSG_PAYLOAD($n,$sizeof{\'struct tcmsg\'}));
    }' unless defined(&TCA_PAYLOAD);
    unless(defined(&__KERNEL__)) {
	eval 'sub RTMGRP_LINK () {1;}' unless defined(&RTMGRP_LINK);
	eval 'sub RTMGRP_NOTIFY () {2;}' unless defined(&RTMGRP_NOTIFY);
	eval 'sub RTMGRP_NEIGH () {4;}' unless defined(&RTMGRP_NEIGH);
	eval 'sub RTMGRP_TC () {8;}' unless defined(&RTMGRP_TC);
	eval 'sub RTMGRP_IPV4_IFADDR () {0x10;}' unless defined(&RTMGRP_IPV4_IFADDR);
	eval 'sub RTMGRP_IPV4_MROUTE () {0x20;}' unless defined(&RTMGRP_IPV4_MROUTE);
	eval 'sub RTMGRP_IPV4_ROUTE () {0x40;}' unless defined(&RTMGRP_IPV4_ROUTE);
	eval 'sub RTMGRP_IPV4_RULE () {0x80;}' unless defined(&RTMGRP_IPV4_RULE);
	eval 'sub RTMGRP_IPV6_IFADDR () {0x100;}' unless defined(&RTMGRP_IPV6_IFADDR);
	eval 'sub RTMGRP_IPV6_MROUTE () {0x200;}' unless defined(&RTMGRP_IPV6_MROUTE);
	eval 'sub RTMGRP_IPV6_ROUTE () {0x400;}' unless defined(&RTMGRP_IPV6_ROUTE);
	eval 'sub RTMGRP_IPV6_IFINFO () {0x800;}' unless defined(&RTMGRP_IPV6_IFINFO);
	eval 'sub RTMGRP_DECnet_IFADDR () {0x1000;}' unless defined(&RTMGRP_DECnet_IFADDR);
	eval 'sub RTMGRP_DECnet_ROUTE () {0x4000;}' unless defined(&RTMGRP_DECnet_ROUTE);
	eval 'sub RTMGRP_IPV6_PREFIX () {0x20000;}' unless defined(&RTMGRP_IPV6_PREFIX);
    }
    eval("sub RTNLGRP_NONE () { 0; }") unless defined(&RTNLGRP_NONE);
    eval("sub RTNLGRP_LINK () { 1; }") unless defined(&RTNLGRP_LINK);
    eval("sub RTNLGRP_NOTIFY () { 2; }") unless defined(&RTNLGRP_NOTIFY);
    eval("sub RTNLGRP_NEIGH () { 3; }") unless defined(&RTNLGRP_NEIGH);
    eval("sub RTNLGRP_TC () { 4; }") unless defined(&RTNLGRP_TC);
    eval("sub RTNLGRP_IPV4_IFADDR () { 5; }") unless defined(&RTNLGRP_IPV4_IFADDR);
    eval("sub RTNLGRP_IPV4_MROUTE () { 6; }") unless defined(&RTNLGRP_IPV4_MROUTE);
    eval("sub RTNLGRP_IPV4_ROUTE () { 7; }") unless defined(&RTNLGRP_IPV4_ROUTE);
    eval("sub RTNLGRP_IPV4_RULE () { 8; }") unless defined(&RTNLGRP_IPV4_RULE);
    eval("sub RTNLGRP_IPV6_IFADDR () { 9; }") unless defined(&RTNLGRP_IPV6_IFADDR);
    eval("sub RTNLGRP_IPV6_MROUTE () { 10; }") unless defined(&RTNLGRP_IPV6_MROUTE);
    eval("sub RTNLGRP_IPV6_ROUTE () { 11; }") unless defined(&RTNLGRP_IPV6_ROUTE);
    eval("sub RTNLGRP_IPV6_IFINFO () { 12; }") unless defined(&RTNLGRP_IPV6_IFINFO);
    eval("sub RTNLGRP_DECnet_IFADDR () { 13; }") unless defined(&RTNLGRP_DECnet_IFADDR);
    eval("sub RTNLGRP_NOP2 () { 14; }") unless defined(&RTNLGRP_NOP2);
    eval("sub RTNLGRP_DECnet_ROUTE () { 15; }") unless defined(&RTNLGRP_DECnet_ROUTE);
    eval("sub RTNLGRP_NOP3 () { 16; }") unless defined(&RTNLGRP_NOP3);
    eval("sub RTNLGRP_NOP4 () { 17; }") unless defined(&RTNLGRP_NOP4);
    eval("sub RTNLGRP_IPV6_PREFIX () { 18; }") unless defined(&RTNLGRP_IPV6_PREFIX);
    eval("sub __RTNLGRP_MAX () { 19; }") unless defined(&__RTNLGRP_MAX);
    eval 'sub RTNLGRP_MAX () {( &__RTNLGRP_MAX - 1);}' unless defined(&RTNLGRP_MAX);
    eval 'sub TA_RTA {
        my($r) = @_;
	    eval q((((($r)) +  &NLMSG_ALIGN($sizeof{\'struct tcamsg\'}))));
    }' unless defined(&TA_RTA);
    eval 'sub TA_PAYLOAD {
        my($n) = @_;
	    eval q( &NLMSG_PAYLOAD($n,$sizeof{\'struct tcamsg\'}));
    }' unless defined(&TA_PAYLOAD);
    eval 'sub TCA_ACT_TAB () {1;}' unless defined(&TCA_ACT_TAB);
    eval 'sub TCAA_MAX () {1;}' unless defined(&TCAA_MAX);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/mutex.ph';
	eval 'sub rtattr_strcmp {
	    my($rta,$str) = @_;
    	    eval q({ \'int\'  &len =  &strlen($str) + 1;  &len >  ($rta->{rta_len}) ||  &memcmp( &RTA_DATA($rta), $str,  &len); });
	}' unless defined(&rtattr_strcmp);
	eval 'sub rtattr_parse_nested {
	    my($tb, $max, $rta) = @_;
    	    eval q( &rtattr_parse(($tb), ($max),  &RTA_DATA(($rta)),  &RTA_PAYLOAD(($rta))));
	}' unless defined(&rtattr_parse_nested);
	eval 'sub RTA_PUT {
	    my($skb, $attrtype, $attrlen, $data) = @_;
    	    eval q(({  &if ( &unlikely( &skb_tailroom <  &RTA_SPACE($attrlen)))  &goto  &rtattr_failure;  &__rta_fill($skb, $attrtype, $attrlen, $data); }));
	}' unless defined(&RTA_PUT);
	eval 'sub RTA_APPEND {
	    my($skb, $attrlen, $data) = @_;
    	    eval q(({  &if ( &unlikely( &skb_tailroom < ($attrlen)))  &goto  &rtattr_failure;  &memcpy( &skb_put($skb, $attrlen), $data, $attrlen); }));
	}' unless defined(&RTA_APPEND);
	eval 'sub RTA_PUT_NOHDR {
	    my($skb, $attrlen, $data) = @_;
    	    eval q(({  &RTA_APPEND($skb,  &RTA_ALIGN($attrlen), $data);  &memset( ($skb->{tail}) - ( &RTA_ALIGN($attrlen) - $attrlen), 0,  &RTA_ALIGN($attrlen) - $attrlen); }));
	}' unless defined(&RTA_PUT_NOHDR);
	eval 'sub RTA_PUT_U8 {
	    my($skb, $attrtype, $value) = @_;
    	    eval q(({  &__u8  &_tmp = ($value);  &RTA_PUT($skb, $attrtype, $sizeof{ &__u8}, & &_tmp); }));
	}' unless defined(&RTA_PUT_U8);
	eval 'sub RTA_PUT_U16 {
	    my($skb, $attrtype, $value) = @_;
    	    eval q(({  &__u16  &_tmp = ($value);  &RTA_PUT($skb, $attrtype, $sizeof{ &__u16}, & &_tmp); }));
	}' unless defined(&RTA_PUT_U16);
	eval 'sub RTA_PUT_U32 {
	    my($skb, $attrtype, $value) = @_;
    	    eval q(({  &__u32  &_tmp = ($value);  &RTA_PUT($skb, $attrtype, $sizeof{ &__u32}, & &_tmp); }));
	}' unless defined(&RTA_PUT_U32);
	eval 'sub RTA_PUT_U64 {
	    my($skb, $attrtype, $value) = @_;
    	    eval q(({  &__u64  &_tmp = ($value);  &RTA_PUT($skb, $attrtype, $sizeof{ &__u64}, & &_tmp); }));
	}' unless defined(&RTA_PUT_U64);
	eval 'sub RTA_PUT_SECS {
	    my($skb, $attrtype, $value) = @_;
    	    eval q( &RTA_PUT_U64($skb, $attrtype, ($value) /  &HZ));
	}' unless defined(&RTA_PUT_SECS);
	eval 'sub RTA_PUT_MSECS {
	    my($skb, $attrtype, $value) = @_;
    	    eval q( &RTA_PUT_U64($skb, $attrtype,  &jiffies_to_msecs($value)));
	}' unless defined(&RTA_PUT_MSECS);
	eval 'sub RTA_PUT_STRING {
	    my($skb, $attrtype, $value) = @_;
    	    eval q( &RTA_PUT($skb, $attrtype,  &strlen($value) + 1, $value));
	}' unless defined(&RTA_PUT_STRING);
	eval 'sub RTA_PUT_FLAG {
	    my($skb, $attrtype) = @_;
    	    eval q( &RTA_PUT($skb, $attrtype, 0,  &NULL););
	}' unless defined(&RTA_PUT_FLAG);
	eval 'sub RTA_NEST {
	    my($skb, $type) = @_;
    	    eval q(({ \'struct rtattr\' * &__start =  ($skb)-> &tail;  &RTA_PUT($skb, $type, 0,  &NULL);  &__start; }));
	}' unless defined(&RTA_NEST);
	eval 'sub RTA_NEST_END {
	    my($skb, $start) = @_;
    	    eval q(({ -> &rta_len = (-> &tail - ($start)); ($skb)-> &len; }));
	}' unless defined(&RTA_NEST_END);
	eval 'sub RTA_NEST_CANCEL {
	    my($skb, $start) = @_;
    	    eval q(({  &if ($start)  &skb_trim($skb, ($start) - ($skb)-> &data); -1; }));
	}' unless defined(&RTA_NEST_CANCEL);
	eval 'sub RTA_GET_U8 {
	    my($rta) = @_;
    	    eval q(({  &if (!$rta ||  &RTA_PAYLOAD($rta) < $sizeof{ &__u8})  &goto  &rtattr_failure; *( &__u8 *)  &RTA_DATA($rta); }));
	}' unless defined(&RTA_GET_U8);
	eval 'sub RTA_GET_U16 {
	    my($rta) = @_;
    	    eval q(({  &if (!$rta ||  &RTA_PAYLOAD($rta) < $sizeof{ &__u16})  &goto  &rtattr_failure; *( &__u16 *)  &RTA_DATA($rta); }));
	}' unless defined(&RTA_GET_U16);
	eval 'sub RTA_GET_U32 {
	    my($rta) = @_;
    	    eval q(({  &if (!$rta ||  &RTA_PAYLOAD($rta) < $sizeof{ &__u32})  &goto  &rtattr_failure; *( &__u32 *)  &RTA_DATA($rta); }));
	}' unless defined(&RTA_GET_U32);
	eval 'sub RTA_GET_U64 {
	    my($rta) = @_;
    	    eval q(({  &__u64  &_tmp;  &if (!$rta ||  &RTA_PAYLOAD($rta) < $sizeof{ &__u64})  &goto  &rtattr_failure;  &memcpy(& &_tmp,  &RTA_DATA($rta), $sizeof{ &_tmp});  &_tmp; }));
	}' unless defined(&RTA_GET_U64);
	eval 'sub RTA_GET_FLAG {
	    my($rta) = @_;
    	    eval q((!!($rta)));
	}' unless defined(&RTA_GET_FLAG);
	eval 'sub RTA_GET_SECS {
	    my($rta) = @_;
    	    eval q((  &RTA_GET_U64($rta) *  &HZ));
	}' unless defined(&RTA_GET_SECS);
	eval 'sub RTA_GET_MSECS {
	    my($rta) = @_;
    	    eval q(( &msecs_to_jiffies(  &RTA_GET_U64($rta))));
	}' unless defined(&RTA_GET_MSECS);
	eval 'sub __RTA_PUT {
	    my($skb, $attrtype, $attrlen) = @_;
    	    eval q(({  &if ( &unlikely( &skb_tailroom <  &RTA_SPACE($attrlen)))  &goto  &rtattr_failure;  &__rta_reserve($skb, $attrtype, $attrlen); }));
	}' unless defined(&__RTA_PUT);
	eval 'sub ASSERT_RTNL () {
	    eval q( &do {  &if ( &unlikely( &rtnl_trylock())) {  &rtnl_unlock();  &printk( &KERN_ERR \\"RTNL: assertion failed at %s (%d)\\\\n\\",  &__FILE__,  &__LINE__);  &dump_stack(); } }  &while(0));
	}' unless defined(&ASSERT_RTNL);
	eval 'sub BUG_TRAP {
	    my($x) = @_;
    	    eval q( &do {  &if ( &unlikely(!($x))) {  &printk( &KERN_ERR \\"KERNEL: assertion (%s) failed at %s (%d)\\\\n\\", $x,  &__FILE__ ,  &__LINE__); } }  &while(0));
	}' unless defined(&BUG_TRAP);
    }
}
1;
