require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SHM_H_)) {
    eval 'sub _LINUX_SHM_H_ () {1;}' unless defined(&_LINUX_SHM_H_);
    require 'linux/ipc.ph';
    require 'linux/errno.ph';
    require 'asm/page.ph';
    eval 'sub SHMMAX () {0x2000000;}' unless defined(&SHMMAX);
    eval 'sub SHMMIN () {1;}' unless defined(&SHMMIN);
    eval 'sub SHMMNI () {4096;}' unless defined(&SHMMNI);
    eval 'sub SHMALL () {( &SHMMAX/ &PAGE_SIZE*( &SHMMNI/16));}' unless defined(&SHMALL);
    eval 'sub SHMSEG () { &SHMMNI;}' unless defined(&SHMSEG);
    require 'asm/shmparam.ph';
    require 'asm/shmbuf.ph';
    eval 'sub SHM_R () {0400;}' unless defined(&SHM_R);
    eval 'sub SHM_W () {0200;}' unless defined(&SHM_W);
    eval 'sub SHM_RDONLY () {010000;}' unless defined(&SHM_RDONLY);
    eval 'sub SHM_RND () {020000;}' unless defined(&SHM_RND);
    eval 'sub SHM_REMAP () {040000;}' unless defined(&SHM_REMAP);
    eval 'sub SHM_EXEC () {0100000;}' unless defined(&SHM_EXEC);
    eval 'sub SHM_LOCK () {11;}' unless defined(&SHM_LOCK);
    eval 'sub SHM_UNLOCK () {12;}' unless defined(&SHM_UNLOCK);
    eval 'sub SHM_STAT () {13;}' unless defined(&SHM_STAT);
    eval 'sub SHM_INFO () {14;}' unless defined(&SHM_INFO);
    if(defined(&__KERNEL__)) {
	eval 'sub SHM_DEST () {01000;}' unless defined(&SHM_DEST);
	eval 'sub SHM_LOCKED () {02000;}' unless defined(&SHM_LOCKED);
	eval 'sub SHM_HUGETLB () {04000;}' unless defined(&SHM_HUGETLB);
	eval 'sub SHM_NORESERVE () {010000;}' unless defined(&SHM_NORESERVE);
	if(defined(&CONFIG_SYSVIPC)) {
	} else {
	    eval 'sub do_shmat {
	        my($shmid,$shmaddr,$shmflg,$addr) = @_;
    		eval q({ - &ENOSYS; });
	    }' unless defined(&do_shmat);
	}
    }
}
1;
