require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_SPINLOCK_API_UP_H)) {
    eval 'sub __LINUX_SPINLOCK_API_UP_H () {1;}' unless defined(&__LINUX_SPINLOCK_API_UP_H);
    unless(defined(&__LINUX_SPINLOCK_H)) {
	die("please don't include this file directly");
    }
    eval 'sub in_lock_functions {
        my($ADDR) = @_;
	    eval q(0);
    }' unless defined(&in_lock_functions);
    eval 'sub assert_spin_locked {
        my($lock) = @_;
	    eval q( &do { ( &void)($lock); }  &while (0));
    }' unless defined(&assert_spin_locked);
    eval 'sub __LOCK {
        my($lock) = @_;
	    eval q( &do {  &preempt_disable();  &__acquire($lock); ( &void)($lock); }  &while (0));
    }' unless defined(&__LOCK);
    eval 'sub __LOCK_BH {
        my($lock) = @_;
	    eval q( &do {  &local_bh_disable();  &__LOCK($lock); }  &while (0));
    }' unless defined(&__LOCK_BH);
    eval 'sub __LOCK_IRQ {
        my($lock) = @_;
	    eval q( &do {  &local_irq_disable();  &__LOCK($lock); }  &while (0));
    }' unless defined(&__LOCK_IRQ);
    eval 'sub __LOCK_IRQSAVE {
        my($lock, $flags) = @_;
	    eval q( &do {  &local_irq_save($flags);  &__LOCK($lock); }  &while (0));
    }' unless defined(&__LOCK_IRQSAVE);
    eval 'sub __UNLOCK {
        my($lock) = @_;
	    eval q( &do {  &preempt_enable();  &__release($lock); ( &void)($lock); }  &while (0));
    }' unless defined(&__UNLOCK);
    eval 'sub __UNLOCK_BH {
        my($lock) = @_;
	    eval q( &do {  &preempt_enable_no_resched();  &local_bh_enable();  &__release($lock); ( &void)($lock); }  &while (0));
    }' unless defined(&__UNLOCK_BH);
    eval 'sub __UNLOCK_IRQ {
        my($lock) = @_;
	    eval q( &do {  &local_irq_enable();  &__UNLOCK($lock); }  &while (0));
    }' unless defined(&__UNLOCK_IRQ);
    eval 'sub __UNLOCK_IRQRESTORE {
        my($lock, $flags) = @_;
	    eval q( &do {  &local_irq_restore($flags);  &__UNLOCK($lock); }  &while (0));
    }' unless defined(&__UNLOCK_IRQRESTORE);
    eval 'sub _spin_lock {
        my($lock) = @_;
	    eval q( &__LOCK($lock));
    }' unless defined(&_spin_lock);
    eval 'sub _read_lock {
        my($lock) = @_;
	    eval q( &__LOCK($lock));
    }' unless defined(&_read_lock);
    eval 'sub _write_lock {
        my($lock) = @_;
	    eval q( &__LOCK($lock));
    }' unless defined(&_write_lock);
    eval 'sub _spin_lock_bh {
        my($lock) = @_;
	    eval q( &__LOCK_BH($lock));
    }' unless defined(&_spin_lock_bh);
    eval 'sub _read_lock_bh {
        my($lock) = @_;
	    eval q( &__LOCK_BH($lock));
    }' unless defined(&_read_lock_bh);
    eval 'sub _write_lock_bh {
        my($lock) = @_;
	    eval q( &__LOCK_BH($lock));
    }' unless defined(&_write_lock_bh);
    eval 'sub _spin_lock_irq {
        my($lock) = @_;
	    eval q( &__LOCK_IRQ($lock));
    }' unless defined(&_spin_lock_irq);
    eval 'sub _read_lock_irq {
        my($lock) = @_;
	    eval q( &__LOCK_IRQ($lock));
    }' unless defined(&_read_lock_irq);
    eval 'sub _write_lock_irq {
        my($lock) = @_;
	    eval q( &__LOCK_IRQ($lock));
    }' unless defined(&_write_lock_irq);
    eval 'sub _spin_lock_irqsave {
        my($lock, $flags) = @_;
	    eval q( &__LOCK_IRQSAVE($lock, $flags));
    }' unless defined(&_spin_lock_irqsave);
    eval 'sub _read_lock_irqsave {
        my($lock, $flags) = @_;
	    eval q( &__LOCK_IRQSAVE($lock, $flags));
    }' unless defined(&_read_lock_irqsave);
    eval 'sub _write_lock_irqsave {
        my($lock, $flags) = @_;
	    eval q( &__LOCK_IRQSAVE($lock, $flags));
    }' unless defined(&_write_lock_irqsave);
    eval 'sub _spin_trylock {
        my($lock) = @_;
	    eval q(({  &__LOCK($lock); 1; }));
    }' unless defined(&_spin_trylock);
    eval 'sub _read_trylock {
        my($lock) = @_;
	    eval q(({  &__LOCK($lock); 1; }));
    }' unless defined(&_read_trylock);
    eval 'sub _write_trylock {
        my($lock) = @_;
	    eval q(({  &__LOCK($lock); 1; }));
    }' unless defined(&_write_trylock);
    eval 'sub _spin_trylock_bh {
        my($lock) = @_;
	    eval q(({  &__LOCK_BH($lock); 1; }));
    }' unless defined(&_spin_trylock_bh);
    eval 'sub _spin_unlock {
        my($lock) = @_;
	    eval q( &__UNLOCK($lock));
    }' unless defined(&_spin_unlock);
    eval 'sub _read_unlock {
        my($lock) = @_;
	    eval q( &__UNLOCK($lock));
    }' unless defined(&_read_unlock);
    eval 'sub _write_unlock {
        my($lock) = @_;
	    eval q( &__UNLOCK($lock));
    }' unless defined(&_write_unlock);
    eval 'sub _spin_unlock_bh {
        my($lock) = @_;
	    eval q( &__UNLOCK_BH($lock));
    }' unless defined(&_spin_unlock_bh);
    eval 'sub _write_unlock_bh {
        my($lock) = @_;
	    eval q( &__UNLOCK_BH($lock));
    }' unless defined(&_write_unlock_bh);
    eval 'sub _read_unlock_bh {
        my($lock) = @_;
	    eval q( &__UNLOCK_BH($lock));
    }' unless defined(&_read_unlock_bh);
    eval 'sub _spin_unlock_irq {
        my($lock) = @_;
	    eval q( &__UNLOCK_IRQ($lock));
    }' unless defined(&_spin_unlock_irq);
    eval 'sub _read_unlock_irq {
        my($lock) = @_;
	    eval q( &__UNLOCK_IRQ($lock));
    }' unless defined(&_read_unlock_irq);
    eval 'sub _write_unlock_irq {
        my($lock) = @_;
	    eval q( &__UNLOCK_IRQ($lock));
    }' unless defined(&_write_unlock_irq);
    eval 'sub _spin_unlock_irqrestore {
        my($lock, $flags) = @_;
	    eval q( &__UNLOCK_IRQRESTORE($lock, $flags));
    }' unless defined(&_spin_unlock_irqrestore);
    eval 'sub _read_unlock_irqrestore {
        my($lock, $flags) = @_;
	    eval q( &__UNLOCK_IRQRESTORE($lock, $flags));
    }' unless defined(&_read_unlock_irqrestore);
    eval 'sub _write_unlock_irqrestore {
        my($lock, $flags) = @_;
	    eval q( &__UNLOCK_IRQRESTORE($lock, $flags));
    }' unless defined(&_write_unlock_irqrestore);
}
1;
