require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_TOPOLOGY_H)) {
    eval 'sub _LINUX_TOPOLOGY_H () {1;}' unless defined(&_LINUX_TOPOLOGY_H);
    if(defined(&__KERNEL__)) {
	require 'linux/cpumask.ph';
	require 'linux/bitops.ph';
	require 'linux/mmzone.ph';
	require 'linux/smp.ph';
	require 'asm/topology.ph';
	unless(defined(&node_has_online_mem)) {
	    eval 'sub node_has_online_mem {
	        my($nid) = @_;
    		eval q((1));
	    }' unless defined(&node_has_online_mem);
	}
	unless(defined(&nr_cpus_node)) {
	    eval 'sub nr_cpus_node {
	        my($node) = @_;
    		eval q(({  &cpumask_t  &__tmp__;  &__tmp__ =  &node_to_cpumask($node);  &cpus_weight( &__tmp__); }));
	    }' unless defined(&nr_cpus_node);
	}
	eval 'sub for_each_node_with_cpus {
	    my($node) = @_;
    	    eval q( &for_each_online_node($node)  &if ( &nr_cpus_node($node)));
	}' unless defined(&for_each_node_with_cpus);
	unless(defined(&node_distance)) {
	    eval 'sub LOCAL_DISTANCE () {10;}' unless defined(&LOCAL_DISTANCE);
	    eval 'sub REMOTE_DISTANCE () {20;}' unless defined(&REMOTE_DISTANCE);
	    eval 'sub node_distance {
	        my($from,$to) = @_;
    		eval q((($from) == ($to) ?  &LOCAL_DISTANCE :  &REMOTE_DISTANCE));
	    }' unless defined(&node_distance);
	}
	unless(defined(&RECLAIM_DISTANCE)) {
	    eval 'sub RECLAIM_DISTANCE () {20;}' unless defined(&RECLAIM_DISTANCE);
	}
	unless(defined(&PENALTY_FOR_NODE_WITH_CPUS)) {
	    eval 'sub PENALTY_FOR_NODE_WITH_CPUS () {(1);}' unless defined(&PENALTY_FOR_NODE_WITH_CPUS);
	}
	if(defined(&CONFIG_SCHED_SMT)) {
	    eval 'sub ARCH_HAS_SCHED_WAKE_IDLE () {1;}' unless defined(&ARCH_HAS_SCHED_WAKE_IDLE);
	    unless(defined(&SD_SIBLING_INIT)) {
		eval 'sub SD_SIBLING_INIT () { { . &span =  &CPU_MASK_NONE, . &parent =  &NULL, . &groups =  &NULL, . &min_interval = 1, . &max_interval = 2, . &busy_factor = 8, . &imbalance_pct = 110, . &cache_nice_tries = 0, . &per_cpu_gain = 25, . &busy_idx = 0, . &idle_idx = 0, . &newidle_idx = 1, . &wake_idx = 0, . &forkexec_idx = 0, . &flags =  &SD_LOAD_BALANCE |  &SD_BALANCE_NEWIDLE |  &SD_BALANCE_EXEC |  &SD_WAKE_AFFINE |  &SD_WAKE_IDLE |  &SD_SHARE_CPUPOWER, . &last_balance =  &jiffies, . &balance_interval = 1, . &nr_balance_failed = 0, };}' unless defined(&SD_SIBLING_INIT);
	    }
	}
	unless(defined(&SD_CPU_INIT)) {
	    eval 'sub SD_CPU_INIT () { { . &span =  &CPU_MASK_NONE, . &parent =  &NULL, . &groups =  &NULL, . &min_interval = 1, . &max_interval = 4, . &busy_factor = 64, . &imbalance_pct = 125, . &cache_nice_tries = 1, . &per_cpu_gain = 100, . &busy_idx = 2, . &idle_idx = 1, . &newidle_idx = 2, . &wake_idx = 1, . &forkexec_idx = 1, . &flags =  &SD_LOAD_BALANCE |  &SD_BALANCE_NEWIDLE |  &SD_BALANCE_EXEC |  &SD_WAKE_AFFINE, . &last_balance =  &jiffies, . &balance_interval = 1, . &nr_balance_failed = 0, };}' unless defined(&SD_CPU_INIT);
	}
	eval 'sub SD_ALLNODES_INIT () { { . &span =  &CPU_MASK_NONE, . &parent =  &NULL, . &groups =  &NULL, . &min_interval = 64, . &max_interval = 64* &num_online_cpus(), . &busy_factor = 128, . &imbalance_pct = 133, . &cache_hot_time = (10*1000000), . &cache_nice_tries = 1, . &busy_idx = 3, . &idle_idx = 3, . &newidle_idx = 0, . &wake_idx = 0, . &forkexec_idx = 0, . &per_cpu_gain = 100, . &flags =  &SD_LOAD_BALANCE, . &last_balance =  &jiffies, . &balance_interval = 64, . &nr_balance_failed = 0, };}' unless defined(&SD_ALLNODES_INIT);
	if(defined(&CONFIG_SCHED_MC)) {
	    unless(defined(&SD_MC_INIT)) {
		eval 'sub SD_MC_INIT () { &SD_CPU_INIT;}' unless defined(&SD_MC_INIT);
	    }
	}
	if(defined(&CONFIG_NUMA)) {
	    unless(defined(&SD_NODE_INIT)) {
		die("Please\ define\ an\ appropriate\ SD_NODE_INIT\ in\ include\/asm\/topology\.h\!\!\!");
	    }
	}
    }
}
1;
