require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_BITOPS_H)) {
    eval 'sub _ASM_POWERPC_BITOPS_H () {1;}' unless defined(&_ASM_POWERPC_BITOPS_H);
    require 'linux/compiler.ph';
    require 'asm/atomic.ph';
    require 'asm/asm-compat.ph';
    require 'asm/synch.ph';
    eval 'sub smp_mb__before_clear_bit () {
        eval q( &smp_mb());
    }' unless defined(&smp_mb__before_clear_bit);
    eval 'sub smp_mb__after_clear_bit () {
        eval q( &smp_mb());
    }' unless defined(&smp_mb__after_clear_bit);
    eval 'sub BITOP_MASK {
        my($nr) = @_;
	    eval q((1 << (($nr) %  &BITS_PER_LONG)));
    }' unless defined(&BITOP_MASK);
    eval 'sub BITOP_WORD {
        my($nr) = @_;
	    eval q((($nr) /  &BITS_PER_LONG));
    }' unless defined(&BITOP_WORD);
    eval 'sub BITOP_LE_SWIZZLE () {(( &BITS_PER_LONG-1) & ~0x7);}' unless defined(&BITOP_LE_SWIZZLE);
    eval 'sub set_bit {
        my($nr,$addr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&set_bit);
    eval 'sub clear_bit {
        my($nr,$addr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&clear_bit);
    eval 'sub change_bit {
        my($nr,$addr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&change_bit);
    eval 'sub test_and_set_bit {
        my($nr,$addr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&test_and_set_bit);
    eval 'sub test_and_clear_bit {
        my($nr,$addr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&test_and_clear_bit);
    eval 'sub test_and_change_bit {
        my($nr,$addr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&test_and_change_bit);
    eval 'sub set_bits {
        my($mask,$addr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&set_bits);
    require 'asm-generic/bitops/non-atomic.ph';
    if(defined(&__KERNEL__)) {
	eval 'sub __ffs {
	    my($x) = @_;
    	    eval q({  &__ilog2($x & -$x); });
	}' unless defined(&__ffs);
	require 'asm-generic/bitops/fls64.ph';
	require 'asm-generic/bitops/hweight.ph';
	eval 'sub find_first_zero_bit {
	    my($addr, $size) = @_;
    	    eval q( &find_next_zero_bit(($addr), ($size), 0));
	}' unless defined(&find_first_zero_bit);
	eval 'sub find_first_bit {
	    my($addr, $size) = @_;
    	    eval q( &find_next_bit(($addr), ($size), 0));
	}' unless defined(&find_first_bit);
	eval 'sub __set_le_bit {
	    my($nr, $addr) = @_;
    	    eval q( &__set_bit(($nr) ^  &BITOP_LE_SWIZZLE, ($addr)));
	}' unless defined(&__set_le_bit);
	eval 'sub __clear_le_bit {
	    my($nr, $addr) = @_;
    	    eval q( &__clear_bit(($nr) ^  &BITOP_LE_SWIZZLE, ($addr)));
	}' unless defined(&__clear_le_bit);
	eval 'sub test_and_set_le_bit {
	    my($nr, $addr) = @_;
    	    eval q( &test_and_set_bit(($nr) ^  &BITOP_LE_SWIZZLE, ($addr)));
	}' unless defined(&test_and_set_le_bit);
	eval 'sub test_and_clear_le_bit {
	    my($nr, $addr) = @_;
    	    eval q( &test_and_clear_bit(($nr) ^  &BITOP_LE_SWIZZLE, ($addr)));
	}' unless defined(&test_and_clear_le_bit);
	eval 'sub __test_and_set_le_bit {
	    my($nr, $addr) = @_;
    	    eval q( &__test_and_set_bit(($nr) ^  &BITOP_LE_SWIZZLE, ($addr)));
	}' unless defined(&__test_and_set_le_bit);
	eval 'sub __test_and_clear_le_bit {
	    my($nr, $addr) = @_;
    	    eval q( &__test_and_clear_bit(($nr) ^  &BITOP_LE_SWIZZLE, ($addr)));
	}' unless defined(&__test_and_clear_le_bit);
	eval 'sub find_first_zero_le_bit {
	    my($addr, $size) = @_;
    	    eval q( &find_next_zero_le_bit(($addr), ($size), 0));
	}' unless defined(&find_first_zero_le_bit);
	eval 'sub ext2_set_bit {
	    my($nr,$addr) = @_;
    	    eval q( &__test_and_set_le_bit(($nr), $addr));
	}' unless defined(&ext2_set_bit);
	eval 'sub ext2_clear_bit {
	    my($nr, $addr) = @_;
    	    eval q( &__test_and_clear_le_bit(($nr), $addr));
	}' unless defined(&ext2_clear_bit);
	eval 'sub ext2_set_bit_atomic {
	    my($lock, $nr, $addr) = @_;
    	    eval q( &test_and_set_le_bit(($nr), $addr));
	}' unless defined(&ext2_set_bit_atomic);
	eval 'sub ext2_clear_bit_atomic {
	    my($lock, $nr, $addr) = @_;
    	    eval q( &test_and_clear_le_bit(($nr), $addr));
	}' unless defined(&ext2_clear_bit_atomic);
	eval 'sub ext2_test_bit {
	    my($nr, $addr) = @_;
    	    eval q( &test_le_bit(($nr),$addr));
	}' unless defined(&ext2_test_bit);
	eval 'sub ext2_find_first_zero_bit {
	    my($addr, $size) = @_;
    	    eval q( &find_first_zero_le_bit($addr, $size));
	}' unless defined(&ext2_find_first_zero_bit);
	eval 'sub ext2_find_next_zero_bit {
	    my($addr, $size, $off) = @_;
    	    eval q( &find_next_zero_le_bit($addr, $size, $off));
	}' unless defined(&ext2_find_next_zero_bit);
	eval 'sub minix_test_and_set_bit {
	    my($nr,$addr) = @_;
    	    eval q( &__test_and_set_le_bit($nr, $addr));
	}' unless defined(&minix_test_and_set_bit);
	eval 'sub minix_set_bit {
	    my($nr,$addr) = @_;
    	    eval q( &__set_le_bit($nr, $addr));
	}' unless defined(&minix_set_bit);
	eval 'sub minix_test_and_clear_bit {
	    my($nr,$addr) = @_;
    	    eval q( &__test_and_clear_le_bit($nr, $addr));
	}' unless defined(&minix_test_and_clear_bit);
	eval 'sub minix_test_bit {
	    my($nr,$addr) = @_;
    	    eval q( &test_le_bit($nr, $addr));
	}' unless defined(&minix_test_bit);
	eval 'sub minix_find_first_zero_bit {
	    my($addr,$size) = @_;
    	    eval q( &find_first_zero_le_bit($addr, $size));
	}' unless defined(&minix_find_first_zero_bit);
	require 'asm-generic/bitops/sched.ph';
    }
}
1;
