require '_h2ph_pre.ph';

no warnings 'redefine';

if(defined(&__KERNEL__)) {
    unless(defined(&_ASM_POWERPC_IRQ_H)) {
	eval 'sub _ASM_POWERPC_IRQ_H () {1;}' unless defined(&_ASM_POWERPC_IRQ_H);
	require 'linux/config.ph';
	require 'linux/threads.ph';
	require 'asm/types.ph';
	require 'asm/atomic.ph';
	eval 'sub NO_IRQ () {(-1);}' unless defined(&NO_IRQ);
	eval 'sub IRQ_SENSE_MASK () {0x1;}' unless defined(&IRQ_SENSE_MASK);
	eval 'sub IRQ_SENSE_LEVEL () {0x1;}' unless defined(&IRQ_SENSE_LEVEL);
	eval 'sub IRQ_SENSE_EDGE () {0x;}' unless defined(&IRQ_SENSE_EDGE);
	eval 'sub IRQ_POLARITY_MASK () {0x2;}' unless defined(&IRQ_POLARITY_MASK);
	eval 'sub IRQ_POLARITY_POSITIVE () {0x2;}' unless defined(&IRQ_POLARITY_POSITIVE);
	eval 'sub IRQ_POLARITY_NEGATIVE () {0x;}' unless defined(&IRQ_POLARITY_NEGATIVE);
	eval 'sub ARCH_HAS_IRQ_PER_CPU () {1;}' unless defined(&ARCH_HAS_IRQ_PER_CPU);
	eval 'sub get_irq_desc {
	    my($irq) = @_;
    	    eval q(( $irq_desc[($irq)]));
	}' unless defined(&get_irq_desc);
	eval 'sub for_each_irq {
	    my($i) = @_;
    	    eval q( &for (($i) = 0; ($i) <  &NR_IRQS; ++($i)));
	}' unless defined(&for_each_irq);
	if(defined(&CONFIG_PPC64)) {
	    eval 'sub NR_IRQS () {512;}' unless defined(&NR_IRQS);
	    eval 'sub virt_irq_to_real {
	        my($virt_irq) = @_;
    		eval q({  $virt_irq_to_real_map[$virt_irq]; });
	    }' unless defined(&virt_irq_to_real);
	    eval 'sub IC_INVALID () {0;}' unless defined(&IC_INVALID);
	    eval 'sub IC_OPEN_PIC () {1;}' unless defined(&IC_OPEN_PIC);
	    eval 'sub IC_PPC_XIC () {2;}' unless defined(&IC_PPC_XIC);
	    eval 'sub IC_CELL_PIC () {3;}' unless defined(&IC_CELL_PIC);
	    eval 'sub IC_ISERIES () {4;}' unless defined(&IC_ISERIES);
	} else {
	    if(defined( &CONFIG_40x)) {
		require 'asm/ibm4xx.ph';
		unless(defined(&NR_BOARD_IRQS)) {
		    eval 'sub NR_BOARD_IRQS () {0;}' unless defined(&NR_BOARD_IRQS);
		}
		unless(defined(&UIC_WIDTH)) {
		    eval 'sub UIC_WIDTH () {32;}' unless defined(&UIC_WIDTH);
		}
		unless(defined(&NR_UICS)) {
		    eval 'sub NR_UICS () {1;}' unless defined(&NR_UICS);
		}
		if(defined ( &CONFIG_403)) {
		    eval 'sub NR_AIC_IRQS () {32;}' unless defined(&NR_AIC_IRQS);
		    eval 'sub NR_IRQS () {( &NR_AIC_IRQS +  &NR_BOARD_IRQS);}' unless defined(&NR_IRQS);
		}
 elsif(!defined ( &CONFIG_403)) {
		    eval 'sub NR_UIC_IRQS () { &UIC_WIDTH;}' unless defined(&NR_UIC_IRQS);
		    eval 'sub NR_IRQS () {(( &NR_UIC_IRQS *  &NR_UICS) +  &NR_BOARD_IRQS);}' unless defined(&NR_IRQS);
		}
	    }
 elsif(defined( &CONFIG_44x)) {
		require 'asm/ibm44x.ph';
		eval 'sub NR_UIC_IRQS () {32;}' unless defined(&NR_UIC_IRQS);
		eval 'sub NR_IRQS () {(( &NR_UIC_IRQS *  &NR_UICS) +  &NR_BOARD_IRQS);}' unless defined(&NR_IRQS);
	    }
 elsif(defined( &CONFIG_8xx)) {
		require 'asm/mpc8xx.ph';
		eval 'sub NR_SIU_INTS () {16;}' unless defined(&NR_SIU_INTS);
		eval 'sub NR_CPM_INTS () {32;}' unless defined(&NR_CPM_INTS);
		unless(defined(&NR_8259_INTS)) {
		    eval 'sub NR_8259_INTS () {0;}' unless defined(&NR_8259_INTS);
		}
		eval 'sub SIU_IRQ_OFFSET () {0;}' unless defined(&SIU_IRQ_OFFSET);
		eval 'sub CPM_IRQ_OFFSET () {( &SIU_IRQ_OFFSET +  &NR_SIU_INTS);}' unless defined(&CPM_IRQ_OFFSET);
		eval 'sub I8259_IRQ_OFFSET () {( &CPM_IRQ_OFFSET +  &NR_CPM_INTS);}' unless defined(&I8259_IRQ_OFFSET);
		eval 'sub NR_IRQS () {( &NR_SIU_INTS +  &NR_CPM_INTS +  &NR_8259_INTS);}' unless defined(&NR_IRQS);
		eval 'sub SIU_IRQ0 () {(0);}' unless defined(&SIU_IRQ0);
		eval 'sub SIU_LEVEL0 () {(1);}' unless defined(&SIU_LEVEL0);
		eval 'sub SIU_IRQ1 () {(2);}' unless defined(&SIU_IRQ1);
		eval 'sub SIU_LEVEL1 () {(3);}' unless defined(&SIU_LEVEL1);
		eval 'sub SIU_IRQ2 () {(4);}' unless defined(&SIU_IRQ2);
		eval 'sub SIU_LEVEL2 () {(5);}' unless defined(&SIU_LEVEL2);
		eval 'sub SIU_IRQ3 () {(6);}' unless defined(&SIU_IRQ3);
		eval 'sub SIU_LEVEL3 () {(7);}' unless defined(&SIU_LEVEL3);
		eval 'sub SIU_IRQ4 () {(8);}' unless defined(&SIU_IRQ4);
		eval 'sub SIU_LEVEL4 () {(9);}' unless defined(&SIU_LEVEL4);
		eval 'sub SIU_IRQ5 () {(10);}' unless defined(&SIU_IRQ5);
		eval 'sub SIU_LEVEL5 () {(11);}' unless defined(&SIU_LEVEL5);
		eval 'sub SIU_IRQ6 () {(12);}' unless defined(&SIU_IRQ6);
		eval 'sub SIU_LEVEL6 () {(13);}' unless defined(&SIU_LEVEL6);
		eval 'sub SIU_IRQ7 () {(14);}' unless defined(&SIU_IRQ7);
		eval 'sub SIU_LEVEL7 () {(15);}' unless defined(&SIU_LEVEL7);
		eval 'sub MPC8xx_INT_FEC1 () { &SIU_LEVEL1;}' unless defined(&MPC8xx_INT_FEC1);
		eval 'sub MPC8xx_INT_FEC2 () { &SIU_LEVEL3;}' unless defined(&MPC8xx_INT_FEC2);
		eval 'sub MPC8xx_INT_SCC1 () {( &CPM_IRQ_OFFSET +  &CPMVEC_SCC1);}' unless defined(&MPC8xx_INT_SCC1);
		eval 'sub MPC8xx_INT_SCC2 () {( &CPM_IRQ_OFFSET +  &CPMVEC_SCC2);}' unless defined(&MPC8xx_INT_SCC2);
		eval 'sub MPC8xx_INT_SCC3 () {( &CPM_IRQ_OFFSET +  &CPMVEC_SCC3);}' unless defined(&MPC8xx_INT_SCC3);
		eval 'sub MPC8xx_INT_SCC4 () {( &CPM_IRQ_OFFSET +  &CPMVEC_SCC4);}' unless defined(&MPC8xx_INT_SCC4);
		eval 'sub MPC8xx_INT_SMC1 () {( &CPM_IRQ_OFFSET +  &CPMVEC_SMC1);}' unless defined(&MPC8xx_INT_SMC1);
		eval 'sub MPC8xx_INT_SMC2 () {( &CPM_IRQ_OFFSET +  &CPMVEC_SMC2);}' unless defined(&MPC8xx_INT_SMC2);
		unless(defined(&PIT_INTERRUPT)) {
		    eval 'sub PIT_INTERRUPT () { &SIU_LEVEL0;}' unless defined(&PIT_INTERRUPT);
		}
		unless(defined(&CPM_INTERRUPT)) {
		    eval 'sub CPM_INTERRUPT () { &SIU_LEVEL2;}' unless defined(&CPM_INTERRUPT);
		}
		unless(defined(&PCMCIA_INTERRUPT)) {
		    eval 'sub PCMCIA_INTERRUPT () { &SIU_LEVEL6;}' unless defined(&PCMCIA_INTERRUPT);
		}
		unless(defined(&DEC_INTERRUPT)) {
		    eval 'sub DEC_INTERRUPT () { &SIU_LEVEL7;}' unless defined(&DEC_INTERRUPT);
		}
		eval 'sub mk_int_int_mask {
		    my($IL) = @_;
    		    eval q((1<< (7- ($IL/2))));
		}' unless defined(&mk_int_int_mask);
	    }
 elsif(defined( &CONFIG_83xx)) {
		require 'asm/mpc83xx.ph';
		eval 'sub NR_IRQS () {( &NR_IPIC_INTS);}' unless defined(&NR_IRQS);
	    }
 elsif(defined( &CONFIG_85xx)) {
		require 'asm/mpc85xx.ph';
		eval 'sub NR_CPM_INTS () {64;}' unless defined(&NR_CPM_INTS);
		eval 'sub NR_EPIC_INTS () {60;}' unless defined(&NR_EPIC_INTS);
		unless(defined(&NR_8259_INTS)) {
		    eval 'sub NR_8259_INTS () {0;}' unless defined(&NR_8259_INTS);
		}
		eval 'sub NUM_8259_INTERRUPTS () { &NR_8259_INTS;}' unless defined(&NUM_8259_INTERRUPTS);
		unless(defined(&CPM_IRQ_OFFSET)) {
		    eval 'sub CPM_IRQ_OFFSET () {0;}' unless defined(&CPM_IRQ_OFFSET);
		}
		eval 'sub NR_IRQS () {( &NR_EPIC_INTS +  &NR_CPM_INTS +  &NR_8259_INTS);}' unless defined(&NR_IRQS);
		unless(defined(&MPC85xx_OPENPIC_IRQ_OFFSET)) {
		    if(defined(&CONFIG_CPM2)) {
			eval 'sub MPC85xx_OPENPIC_IRQ_OFFSET () {( &CPM_IRQ_OFFSET +  &NR_CPM_INTS);}' unless defined(&MPC85xx_OPENPIC_IRQ_OFFSET);
		    } else {
			eval 'sub MPC85xx_OPENPIC_IRQ_OFFSET () {0;}' unless defined(&MPC85xx_OPENPIC_IRQ_OFFSET);
		    }
		}
		eval 'sub MPC85xx_IRQ_L2CACHE () {( 0+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_L2CACHE);
		eval 'sub MPC85xx_IRQ_ECM () {( 1+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_ECM);
		eval 'sub MPC85xx_IRQ_DDR () {( 2+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_DDR);
		eval 'sub MPC85xx_IRQ_LBIU () {( 3+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_LBIU);
		eval 'sub MPC85xx_IRQ_DMA0 () {( 4+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_DMA0);
		eval 'sub MPC85xx_IRQ_DMA1 () {( 5+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_DMA1);
		eval 'sub MPC85xx_IRQ_DMA2 () {( 6+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_DMA2);
		eval 'sub MPC85xx_IRQ_DMA3 () {( 7+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_DMA3);
		eval 'sub MPC85xx_IRQ_PCI1 () {( 8+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_PCI1);
		eval 'sub MPC85xx_IRQ_PCI2 () {( 9+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_PCI2);
		eval 'sub MPC85xx_IRQ_RIO_ERROR () {( 9+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_RIO_ERROR);
		eval 'sub MPC85xx_IRQ_RIO_BELL () {(10+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_RIO_BELL);
		eval 'sub MPC85xx_IRQ_RIO_TX () {(11+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_RIO_TX);
		eval 'sub MPC85xx_IRQ_RIO_RX () {(12+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_RIO_RX);
		eval 'sub MPC85xx_IRQ_TSEC1_TX () {(13+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC1_TX);
		eval 'sub MPC85xx_IRQ_TSEC1_RX () {(14+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC1_RX);
		eval 'sub MPC85xx_IRQ_TSEC3_TX () {(15+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC3_TX);
		eval 'sub MPC85xx_IRQ_TSEC3_RX () {(16+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC3_RX);
		eval 'sub MPC85xx_IRQ_TSEC3_ERROR () {(17+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC3_ERROR);
		eval 'sub MPC85xx_IRQ_TSEC1_ERROR () {(18+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC1_ERROR);
		eval 'sub MPC85xx_IRQ_TSEC2_TX () {(19+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC2_TX);
		eval 'sub MPC85xx_IRQ_TSEC2_RX () {(20+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC2_RX);
		eval 'sub MPC85xx_IRQ_TSEC4_TX () {(21+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC4_TX);
		eval 'sub MPC85xx_IRQ_TSEC4_RX () {(22+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC4_RX);
		eval 'sub MPC85xx_IRQ_TSEC4_ERROR () {(23+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC4_ERROR);
		eval 'sub MPC85xx_IRQ_TSEC2_ERROR () {(24+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_TSEC2_ERROR);
		eval 'sub MPC85xx_IRQ_FEC () {(25+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_FEC);
		eval 'sub MPC85xx_IRQ_DUART () {(26+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_DUART);
		eval 'sub MPC85xx_IRQ_IIC1 () {(27+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_IIC1);
		eval 'sub MPC85xx_IRQ_PERFMON () {(28+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_PERFMON);
		eval 'sub MPC85xx_IRQ_SEC2 () {(29+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_SEC2);
		eval 'sub MPC85xx_IRQ_CPM () {(30+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_CPM);
		eval 'sub MPC85xx_IRQ_EXT0 () {(48+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT0);
		eval 'sub MPC85xx_IRQ_EXT1 () {(49+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT1);
		eval 'sub MPC85xx_IRQ_EXT2 () {(50+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT2);
		eval 'sub MPC85xx_IRQ_EXT3 () {(51+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT3);
		eval 'sub MPC85xx_IRQ_EXT4 () {(52+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT4);
		eval 'sub MPC85xx_IRQ_EXT5 () {(53+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT5);
		eval 'sub MPC85xx_IRQ_EXT6 () {(54+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT6);
		eval 'sub MPC85xx_IRQ_EXT7 () {(55+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT7);
		eval 'sub MPC85xx_IRQ_EXT8 () {(56+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT8);
		eval 'sub MPC85xx_IRQ_EXT9 () {(57+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT9);
		eval 'sub MPC85xx_IRQ_EXT10 () {(58+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT10);
		eval 'sub MPC85xx_IRQ_EXT11 () {(59+  &MPC85xx_OPENPIC_IRQ_OFFSET);}' unless defined(&MPC85xx_IRQ_EXT11);
		eval 'sub SIU_INT_ERROR () {(0x+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_ERROR);
		eval 'sub SIU_INT_I2C () {(0x1+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_I2C);
		eval 'sub SIU_INT_SPI () {(0x2+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SPI);
		eval 'sub SIU_INT_RISC () {(0x3+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_RISC);
		eval 'sub SIU_INT_SMC1 () {(0x4+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SMC1);
		eval 'sub SIU_INT_SMC2 () {(0x5+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SMC2);
		eval 'sub SIU_INT_USB () {(0xb+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_USB);
		eval 'sub SIU_INT_TIMER1 () {(0xc+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_TIMER1);
		eval 'sub SIU_INT_TIMER2 () {(0xd+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_TIMER2);
		eval 'sub SIU_INT_TIMER3 () {(0xe+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_TIMER3);
		eval 'sub SIU_INT_TIMER4 () {(0xf+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_TIMER4);
		eval 'sub SIU_INT_FCC1 () {(0x20+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_FCC1);
		eval 'sub SIU_INT_FCC2 () {(0x21+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_FCC2);
		eval 'sub SIU_INT_FCC3 () {(0x22+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_FCC3);
		eval 'sub SIU_INT_MCC1 () {(0x24+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_MCC1);
		eval 'sub SIU_INT_MCC2 () {(0x25+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_MCC2);
		eval 'sub SIU_INT_SCC1 () {(0x28+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SCC1);
		eval 'sub SIU_INT_SCC2 () {(0x29+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SCC2);
		eval 'sub SIU_INT_SCC3 () {(0x2a+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SCC3);
		eval 'sub SIU_INT_SCC4 () {(0x2b+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SCC4);
		eval 'sub SIU_INT_PC15 () {(0x30+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC15);
		eval 'sub SIU_INT_PC14 () {(0x31+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC14);
		eval 'sub SIU_INT_PC13 () {(0x32+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC13);
		eval 'sub SIU_INT_PC12 () {(0x33+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC12);
		eval 'sub SIU_INT_PC11 () {(0x34+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC11);
		eval 'sub SIU_INT_PC10 () {(0x35+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC10);
		eval 'sub SIU_INT_PC9 () {(0x36+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC9);
		eval 'sub SIU_INT_PC8 () {(0x37+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC8);
		eval 'sub SIU_INT_PC7 () {(0x38+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC7);
		eval 'sub SIU_INT_PC6 () {(0x39+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC6);
		eval 'sub SIU_INT_PC5 () {(0x3a+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC5);
		eval 'sub SIU_INT_PC4 () {(0x3b+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC4);
		eval 'sub SIU_INT_PC3 () {(0x3c+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC3);
		eval 'sub SIU_INT_PC2 () {(0x3d+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC2);
		eval 'sub SIU_INT_PC1 () {(0x3e+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC1);
		eval 'sub SIU_INT_PC0 () {(0x3f+ &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC0);
	    } else {
		eval 'sub NR_IRQS () {256;}' unless defined(&NR_IRQS);
		eval 'sub __DO_IRQ_CANON () {1;}' unless defined(&__DO_IRQ_CANON);
		unless(defined(&CONFIG_8260)) {
		    eval 'sub NUM_8259_INTERRUPTS () {16;}' unless defined(&NUM_8259_INTERRUPTS);
		} else {
		    unless(defined(&CPM_IRQ_OFFSET)) {
			eval 'sub CPM_IRQ_OFFSET () {0;}' unless defined(&CPM_IRQ_OFFSET);
		    }
		    eval 'sub NR_CPM_INTS () {64;}' unless defined(&NR_CPM_INTS);
		    eval 'sub SIU_INT_ERROR () {(0x +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_ERROR);
		    eval 'sub SIU_INT_I2C () {(0x1 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_I2C);
		    eval 'sub SIU_INT_SPI () {(0x2 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SPI);
		    eval 'sub SIU_INT_RISC () {(0x3 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_RISC);
		    eval 'sub SIU_INT_SMC1 () {(0x4 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SMC1);
		    eval 'sub SIU_INT_SMC2 () {(0x5 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SMC2);
		    eval 'sub SIU_INT_IDMA1 () {(0x6 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_IDMA1);
		    eval 'sub SIU_INT_IDMA2 () {(0x7 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_IDMA2);
		    eval 'sub SIU_INT_IDMA3 () {(0x8 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_IDMA3);
		    eval 'sub SIU_INT_IDMA4 () {(0x9 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_IDMA4);
		    eval 'sub SIU_INT_SDMA () {(0xa +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SDMA);
		    eval 'sub SIU_INT_USB () {(0xb +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_USB);
		    eval 'sub SIU_INT_TIMER1 () {(0xc +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_TIMER1);
		    eval 'sub SIU_INT_TIMER2 () {(0xd +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_TIMER2);
		    eval 'sub SIU_INT_TIMER3 () {(0xe +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_TIMER3);
		    eval 'sub SIU_INT_TIMER4 () {(0xf +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_TIMER4);
		    eval 'sub SIU_INT_TMCNT () {(0x10 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_TMCNT);
		    eval 'sub SIU_INT_PIT () {(0x11 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PIT);
		    eval 'sub SIU_INT_PCI () {(0x12 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PCI);
		    eval 'sub SIU_INT_IRQ1 () {(0x13 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_IRQ1);
		    eval 'sub SIU_INT_IRQ2 () {(0x14 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_IRQ2);
		    eval 'sub SIU_INT_IRQ3 () {(0x15 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_IRQ3);
		    eval 'sub SIU_INT_IRQ4 () {(0x16 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_IRQ4);
		    eval 'sub SIU_INT_IRQ5 () {(0x17 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_IRQ5);
		    eval 'sub SIU_INT_IRQ6 () {(0x18 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_IRQ6);
		    eval 'sub SIU_INT_IRQ7 () {(0x19 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_IRQ7);
		    eval 'sub SIU_INT_FCC1 () {(0x20 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_FCC1);
		    eval 'sub SIU_INT_FCC2 () {(0x21 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_FCC2);
		    eval 'sub SIU_INT_FCC3 () {(0x22 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_FCC3);
		    eval 'sub SIU_INT_MCC1 () {(0x24 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_MCC1);
		    eval 'sub SIU_INT_MCC2 () {(0x25 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_MCC2);
		    eval 'sub SIU_INT_SCC1 () {(0x28 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SCC1);
		    eval 'sub SIU_INT_SCC2 () {(0x29 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SCC2);
		    eval 'sub SIU_INT_SCC3 () {(0x2a +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SCC3);
		    eval 'sub SIU_INT_SCC4 () {(0x2b +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_SCC4);
		    eval 'sub SIU_INT_PC15 () {(0x30 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC15);
		    eval 'sub SIU_INT_PC14 () {(0x31 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC14);
		    eval 'sub SIU_INT_PC13 () {(0x32 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC13);
		    eval 'sub SIU_INT_PC12 () {(0x33 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC12);
		    eval 'sub SIU_INT_PC11 () {(0x34 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC11);
		    eval 'sub SIU_INT_PC10 () {(0x35 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC10);
		    eval 'sub SIU_INT_PC9 () {(0x36 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC9);
		    eval 'sub SIU_INT_PC8 () {(0x37 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC8);
		    eval 'sub SIU_INT_PC7 () {(0x38 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC7);
		    eval 'sub SIU_INT_PC6 () {(0x39 +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC6);
		    eval 'sub SIU_INT_PC5 () {(0x3a +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC5);
		    eval 'sub SIU_INT_PC4 () {(0x3b +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC4);
		    eval 'sub SIU_INT_PC3 () {(0x3c +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC3);
		    eval 'sub SIU_INT_PC2 () {(0x3d +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC2);
		    eval 'sub SIU_INT_PC1 () {(0x3e +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC1);
		    eval 'sub SIU_INT_PC0 () {(0x3f +  &CPM_IRQ_OFFSET);}' unless defined(&SIU_INT_PC0);
		}
	    }
	    eval 'sub NR_MASK_WORDS () {(( &NR_IRQS + 31) / 32);}' unless defined(&NR_MASK_WORDS);
	    eval 'sub virt_irq_create_mapping {
	        my($x) = @_;
    		eval q(($x));
	    }' unless defined(&virt_irq_create_mapping);
	}
	eval 'sub NUM_ISA_INTERRUPTS () {0x10;}' unless defined(&NUM_ISA_INTERRUPTS);
	eval 'sub irq_offset_up {
	    my($irq) = @_;
    	    eval q({ ($irq +  &__irq_offset_value); });
	}' unless defined(&irq_offset_up);
	eval 'sub irq_offset_down {
	    my($irq) = @_;
    	    eval q({ ($irq -  &__irq_offset_value); });
	}' unless defined(&irq_offset_down);
	eval 'sub irq_offset_value {
	    my($void) = @_;
    	    eval q({  &__irq_offset_value; });
	}' unless defined(&irq_offset_value);
	if(defined(&__DO_IRQ_CANON)) {
	} else {
	    eval 'sub ppc_do_canonicalize_irqs () {0;}' unless defined(&ppc_do_canonicalize_irqs);
	}
	eval 'sub irq_canonicalize {
	    my($irq) = @_;
    	    eval q({  &if ( &ppc_do_canonicalize_irqs  && $irq == 2) $irq = 9; $irq; });
	}' unless defined(&irq_canonicalize);
	eval 'sub __ARCH_HAS_DO_SOFTIRQ () {1;}' unless defined(&__ARCH_HAS_DO_SOFTIRQ);
	if(defined(&CONFIG_IRQSTACKS)) {
	} else {
	    eval 'sub irq_ctx_init () {
	        eval q();
	    }' unless defined(&irq_ctx_init);
	}
    }
}
1;
