require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_MMU_H_)) {
    eval 'sub _ASM_POWERPC_MMU_H_ () {1;}' unless defined(&_ASM_POWERPC_MMU_H_);
    if(defined(&__KERNEL__)) {
	unless(defined(&CONFIG_PPC64)) {
	    require 'asm-ppc/mmu.ph';
	} else {
	    require 'asm/asm-compat.ph';
	    require 'asm/page.ph';
	    eval 'sub STE_ESID_V () {0x80;}' unless defined(&STE_ESID_V);
	    eval 'sub STE_ESID_KS () {0x20;}' unless defined(&STE_ESID_KS);
	    eval 'sub STE_ESID_KP () {0x10;}' unless defined(&STE_ESID_KP);
	    eval 'sub STE_ESID_N () {0x8;}' unless defined(&STE_ESID_N);
	    eval 'sub STE_VSID_SHIFT () {12;}' unless defined(&STE_VSID_SHIFT);
	    eval 'sub STAB0_PAGE () {0x6;}' unless defined(&STAB0_PAGE);
	    eval 'sub STAB0_OFFSET () {( &STAB0_PAGE << 12);}' unless defined(&STAB0_OFFSET);
	    eval 'sub STAB0_PHYS_ADDR () {( &STAB0_OFFSET +  &PHYSICAL_START);}' unless defined(&STAB0_PHYS_ADDR);
	    unless(defined(&__ASSEMBLY__)) {
	    }
	    eval 'sub SLB_NUM_BOLTED () {3;}' unless defined(&SLB_NUM_BOLTED);
	    eval 'sub SLB_CACHE_ENTRIES () {8;}' unless defined(&SLB_CACHE_ENTRIES);
	    eval 'sub SLB_ESID_V () { &ASM_CONST(0x8000000);}' unless defined(&SLB_ESID_V);
	    eval 'sub SLB_VSID_SHIFT () {12;}' unless defined(&SLB_VSID_SHIFT);
	    eval 'sub SLB_VSID_B () { &ASM_CONST(1.38350580552822e+19);}' unless defined(&SLB_VSID_B);
	    eval 'sub SLB_VSID_B_256M () { &ASM_CONST(0x);}' unless defined(&SLB_VSID_B_256M);
	    eval 'sub SLB_VSID_B_1T () { &ASM_CONST(4.61168601842739e+18);}' unless defined(&SLB_VSID_B_1T);
	    eval 'sub SLB_VSID_KS () { &ASM_CONST(0x800);}' unless defined(&SLB_VSID_KS);
	    eval 'sub SLB_VSID_KP () { &ASM_CONST(0x400);}' unless defined(&SLB_VSID_KP);
	    eval 'sub SLB_VSID_N () { &ASM_CONST(0x200);}' unless defined(&SLB_VSID_N);
	    eval 'sub SLB_VSID_L () { &ASM_CONST(0x100);}' unless defined(&SLB_VSID_L);
	    eval 'sub SLB_VSID_C () { &ASM_CONST(0x80);}' unless defined(&SLB_VSID_C);
	    eval 'sub SLB_VSID_LP () { &ASM_CONST(0x30);}' unless defined(&SLB_VSID_LP);
	    eval 'sub SLB_VSID_LP_00 () { &ASM_CONST(0x);}' unless defined(&SLB_VSID_LP_00);
	    eval 'sub SLB_VSID_LP_01 () { &ASM_CONST(0x10);}' unless defined(&SLB_VSID_LP_01);
	    eval 'sub SLB_VSID_LP_10 () { &ASM_CONST(0x20);}' unless defined(&SLB_VSID_LP_10);
	    eval 'sub SLB_VSID_LP_11 () { &ASM_CONST(0x30);}' unless defined(&SLB_VSID_LP_11);
	    eval 'sub SLB_VSID_LLP () {( &SLB_VSID_L| &SLB_VSID_LP);}' unless defined(&SLB_VSID_LLP);
	    eval 'sub SLB_VSID_KERNEL () {( &SLB_VSID_KP);}' unless defined(&SLB_VSID_KERNEL);
	    eval 'sub SLB_VSID_USER () {( &SLB_VSID_KP| &SLB_VSID_KS| &SLB_VSID_C);}' unless defined(&SLB_VSID_USER);
	    eval 'sub SLBIE_C () {(0x8000000);}' unless defined(&SLBIE_C);
	    eval 'sub HPTES_PER_GROUP () {8;}' unless defined(&HPTES_PER_GROUP);
	    eval 'sub HPTE_V_AVPN_SHIFT () {7;}' unless defined(&HPTE_V_AVPN_SHIFT);
	    eval 'sub HPTE_V_AVPN () { &ASM_CONST(1.84467440737096e+19);}' unless defined(&HPTE_V_AVPN);
	    eval 'sub HPTE_V_AVPN_VAL {
	        my($x) = @_;
    		eval q(((($x) &  &HPTE_V_AVPN) >>  &HPTE_V_AVPN_SHIFT));
	    }' unless defined(&HPTE_V_AVPN_VAL);
	    eval 'sub HPTE_V_COMPARE {
	        my($x,$y) = @_;
    		eval q((!((($x) ^ ($y)) &  &HPTE_V_AVPN)));
	    }' unless defined(&HPTE_V_COMPARE);
	    eval 'sub HPTE_V_BOLTED () { &ASM_CONST(0x10);}' unless defined(&HPTE_V_BOLTED);
	    eval 'sub HPTE_V_LOCK () { &ASM_CONST(0x8);}' unless defined(&HPTE_V_LOCK);
	    eval 'sub HPTE_V_LARGE () { &ASM_CONST(0x4);}' unless defined(&HPTE_V_LARGE);
	    eval 'sub HPTE_V_SECONDARY () { &ASM_CONST(0x2);}' unless defined(&HPTE_V_SECONDARY);
	    eval 'sub HPTE_V_VALID () { &ASM_CONST(0x1);}' unless defined(&HPTE_V_VALID);
	    eval 'sub HPTE_R_PP0 () { &ASM_CONST(9.22337203685478e+18);}' unless defined(&HPTE_R_PP0);
	    eval 'sub HPTE_R_TS () { &ASM_CONST(4.61168601842739e+18);}' unless defined(&HPTE_R_TS);
	    eval 'sub HPTE_R_RPN_SHIFT () {12;}' unless defined(&HPTE_R_RPN_SHIFT);
	    eval 'sub HPTE_R_RPN () { &ASM_CONST(4.61168601842738e+18);}' unless defined(&HPTE_R_RPN);
	    eval 'sub HPTE_R_FLAGS () { &ASM_CONST(0x3ff);}' unless defined(&HPTE_R_FLAGS);
	    eval 'sub HPTE_R_PP () { &ASM_CONST(0x3);}' unless defined(&HPTE_R_PP);
	    eval 'sub HPTE_R_N () { &ASM_CONST(0x4);}' unless defined(&HPTE_R_N);
	    eval 'sub PP_RWXX () {0;}' unless defined(&PP_RWXX);
	    eval 'sub PP_RWRX () {1;}' unless defined(&PP_RWRX);
	    eval 'sub PP_RWRW () {2;}' unless defined(&PP_RWRW);
	    eval 'sub PP_RXRX () {3;}' unless defined(&PP_RXRX);
	    unless(defined(&__ASSEMBLY__)) {
	    }
	    eval 'sub MMU_PAGE_4K () {0;}' unless defined(&MMU_PAGE_4K);
	    eval 'sub MMU_PAGE_64K () {1;}' unless defined(&MMU_PAGE_64K);
	    eval 'sub MMU_PAGE_64K_AP () {2;}' unless defined(&MMU_PAGE_64K_AP);
	    eval 'sub MMU_PAGE_1M () {3;}' unless defined(&MMU_PAGE_1M);
	    eval 'sub MMU_PAGE_16M () {4;}' unless defined(&MMU_PAGE_16M);
	    eval 'sub MMU_PAGE_16G () {5;}' unless defined(&MMU_PAGE_16G);
	    eval 'sub MMU_PAGE_COUNT () {6;}' unless defined(&MMU_PAGE_COUNT);
	    unless(defined(&__ASSEMBLY__)) {
		if(defined(&CONFIG_HUGETLB_PAGE)) {
		}
	    }
	    eval 'sub VSID_MULTIPLIER () { &ASM_CONST(200730139);}' unless defined(&VSID_MULTIPLIER);
	    eval 'sub VSID_BITS () {36;}' unless defined(&VSID_BITS);
	    eval 'sub VSID_MODULUS () {((1<< &VSID_BITS)-1);}' unless defined(&VSID_MODULUS);
	    eval 'sub CONTEXT_BITS () {19;}' unless defined(&CONTEXT_BITS);
	    eval 'sub USER_ESID_BITS () {16;}' unless defined(&USER_ESID_BITS);
	    eval 'sub USER_VSID_RANGE () {(1 << ( &USER_ESID_BITS +  &SID_SHIFT));}' unless defined(&USER_VSID_RANGE);
	    eval 'sub ASM_VSID_SCRAMBLE {
	        my($rt, $rx) = @_;
    		eval q( &lis $rx, &VSID_MULTIPLIER@ &h;  &ori $rx,$rx, &VSID_MULTIPLIER@ &l;  &mulld $rt,$rt,$rx;  &srdi $rx,$rt, &VSID_BITS;  &clrldi $rt,$rt,(64- &VSID_BITS);  &add $rt,$rt,$rx;  &addi $rx,$rt,1;  &srdi $rx,$rx, &VSID_BITS;  &add $rt,$rt,$rx);
	    }' unless defined(&ASM_VSID_SCRAMBLE);
	    unless(defined(&__ASSEMBLY__)) {
		if(defined(&CONFIG_HUGETLB_PAGE)) {
		}
# some #ifdef were dropped here -- fill in the blanks
		eval 'sub vsid_scramble {
		    my($protovsid) = @_;
    		    eval q({ });
		}' unless defined(&vsid_scramble);
		eval 'sub VSID_SCRAMBLE {
		    my($pvsid) = @_;
    		    eval q(((($pvsid) *  &VSID_MULTIPLIER) %  &VSID_MODULUS));
		}' unless defined(&VSID_SCRAMBLE);
		eval 'sub KERNEL_VSID {
		    my($ea) = @_;
    		    eval q( &VSID_SCRAMBLE( &GET_ESID($ea)));
		}' unless defined(&KERNEL_VSID);
	    }
	}
    }
}
1;
