require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_PAGE_H)) {
    eval 'sub _ASM_POWERPC_PAGE_H () {1;}' unless defined(&_ASM_POWERPC_PAGE_H);
    require 'linux/config.ph';
    require 'asm/asm-compat.ph';
    if(defined(&CONFIG_PPC_64K_PAGES)) {
	eval 'sub PAGE_SHIFT () {16;}' unless defined(&PAGE_SHIFT);
    } else {
	eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    }
    eval 'sub PAGE_SIZE () {( &ASM_CONST(1) <<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub __HAVE_ARCH_GATE_AREA () {1;}' unless defined(&__HAVE_ARCH_GATE_AREA);
    eval 'sub PAGE_MASK () {(~((1<<  &PAGE_SHIFT) - 1));}' unless defined(&PAGE_MASK);
    if(defined(&CONFIG_CRASH_DUMP)) {
	eval 'sub PHYSICAL_START () {0x2000000;}' unless defined(&PHYSICAL_START);
    } else {
	eval 'sub PHYSICAL_START () {0x;}' unless defined(&PHYSICAL_START);
    }
    eval 'sub PAGE_OFFSET () { &ASM_CONST( &CONFIG_KERNEL_START);}' unless defined(&PAGE_OFFSET);
    eval 'sub KERNELBASE () {( &PAGE_OFFSET +  &PHYSICAL_START);}' unless defined(&KERNELBASE);
    if(defined(&CONFIG_DISCONTIGMEM)) {
	eval 'sub page_to_pfn {
	    my($page) = @_;
    	    eval q( &discontigmem_page_to_pfn($page));
	}' unless defined(&page_to_pfn);
	eval 'sub pfn_to_page {
	    my($pfn) = @_;
    	    eval q( &discontigmem_pfn_to_page($pfn));
	}' unless defined(&pfn_to_page);
	eval 'sub pfn_valid {
	    my($pfn) = @_;
    	    eval q( &discontigmem_pfn_valid($pfn));
	}' unless defined(&pfn_valid);
    }
    if(defined(&CONFIG_FLATMEM)) {
	eval 'sub pfn_valid {
	    my($pfn) = @_;
    	    eval q((($pfn) <  &max_mapnr));
	}' unless defined(&pfn_valid);
    }
    eval 'sub virt_to_page {
        my($kaddr) = @_;
	    eval q( &pfn_to_page( &__pa($kaddr) >>  &PAGE_SHIFT));
    }' unless defined(&virt_to_page);
    eval 'sub pfn_to_kaddr {
        my($pfn) = @_;
	    eval q( &__va(($pfn) <<  &PAGE_SHIFT));
    }' unless defined(&pfn_to_kaddr);
    eval 'sub virt_addr_valid {
        my($kaddr) = @_;
	    eval q( &pfn_valid( &__pa($kaddr) >>  &PAGE_SHIFT));
    }' unless defined(&virt_addr_valid);
    eval 'sub __va {
        my($x) = @_;
	    eval q((( &void *)(($x) +  &PAGE_OFFSET)));
    }' unless defined(&__va);
    eval 'sub __pa {
        my($x) = @_;
	    eval q((($x) -  &PAGE_OFFSET));
    }' unless defined(&__pa);
    eval 'sub VM_DATA_DEFAULT_FLAGS32 () {( &VM_READ |  &VM_WRITE |  &VM_EXEC |  &VM_MAYREAD |  &VM_MAYWRITE |  &VM_MAYEXEC);}' unless defined(&VM_DATA_DEFAULT_FLAGS32);
    eval 'sub VM_DATA_DEFAULT_FLAGS64 () {( &VM_READ |  &VM_WRITE |  &VM_MAYREAD |  &VM_MAYWRITE |  &VM_MAYEXEC);}' unless defined(&VM_DATA_DEFAULT_FLAGS64);
    if(defined(&__powerpc64__)) {
	require 'asm/page_64.ph';
    } else {
	require 'asm/page_32.ph';
    }
    eval 'sub _ALIGN_UP {
        my($addr,$size) = @_;
	    eval q(((($addr)+(($size)-1))(~(($size)-1))));
    }' unless defined(&_ALIGN_UP);
    eval 'sub _ALIGN_DOWN {
        my($addr,$size) = @_;
	    eval q((($addr)(~(($size)-1))));
    }' unless defined(&_ALIGN_DOWN);
    eval 'sub _ALIGN {
        my($addr,$size) = @_;
	    eval q( &_ALIGN_UP($addr,$size));
    }' unless defined(&_ALIGN);
    eval 'sub PAGE_ALIGN {
        my($addr) = @_;
	    eval q( &_ALIGN($addr,  &PAGE_SIZE));
    }' unless defined(&PAGE_ALIGN);
    eval 'sub is_kernel_addr {
        my($x) = @_;
	    eval q((($x) >=  &PAGE_OFFSET));
    }' unless defined(&is_kernel_addr);
    unless(defined(&__ASSEMBLY__)) {
	undef(&STRICT_MM_TYPECHECKS) if defined(&STRICT_MM_TYPECHECKS);
	if(defined(&STRICT_MM_TYPECHECKS)) {
	    if(defined(&__KERNEL__)) {
		eval 'sub pte_val {
		    my($x) = @_;
    		    eval q((($x). &pte));
		}' unless defined(&pte_val);
		eval 'sub __pte {
		    my($x) = @_;
    		    eval q((( &pte_t) { ($x) }));
		}' unless defined(&__pte);
	    }
	    if(defined(&CONFIG_PPC_64K_PAGES)) {
	    } else {
	    }
	    eval 'sub pmd_val {
	        my($x) = @_;
    		eval q((($x). &pmd));
	    }' unless defined(&pmd_val);
	    eval 'sub __pmd {
	        my($x) = @_;
    		eval q((( &pmd_t) { ($x) }));
	    }' unless defined(&__pmd);
	    unless(defined(&CONFIG_PPC_64K_PAGES)) {
		eval 'sub pud_val {
		    my($x) = @_;
    		    eval q((($x). &pud));
		}' unless defined(&pud_val);
		eval 'sub __pud {
		    my($x) = @_;
    		    eval q((( &pud_t) { ($x) }));
		}' unless defined(&__pud);
	    }
	    eval 'sub pgd_val {
	        my($x) = @_;
    		eval q((($x). &pgd));
	    }' unless defined(&pgd_val);
	    eval 'sub __pgd {
	        my($x) = @_;
    		eval q((( &pgd_t) { ($x) }));
	    }' unless defined(&__pgd);
	    eval 'sub pgprot_val {
	        my($x) = @_;
    		eval q((($x). &pgprot));
	    }' unless defined(&pgprot_val);
	    eval 'sub __pgprot {
	        my($x) = @_;
    		eval q((( &pgprot_t) { ($x) }));
	    }' unless defined(&__pgprot);
	} else {
	    if(defined(&__KERNEL__)) {
		eval 'sub pte_val {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&pte_val);
		eval 'sub __pte {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&__pte);
	    }
	    if(defined(&CONFIG_PPC_64K_PAGES)) {
	    } else {
	    }
	    eval 'sub pmd_val {
	        my($x) = @_;
    		eval q(($x));
	    }' unless defined(&pmd_val);
	    eval 'sub __pmd {
	        my($x) = @_;
    		eval q(($x));
	    }' unless defined(&__pmd);
	    if(defined( &CONFIG_PPC64)  && !defined( &CONFIG_PPC_64K_PAGES)) {
		eval 'sub pud_val {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&pud_val);
		eval 'sub __pud {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&__pud);
	    }
	    eval 'sub pgd_val {
	        my($x) = @_;
    		eval q(($x));
	    }' unless defined(&pgd_val);
	    eval 'sub pgprot_val {
	        my($x) = @_;
    		eval q(($x));
	    }' unless defined(&pgprot_val);
	    eval 'sub __pgd {
	        my($x) = @_;
    		eval q(($x));
	    }' unless defined(&__pgd);
	    eval 'sub __pgprot {
	        my($x) = @_;
    		eval q(($x));
	    }' unless defined(&__pgprot);
	}
	require 'asm-generic/memory_model.ph';
    }
}
1;
