require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_PGALLOC_H)) {
    eval 'sub _ASM_POWERPC_PGALLOC_H () {1;}' unless defined(&_ASM_POWERPC_PGALLOC_H);
    if(defined(&__KERNEL__)) {
	unless(defined(&CONFIG_PPC64)) {
	    require 'asm-ppc/pgalloc.ph';
	} else {
	    require 'linux/mm.ph';
	    require 'linux/slab.ph';
	    require 'linux/cpumask.ph';
	    require 'linux/percpu.ph';
	    if(defined(&CONFIG_PPC_64K_PAGES)) {
		eval 'sub PTE_CACHE_NUM () {0;}' unless defined(&PTE_CACHE_NUM);
		eval 'sub PMD_CACHE_NUM () {1;}' unless defined(&PMD_CACHE_NUM);
		eval 'sub PGD_CACHE_NUM () {2;}' unless defined(&PGD_CACHE_NUM);
		eval 'sub HUGEPTE_CACHE_NUM () {3;}' unless defined(&HUGEPTE_CACHE_NUM);
	    } else {
		eval 'sub PTE_CACHE_NUM () {0;}' unless defined(&PTE_CACHE_NUM);
		eval 'sub PMD_CACHE_NUM () {1;}' unless defined(&PMD_CACHE_NUM);
		eval 'sub PUD_CACHE_NUM () {1;}' unless defined(&PUD_CACHE_NUM);
		eval 'sub PGD_CACHE_NUM () {0;}' unless defined(&PGD_CACHE_NUM);
		eval 'sub HUGEPTE_CACHE_NUM () {2;}' unless defined(&HUGEPTE_CACHE_NUM);
	    }
	    eval 'sub pgd_free {
	        my($pgd) = @_;
    		eval q({  &kmem_cache_free( $pgtable_cache[ &PGD_CACHE_NUM], $pgd); });
	    }' unless defined(&pgd_free);
	    unless(defined(&CONFIG_PPC_64K_PAGES)) {
		eval 'sub pgd_populate {
		    my($MM, $PGD, $PUD) = @_;
    		    eval q( &pgd_set($PGD, $PUD));
		}' unless defined(&pgd_populate);
		eval 'sub pud_t {
		    eval q(* &pud_alloc_one(\'struct mm_struct\' * &mm, my $addr) {  &kmem_cache_alloc( $pgtable_cache[ &PUD_CACHE_NUM],  &GFP_KERNEL| &__GFP_REPEAT); });
		}' unless defined(&pud_t);
		eval 'sub pud_free {
		    my($pud) = @_;
    		    eval q({  &kmem_cache_free( $pgtable_cache[ &PUD_CACHE_NUM], $pud); });
		}' unless defined(&pud_free);
		eval 'sub pud_populate {
		    my($mm,$pud,$pmd) = @_;
    		    eval q({  &pud_set($pud, $pmd); });
		}' unless defined(&pud_populate);
		eval 'sub pmd_populate {
		    my($mm, $pmd, $pte_page) = @_;
    		    eval q( &pmd_populate_kernel($mm, $pmd,  &page_address($pte_page)));
		}' unless defined(&pmd_populate);
		eval 'sub pmd_populate_kernel {
		    my($mm, $pmd, $pte) = @_;
    		    eval q( &pmd_set($pmd, ($pte)));
		}' unless defined(&pmd_populate_kernel);
	    } else {
		eval 'sub pud_populate {
		    my($mm, $pud, $pmd) = @_;
    		    eval q( &pud_set($pud, $pmd));
		}' unless defined(&pud_populate);
		eval 'sub pmd_populate_kernel {
		    my($mm,$pmd,$pte) = @_;
    		    eval q({  &pmd_set($pmd, $pte); });
		}' unless defined(&pmd_populate_kernel);
		eval 'sub pmd_populate {
		    my($mm, $pmd, $pte_page) = @_;
    		    eval q( &pmd_populate_kernel($mm, $pmd,  &page_address($pte_page)));
		}' unless defined(&pmd_populate);
	    }
	    eval 'sub pmd_t {
	        eval q(* &pmd_alloc_one(\'struct mm_struct\' * &mm, my $addr) {  &kmem_cache_alloc( $pgtable_cache[ &PMD_CACHE_NUM],  &GFP_KERNEL| &__GFP_REPEAT); });
	    }' unless defined(&pmd_t);
	    eval 'sub pmd_free {
	        my($pmd) = @_;
    		eval q({  &kmem_cache_free( $pgtable_cache[ &PMD_CACHE_NUM], $pmd); });
	    }' unless defined(&pmd_free);
	    eval 'sub pte_t {
	        eval q(* &pte_alloc_one_kernel(\'struct mm_struct\' * &mm, my $address) {  &kmem_cache_alloc( $pgtable_cache[ &PTE_CACHE_NUM],  &GFP_KERNEL| &__GFP_REPEAT); });
	    }' unless defined(&pte_t);
	    eval 'sub page {
	        eval q(* &pte_alloc_one(\'struct mm_struct\' * &mm, my $address) {  &virt_to_page( &pte_alloc_one_kernel( &mm,  $address)); });
	    }' unless defined(&page);
	    eval 'sub pte_free {
	        my($ptepage) = @_;
    		eval q({  &pte_free_kernel( &page_address($ptepage)); });
	    }' unless defined(&pte_free);
	    eval 'sub PGF_CACHENUM_MASK () {0xf;}' unless defined(&PGF_CACHENUM_MASK);
	    eval 'sub pgtable_free_cache {
	        my($p,$cachenum,$mask) = @_;
    		eval q({  &BUG_ON($cachenum >  &PGF_CACHENUM_MASK); ( &pgtable_free_t){. &val = ( $p & ~$mask) | $cachenum}; });
	    }' unless defined(&pgtable_free_cache);
	    eval 'sub pgtable_free {
	        my($pgf) = @_;
    		eval q({  &void * &p = ( &void *)( ($pgf->{val}) & ~ &PGF_CACHENUM_MASK); \'int\'  &cachenum =  ($pgf->{val}) &  &PGF_CACHENUM_MASK;  &kmem_cache_free( $pgtable_cache[ &cachenum],  &p); });
	    }' unless defined(&pgtable_free);
	    eval 'sub __pte_free_tlb {
	        my($tlb, $ptepage) = @_;
    		eval q( &pgtable_free_tlb($tlb,  &pgtable_free_cache( &page_address($ptepage),  &PTE_CACHE_NUM,  &PTE_TABLE_SIZE-1)));
	    }' unless defined(&__pte_free_tlb);
	    eval 'sub __pmd_free_tlb {
	        my($tlb, $pmd) = @_;
    		eval q( &pgtable_free_tlb($tlb,  &pgtable_free_cache($pmd,  &PMD_CACHE_NUM,  &PMD_TABLE_SIZE-1)));
	    }' unless defined(&__pmd_free_tlb);
	    unless(defined(&CONFIG_PPC_64K_PAGES)) {
		eval 'sub __pud_free_tlb {
		    my($tlb, $pud) = @_;
    		    eval q( &pgtable_free_tlb($tlb,  &pgtable_free_cache($pud,  &PUD_CACHE_NUM,  &PUD_TABLE_SIZE-1)));
		}' unless defined(&__pud_free_tlb);
	    }
	    eval 'sub check_pgt_cache () {
	        eval q( &do { }  &while (0));
	    }' unless defined(&check_pgt_cache);
	}
    }
}
1;
