require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_PGTABLE_H)) {
    eval 'sub _ASM_POWERPC_PGTABLE_H () {1;}' unless defined(&_ASM_POWERPC_PGTABLE_H);
    if(defined(&__KERNEL__)) {
	unless(defined(&CONFIG_PPC64)) {
	    require 'asm-ppc/pgtable.ph';
	} else {
	    unless(defined(&__ASSEMBLY__)) {
		require 'linux/config.ph';
		require 'linux/stddef.ph';
		require 'asm/processor.ph';
		require 'asm/mmu.ph';
		require 'asm/page.ph';
		require 'asm/tlbflush.ph';
	    }
	    if(defined(&CONFIG_PPC_64K_PAGES)) {
		require 'asm/pgtable-64k.ph';
	    } else {
		require 'asm/pgtable-4k.ph';
	    }
	    eval 'sub FIRST_USER_ADDRESS () {0;}' unless defined(&FIRST_USER_ADDRESS);
	    eval 'sub PGTABLE_EADDR_SIZE () {( &PTE_INDEX_SIZE +  &PMD_INDEX_SIZE +  &PUD_INDEX_SIZE +  &PGD_INDEX_SIZE +  &PAGE_SHIFT);}' unless defined(&PGTABLE_EADDR_SIZE);
	    eval 'sub PGTABLE_RANGE () {(1 <<  &PGTABLE_EADDR_SIZE);}' unless defined(&PGTABLE_RANGE);
	    if((defined(&TASK_SIZE_USER64) ? &TASK_SIZE_USER64 : 0) > (defined(&PGTABLE_RANGE) ? &PGTABLE_RANGE : 0)) {
		die("TASK_SIZE_USER64\ exceeds\ pagetable\ range");
	    }
	    if((defined(&TASK_SIZE_USER64) ? &TASK_SIZE_USER64 : 0) > (1 << ((defined(&USER_ESID_BITS) ? &USER_ESID_BITS : 0) + (defined(&SID_SHIFT) ? &SID_SHIFT : 0)))) {
		die("TASK_SIZE_USER64\ exceeds\ user\ VSID\ range");
	    }
	    eval 'sub VMALLOC_START () {(1.4987979559889e+19);}' unless defined(&VMALLOC_START);
	    eval 'sub VMALLOC_SIZE () {(8796093022208);}' unless defined(&VMALLOC_SIZE);
	    eval 'sub VMALLOC_END () {( &VMALLOC_START +  &VMALLOC_SIZE);}' unless defined(&VMALLOC_END);
	    eval 'sub PHBS_IO_BASE () { &VMALLOC_END;}' unless defined(&PHBS_IO_BASE);
	    eval 'sub IMALLOC_BASE () {( &PHBS_IO_BASE + 0x80000000);}' unless defined(&IMALLOC_BASE);
	    eval 'sub IMALLOC_END () {( &VMALLOC_START +  &PGTABLE_RANGE);}' unless defined(&IMALLOC_END);
	    eval 'sub REGION_SHIFT () {60;}' unless defined(&REGION_SHIFT);
	    eval 'sub REGION_MASK () {(0xf <<  &REGION_SHIFT);}' unless defined(&REGION_MASK);
	    eval 'sub REGION_ID {
	        my($ea) = @_;
    		eval q(((($ea)) >>  &REGION_SHIFT));
	    }' unless defined(&REGION_ID);
	    eval 'sub VMALLOC_REGION_ID () {( &REGION_ID( &VMALLOC_START));}' unless defined(&VMALLOC_REGION_ID);
	    eval 'sub KERNEL_REGION_ID () {( &REGION_ID( &PAGE_OFFSET));}' unless defined(&KERNEL_REGION_ID);
	    eval 'sub USER_REGION_ID () {(0);}' unless defined(&USER_REGION_ID);
	    eval 'sub _PAGE_PRESENT () {0x1;}' unless defined(&_PAGE_PRESENT);
	    eval 'sub _PAGE_USER () {0x2;}' unless defined(&_PAGE_USER);
	    eval 'sub _PAGE_FILE () {0x2;}' unless defined(&_PAGE_FILE);
	    eval 'sub _PAGE_EXEC () {0x4;}' unless defined(&_PAGE_EXEC);
	    eval 'sub _PAGE_GUARDED () {0x8;}' unless defined(&_PAGE_GUARDED);
	    eval 'sub _PAGE_COHERENT () {0x10;}' unless defined(&_PAGE_COHERENT);
	    eval 'sub _PAGE_NO_CACHE () {0x20;}' unless defined(&_PAGE_NO_CACHE);
	    eval 'sub _PAGE_WRITETHRU () {0x40;}' unless defined(&_PAGE_WRITETHRU);
	    eval 'sub _PAGE_DIRTY () {0x80;}' unless defined(&_PAGE_DIRTY);
	    eval 'sub _PAGE_ACCESSED () {0x100;}' unless defined(&_PAGE_ACCESSED);
	    eval 'sub _PAGE_RW () {0x200;}' unless defined(&_PAGE_RW);
	    eval 'sub _PAGE_HASHPTE () {0x400;}' unless defined(&_PAGE_HASHPTE);
	    eval 'sub _PAGE_BUSY () {0x800;}' unless defined(&_PAGE_BUSY);
	    eval 'sub _PAGE_BASE () {( &_PAGE_PRESENT |  &_PAGE_ACCESSED |  &_PAGE_COHERENT);}' unless defined(&_PAGE_BASE);
	    eval 'sub _PAGE_WRENABLE () {( &_PAGE_RW |  &_PAGE_DIRTY);}' unless defined(&_PAGE_WRENABLE);
	    eval 'sub PAGE_NONE () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_ACCESSED);}' unless defined(&PAGE_NONE);
	    eval 'sub PAGE_SHARED () { &__pgprot( &_PAGE_BASE |  &_PAGE_RW |  &_PAGE_USER);}' unless defined(&PAGE_SHARED);
	    eval 'sub PAGE_SHARED_X () { &__pgprot( &_PAGE_BASE |  &_PAGE_RW |  &_PAGE_USER |  &_PAGE_EXEC);}' unless defined(&PAGE_SHARED_X);
	    eval 'sub PAGE_COPY () { &__pgprot( &_PAGE_BASE |  &_PAGE_USER);}' unless defined(&PAGE_COPY);
	    eval 'sub PAGE_COPY_X () { &__pgprot( &_PAGE_BASE |  &_PAGE_USER |  &_PAGE_EXEC);}' unless defined(&PAGE_COPY_X);
	    eval 'sub PAGE_READONLY () { &__pgprot( &_PAGE_BASE |  &_PAGE_USER);}' unless defined(&PAGE_READONLY);
	    eval 'sub PAGE_READONLY_X () { &__pgprot( &_PAGE_BASE |  &_PAGE_USER |  &_PAGE_EXEC);}' unless defined(&PAGE_READONLY_X);
	    eval 'sub PAGE_KERNEL () { &__pgprot( &_PAGE_BASE |  &_PAGE_WRENABLE);}' unless defined(&PAGE_KERNEL);
	    eval 'sub PAGE_KERNEL_CI () { &__pgprot( &_PAGE_PRESENT |  &_PAGE_ACCESSED |  &_PAGE_WRENABLE |  &_PAGE_NO_CACHE |  &_PAGE_GUARDED);}' unless defined(&PAGE_KERNEL_CI);
	    eval 'sub PAGE_KERNEL_EXEC () { &__pgprot( &_PAGE_BASE |  &_PAGE_WRENABLE |  &_PAGE_EXEC);}' unless defined(&PAGE_KERNEL_EXEC);
	    eval 'sub PAGE_AGP () { &__pgprot( &_PAGE_BASE |  &_PAGE_WRENABLE |  &_PAGE_NO_CACHE);}' unless defined(&PAGE_AGP);
	    eval 'sub HAVE_PAGE_AGP () {1;}' unless defined(&HAVE_PAGE_AGP);
	    eval 'sub _PTEIDX_SECONDARY () {0x8;}' unless defined(&_PTEIDX_SECONDARY);
	    eval 'sub _PTEIDX_GROUP_IX () {0x7;}' unless defined(&_PTEIDX_GROUP_IX);
	    eval 'sub __P000 () { &PAGE_NONE;}' unless defined(&__P000);
	    eval 'sub __P001 () { &PAGE_READONLY;}' unless defined(&__P001);
	    eval 'sub __P010 () { &PAGE_COPY;}' unless defined(&__P010);
	    eval 'sub __P011 () { &PAGE_COPY;}' unless defined(&__P011);
	    eval 'sub __P100 () { &PAGE_READONLY_X;}' unless defined(&__P100);
	    eval 'sub __P101 () { &PAGE_READONLY_X;}' unless defined(&__P101);
	    eval 'sub __P110 () { &PAGE_COPY_X;}' unless defined(&__P110);
	    eval 'sub __P111 () { &PAGE_COPY_X;}' unless defined(&__P111);
	    eval 'sub __S000 () { &PAGE_NONE;}' unless defined(&__S000);
	    eval 'sub __S001 () { &PAGE_READONLY;}' unless defined(&__S001);
	    eval 'sub __S010 () { &PAGE_SHARED;}' unless defined(&__S010);
	    eval 'sub __S011 () { &PAGE_SHARED;}' unless defined(&__S011);
	    eval 'sub __S100 () { &PAGE_READONLY_X;}' unless defined(&__S100);
	    eval 'sub __S101 () { &PAGE_READONLY_X;}' unless defined(&__S101);
	    eval 'sub __S110 () { &PAGE_SHARED_X;}' unless defined(&__S110);
	    eval 'sub __S111 () { &PAGE_SHARED_X;}' unless defined(&__S111);
	    unless(defined(&__ASSEMBLY__)) {
		eval 'sub ZERO_PAGE {
		    my($vaddr) = @_;
    		    eval q(( &virt_to_page( &empty_zero_page)));
		}' unless defined(&ZERO_PAGE);
	    }
	    if(defined(&CONFIG_HUGETLB_PAGE)) {
		eval 'sub HAVE_ARCH_UNMAPPED_AREA () {1;}' unless defined(&HAVE_ARCH_UNMAPPED_AREA);
		eval 'sub HAVE_ARCH_UNMAPPED_AREA_TOPDOWN () {1;}' unless defined(&HAVE_ARCH_UNMAPPED_AREA_TOPDOWN);
	    }
	    unless(defined(&__ASSEMBLY__)) {
		eval 'sub mk_pte {
		    my($page, $pgprot) = @_;
    		    eval q( &pfn_pte( &page_to_pfn($page), ($pgprot)));
		}' unless defined(&mk_pte);
		eval 'sub pfn_pte {
		    my($pfn,$pgprot) = @_;
    		    eval q({  &pte_t  &pte;  &pte_val( &pte) = ($pfn <<  &PTE_RPN_SHIFT) |  &pgprot_val($pgprot);  &pte; });
		}' unless defined(&pfn_pte);
		eval 'sub pte_modify {
		    my($_pte, $newprot) = @_;
    		    eval q(( &__pte(( &pte_val($_pte) &  &_PAGE_CHG_MASK) |  &pgprot_val($newprot))));
		}' unless defined(&pte_modify);
		eval 'sub pte_none {
		    my($pte) = @_;
    		    eval q((( &pte_val($pte) & ~ &_PAGE_HPTEFLAGS) == 0));
		}' unless defined(&pte_none);
		eval 'sub pte_present {
		    my($pte) = @_;
    		    eval q(( &pte_val($pte) &  &_PAGE_PRESENT));
		}' unless defined(&pte_present);
		eval 'sub pte_pfn {
		    my($x) = @_;
    		    eval q(((( &pte_val($x)>> &PTE_RPN_SHIFT))));
		}' unless defined(&pte_pfn);
		eval 'sub pte_page {
		    my($x) = @_;
    		    eval q( &pfn_to_page( &pte_pfn($x)));
		}' unless defined(&pte_page);
		eval 'sub PMD_BAD_BITS () {( &PTE_TABLE_SIZE-1);}' unless defined(&PMD_BAD_BITS);
		eval 'sub PUD_BAD_BITS () {( &PMD_TABLE_SIZE-1);}' unless defined(&PUD_BAD_BITS);
		eval 'sub pmd_set {
		    my($pmdp, $pmdval) = @_;
    		    eval q(( &pmd_val(*($pmdp)) = ($pmdval)));
		}' unless defined(&pmd_set);
		eval 'sub pmd_none {
		    my($pmd) = @_;
    		    eval q((! &pmd_val($pmd)));
		}' unless defined(&pmd_none);
		eval 'sub pmd_bad {
		    my($pmd) = @_;
    		    eval q((! &is_kernel_addr( &pmd_val($pmd)) || ( &pmd_val($pmd) &  &PMD_BAD_BITS)));
		}' unless defined(&pmd_bad);
		eval 'sub pmd_present {
		    my($pmd) = @_;
    		    eval q(( &pmd_val($pmd) != 0));
		}' unless defined(&pmd_present);
		eval 'sub pmd_clear {
		    my($pmdp) = @_;
    		    eval q(( &pmd_val(*($pmdp)) = 0));
		}' unless defined(&pmd_clear);
		eval 'sub pmd_page_kernel {
		    my($pmd) = @_;
    		    eval q(( &pmd_val($pmd) & ~ &PMD_MASKED_BITS));
		}' unless defined(&pmd_page_kernel);
		eval 'sub pmd_page {
		    my($pmd) = @_;
    		    eval q( &virt_to_page( &pmd_page_kernel($pmd)));
		}' unless defined(&pmd_page);
		eval 'sub pud_set {
		    my($pudp, $pudval) = @_;
    		    eval q(( &pud_val(*($pudp)) = ($pudval)));
		}' unless defined(&pud_set);
		eval 'sub pud_none {
		    my($pud) = @_;
    		    eval q((! &pud_val($pud)));
		}' unless defined(&pud_none);
		eval 'sub pud_bad {
		    my($pud) = @_;
    		    eval q((! &is_kernel_addr( &pud_val($pud)) || ( &pud_val($pud) &  &PUD_BAD_BITS)));
		}' unless defined(&pud_bad);
		eval 'sub pud_present {
		    my($pud) = @_;
    		    eval q(( &pud_val($pud) != 0));
		}' unless defined(&pud_present);
		eval 'sub pud_clear {
		    my($pudp) = @_;
    		    eval q(( &pud_val(*($pudp)) = 0));
		}' unless defined(&pud_clear);
		eval 'sub pud_page {
		    my($pud) = @_;
    		    eval q(( &pud_val($pud) & ~ &PUD_MASKED_BITS));
		}' unless defined(&pud_page);
		eval 'sub pgd_set {
		    my($pgdp, $pudp) = @_;
    		    eval q(({ &pgd_val(*($pgdp)) = ($pudp);}));
		}' unless defined(&pgd_set);
		eval 'sub pgd_index {
		    my($address) = @_;
    		    eval q(((($address) >> ( &PGDIR_SHIFT)) & 0x1ff));
		}' unless defined(&pgd_index);
		eval 'sub pgd_offset {
		    my($mm, $address) = @_;
    		    eval q((($mm)-> &pgd +  &pgd_index($address)));
		}' unless defined(&pgd_offset);
		eval 'sub pmd_offset {
		    my($pudp,$addr) = @_;
    		    eval q(((( &pmd_t *)  &pud_page(*($pudp))) + ((($addr) >>  &PMD_SHIFT) & ( &PTRS_PER_PMD - 1))));
		}' unless defined(&pmd_offset);
		eval 'sub pte_offset_kernel {
		    my($dir,$addr) = @_;
    		    eval q(((( &pte_t *)  &pmd_page_kernel(*($dir))) + ((($addr) >>  &PAGE_SHIFT) & ( &PTRS_PER_PTE - 1))));
		}' unless defined(&pte_offset_kernel);
		eval 'sub pte_offset_map {
		    my($dir,$addr) = @_;
    		    eval q( &pte_offset_kernel(($dir), ($addr)));
		}' unless defined(&pte_offset_map);
		eval 'sub pte_offset_map_nested {
		    my($dir,$addr) = @_;
    		    eval q( &pte_offset_kernel(($dir), ($addr)));
		}' unless defined(&pte_offset_map_nested);
		eval 'sub pte_unmap {
		    my($pte) = @_;
    		    eval q( &do { }  &while(0));
		}' unless defined(&pte_unmap);
		eval 'sub pte_unmap_nested {
		    my($pte) = @_;
    		    eval q( &do { }  &while(0));
		}' unless defined(&pte_unmap_nested);
		eval 'sub pgd_offset_k {
		    my($address) = @_;
    		    eval q( &pgd_offset( &init_mm, $address));
		}' unless defined(&pgd_offset_k);
		eval 'sub __ptep_test_and_clear_young {
		    my($mm,$addr,$ptep) = @_;
    		    eval q({ my $old;  &if (( &pte_val(*$ptep) & ( &_PAGE_ACCESSED |  &_PAGE_HASHPTE)) == 0) 0;  $old =  &pte_update($ptep,  &_PAGE_ACCESSED);  &if ( $old &  &_PAGE_HASHPTE) {  &hpte_update($mm, $addr, $ptep,  $old, 0);  &flush_tlb_pending(); } ( $old &  &_PAGE_ACCESSED) != 0; });
		}' unless defined(&__ptep_test_and_clear_young);
		eval 'sub __HAVE_ARCH_PTEP_TEST_AND_CLEAR_YOUNG () {1;}' unless defined(&__HAVE_ARCH_PTEP_TEST_AND_CLEAR_YOUNG);
		eval 'sub ptep_test_and_clear_young {
		    my($__vma, $__addr, $__ptep) = @_;
    		    eval q(({ \'int\'  &__r;  &__r =  &__ptep_test_and_clear_young(($__vma)-> &vm_mm, $__addr, $__ptep);  &__r; }));
		}' unless defined(&ptep_test_and_clear_young);
		eval 'sub __HAVE_ARCH_PTEP_TEST_AND_CLEAR_DIRTY () {1;}' unless defined(&__HAVE_ARCH_PTEP_TEST_AND_CLEAR_DIRTY);
		eval 'sub ptep_test_and_clear_dirty {
		    my($__vma, $__addr, $__ptep) = @_;
    		    eval q(({ \'int\'  &__r;  &__r =  &__ptep_test_and_clear_dirty(($__vma)-> &vm_mm, $__addr, $__ptep);  &__r; }));
		}' unless defined(&ptep_test_and_clear_dirty);
		eval 'sub __HAVE_ARCH_PTEP_SET_WRPROTECT () {1;}' unless defined(&__HAVE_ARCH_PTEP_SET_WRPROTECT);
		eval 'sub ptep_set_wrprotect {
		    my($mm,$addr,$ptep) = @_;
    		    eval q({ my $old;  &if (( &pte_val(*$ptep) &  &_PAGE_RW) == 0) ;  $old =  &pte_update($ptep,  &_PAGE_RW);  &if ( $old &  &_PAGE_HASHPTE)  &hpte_update($mm, $addr, $ptep,  $old, 0); });
		}' unless defined(&ptep_set_wrprotect);
		eval 'sub __HAVE_ARCH_PTEP_CLEAR_YOUNG_FLUSH () {1;}' unless defined(&__HAVE_ARCH_PTEP_CLEAR_YOUNG_FLUSH);
		eval 'sub ptep_clear_flush_young {
		    my($__vma, $__address, $__ptep) = @_;
    		    eval q(({ \'int\'  &__young =  &__ptep_test_and_clear_young(($__vma)-> &vm_mm, $__address, $__ptep);  &__young; }));
		}' unless defined(&ptep_clear_flush_young);
		eval 'sub __HAVE_ARCH_PTEP_CLEAR_DIRTY_FLUSH () {1;}' unless defined(&__HAVE_ARCH_PTEP_CLEAR_DIRTY_FLUSH);
		eval 'sub ptep_clear_flush_dirty {
		    my($__vma, $__address, $__ptep) = @_;
    		    eval q(({ \'int\'  &__dirty =  &__ptep_test_and_clear_dirty(($__vma)-> &vm_mm, $__address, $__ptep);  &flush_tlb_page($__vma, $__address);  &__dirty; }));
		}' unless defined(&ptep_clear_flush_dirty);
		eval 'sub __HAVE_ARCH_PTEP_GET_AND_CLEAR () {1;}' unless defined(&__HAVE_ARCH_PTEP_GET_AND_CLEAR);
		eval 'sub ptep_get_and_clear {
		    my($mm,$addr,$ptep) = @_;
    		    eval q({ my $old =  &pte_update($ptep, ~0);  &if ( $old &  &_PAGE_HASHPTE)  &hpte_update($mm, $addr, $ptep,  $old, 0);  &__pte( $old); });
		}' unless defined(&ptep_get_and_clear);
		eval 'sub pte_clear {
		    my($mm,$addr,$ptep) = @_;
    		    eval q({ my $old =  &pte_update($ptep, ~0);  &if ( $old &  &_PAGE_HASHPTE)  &hpte_update($mm, $addr, $ptep,  $old, 0); });
		}' unless defined(&pte_clear);
		if(defined(&CONFIG_PPC_64K_PAGES)) {
		}
		eval 'sub __HAVE_ARCH_PTEP_SET_ACCESS_FLAGS () {1;}' unless defined(&__HAVE_ARCH_PTEP_SET_ACCESS_FLAGS);
		eval 'sub __ptep_set_access_flags {
		    my($ptep,$entry,$dirty) = @_;
    		    eval q(\\"(assembly code)\\");
		}' unless defined(&__ptep_set_access_flags);
		eval 'sub ptep_set_access_flags {
		    my($__vma, $__address, $__ptep, $__entry, $__dirty) = @_;
    		    eval q( &do {  &__ptep_set_access_flags($__ptep, $__entry, $__dirty);  &flush_tlb_page_nohash($__vma, $__address); }  &while(0));
		}' unless defined(&ptep_set_access_flags);
		eval 'sub pgprot_noncached {
		    my($prot) = @_;
    		    eval q(( &__pgprot( &pgprot_val($prot) |  &_PAGE_NO_CACHE |  &_PAGE_GUARDED)));
		}' unless defined(&pgprot_noncached);
		eval 'sub __HAVE_PHYS_MEM_ACCESS_PROT () {1;}' unless defined(&__HAVE_PHYS_MEM_ACCESS_PROT);
		eval 'sub __HAVE_ARCH_PTE_SAME () {1;}' unless defined(&__HAVE_ARCH_PTE_SAME);
		eval 'sub pte_same {
		    my($A,$B) = @_;
    		    eval q(((( &pte_val($A) ^  &pte_val($B)) & ~ &_PAGE_HPTEFLAGS) == 0));
		}' unless defined(&pte_same);
		eval 'sub pte_ERROR {
		    my($e) = @_;
    		    eval q( &printk(\\"%s:%d: bad pte %08lx.\\\\n\\",  &__FILE__,  &__LINE__,  &pte_val($e)));
		}' unless defined(&pte_ERROR);
		eval 'sub pmd_ERROR {
		    my($e) = @_;
    		    eval q( &printk(\\"%s:%d: bad pmd %08lx.\\\\n\\",  &__FILE__,  &__LINE__,  &pmd_val($e)));
		}' unless defined(&pmd_ERROR);
		eval 'sub pgd_ERROR {
		    my($e) = @_;
    		    eval q( &printk(\\"%s:%d: bad pgd %08lx.\\\\n\\",  &__FILE__,  &__LINE__,  &pgd_val($e)));
		}' unless defined(&pgd_ERROR);
		eval 'sub __swp_type {
		    my($entry) = @_;
    		    eval q(((($entry). &val >> 1) & 0x3f));
		}' unless defined(&__swp_type);
		eval 'sub __swp_offset {
		    my($entry) = @_;
    		    eval q((($entry). &val >> 8));
		}' unless defined(&__swp_offset);
		eval 'sub __swp_entry {
		    my($type, $offset) = @_;
    		    eval q((( &swp_entry_t){(($type)<< 1)|(($offset)<<8)}));
		}' unless defined(&__swp_entry);
		eval 'sub __pte_to_swp_entry {
		    my($pte) = @_;
    		    eval q((( &swp_entry_t){ &pte_val($pte) >>  &PTE_RPN_SHIFT}));
		}' unless defined(&__pte_to_swp_entry);
		eval 'sub __swp_entry_to_pte {
		    my($x) = @_;
    		    eval q((( &pte_t) { ($x). &val <<  &PTE_RPN_SHIFT }));
		}' unless defined(&__swp_entry_to_pte);
		eval 'sub pte_to_pgoff {
		    my($pte) = @_;
    		    eval q(( &pte_val($pte) >>  &PTE_RPN_SHIFT));
		}' unless defined(&pte_to_pgoff);
		eval 'sub pgoff_to_pte {
		    my($off) = @_;
    		    eval q((( &pte_t) {(($off) <<  &PTE_RPN_SHIFT)| &_PAGE_FILE}));
		}' unless defined(&pgoff_to_pte);
		eval 'sub PTE_FILE_MAX_BITS () {( &BITS_PER_LONG -  &PTE_RPN_SHIFT);}' unless defined(&PTE_FILE_MAX_BITS);
		eval 'sub kern_addr_valid {
		    my($addr) = @_;
    		    eval q((1));
		}' unless defined(&kern_addr_valid);
		eval 'sub io_remap_pfn_range {
		    my($vma, $vaddr, $pfn, $size, $prot) = @_;
    		    eval q( &remap_pfn_range($vma, $vaddr, $pfn, $size, $prot));
		}' unless defined(&io_remap_pfn_range);
		require 'asm-generic/pgtable.ph';
	    }
	}
    }
}
1;
