require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_RWSEM_H)) {
    eval 'sub _ASM_POWERPC_RWSEM_H () {1;}' unless defined(&_ASM_POWERPC_RWSEM_H);
    if(defined(&__KERNEL__)) {
	require 'linux/list.ph';
	require 'linux/spinlock.ph';
	require 'asm/atomic.ph';
	require 'asm/system.ph';
	eval 'sub RWSEM_UNLOCKED_VALUE () {0x;}' unless defined(&RWSEM_UNLOCKED_VALUE);
	eval 'sub RWSEM_ACTIVE_BIAS () {0x1;}' unless defined(&RWSEM_ACTIVE_BIAS);
	eval 'sub RWSEM_ACTIVE_MASK () {0xffff;}' unless defined(&RWSEM_ACTIVE_MASK);
	eval 'sub RWSEM_WAITING_BIAS () {(-0x10000);}' unless defined(&RWSEM_WAITING_BIAS);
	eval 'sub RWSEM_ACTIVE_READ_BIAS () { &RWSEM_ACTIVE_BIAS;}' unless defined(&RWSEM_ACTIVE_READ_BIAS);
	eval 'sub RWSEM_ACTIVE_WRITE_BIAS () {( &RWSEM_WAITING_BIAS +  &RWSEM_ACTIVE_BIAS);}' unless defined(&RWSEM_ACTIVE_WRITE_BIAS);
	if((defined(&RWSEM_DEBUG) ? &RWSEM_DEBUG : 0)) {
	}
	if((defined(&RWSEM_DEBUG) ? &RWSEM_DEBUG : 0)) {
	    eval 'sub __RWSEM_DEBUG_INIT () {, 0;}' unless defined(&__RWSEM_DEBUG_INIT);
	} else {
	    eval 'sub __RWSEM_DEBUG_INIT () {1;}' unless defined(&__RWSEM_DEBUG_INIT);
	}
	eval 'sub __RWSEM_INITIALIZER {
	    my($name) = @_;
    	    eval q({  &RWSEM_UNLOCKED_VALUE,  &SPIN_LOCK_UNLOCKED,  &LIST_HEAD_INIT(($name). &wait_list)  &__RWSEM_DEBUG_INIT });
	}' unless defined(&__RWSEM_INITIALIZER);
	eval 'sub DECLARE_RWSEM {
	    my($name) = @_;
    	    eval q(\'struct rw_semaphore\' $name =  &__RWSEM_INITIALIZER($name));
	}' unless defined(&DECLARE_RWSEM);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub init_rwsem {
	    my($sem) = @_;
    	    eval q({  ($sem->{count}) =  &RWSEM_UNLOCKED_VALUE;  &spin_lock_init( ($sem->{wait_lock}));  &INIT_LIST_HEAD( ($sem->{wait_list})); });
	}' unless defined(&init_rwsem);
	eval 'sub __down_read_trylock {
	    my($sem) = @_;
    	    eval q({ \'int\'  &tmp;  &while (( &tmp =  ($sem->{count})) >= 0) {  &if ( &tmp ==  &cmpxchg( ($sem->{count}),  &tmp,  &tmp +  &RWSEM_ACTIVE_READ_BIAS)) { 1; } } 0; });
	}' unless defined(&__down_read_trylock);
	eval 'sub __down_write_trylock {
	    my($sem) = @_;
    	    eval q({ \'int\'  &tmp;  &tmp =  &cmpxchg( ($sem->{count}),  &RWSEM_UNLOCKED_VALUE,  &RWSEM_ACTIVE_WRITE_BIAS);  &tmp ==  &RWSEM_UNLOCKED_VALUE; });
	}' unless defined(&__down_write_trylock);
	eval 'sub rwsem_is_locked {
	    my($sem) = @_;
    	    eval q({ ( ($sem->{count}) != 0); });
	}' unless defined(&rwsem_is_locked);
    }
}
1;
